/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/
package widgets;

import help.Config;
import help.GenerateScript;

import java.awt.BorderLayout;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;

import xmlObjects.VtEnv;

public class LaunchIt extends javax.swing.JPanel{

	/**
	 * serial version id
	 */
	private static final long serialVersionUID = 8215014096591551417L;
	private JTextPane input = null;
	private JTextPane output = null;
	private JScrollPane viewerOut = null;
	private JScrollPane viewerIn = null;
	private VtEnv env = null;
	private JSplitPane splitPane = null;
	private Process p = null;
	private myFileDialog bpath;
	private String tempPath = null;
	private JButton vampir=null;
	private boolean lookforExistingFiles = true;
	
	private myActionListener l = new myActionListener();
	
	public LaunchIt(Image icon,final VtEnv env)
	{
		
		this.env = env;
		final JFrame frame = new JFrame("Experimentel Launch");
		frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		frame.setPreferredSize(new Dimension(650,450));
		frame.setMinimumSize(new Dimension(650,450));
		frame.setIconImage(icon);
		this.setLayout(new BorderLayout());
		
		JLabel info = new JLabel("<html><body>This tool is used to start your application with the environmental variables you set-up. " +
			"Your application will run on the same machine as you used to start vtsetup, " +
			"you may need to start a batch job on most HPC systems instead.</body></html>");
		JLabel execPath = new JLabel("Working directory:");
		
		tempPath = ((myFileDialog) env.getItemById("VTSetup_EXECUTABLE").getValue().get(0).getComponent()).text.getText();
		String path = "";
		if(tempPath.contains("/"))
			path = tempPath.substring(0,tempPath.lastIndexOf("/"));
		if(path.equals(""))
			path = System.getProperty("user.dir");
		bpath = new myFileDialog(path);
		bpath.setIsPath(true);
		bpath.setIsFile(false);
		bpath.showDialog();

		JPanel top = new JPanel(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.HORIZONTAL;
		c.insets = new Insets(5,5,5,5);
		c.gridx = c.gridy = 0;
		c.gridwidth=2;
		c.weightx = 1;
		
		top.add(info,c);
		c.gridwidth=1;
		c.gridy++;
		c.weightx = 0;
		top.add(execPath,c);
		c.weightx = 1;
		c.gridx=1;
		top.add(bpath,c);
		
		this.add(top,BorderLayout.NORTH);
		
		input = new JTextPane();
		input.setContentType("text/plain");
		viewerIn = new JScrollPane(input);
		viewerIn.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		viewerIn.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		
		
		output = new JTextPane();
		output.setContentType("text/plain");
		viewerOut = new JScrollPane(output);
		viewerOut.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		viewerOut.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		
		viewerOut.setVisible(false);
		viewerOut.setEnabled(false);
		splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true, viewerIn,viewerOut);
        splitPane.setOneTouchExpandable(false);
        splitPane.setResizeWeight(1.0);
        
        this.add(splitPane,BorderLayout.CENTER);
		
		JButton cancel = new JButton("Done");
		
		//check if vampir is available and the place of vampir with whereis
		vampir = new JButton("View Tracefile In Vampir");
		vampir.setEnabled(false);
		JButton run = new JButton("Run...");
		
		JPanel buttons = new JPanel(new BorderLayout());
		buttons.add(cancel,BorderLayout.WEST);
		buttons.add(vampir,BorderLayout.CENTER);
		buttons.add(run,BorderLayout.EAST);
		
		this.add(buttons,BorderLayout.SOUTH);	
		run.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				run();
			}
		});
		
		cancel.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				if(p != null)
					p.destroy();
			frame.dispose();	
			}
		});
		
		vampir.addActionListener(l);
		
		frame.add(this);
		frame.setVisible(true);
		frame.pack();
		setInput();
		
		frame.addWindowFocusListener(new WindowFocusListener(){

			public void windowGainedFocus(WindowEvent e) {
				//replace the output filenames
				
				String filterFile = ((myFileDialog) env.getItemById("VT_FILTER_SPEC").getValue().get(0).getComponent()).text.getText();
				String GroupFile = ((myFileDialog) env.getItemById("VT_GROUPS_SPEC").getValue().get(0).getComponent()).text.getText();
				input.setText(input.getText().replaceAll("#The overall set-up takes place in .* and used .* \n# and .* for grouping and filtering\n", "#The overall set-up takes place in vtsetup_setup_output.sh and used "+GroupFile+" \n# and "+filterFile+" for grouping and filtering\n"));
			}

			
			public void windowLostFocus(WindowEvent e) {
				;
			}
			
		});
	}
	
	private void setInput()
	{
		String executable = "<yourApplication>";
		
		if(!tempPath.trim().equals(""))
		{
			executable = tempPath.trim();
		}
		if(!executable.startsWith("/"))
		{
			executable = System.getProperty("user.dir")+"/"+executable;
		}
		
		String filterFile = ((myFileDialog) env.getItemById("VT_FILTER_SPEC").getValue().get(0).getComponent()).text.getText();
		String GroupFile = ((myFileDialog) env.getItemById("VT_GROUPS_SPEC").getValue().get(0).getComponent()).text.getText();
		
		input.setText(input.getText()+"#Add any commands needed to make VampirTrace and its library available below\n" +
				"# e.g.: module load vampirtrace\n" +
				"# e.g.: PATH=<VT_INSTALL_DIR>/bin:$PATH\n" +
				"#      LD_LIBRARY_PATH=<VT_INSTALL_DIR>/lib:$LD_LIBRARY_PATH\n\n" +
				"#Load all environmental variables and settings along with filter and grouping rules\n" +
				"#The overall set-up takes place in vtsetup_setup_output.sh and used "+GroupFile+" \n# and "+ filterFile+" for grouping and filtering\n" +
				"source ./vtsetup_setup_output.sh\n\n" +
				"#Start application\n" +
				"mpirun -np 4 "+executable+" "+env.arguments+"\n");
	}
	
	private void run()
	{
		boolean doit= true;
		vampir.setEnabled(false);
		String path = bpath.text.getText();

		
		GenerateScript generator = new GenerateScript(env.getItems());
		generator.setFilename(path+"/vtsetup_setup_output.sh");
		
		if(lookforExistingFiles)
		{

			
			if(new File(generator.getFiltFileName()).isFile() || new File(generator.getGrpFileName()).isFile() || new File(generator.getFileName()).isFile())
			{
				String[] options = { "yes", "cancel" };
				int answer = JOptionPane.showOptionDialog(null, "Do you want to replace the existing files?", "File Already Exists",JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
				
				if(answer == 1)
					doit=false;
				else
					lookforExistingFiles = false;
					
			}	
			
		}
		
		
		if(doit)
		{
			if(!viewerOut.isVisible())
			{
				viewerOut.setVisible(true);
				splitPane.setDividerLocation(100);
				splitPane.setOneTouchExpandable(true);
			}
			if(!(new File(path).isDirectory()))
			{
				output.setText("Build path '"+path+"' is not a directory.");
			}
			else
			{
				
				output.setText("");
				generator.generate(env.getGrpFiltWidget());
				String[] send = input.getText().split("\n");
				try{
					p = Runtime.getRuntime().exec("/bin/bash",null);
					
					//get Stream
					PrintWriter out = new PrintWriter(p.getOutputStream());
					
					//setup listener
					myStreamReader errorReader = new myStreamReader(p.getErrorStream(), "ERROR");
				    myStreamReader outputReader = new myStreamReader(p.getInputStream(), "OUTPUT");
				    errorReader.start();
				    outputReader.start();
				    				
					//make input
				    out.println("cd "+path);
					for(int i=0;i<send.length;i++)
					{
						String command = send[i]+"\n";
						out.append(command);
						out.flush();
						
					}
					out.println("exit");
					out.flush();
					out.close();
				}catch(Exception ex)
				{
					Config.errorHandler(ex);
				}
			}
		}
	}
	
	private void checkForVampir()
	{
		//get path of otf output
		String OTFpath = bpath.text.getText()+"/"+((JFormattedTextField) env.getItemById("VT_FILE_PREFIX").getValue().get(0).getComponent()).getText()+".otf";
		String VAMPIRpath = "";
		
		// get the vampir path
		try{
			Process myp = Runtime.getRuntime().exec(new String[] {"/bin/which", "vampir"});  
			BufferedReader br = new BufferedReader(new InputStreamReader(myp.getInputStream()));   
			String line;
			String out = "";
			while ((line = br.readLine()) != null) {  
				out += line;
			}
			out = out.trim();
			myp.waitFor();
			br.close();
			myp.destroy();
	
			
			VAMPIRpath = out;
		}catch(Exception ex)
		{
			Config.errorHandler(ex);
		}
		
		//check if both pathes are valid
		if(new File(OTFpath).isFile() && new File(VAMPIRpath).isFile())
		{
			vampir.setEnabled(true);
			l.setPath(VAMPIRpath);
			l.setotfPath(bpath.text.getText()+"/");
		}
		else
		{
			vampir.setEnabled(false);
		}
	}
	
	
	/***
	 * 
	 * class
	 * read streams and fill the output text box, from a separate thread 
 	 * 
	 */
	class myStreamReader extends Thread
	{
	    InputStream is;
	    String type;
	    
	    myStreamReader(InputStream is, String type)
	    {
	        this.is = is;
	        is.mark(1);
	        this.type = type;
	    }
	    
	    public void run()
	    {
	        try
	        {
	            InputStreamReader isr = new InputStreamReader(is);
	            BufferedReader br = new BufferedReader(isr);
	            
	            String line=null;
	            while ((line = br.readLine()) != null)
	            {
	               try{
	            	   output.getDocument().insertString(output.getText().length(), "\n"+type + "> " + line, null);
	               }catch(Exception ex)
	               {
	            	   Config.errorHandler(ex);
	               }
	               output.setCaretPosition(output.getText().length());
	            }
	            
	            is.close();
	            if(type.equals("OUTPUT"))
	            	checkForVampir();
	            }catch (IOException ex)
	            {
	            	if(!ex.getMessage().equals("Stream closed"))
	            		Config.errorHandler(ex);
	            }
	            
	    }
	}

	class myActionListener implements ActionListener
	{
		String path = "";
		String otfPath = "";
		public void setPath(String path)
		{
			this.path = path;
		}
		
		public void setotfPath(String path)
		{
			this.otfPath = path;
		}
		
		public void actionPerformed(ActionEvent e) {
		    try{
			 	Process p = Runtime.getRuntime().exec(path+" "+otfPath+((JFormattedTextField) env.getItemById("VT_FILE_PREFIX").getValue().get(0).getComponent()).getText()+".otf");
			}catch(Exception ex)
			{
				Config.errorHandler(ex);
			}
		}	
	}
}
