/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 *
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * ! BUILT BY mk_c_wrapper.sh; DO NOT EDIT THIS FILE       !
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 **/

/* -- MPI_Abort -- */

VT_MPI_INT MPI_Abort(MPI_Comm comm, VT_MPI_INT errorcode)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ABORT]);

    VT_UNIMCI_CHECK_PRE(MPI_Abort,
      (comm, errorcode, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Abort(comm, errorcode);

    VT_UNIMCI_CHECK_POST(MPI_Abort,
      (comm, errorcode, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Abort(comm, errorcode);
  }

  return result;
}

/* -- MPI_Address -- not generated */

/* -- MPI_Allgather -- not generated */

/* -- MPI_Allgatherv -- not generated */

/* -- MPI_Allreduce -- not generated */

/* -- MPI_Alltoall -- not generated */

/* -- MPI_Alltoallv -- not generated */

/* -- MPI_Attr_delete -- */

VT_MPI_INT MPI_Attr_delete(MPI_Comm comm, VT_MPI_INT keyval)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ATTR_DELETE]);

    VT_UNIMCI_CHECK_PRE(MPI_Attr_delete,
      (comm, keyval, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Attr_delete(comm, keyval);

    VT_UNIMCI_CHECK_POST(MPI_Attr_delete,
      (comm, keyval, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Attr_delete(comm, keyval);
  }

  return result;
}

/* -- MPI_Attr_get -- */

VT_MPI_INT MPI_Attr_get(MPI_Comm comm, VT_MPI_INT keyval, void* attribute_val, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ATTR_GET]);

    VT_UNIMCI_CHECK_PRE(MPI_Attr_get,
      (comm, keyval, attribute_val, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Attr_get(comm, keyval, attribute_val, flag);

    VT_UNIMCI_CHECK_POST(MPI_Attr_get,
      (comm, keyval, attribute_val, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Attr_get(comm, keyval, attribute_val, flag);
  }

  return result;
}

/* -- MPI_Attr_put -- */

VT_MPI_INT MPI_Attr_put(MPI_Comm comm, VT_MPI_INT keyval, void* attribute_val)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ATTR_PUT]);

    VT_UNIMCI_CHECK_PRE(MPI_Attr_put,
      (comm, keyval, attribute_val, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Attr_put(comm, keyval, attribute_val);

    VT_UNIMCI_CHECK_POST(MPI_Attr_put,
      (comm, keyval, attribute_val, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Attr_put(comm, keyval, attribute_val);
  }

  return result;
}

/* -- MPI_Barrier -- not generated */

/* -- MPI_Bcast -- not generated */

/* -- MPI_Bsend -- not generated */

/* -- MPI_Bsend_init -- not generated */

/* -- MPI_Buffer_attach -- */

VT_MPI_INT MPI_Buffer_attach(void* buf, VT_MPI_INT size)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_BUFFER_ATTACH]);

    VT_UNIMCI_CHECK_PRE(MPI_Buffer_attach,
      (buf, size, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Buffer_attach(buf, size);

    VT_UNIMCI_CHECK_POST(MPI_Buffer_attach,
      (buf, size, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Buffer_attach(buf, size);
  }

  return result;
}

/* -- MPI_Buffer_detach -- */

VT_MPI_INT MPI_Buffer_detach(void* buf, VT_MPI_INT* size)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_BUFFER_DETACH]);

    VT_UNIMCI_CHECK_PRE(MPI_Buffer_detach,
      (buf, size, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Buffer_detach(buf, size);

    VT_UNIMCI_CHECK_POST(MPI_Buffer_detach,
      (buf, size, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Buffer_detach(buf, size);
  }

  return result;
}

/* -- MPI_Cancel -- not generated */

/* -- MPI_Cart_coords -- */

VT_MPI_INT MPI_Cart_coords(MPI_Comm comm, VT_MPI_INT rank, VT_MPI_INT maxdims, VT_MPI_INT* coords)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_CART_COORDS]);

    VT_UNIMCI_CHECK_PRE(MPI_Cart_coords,
      (comm, rank, maxdims, coords, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Cart_coords(comm, rank, maxdims, coords);

    VT_UNIMCI_CHECK_POST(MPI_Cart_coords,
      (comm, rank, maxdims, coords, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Cart_coords(comm, rank, maxdims, coords);
  }

  return result;
}

/* -- MPI_Cart_create -- not generated */

/* -- MPI_Cart_get -- */

VT_MPI_INT MPI_Cart_get(MPI_Comm comm, VT_MPI_INT maxdims, VT_MPI_INT* dims, VT_MPI_INT* periods, VT_MPI_INT* coords)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_CART_GET]);

    VT_UNIMCI_CHECK_PRE(MPI_Cart_get,
      (comm, maxdims, dims, periods, coords, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Cart_get(comm, maxdims, dims, periods, coords);

    VT_UNIMCI_CHECK_POST(MPI_Cart_get,
      (comm, maxdims, dims, periods, coords, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Cart_get(comm, maxdims, dims, periods, coords);
  }

  return result;
}

/* -- MPI_Cart_map -- */

VT_MPI_INT MPI_Cart_map(MPI_Comm comm, VT_MPI_INT ndims, VT_MPI_INT* dims, VT_MPI_INT* periods, VT_MPI_INT* newrank)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_CART_MAP]);

    VT_UNIMCI_CHECK_PRE(MPI_Cart_map,
      (comm, ndims, dims, periods, newrank, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Cart_map(comm, ndims, dims, periods, newrank);

    VT_UNIMCI_CHECK_POST(MPI_Cart_map,
      (comm, ndims, dims, periods, newrank, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Cart_map(comm, ndims, dims, periods, newrank);
  }

  return result;
}

/* -- MPI_Cart_rank -- */

VT_MPI_INT MPI_Cart_rank(MPI_Comm comm, VT_MPI_INT* coords, VT_MPI_INT* rank)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_CART_RANK]);

    VT_UNIMCI_CHECK_PRE(MPI_Cart_rank,
      (comm, coords, rank, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Cart_rank(comm, coords, rank);

    VT_UNIMCI_CHECK_POST(MPI_Cart_rank,
      (comm, coords, rank, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Cart_rank(comm, coords, rank);
  }

  return result;
}

/* -- MPI_Cart_shift -- */

VT_MPI_INT MPI_Cart_shift(MPI_Comm comm, VT_MPI_INT direction, VT_MPI_INT disp, VT_MPI_INT* rank_source, VT_MPI_INT* rank_dest)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_CART_SHIFT]);

    VT_UNIMCI_CHECK_PRE(MPI_Cart_shift,
      (comm, direction, disp, rank_source, rank_dest, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Cart_shift(comm, direction, disp, rank_source, rank_dest);

    VT_UNIMCI_CHECK_POST(MPI_Cart_shift,
      (comm, direction, disp, rank_source, rank_dest, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Cart_shift(comm, direction, disp, rank_source, rank_dest);
  }

  return result;
}

/* -- MPI_Cart_sub -- not generated */

/* -- MPI_Cartdim_get -- */

VT_MPI_INT MPI_Cartdim_get(MPI_Comm comm, VT_MPI_INT* ndims)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_CARTDIM_GET]);

    VT_UNIMCI_CHECK_PRE(MPI_Cartdim_get,
      (comm, ndims, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Cartdim_get(comm, ndims);

    VT_UNIMCI_CHECK_POST(MPI_Cartdim_get,
      (comm, ndims, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Cartdim_get(comm, ndims);
  }

  return result;
}

/* -- MPI_Comm_compare -- */

VT_MPI_INT MPI_Comm_compare(MPI_Comm comm1, MPI_Comm comm2, VT_MPI_INT* _result)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_COMPARE]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_compare,
      (comm1, comm2, _result, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_compare(comm1, comm2, _result);

    VT_UNIMCI_CHECK_POST(MPI_Comm_compare,
      (comm1, comm2, _result, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_compare(comm1, comm2, _result);
  }

  return result;
}

/* -- MPI_Comm_create -- not generated */

/* -- MPI_Comm_dup -- not generated */

/* -- MPI_Comm_free -- not generated */

/* -- MPI_Comm_group -- not generated */

/* -- MPI_Comm_rank -- */

VT_MPI_INT MPI_Comm_rank(MPI_Comm comm, VT_MPI_INT* rank)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_RANK]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_rank,
      (comm, rank, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_rank(comm, rank);

    VT_UNIMCI_CHECK_POST(MPI_Comm_rank,
      (comm, rank, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_rank(comm, rank);
  }

  return result;
}

/* -- MPI_Comm_remote_group -- not generated */

/* -- MPI_Comm_remote_size -- */

VT_MPI_INT MPI_Comm_remote_size(MPI_Comm comm, VT_MPI_INT* size)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_REMOTE_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_remote_size,
      (comm, size, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_remote_size(comm, size);

    VT_UNIMCI_CHECK_POST(MPI_Comm_remote_size,
      (comm, size, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_remote_size(comm, size);
  }

  return result;
}

/* -- MPI_Comm_size -- */

VT_MPI_INT MPI_Comm_size(MPI_Comm comm, VT_MPI_INT* size)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_size,
      (comm, size, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_size(comm, size);

    VT_UNIMCI_CHECK_POST(MPI_Comm_size,
      (comm, size, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_size(comm, size);
  }

  return result;
}

/* -- MPI_Comm_split -- not generated */

/* -- MPI_Comm_test_inter -- */

VT_MPI_INT MPI_Comm_test_inter(MPI_Comm comm, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_TEST_INTER]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_test_inter,
      (comm, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_test_inter(comm, flag);

    VT_UNIMCI_CHECK_POST(MPI_Comm_test_inter,
      (comm, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_test_inter(comm, flag);
  }

  return result;
}

/* -- MPI_Dims_create -- */

VT_MPI_INT MPI_Dims_create(VT_MPI_INT nnodes, VT_MPI_INT ndims, VT_MPI_INT* dims)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_DIMS_CREATE]);

    VT_UNIMCI_CHECK_PRE(MPI_Dims_create,
      (nnodes, ndims, dims, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Dims_create(nnodes, ndims, dims);

    VT_UNIMCI_CHECK_POST(MPI_Dims_create,
      (nnodes, ndims, dims, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Dims_create(nnodes, ndims, dims);
  }

  return result;
}

/* -- MPI_Errhandler_create -- */

VT_MPI_INT MPI_Errhandler_create(MPI_Handler_function* function, MPI_Errhandler* errhandler_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ERRHANDLER_CREATE]);

    VT_UNIMCI_CHECK_PRE(MPI_Errhandler_create,
      (function, errhandler_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Errhandler_create(function, errhandler_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Errhandler_create,
      (function, errhandler_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Errhandler_create(function, errhandler_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Errhandler_free -- */

VT_MPI_INT MPI_Errhandler_free(MPI_Errhandler* errhandler_CLASS_SINGLE_IN)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ERRHANDLER_FREE]);

    VT_UNIMCI_CHECK_PRE(MPI_Errhandler_free,
      (errhandler_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Errhandler_free(errhandler_CLASS_SINGLE_IN);

    VT_UNIMCI_CHECK_POST(MPI_Errhandler_free,
      (errhandler_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Errhandler_free(errhandler_CLASS_SINGLE_IN);
  }

  return result;
}

/* -- MPI_Errhandler_get -- */

VT_MPI_INT MPI_Errhandler_get(MPI_Comm comm, MPI_Errhandler* errhandler_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ERRHANDLER_GET]);

    VT_UNIMCI_CHECK_PRE(MPI_Errhandler_get,
      (comm, errhandler_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Errhandler_get(comm, errhandler_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Errhandler_get,
      (comm, errhandler_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Errhandler_get(comm, errhandler_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Errhandler_set -- */

VT_MPI_INT MPI_Errhandler_set(MPI_Comm comm, MPI_Errhandler errhandler)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ERRHANDLER_SET]);

    VT_UNIMCI_CHECK_PRE(MPI_Errhandler_set,
      (comm, errhandler, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Errhandler_set(comm, errhandler);

    VT_UNIMCI_CHECK_POST(MPI_Errhandler_set,
      (comm, errhandler, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Errhandler_set(comm, errhandler);
  }

  return result;
}

/* -- MPI_Error_class -- */

VT_MPI_INT MPI_Error_class(VT_MPI_INT errorcode, VT_MPI_INT* errorclass)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ERROR_CLASS]);

    VT_UNIMCI_CHECK_PRE(MPI_Error_class,
      (errorcode, errorclass, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Error_class(errorcode, errorclass);

    VT_UNIMCI_CHECK_POST(MPI_Error_class,
      (errorcode, errorclass, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Error_class(errorcode, errorclass);
  }

  return result;
}

/* -- MPI_Error_string -- */

VT_MPI_INT MPI_Error_string(VT_MPI_INT errorcode, char* string_CLASS_SINGLE_OUT, VT_MPI_INT* resultlen)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ERROR_STRING]);

    VT_UNIMCI_CHECK_PRE(MPI_Error_string,
      (errorcode, string_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Error_string(errorcode, string_CLASS_SINGLE_OUT, resultlen);

    VT_UNIMCI_CHECK_POST(MPI_Error_string,
      (errorcode, string_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Error_string(errorcode, string_CLASS_SINGLE_OUT, resultlen);
  }

  return result;
}

/* -- MPI_Finalize -- not generated */

/* -- MPI_Gather -- not generated */

/* -- MPI_Gatherv -- not generated */

/* -- MPI_Get_count -- */

VT_MPI_INT MPI_Get_count(MPI_Status* status_CLASS_SINGLE_IN, MPI_Datatype datatype, VT_MPI_INT* count)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GET_COUNT]);

    VT_UNIMCI_CHECK_PRE(MPI_Get_count,
      (status_CLASS_SINGLE_IN, datatype, count, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Get_count(status_CLASS_SINGLE_IN, datatype, count);

    VT_UNIMCI_CHECK_POST(MPI_Get_count,
      (status_CLASS_SINGLE_IN, datatype, count, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Get_count(status_CLASS_SINGLE_IN, datatype, count);
  }

  return result;
}

/* -- MPI_Get_elements -- */

VT_MPI_INT MPI_Get_elements(MPI_Status* status_CLASS_SINGLE_IN, MPI_Datatype datatype, VT_MPI_INT* count)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GET_ELEMENTS]);

    VT_UNIMCI_CHECK_PRE(MPI_Get_elements,
      (status_CLASS_SINGLE_IN, datatype, count, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Get_elements(status_CLASS_SINGLE_IN, datatype, count);

    VT_UNIMCI_CHECK_POST(MPI_Get_elements,
      (status_CLASS_SINGLE_IN, datatype, count, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Get_elements(status_CLASS_SINGLE_IN, datatype, count);
  }

  return result;
}

/* -- MPI_Get_processor_name -- */

VT_MPI_INT MPI_Get_processor_name(char* name_CLASS_SINGLE_OUT, VT_MPI_INT* resultlen)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GET_PROCESSOR_NAME]);

    VT_UNIMCI_CHECK_PRE(MPI_Get_processor_name,
      (name_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Get_processor_name(name_CLASS_SINGLE_OUT, resultlen);

    VT_UNIMCI_CHECK_POST(MPI_Get_processor_name,
      (name_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Get_processor_name(name_CLASS_SINGLE_OUT, resultlen);
  }

  return result;
}

/* -- MPI_Get_version -- */

VT_MPI_INT MPI_Get_version(VT_MPI_INT* version, VT_MPI_INT* subversion)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GET_VERSION]);

    VT_UNIMCI_CHECK_PRE(MPI_Get_version,
      (version, subversion, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Get_version(version, subversion);

    VT_UNIMCI_CHECK_POST(MPI_Get_version,
      (version, subversion, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Get_version(version, subversion);
  }

  return result;
}

/* -- MPI_Graph_create -- not generated */

/* -- MPI_Graph_get -- */

VT_MPI_INT MPI_Graph_get(MPI_Comm comm, VT_MPI_INT maxindex, VT_MPI_INT maxedges, VT_MPI_INT* index, VT_MPI_INT* edges)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GRAPH_GET]);

    VT_UNIMCI_CHECK_PRE(MPI_Graph_get,
      (comm, maxindex, maxedges, index, edges, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Graph_get(comm, maxindex, maxedges, index, edges);

    VT_UNIMCI_CHECK_POST(MPI_Graph_get,
      (comm, maxindex, maxedges, index, edges, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Graph_get(comm, maxindex, maxedges, index, edges);
  }

  return result;
}

/* -- MPI_Graph_map -- */

VT_MPI_INT MPI_Graph_map(MPI_Comm comm, VT_MPI_INT nnodes, VT_MPI_INT* index, VT_MPI_INT* edges, VT_MPI_INT* newrank)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GRAPH_MAP]);

    VT_UNIMCI_CHECK_PRE(MPI_Graph_map,
      (comm, nnodes, index, edges, newrank, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Graph_map(comm, nnodes, index, edges, newrank);

    VT_UNIMCI_CHECK_POST(MPI_Graph_map,
      (comm, nnodes, index, edges, newrank, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Graph_map(comm, nnodes, index, edges, newrank);
  }

  return result;
}

/* -- MPI_Graph_neighbors -- */

VT_MPI_INT MPI_Graph_neighbors(MPI_Comm comm, VT_MPI_INT rank, VT_MPI_INT maxneighbors, VT_MPI_INT* neighbors)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GRAPH_NEIGHBORS]);

    VT_UNIMCI_CHECK_PRE(MPI_Graph_neighbors,
      (comm, rank, maxneighbors, neighbors, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Graph_neighbors(comm, rank, maxneighbors, neighbors);

    VT_UNIMCI_CHECK_POST(MPI_Graph_neighbors,
      (comm, rank, maxneighbors, neighbors, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Graph_neighbors(comm, rank, maxneighbors, neighbors);
  }

  return result;
}

/* -- MPI_Graph_neighbors_count -- */

VT_MPI_INT MPI_Graph_neighbors_count(MPI_Comm comm, VT_MPI_INT rank, VT_MPI_INT* nneighbors)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GRAPH_NEIGHBORS_COUNT]);

    VT_UNIMCI_CHECK_PRE(MPI_Graph_neighbors_count,
      (comm, rank, nneighbors, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Graph_neighbors_count(comm, rank, nneighbors);

    VT_UNIMCI_CHECK_POST(MPI_Graph_neighbors_count,
      (comm, rank, nneighbors, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Graph_neighbors_count(comm, rank, nneighbors);
  }

  return result;
}

/* -- MPI_Graphdims_get -- */

VT_MPI_INT MPI_Graphdims_get(MPI_Comm comm, VT_MPI_INT* nnodes, VT_MPI_INT* nedges)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GRAPHDIMS_GET]);

    VT_UNIMCI_CHECK_PRE(MPI_Graphdims_get,
      (comm, nnodes, nedges, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Graphdims_get(comm, nnodes, nedges);

    VT_UNIMCI_CHECK_POST(MPI_Graphdims_get,
      (comm, nnodes, nedges, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Graphdims_get(comm, nnodes, nedges);
  }

  return result;
}

/* -- MPI_Group_compare -- */

VT_MPI_INT MPI_Group_compare(MPI_Group group1, MPI_Group group2, VT_MPI_INT* _result)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GROUP_COMPARE]);

    VT_UNIMCI_CHECK_PRE(MPI_Group_compare,
      (group1, group2, _result, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Group_compare(group1, group2, _result);

    VT_UNIMCI_CHECK_POST(MPI_Group_compare,
      (group1, group2, _result, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Group_compare(group1, group2, _result);
  }

  return result;
}

/* -- MPI_Group_difference -- not generated */

/* -- MPI_Group_excl -- not generated */

/* -- MPI_Group_free -- not generated */

/* -- MPI_Group_incl -- not generated */

/* -- MPI_Group_intersection -- not generated */

/* -- MPI_Group_range_excl -- not generated */

/* -- MPI_Group_range_incl -- not generated */

/* -- MPI_Group_rank -- */

VT_MPI_INT MPI_Group_rank(MPI_Group group, VT_MPI_INT* rank)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GROUP_RANK]);

    VT_UNIMCI_CHECK_PRE(MPI_Group_rank,
      (group, rank, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Group_rank(group, rank);

    VT_UNIMCI_CHECK_POST(MPI_Group_rank,
      (group, rank, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Group_rank(group, rank);
  }

  return result;
}

/* -- MPI_Group_size -- */

VT_MPI_INT MPI_Group_size(MPI_Group group, VT_MPI_INT* size)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GROUP_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_Group_size,
      (group, size, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Group_size(group, size);

    VT_UNIMCI_CHECK_POST(MPI_Group_size,
      (group, size, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Group_size(group, size);
  }

  return result;
}

/* -- MPI_Group_translate_ranks -- */

VT_MPI_INT MPI_Group_translate_ranks(MPI_Group group1, VT_MPI_INT n, VT_MPI_INT* ranks1, MPI_Group group2, VT_MPI_INT* ranks2)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GROUP_TRANSLATE_RANKS]);

    VT_UNIMCI_CHECK_PRE(MPI_Group_translate_ranks,
      (group1, n, ranks1, group2, ranks2, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Group_translate_ranks(group1, n, ranks1, group2, ranks2);

    VT_UNIMCI_CHECK_POST(MPI_Group_translate_ranks,
      (group1, n, ranks1, group2, ranks2, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Group_translate_ranks(group1, n, ranks1, group2, ranks2);
  }

  return result;
}

/* -- MPI_Group_union -- not generated */

/* -- MPI_Ibsend -- not generated */

/* -- MPI_Init -- not generated */

/* -- MPI_Initialized -- */

VT_MPI_INT MPI_Initialized(VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INITIALIZED]);

    VT_UNIMCI_CHECK_PRE(MPI_Initialized,
      (flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Initialized(flag);

    VT_UNIMCI_CHECK_POST(MPI_Initialized,
      (flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Initialized(flag);
  }

  return result;
}

/* -- MPI_Intercomm_create -- not generated */

/* -- MPI_Intercomm_merge -- not generated */

/* -- MPI_Iprobe -- */

VT_MPI_INT MPI_Iprobe(VT_MPI_INT source, VT_MPI_INT tag, MPI_Comm comm, VT_MPI_INT* flag, MPI_Status* status_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_IPROBE]);

    VT_UNIMCI_CHECK_PRE(MPI_Iprobe,
      (source, tag, comm, flag, status_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Iprobe(source, tag, comm, flag, status_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Iprobe,
      (source, tag, comm, flag, status_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Iprobe(source, tag, comm, flag, status_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Irecv -- not generated */

/* -- MPI_Irsend -- not generated */

/* -- MPI_Isend -- not generated */

/* -- MPI_Issend -- not generated */

/* -- MPI_Keyval_create -- */

VT_MPI_INT MPI_Keyval_create(MPI_Copy_function* copy_fn, MPI_Delete_function* delete_fn, VT_MPI_INT* keyval, void* extra_state)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_KEYVAL_CREATE]);

    VT_UNIMCI_CHECK_PRE(MPI_Keyval_create,
      (copy_fn, delete_fn, keyval, extra_state, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Keyval_create(copy_fn, delete_fn, keyval, extra_state);

    VT_UNIMCI_CHECK_POST(MPI_Keyval_create,
      (copy_fn, delete_fn, keyval, extra_state, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Keyval_create(copy_fn, delete_fn, keyval, extra_state);
  }

  return result;
}

/* -- MPI_Keyval_free -- */

VT_MPI_INT MPI_Keyval_free(VT_MPI_INT* keyval)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_KEYVAL_FREE]);

    VT_UNIMCI_CHECK_PRE(MPI_Keyval_free,
      (keyval, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Keyval_free(keyval);

    VT_UNIMCI_CHECK_POST(MPI_Keyval_free,
      (keyval, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Keyval_free(keyval);
  }

  return result;
}

/* -- MPI_Op_create -- */

VT_MPI_INT MPI_Op_create(MPI_User_function* function, VT_MPI_INT commute, MPI_Op* op_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_OP_CREATE]);

    VT_UNIMCI_CHECK_PRE(MPI_Op_create,
      (function, commute, op_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Op_create(function, commute, op_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Op_create,
      (function, commute, op_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Op_create(function, commute, op_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Op_free -- */

VT_MPI_INT MPI_Op_free(MPI_Op* op_CLASS_SINGLE_IO)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_OP_FREE]);

    VT_UNIMCI_CHECK_PRE(MPI_Op_free,
      (op_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Op_free(op_CLASS_SINGLE_IO);

    VT_UNIMCI_CHECK_POST(MPI_Op_free,
      (op_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Op_free(op_CLASS_SINGLE_IO);
  }

  return result;
}

/* -- MPI_Pack -- */

VT_MPI_INT MPI_Pack(void* inbuf_CLASS_BUFFER, VT_MPI_INT incount, MPI_Datatype datatype, void* outbuf, VT_MPI_INT outsize, VT_MPI_INT* position, MPI_Comm comm)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_PACK]);

    VT_UNIMCI_CHECK_PRE(MPI_Pack,
      (inbuf_CLASS_BUFFER, incount, datatype, outbuf, outsize, position, comm, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Pack(inbuf_CLASS_BUFFER, incount, datatype, outbuf, outsize, position, comm);

    VT_UNIMCI_CHECK_POST(MPI_Pack,
      (inbuf_CLASS_BUFFER, incount, datatype, outbuf, outsize, position, comm, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Pack(inbuf_CLASS_BUFFER, incount, datatype, outbuf, outsize, position, comm);
  }

  return result;
}

/* -- MPI_Pack_size -- */

VT_MPI_INT MPI_Pack_size(VT_MPI_INT incount, MPI_Datatype datatype, MPI_Comm comm, VT_MPI_INT* size)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_PACK_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_Pack_size,
      (incount, datatype, comm, size, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Pack_size(incount, datatype, comm, size);

    VT_UNIMCI_CHECK_POST(MPI_Pack_size,
      (incount, datatype, comm, size, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Pack_size(incount, datatype, comm, size);
  }

  return result;
}

/* -- MPI_Pcontrol -- not generated */

/* -- MPI_Probe -- */

VT_MPI_INT MPI_Probe(VT_MPI_INT source, VT_MPI_INT tag, MPI_Comm comm, MPI_Status* status_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_PROBE]);

    VT_UNIMCI_CHECK_PRE(MPI_Probe,
      (source, tag, comm, status_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Probe(source, tag, comm, status_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Probe,
      (source, tag, comm, status_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Probe(source, tag, comm, status_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Recv -- not generated */

/* -- MPI_Recv_init -- not generated */

/* -- MPI_Reduce -- not generated */

/* -- MPI_Reduce_scatter -- not generated */

/* -- MPI_Request_free -- not generated */

/* -- MPI_Rsend -- not generated */

/* -- MPI_Rsend_init -- not generated */

/* -- MPI_Scan -- not generated */

/* -- MPI_Scatter -- not generated */

/* -- MPI_Scatterv -- not generated */

/* -- MPI_Send -- not generated */

/* -- MPI_Send_init -- not generated */

/* -- MPI_Sendrecv -- not generated */

/* -- MPI_Sendrecv_replace -- not generated */

/* -- MPI_Ssend -- not generated */

/* -- MPI_Ssend_init -- not generated */

/* -- MPI_Start -- not generated */

/* -- MPI_Startall -- not generated */

/* -- MPI_Test -- not generated */

/* -- MPI_Test_cancelled -- */

VT_MPI_INT MPI_Test_cancelled(MPI_Status* status_CLASS_SINGLE_IN, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TEST_CANCELLED]);

    VT_UNIMCI_CHECK_PRE(MPI_Test_cancelled,
      (status_CLASS_SINGLE_IN, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Test_cancelled(status_CLASS_SINGLE_IN, flag);

    VT_UNIMCI_CHECK_POST(MPI_Test_cancelled,
      (status_CLASS_SINGLE_IN, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Test_cancelled(status_CLASS_SINGLE_IN, flag);
  }

  return result;
}

/* -- MPI_Testall -- not generated */

/* -- MPI_Testany -- not generated */

/* -- MPI_Testsome -- not generated */

/* -- MPI_Topo_test -- */

VT_MPI_INT MPI_Topo_test(MPI_Comm comm, VT_MPI_INT* status)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TOPO_TEST]);

    VT_UNIMCI_CHECK_PRE(MPI_Topo_test,
      (comm, status, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Topo_test(comm, status);

    VT_UNIMCI_CHECK_POST(MPI_Topo_test,
      (comm, status, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Topo_test(comm, status);
  }

  return result;
}

/* -- MPI_Type_commit -- */

VT_MPI_INT MPI_Type_commit(MPI_Datatype* datatype_CLASS_SINGLE_IO)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_COMMIT]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_commit,
      (datatype_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_commit(datatype_CLASS_SINGLE_IO);

    VT_UNIMCI_CHECK_POST(MPI_Type_commit,
      (datatype_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_commit(datatype_CLASS_SINGLE_IO);
  }

  return result;
}

/* -- MPI_Type_contiguous -- */

VT_MPI_INT MPI_Type_contiguous(VT_MPI_INT count, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CONTIGUOUS]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_contiguous,
      (count, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_contiguous(count, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_contiguous,
      (count, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_contiguous(count, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_extent -- */

VT_MPI_INT MPI_Type_extent(MPI_Datatype datatype, MPI_Aint* extent_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_EXTENT]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_extent,
      (datatype, extent_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_extent(datatype, extent_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_extent,
      (datatype, extent_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_extent(datatype, extent_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_free -- */

VT_MPI_INT MPI_Type_free(MPI_Datatype* datatype_CLASS_SINGLE_IO)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_FREE]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_free,
      (datatype_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_free(datatype_CLASS_SINGLE_IO);

    VT_UNIMCI_CHECK_POST(MPI_Type_free,
      (datatype_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_free(datatype_CLASS_SINGLE_IO);
  }

  return result;
}

/* -- MPI_Type_hindexed -- */

VT_MPI_INT MPI_Type_hindexed(VT_MPI_INT count, VT_MPI_INT* array_of_blocklengths, MPI_Aint* array_of_displacements_CLASS_ARRAY_IN_count, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_HINDEXED]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_hindexed,
      (count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_hindexed(count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_hindexed,
      (count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_hindexed(count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_hvector -- */

VT_MPI_INT MPI_Type_hvector(VT_MPI_INT count, VT_MPI_INT blocklength, MPI_Aint stride, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_HVECTOR]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_hvector,
      (count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_hvector(count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_hvector,
      (count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_hvector(count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_indexed -- */

VT_MPI_INT MPI_Type_indexed(VT_MPI_INT count, VT_MPI_INT* array_of_blocklengths, VT_MPI_INT* array_of_displacements, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_INDEXED]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_indexed,
      (count, array_of_blocklengths, array_of_displacements, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_indexed(count, array_of_blocklengths, array_of_displacements, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_indexed,
      (count, array_of_blocklengths, array_of_displacements, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_indexed(count, array_of_blocklengths, array_of_displacements, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_lb -- */

VT_MPI_INT MPI_Type_lb(MPI_Datatype datatype, MPI_Aint* displacement_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_LB]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_lb,
      (datatype, displacement_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_lb(datatype, displacement_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_lb,
      (datatype, displacement_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_lb(datatype, displacement_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_size -- */

VT_MPI_INT MPI_Type_size(MPI_Datatype datatype, VT_MPI_INT* size)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_size,
      (datatype, size, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_size(datatype, size);

    VT_UNIMCI_CHECK_POST(MPI_Type_size,
      (datatype, size, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_size(datatype, size);
  }

  return result;
}

/* -- MPI_Type_struct -- */

VT_MPI_INT MPI_Type_struct(VT_MPI_INT count, VT_MPI_INT* array_of_blocklengths, MPI_Aint* array_of_displacements_CLASS_ARRAY_IN_count, MPI_Datatype* array_of_types_CLASS_ARRAY_IN_count, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_STRUCT]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_struct,
      (count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, array_of_types_CLASS_ARRAY_IN_count, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_struct(count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, array_of_types_CLASS_ARRAY_IN_count, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_struct,
      (count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, array_of_types_CLASS_ARRAY_IN_count, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_struct(count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, array_of_types_CLASS_ARRAY_IN_count, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_ub -- */

VT_MPI_INT MPI_Type_ub(MPI_Datatype datatype, MPI_Aint* displacement_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_UB]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_ub,
      (datatype, displacement_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_ub(datatype, displacement_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_ub,
      (datatype, displacement_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_ub(datatype, displacement_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_vector -- */

VT_MPI_INT MPI_Type_vector(VT_MPI_INT count, VT_MPI_INT blocklength, VT_MPI_INT stride, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_VECTOR]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_vector,
      (count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_vector(count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_vector,
      (count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_vector(count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Unpack -- */

VT_MPI_INT MPI_Unpack(void* inbuf, VT_MPI_INT insize, VT_MPI_INT* position, void* outbuf_CLASS_BUFFER, VT_MPI_INT outcount, MPI_Datatype datatype, MPI_Comm comm)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_UNPACK]);

    VT_UNIMCI_CHECK_PRE(MPI_Unpack,
      (inbuf, insize, position, outbuf_CLASS_BUFFER, outcount, datatype, comm, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Unpack(inbuf, insize, position, outbuf_CLASS_BUFFER, outcount, datatype, comm);

    VT_UNIMCI_CHECK_POST(MPI_Unpack,
      (inbuf, insize, position, outbuf_CLASS_BUFFER, outcount, datatype, comm, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Unpack(inbuf, insize, position, outbuf_CLASS_BUFFER, outcount, datatype, comm);
  }

  return result;
}

/* -- MPI_Wait -- not generated */

/* -- MPI_Waitall -- not generated */

/* -- MPI_Waitany -- not generated */

/* -- MPI_Waitsome -- not generated */

/* -- MPI_Wtick -- not generated */

/* -- MPI_Wtime -- not generated */

/* -- MPI_Alloc_mem -- */

VT_MPI_INT MPI_Alloc_mem(MPI_Aint size, MPI_Info info, void* baseptr)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ALLOC_MEM]);

    VT_UNIMCI_CHECK_PRE(MPI_Alloc_mem,
      (size, info, baseptr, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Alloc_mem(size, info, baseptr);

    VT_UNIMCI_CHECK_POST(MPI_Alloc_mem,
      (size, info, baseptr, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Alloc_mem(size, info, baseptr);
  }

  return result;
}

/* -- MPI_Comm_create_errhandler -- not generated */

/* -- MPI_Comm_get_errhandler -- not generated */

/* -- MPI_Comm_set_errhandler -- not generated */

/* -- MPI_File_call_errhandler -- not generated */

/* -- MPI_File_create_errhandler -- not generated */

/* -- MPI_File_get_errhandler -- not generated */

/* -- MPI_File_set_errhandler -- not generated */

/* -- MPI_Finalized -- not generated */

/* -- MPI_Free_mem -- */

VT_MPI_INT MPI_Free_mem(void* base)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FREE_MEM]);

    VT_UNIMCI_CHECK_PRE(MPI_Free_mem,
      (base, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Free_mem(base);

    VT_UNIMCI_CHECK_POST(MPI_Free_mem,
      (base, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Free_mem(base);
  }

  return result;
}

/* -- MPI_Get_address -- not generated */

/* -- MPI_Info_create -- */

VT_MPI_INT MPI_Info_create(MPI_Info* info_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_CREATE]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_create,
      (info_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_create(info_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Info_create,
      (info_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_create(info_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Info_delete -- */

VT_MPI_INT MPI_Info_delete(MPI_Info info, char* key_CLASS_SINGLE_IN)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_DELETE]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_delete,
      (info, key_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_delete(info, key_CLASS_SINGLE_IN);

    VT_UNIMCI_CHECK_POST(MPI_Info_delete,
      (info, key_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_delete(info, key_CLASS_SINGLE_IN);
  }

  return result;
}

/* -- MPI_Info_dup -- */

VT_MPI_INT MPI_Info_dup(MPI_Info info, MPI_Info* newinfo_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_DUP]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_dup,
      (info, newinfo_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_dup(info, newinfo_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Info_dup,
      (info, newinfo_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_dup(info, newinfo_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Info_free -- */

VT_MPI_INT MPI_Info_free(MPI_Info* info_CLASS_SINGLE_IO)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_FREE]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_free,
      (info_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_free(info_CLASS_SINGLE_IO);

    VT_UNIMCI_CHECK_POST(MPI_Info_free,
      (info_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_free(info_CLASS_SINGLE_IO);
  }

  return result;
}

/* -- MPI_Info_get -- */

VT_MPI_INT MPI_Info_get(MPI_Info info, char* key_CLASS_SINGLE_IN, VT_MPI_INT valuelen, char* value_CLASS_SINGLE_OUT, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_GET]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_get,
      (info, key_CLASS_SINGLE_IN, valuelen, value_CLASS_SINGLE_OUT, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_get(info, key_CLASS_SINGLE_IN, valuelen, value_CLASS_SINGLE_OUT, flag);

    VT_UNIMCI_CHECK_POST(MPI_Info_get,
      (info, key_CLASS_SINGLE_IN, valuelen, value_CLASS_SINGLE_OUT, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_get(info, key_CLASS_SINGLE_IN, valuelen, value_CLASS_SINGLE_OUT, flag);
  }

  return result;
}

/* -- MPI_Info_get_nkeys -- */

VT_MPI_INT MPI_Info_get_nkeys(MPI_Info info, VT_MPI_INT* nkeys)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_GET_NKEYS]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_get_nkeys,
      (info, nkeys, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_get_nkeys(info, nkeys);

    VT_UNIMCI_CHECK_POST(MPI_Info_get_nkeys,
      (info, nkeys, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_get_nkeys(info, nkeys);
  }

  return result;
}

/* -- MPI_Info_get_nthkey -- */

VT_MPI_INT MPI_Info_get_nthkey(MPI_Info info, VT_MPI_INT n, char* key_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_GET_NTHKEY]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_get_nthkey,
      (info, n, key_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_get_nthkey(info, n, key_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Info_get_nthkey,
      (info, n, key_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_get_nthkey(info, n, key_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Info_get_valuelen -- */

VT_MPI_INT MPI_Info_get_valuelen(MPI_Info info, char* key_CLASS_SINGLE_IN, VT_MPI_INT* valuelen, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_GET_VALUELEN]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_get_valuelen,
      (info, key_CLASS_SINGLE_IN, valuelen, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_get_valuelen(info, key_CLASS_SINGLE_IN, valuelen, flag);

    VT_UNIMCI_CHECK_POST(MPI_Info_get_valuelen,
      (info, key_CLASS_SINGLE_IN, valuelen, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_get_valuelen(info, key_CLASS_SINGLE_IN, valuelen, flag);
  }

  return result;
}

/* -- MPI_Info_set -- */

VT_MPI_INT MPI_Info_set(MPI_Info info, char* key_CLASS_SINGLE_IN, char* value_CLASS_SINGLE_IN)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_INFO_SET]);

    VT_UNIMCI_CHECK_PRE(MPI_Info_set,
      (info, key_CLASS_SINGLE_IN, value_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Info_set(info, key_CLASS_SINGLE_IN, value_CLASS_SINGLE_IN);

    VT_UNIMCI_CHECK_POST(MPI_Info_set,
      (info, key_CLASS_SINGLE_IN, value_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Info_set(info, key_CLASS_SINGLE_IN, value_CLASS_SINGLE_IN);
  }

  return result;
}

/* -- MPI_Pack_external -- */

VT_MPI_INT MPI_Pack_external(char* datarep_CLASS_SINGLE_IN, void* inbuf, VT_MPI_INT incount, MPI_Datatype datatype, void* outbuf, MPI_Aint outsize, MPI_Aint* position_CLASS_SINGLE_IO)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_PACK_EXTERNAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Pack_external,
      (datarep_CLASS_SINGLE_IN, inbuf, incount, datatype, outbuf, outsize, position_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Pack_external(datarep_CLASS_SINGLE_IN, inbuf, incount, datatype, outbuf, outsize, position_CLASS_SINGLE_IO);

    VT_UNIMCI_CHECK_POST(MPI_Pack_external,
      (datarep_CLASS_SINGLE_IN, inbuf, incount, datatype, outbuf, outsize, position_CLASS_SINGLE_IO, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Pack_external(datarep_CLASS_SINGLE_IN, inbuf, incount, datatype, outbuf, outsize, position_CLASS_SINGLE_IO);
  }

  return result;
}

/* -- MPI_Pack_external_size -- */

VT_MPI_INT MPI_Pack_external_size(char* datarep_CLASS_SINGLE_IN, VT_MPI_INT incount, MPI_Datatype datatype, MPI_Aint* size_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_PACK_EXTERNAL_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_Pack_external_size,
      (datarep_CLASS_SINGLE_IN, incount, datatype, size_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Pack_external_size(datarep_CLASS_SINGLE_IN, incount, datatype, size_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Pack_external_size,
      (datarep_CLASS_SINGLE_IN, incount, datatype, size_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Pack_external_size(datarep_CLASS_SINGLE_IN, incount, datatype, size_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Request_get_status -- */

VT_MPI_INT MPI_Request_get_status(MPI_Request request, VT_MPI_INT* flag, MPI_Status* status_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_REQUEST_GET_STATUS]);

    VT_UNIMCI_CHECK_PRE(MPI_Request_get_status,
      (request, flag, status_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Request_get_status(request, flag, status_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Request_get_status,
      (request, flag, status_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Request_get_status(request, flag, status_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_create_darray -- */

VT_MPI_INT MPI_Type_create_darray(VT_MPI_INT size, VT_MPI_INT rank, VT_MPI_INT ndims, VT_MPI_INT* array_of_gsizes, VT_MPI_INT* array_of_distribs, VT_MPI_INT* array_of_dargs, VT_MPI_INT* array_of_psizes, VT_MPI_INT order, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_DARRAY]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_darray,
      (size, rank, ndims, array_of_gsizes, array_of_distribs, array_of_dargs, array_of_psizes, order, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_darray(size, rank, ndims, array_of_gsizes, array_of_distribs, array_of_dargs, array_of_psizes, order, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_darray,
      (size, rank, ndims, array_of_gsizes, array_of_distribs, array_of_dargs, array_of_psizes, order, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_darray(size, rank, ndims, array_of_gsizes, array_of_distribs, array_of_dargs, array_of_psizes, order, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_create_hindexed -- */

VT_MPI_INT MPI_Type_create_hindexed(VT_MPI_INT count, VT_MPI_INT* array_of_blocklengths, MPI_Aint* array_of_displacements_CLASS_ARRAY_IN_count, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_HINDEXED]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_hindexed,
      (count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_hindexed(count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_hindexed,
      (count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_hindexed(count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_create_hvector -- */

VT_MPI_INT MPI_Type_create_hvector(VT_MPI_INT count, VT_MPI_INT blocklength, MPI_Aint stride, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_HVECTOR]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_hvector,
      (count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_hvector(count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_hvector,
      (count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_hvector(count, blocklength, stride, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_create_indexed_block -- */

VT_MPI_INT MPI_Type_create_indexed_block(VT_MPI_INT count, VT_MPI_INT blocklength, VT_MPI_INT* array_of_displacements, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_INDEXED_BLOCK]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_indexed_block,
      (count, blocklength, array_of_displacements, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_indexed_block(count, blocklength, array_of_displacements, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_indexed_block,
      (count, blocklength, array_of_displacements, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_indexed_block(count, blocklength, array_of_displacements, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_create_resized -- */

VT_MPI_INT MPI_Type_create_resized(MPI_Datatype oldtype, MPI_Aint lb, MPI_Aint extent, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_RESIZED]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_resized,
      (oldtype, lb, extent, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_resized(oldtype, lb, extent, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_resized,
      (oldtype, lb, extent, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_resized(oldtype, lb, extent, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_create_struct -- */

VT_MPI_INT MPI_Type_create_struct(VT_MPI_INT count, VT_MPI_INT* array_of_blocklengths, MPI_Aint* array_of_displacements_CLASS_ARRAY_IN_count, MPI_Datatype* array_of_types_CLASS_ARRAY_IN_count, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_STRUCT]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_struct,
      (count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, array_of_types_CLASS_ARRAY_IN_count, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_struct(count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, array_of_types_CLASS_ARRAY_IN_count, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_struct,
      (count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, array_of_types_CLASS_ARRAY_IN_count, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_struct(count, array_of_blocklengths, array_of_displacements_CLASS_ARRAY_IN_count, array_of_types_CLASS_ARRAY_IN_count, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_create_subarray -- */

VT_MPI_INT MPI_Type_create_subarray(VT_MPI_INT ndims, VT_MPI_INT* array_of_sizes, VT_MPI_INT* array_of_subsizes, VT_MPI_INT* array_of_starts, VT_MPI_INT order, MPI_Datatype oldtype, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_SUBARRAY]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_subarray,
      (ndims, array_of_sizes, array_of_subsizes, array_of_starts, order, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_subarray(ndims, array_of_sizes, array_of_subsizes, array_of_starts, order, oldtype, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_subarray,
      (ndims, array_of_sizes, array_of_subsizes, array_of_starts, order, oldtype, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_subarray(ndims, array_of_sizes, array_of_subsizes, array_of_starts, order, oldtype, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_get_extent -- */

VT_MPI_INT MPI_Type_get_extent(MPI_Datatype datatype, MPI_Aint* lb_CLASS_SINGLE_OUT, MPI_Aint* extent_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_GET_EXTENT]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_get_extent,
      (datatype, lb_CLASS_SINGLE_OUT, extent_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_get_extent(datatype, lb_CLASS_SINGLE_OUT, extent_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_get_extent,
      (datatype, lb_CLASS_SINGLE_OUT, extent_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_get_extent(datatype, lb_CLASS_SINGLE_OUT, extent_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_get_true_extent -- */

VT_MPI_INT MPI_Type_get_true_extent(MPI_Datatype datatype, MPI_Aint* true_lb_CLASS_SINGLE_OUT, MPI_Aint* true_extent_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_GET_TRUE_EXTENT]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_get_true_extent,
      (datatype, true_lb_CLASS_SINGLE_OUT, true_extent_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_get_true_extent(datatype, true_lb_CLASS_SINGLE_OUT, true_extent_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_get_true_extent,
      (datatype, true_lb_CLASS_SINGLE_OUT, true_extent_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_get_true_extent(datatype, true_lb_CLASS_SINGLE_OUT, true_extent_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Unpack_external -- */

VT_MPI_INT MPI_Unpack_external(char* datarep_CLASS_SINGLE_IN, void* inbuf, MPI_Aint insize, MPI_Aint* position_CLASS_SINGLE_IO, void* outbuf, VT_MPI_INT outcount, MPI_Datatype datatype)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_UNPACK_EXTERNAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Unpack_external,
      (datarep_CLASS_SINGLE_IN, inbuf, insize, position_CLASS_SINGLE_IO, outbuf, outcount, datatype, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Unpack_external(datarep_CLASS_SINGLE_IN, inbuf, insize, position_CLASS_SINGLE_IO, outbuf, outcount, datatype);

    VT_UNIMCI_CHECK_POST(MPI_Unpack_external,
      (datarep_CLASS_SINGLE_IN, inbuf, insize, position_CLASS_SINGLE_IO, outbuf, outcount, datatype, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Unpack_external(datarep_CLASS_SINGLE_IN, inbuf, insize, position_CLASS_SINGLE_IO, outbuf, outcount, datatype);
  }

  return result;
}

/* -- MPI_Win_create_errhandler -- not generated */

/* -- MPI_Win_get_errhandler -- not generated */

/* -- MPI_Win_set_errhandler -- not generated */

#if defined(HAVE_MPI_ADD_ERROR_CLASS) && HAVE_MPI_ADD_ERROR_CLASS

/* -- MPI_Add_error_class -- */

VT_MPI_INT MPI_Add_error_class(VT_MPI_INT* errorclass)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ADD_ERROR_CLASS]);

    VT_UNIMCI_CHECK_PRE(MPI_Add_error_class,
      (errorclass, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Add_error_class(errorclass);

    VT_UNIMCI_CHECK_POST(MPI_Add_error_class,
      (errorclass, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Add_error_class(errorclass);
  }

  return result;
}

#endif

#if defined(HAVE_MPI_ADD_ERROR_CODE) && HAVE_MPI_ADD_ERROR_CODE

/* -- MPI_Add_error_code -- */

VT_MPI_INT MPI_Add_error_code(VT_MPI_INT errorclass, VT_MPI_INT* errorcode)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ADD_ERROR_CODE]);

    VT_UNIMCI_CHECK_PRE(MPI_Add_error_code,
      (errorclass, errorcode, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Add_error_code(errorclass, errorcode);

    VT_UNIMCI_CHECK_POST(MPI_Add_error_code,
      (errorclass, errorcode, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Add_error_code(errorclass, errorcode);
  }

  return result;
}

#endif

#if defined(HAVE_MPI_ADD_ERROR_STRING) && HAVE_MPI_ADD_ERROR_STRING

/* -- MPI_Add_error_string -- */

VT_MPI_INT MPI_Add_error_string(VT_MPI_INT errorcode, char* string_CLASS_SINGLE_IN)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_ADD_ERROR_STRING]);

    VT_UNIMCI_CHECK_PRE(MPI_Add_error_string,
      (errorcode, string_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Add_error_string(errorcode, string_CLASS_SINGLE_IN);

    VT_UNIMCI_CHECK_POST(MPI_Add_error_string,
      (errorcode, string_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Add_error_string(errorcode, string_CLASS_SINGLE_IN);
  }

  return result;
}

#endif

/* -- MPI_Comm_call_errhandler -- not generated */

/* -- MPI_Comm_create_keyval -- */

VT_MPI_INT MPI_Comm_create_keyval(MPI_Comm_copy_attr_function* comm_copy_attr_fn, MPI_Comm_delete_attr_function* comm_delete_attr_fn, VT_MPI_INT* comm_keyval, void* extra_state)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_CREATE_KEYVAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_create_keyval,
      (comm_copy_attr_fn, comm_delete_attr_fn, comm_keyval, extra_state, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_create_keyval(comm_copy_attr_fn, comm_delete_attr_fn, comm_keyval, extra_state);

    VT_UNIMCI_CHECK_POST(MPI_Comm_create_keyval,
      (comm_copy_attr_fn, comm_delete_attr_fn, comm_keyval, extra_state, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_create_keyval(comm_copy_attr_fn, comm_delete_attr_fn, comm_keyval, extra_state);
  }

  return result;
}

/* -- MPI_Comm_delete_attr -- */

VT_MPI_INT MPI_Comm_delete_attr(MPI_Comm comm, VT_MPI_INT comm_keyval)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_DELETE_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_delete_attr,
      (comm, comm_keyval, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_delete_attr(comm, comm_keyval);

    VT_UNIMCI_CHECK_POST(MPI_Comm_delete_attr,
      (comm, comm_keyval, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_delete_attr(comm, comm_keyval);
  }

  return result;
}

/* -- MPI_Comm_free_keyval -- */

VT_MPI_INT MPI_Comm_free_keyval(VT_MPI_INT* comm_keyval)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_FREE_KEYVAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_free_keyval,
      (comm_keyval, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_free_keyval(comm_keyval);

    VT_UNIMCI_CHECK_POST(MPI_Comm_free_keyval,
      (comm_keyval, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_free_keyval(comm_keyval);
  }

  return result;
}

/* -- MPI_Comm_get_attr -- */

VT_MPI_INT MPI_Comm_get_attr(MPI_Comm comm, VT_MPI_INT comm_keyval, void* attribute_val, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_GET_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_get_attr,
      (comm, comm_keyval, attribute_val, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_get_attr(comm, comm_keyval, attribute_val, flag);

    VT_UNIMCI_CHECK_POST(MPI_Comm_get_attr,
      (comm, comm_keyval, attribute_val, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_get_attr(comm, comm_keyval, attribute_val, flag);
  }

  return result;
}

/* -- MPI_Comm_get_name -- */

VT_MPI_INT MPI_Comm_get_name(MPI_Comm comm, char* comm_name_CLASS_SINGLE_OUT, VT_MPI_INT* resultlen)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_GET_NAME]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_get_name,
      (comm, comm_name_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_get_name(comm, comm_name_CLASS_SINGLE_OUT, resultlen);

    VT_UNIMCI_CHECK_POST(MPI_Comm_get_name,
      (comm, comm_name_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_get_name(comm, comm_name_CLASS_SINGLE_OUT, resultlen);
  }

  return result;
}

/* -- MPI_Comm_set_attr -- */

VT_MPI_INT MPI_Comm_set_attr(MPI_Comm comm, VT_MPI_INT comm_keyval, void* attribute_val)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_SET_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_set_attr,
      (comm, comm_keyval, attribute_val, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_set_attr(comm, comm_keyval, attribute_val);

    VT_UNIMCI_CHECK_POST(MPI_Comm_set_attr,
      (comm, comm_keyval, attribute_val, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_set_attr(comm, comm_keyval, attribute_val);
  }

  return result;
}

/* -- MPI_Comm_set_name -- */

VT_MPI_INT MPI_Comm_set_name(MPI_Comm comm, char* comm_name_CLASS_SINGLE_IN)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_COMM_SET_NAME]);

    VT_UNIMCI_CHECK_PRE(MPI_Comm_set_name,
      (comm, comm_name_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Comm_set_name(comm, comm_name_CLASS_SINGLE_IN);

    VT_UNIMCI_CHECK_POST(MPI_Comm_set_name,
      (comm, comm_name_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Comm_set_name(comm, comm_name_CLASS_SINGLE_IN);
  }

  return result;
}

/* -- MPI_Grequest_complete -- not generated */

/* -- MPI_Grequest_start -- */

VT_MPI_INT MPI_Grequest_start(MPI_Grequest_query_function* query_fn, MPI_Grequest_free_function* free_fn, MPI_Grequest_cancel_function* cancel_fn, void* extra_state, MPI_Request* request_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_GREQUEST_START]);

    VT_UNIMCI_CHECK_PRE(MPI_Grequest_start,
      (query_fn, free_fn, cancel_fn, extra_state, request_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Grequest_start(query_fn, free_fn, cancel_fn, extra_state, request_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Grequest_start,
      (query_fn, free_fn, cancel_fn, extra_state, request_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Grequest_start(query_fn, free_fn, cancel_fn, extra_state, request_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Status_set_cancelled -- */

VT_MPI_INT MPI_Status_set_cancelled(MPI_Status* status_CLASS_SINGLE_IO, VT_MPI_INT flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_STATUS_SET_CANCELLED]);

    VT_UNIMCI_CHECK_PRE(MPI_Status_set_cancelled,
      (status_CLASS_SINGLE_IO, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Status_set_cancelled(status_CLASS_SINGLE_IO, flag);

    VT_UNIMCI_CHECK_POST(MPI_Status_set_cancelled,
      (status_CLASS_SINGLE_IO, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Status_set_cancelled(status_CLASS_SINGLE_IO, flag);
  }

  return result;
}

/* -- MPI_Status_set_elements -- */

VT_MPI_INT MPI_Status_set_elements(MPI_Status* status_CLASS_SINGLE_IO, MPI_Datatype datatype, VT_MPI_INT count)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_STATUS_SET_ELEMENTS]);

    VT_UNIMCI_CHECK_PRE(MPI_Status_set_elements,
      (status_CLASS_SINGLE_IO, datatype, count, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Status_set_elements(status_CLASS_SINGLE_IO, datatype, count);

    VT_UNIMCI_CHECK_POST(MPI_Status_set_elements,
      (status_CLASS_SINGLE_IO, datatype, count, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Status_set_elements(status_CLASS_SINGLE_IO, datatype, count);
  }

  return result;
}

/* -- MPI_Type_create_keyval -- */

VT_MPI_INT MPI_Type_create_keyval(MPI_Type_copy_attr_function* type_copy_attr_fn, MPI_Type_delete_attr_function* type_delete_attr_fn, VT_MPI_INT* type_keyval, void* extra_state)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_KEYVAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_keyval,
      (type_copy_attr_fn, type_delete_attr_fn, type_keyval, extra_state, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_keyval(type_copy_attr_fn, type_delete_attr_fn, type_keyval, extra_state);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_keyval,
      (type_copy_attr_fn, type_delete_attr_fn, type_keyval, extra_state, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_keyval(type_copy_attr_fn, type_delete_attr_fn, type_keyval, extra_state);
  }

  return result;
}

/* -- MPI_Type_delete_attr -- */

VT_MPI_INT MPI_Type_delete_attr(MPI_Datatype type, VT_MPI_INT type_keyval)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_DELETE_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_delete_attr,
      (type, type_keyval, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_delete_attr(type, type_keyval);

    VT_UNIMCI_CHECK_POST(MPI_Type_delete_attr,
      (type, type_keyval, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_delete_attr(type, type_keyval);
  }

  return result;
}

/* -- MPI_Type_dup -- */

VT_MPI_INT MPI_Type_dup(MPI_Datatype type, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_DUP]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_dup,
      (type, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_dup(type, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_dup,
      (type, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_dup(type, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_Type_free_keyval -- */

VT_MPI_INT MPI_Type_free_keyval(VT_MPI_INT* type_keyval)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_FREE_KEYVAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_free_keyval,
      (type_keyval, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_free_keyval(type_keyval);

    VT_UNIMCI_CHECK_POST(MPI_Type_free_keyval,
      (type_keyval, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_free_keyval(type_keyval);
  }

  return result;
}

/* -- MPI_Type_get_attr -- */

VT_MPI_INT MPI_Type_get_attr(MPI_Datatype type, VT_MPI_INT type_keyval, void* attribute_val, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_GET_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_get_attr,
      (type, type_keyval, attribute_val, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_get_attr(type, type_keyval, attribute_val, flag);

    VT_UNIMCI_CHECK_POST(MPI_Type_get_attr,
      (type, type_keyval, attribute_val, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_get_attr(type, type_keyval, attribute_val, flag);
  }

  return result;
}

/* -- MPI_Type_get_contents -- */

VT_MPI_INT MPI_Type_get_contents(MPI_Datatype datatype, VT_MPI_INT max_integers, VT_MPI_INT max_addresses, VT_MPI_INT max_datatypes, VT_MPI_INT* array_of_integers, MPI_Aint* array_of_addresses_CLASS_ARRAY_OUT_max_addresses, MPI_Datatype* array_of_datatypes_CLASS_ARRAY_OUT_max_datatypes)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_GET_CONTENTS]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_get_contents,
      (datatype, max_integers, max_addresses, max_datatypes, array_of_integers, array_of_addresses_CLASS_ARRAY_OUT_max_addresses, array_of_datatypes_CLASS_ARRAY_OUT_max_datatypes, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_get_contents(datatype, max_integers, max_addresses, max_datatypes, array_of_integers, array_of_addresses_CLASS_ARRAY_OUT_max_addresses, array_of_datatypes_CLASS_ARRAY_OUT_max_datatypes);

    VT_UNIMCI_CHECK_POST(MPI_Type_get_contents,
      (datatype, max_integers, max_addresses, max_datatypes, array_of_integers, array_of_addresses_CLASS_ARRAY_OUT_max_addresses, array_of_datatypes_CLASS_ARRAY_OUT_max_datatypes, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_get_contents(datatype, max_integers, max_addresses, max_datatypes, array_of_integers, array_of_addresses_CLASS_ARRAY_OUT_max_addresses, array_of_datatypes_CLASS_ARRAY_OUT_max_datatypes);
  }

  return result;
}

/* -- MPI_Type_get_envelope -- */

VT_MPI_INT MPI_Type_get_envelope(MPI_Datatype datatype, VT_MPI_INT* num_integers, VT_MPI_INT* num_addresses, VT_MPI_INT* num_datatypes, VT_MPI_INT* combiner)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_GET_ENVELOPE]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_get_envelope,
      (datatype, num_integers, num_addresses, num_datatypes, combiner, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_get_envelope(datatype, num_integers, num_addresses, num_datatypes, combiner);

    VT_UNIMCI_CHECK_POST(MPI_Type_get_envelope,
      (datatype, num_integers, num_addresses, num_datatypes, combiner, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_get_envelope(datatype, num_integers, num_addresses, num_datatypes, combiner);
  }

  return result;
}

/* -- MPI_Type_get_name -- */

VT_MPI_INT MPI_Type_get_name(MPI_Datatype type, char* type_name_CLASS_SINGLE_OUT, VT_MPI_INT* resultlen)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_GET_NAME]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_get_name,
      (type, type_name_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_get_name(type, type_name_CLASS_SINGLE_OUT, resultlen);

    VT_UNIMCI_CHECK_POST(MPI_Type_get_name,
      (type, type_name_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_get_name(type, type_name_CLASS_SINGLE_OUT, resultlen);
  }

  return result;
}

/* -- MPI_Type_set_attr -- */

VT_MPI_INT MPI_Type_set_attr(MPI_Datatype type, VT_MPI_INT type_keyval, void* attribute_val)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_SET_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_set_attr,
      (type, type_keyval, attribute_val, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_set_attr(type, type_keyval, attribute_val);

    VT_UNIMCI_CHECK_POST(MPI_Type_set_attr,
      (type, type_keyval, attribute_val, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_set_attr(type, type_keyval, attribute_val);
  }

  return result;
}

/* -- MPI_Type_set_name -- */

VT_MPI_INT MPI_Type_set_name(MPI_Datatype type, char* type_name_CLASS_SINGLE_IN)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_SET_NAME]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_set_name,
      (type, type_name_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_set_name(type, type_name_CLASS_SINGLE_IN);

    VT_UNIMCI_CHECK_POST(MPI_Type_set_name,
      (type, type_name_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_set_name(type, type_name_CLASS_SINGLE_IN);
  }

  return result;
}

/* -- MPI_Win_call_errhandler -- not generated */

/* -- MPI_Win_create_keyval -- */

VT_MPI_INT MPI_Win_create_keyval(MPI_Win_copy_attr_function* win_copy_attr_fn, MPI_Win_delete_attr_function* win_delete_attr_fn, VT_MPI_INT* win_keyval, void* extra_state)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_WIN_CREATE_KEYVAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Win_create_keyval,
      (win_copy_attr_fn, win_delete_attr_fn, win_keyval, extra_state, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Win_create_keyval(win_copy_attr_fn, win_delete_attr_fn, win_keyval, extra_state);

    VT_UNIMCI_CHECK_POST(MPI_Win_create_keyval,
      (win_copy_attr_fn, win_delete_attr_fn, win_keyval, extra_state, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Win_create_keyval(win_copy_attr_fn, win_delete_attr_fn, win_keyval, extra_state);
  }

  return result;
}

/* -- MPI_Win_delete_attr -- */

VT_MPI_INT MPI_Win_delete_attr(MPI_Win win, VT_MPI_INT win_keyval)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_WIN_DELETE_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Win_delete_attr,
      (win, win_keyval, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Win_delete_attr(win, win_keyval);

    VT_UNIMCI_CHECK_POST(MPI_Win_delete_attr,
      (win, win_keyval, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Win_delete_attr(win, win_keyval);
  }

  return result;
}

/* -- MPI_Win_free_keyval -- */

VT_MPI_INT MPI_Win_free_keyval(VT_MPI_INT* win_keyval)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_WIN_FREE_KEYVAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Win_free_keyval,
      (win_keyval, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Win_free_keyval(win_keyval);

    VT_UNIMCI_CHECK_POST(MPI_Win_free_keyval,
      (win_keyval, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Win_free_keyval(win_keyval);
  }

  return result;
}

/* -- MPI_Win_get_attr -- */

VT_MPI_INT MPI_Win_get_attr(MPI_Win win, VT_MPI_INT win_keyval, void* attribute_val, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_WIN_GET_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Win_get_attr,
      (win, win_keyval, attribute_val, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Win_get_attr(win, win_keyval, attribute_val, flag);

    VT_UNIMCI_CHECK_POST(MPI_Win_get_attr,
      (win, win_keyval, attribute_val, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Win_get_attr(win, win_keyval, attribute_val, flag);
  }

  return result;
}

/* -- MPI_Win_get_name -- */

VT_MPI_INT MPI_Win_get_name(MPI_Win win, char* win_name_CLASS_SINGLE_OUT, VT_MPI_INT* resultlen)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_WIN_GET_NAME]);

    VT_UNIMCI_CHECK_PRE(MPI_Win_get_name,
      (win, win_name_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Win_get_name(win, win_name_CLASS_SINGLE_OUT, resultlen);

    VT_UNIMCI_CHECK_POST(MPI_Win_get_name,
      (win, win_name_CLASS_SINGLE_OUT, resultlen, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Win_get_name(win, win_name_CLASS_SINGLE_OUT, resultlen);
  }

  return result;
}

/* -- MPI_Win_set_attr -- */

VT_MPI_INT MPI_Win_set_attr(MPI_Win win, VT_MPI_INT win_keyval, void* attribute_val)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_WIN_SET_ATTR]);

    VT_UNIMCI_CHECK_PRE(MPI_Win_set_attr,
      (win, win_keyval, attribute_val, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Win_set_attr(win, win_keyval, attribute_val);

    VT_UNIMCI_CHECK_POST(MPI_Win_set_attr,
      (win, win_keyval, attribute_val, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Win_set_attr(win, win_keyval, attribute_val);
  }

  return result;
}

/* -- MPI_Win_set_name -- */

VT_MPI_INT MPI_Win_set_name(MPI_Win win, char* win_name_CLASS_SINGLE_IN)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_WIN_SET_NAME]);

    VT_UNIMCI_CHECK_PRE(MPI_Win_set_name,
      (win, win_name_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Win_set_name(win, win_name_CLASS_SINGLE_IN);

    VT_UNIMCI_CHECK_POST(MPI_Win_set_name,
      (win, win_name_CLASS_SINGLE_IN, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Win_set_name(win, win_name_CLASS_SINGLE_IN);
  }

  return result;
}

#if defined(HAVE_MPI_TYPE_CREATE_F90_COMPLEX) && HAVE_MPI_TYPE_CREATE_F90_COMPLEX

/* -- MPI_Type_create_f90_complex -- */

VT_MPI_INT MPI_Type_create_f90_complex(VT_MPI_INT p, VT_MPI_INT r, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_F90_COMPLEX]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_f90_complex,
      (p, r, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_f90_complex(p, r, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_f90_complex,
      (p, r, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_f90_complex(p, r, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

#endif

#if defined(HAVE_MPI_TYPE_CREATE_F90_INTEGER) && HAVE_MPI_TYPE_CREATE_F90_INTEGER

/* -- MPI_Type_create_f90_integer -- */

VT_MPI_INT MPI_Type_create_f90_integer(VT_MPI_INT r, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_F90_INTEGER]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_f90_integer,
      (r, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_f90_integer(r, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_f90_integer,
      (r, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_f90_integer(r, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

#endif

#if defined(HAVE_MPI_TYPE_CREATE_F90_REAL) && HAVE_MPI_TYPE_CREATE_F90_REAL

/* -- MPI_Type_create_f90_real -- */

VT_MPI_INT MPI_Type_create_f90_real(VT_MPI_INT p, VT_MPI_INT r, MPI_Datatype* newtype_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_CREATE_F90_REAL]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_create_f90_real,
      (p, r, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_create_f90_real(p, r, newtype_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_create_f90_real,
      (p, r, newtype_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_create_f90_real(p, r, newtype_CLASS_SINGLE_OUT);
  }

  return result;
}

#endif

#if defined(HAVE_MPI_TYPE_MATCH_SIZE) && HAVE_MPI_TYPE_MATCH_SIZE

/* -- MPI_Type_match_size -- */

VT_MPI_INT MPI_Type_match_size(VT_MPI_INT typeclass, VT_MPI_INT size, MPI_Datatype* type_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_TYPE_MATCH_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_Type_match_size,
      (typeclass, size, type_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Type_match_size(typeclass, size, type_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_Type_match_size,
      (typeclass, size, type_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Type_match_size(typeclass, size, type_CLASS_SINGLE_OUT);
  }

  return result;
}

#endif

/* -- MPI_Init_thread -- not generated */

/* -- MPI_Is_thread_main -- */

VT_MPI_INT MPI_Is_thread_main(VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_IS_THREAD_MAIN]);

    VT_UNIMCI_CHECK_PRE(MPI_Is_thread_main,
      (flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Is_thread_main(flag);

    VT_UNIMCI_CHECK_POST(MPI_Is_thread_main,
      (flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Is_thread_main(flag);
  }

  return result;
}

/* -- MPI_Query_thread -- */

VT_MPI_INT MPI_Query_thread(VT_MPI_INT* provided)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_QUERY_THREAD]);

    VT_UNIMCI_CHECK_PRE(MPI_Query_thread,
      (provided, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Query_thread(provided);

    VT_UNIMCI_CHECK_POST(MPI_Query_thread,
      (provided, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Query_thread(provided);
  }

  return result;
}

/* -- MPI_Accumulate -- not generated */

/* -- MPI_Get -- not generated */

/* -- MPI_Put -- not generated */

/* -- MPI_Win_complete -- not generated */

/* -- MPI_Win_create -- not generated */

/* -- MPI_Win_fence -- not generated */

/* -- MPI_Win_free -- not generated */

/* -- MPI_Win_get_group -- not generated */

/* -- MPI_Win_lock -- not generated */

/* -- MPI_Win_post -- not generated */

/* -- MPI_Win_start -- not generated */

/* -- MPI_Win_test -- not generated */

/* -- MPI_Win_unlock -- not generated */

/* -- MPI_Win_wait -- not generated */

/* -- MPI_Alltoallw -- not generated */

/* -- MPI_Exscan -- not generated */

/* -- MPI_File_open -- not generated */

/* -- MPI_File_close -- not generated */

/* -- MPI_File_delete -- not generated */

/* -- MPI_File_set_size -- */

VT_MPI_INT MPI_File_set_size(MPI_File fh, MPI_Offset size)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_SET_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_File_set_size,
      (fh, size, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_set_size(fh, size);

    VT_UNIMCI_CHECK_POST(MPI_File_set_size,
      (fh, size, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_set_size(fh, size);
  }

  return result;
}

/* -- MPI_File_preallocate -- not generated */

/* -- MPI_File_get_size -- */

VT_MPI_INT MPI_File_get_size(MPI_File fh, MPI_Offset* size_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_SIZE]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_size,
      (fh, size_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_size(fh, size_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_File_get_size,
      (fh, size_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_size(fh, size_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_File_get_group -- */

VT_MPI_INT MPI_File_get_group(MPI_File fh, MPI_Group* group_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_GROUP]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_group,
      (fh, group_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_group(fh, group_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_File_get_group,
      (fh, group_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_group(fh, group_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_File_get_amode -- */

VT_MPI_INT MPI_File_get_amode(MPI_File fh, VT_MPI_INT* amode)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_AMODE]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_amode,
      (fh, amode, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_amode(fh, amode);

    VT_UNIMCI_CHECK_POST(MPI_File_get_amode,
      (fh, amode, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_amode(fh, amode);
  }

  return result;
}

/* -- MPI_File_set_info -- */

VT_MPI_INT MPI_File_set_info(MPI_File fh, MPI_Info info)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_SET_INFO]);

    VT_UNIMCI_CHECK_PRE(MPI_File_set_info,
      (fh, info, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_set_info(fh, info);

    VT_UNIMCI_CHECK_POST(MPI_File_set_info,
      (fh, info, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_set_info(fh, info);
  }

  return result;
}

/* -- MPI_File_get_info -- */

VT_MPI_INT MPI_File_get_info(MPI_File fh, MPI_Info* info_used_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_INFO]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_info,
      (fh, info_used_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_info(fh, info_used_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_File_get_info,
      (fh, info_used_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_info(fh, info_used_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_File_set_view -- */

VT_MPI_INT MPI_File_set_view(MPI_File fh, MPI_Offset disp, MPI_Datatype etype, MPI_Datatype filetype, char* datarep_CLASS_SINGLE_IN, MPI_Info info)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_SET_VIEW]);

    VT_UNIMCI_CHECK_PRE(MPI_File_set_view,
      (fh, disp, etype, filetype, datarep_CLASS_SINGLE_IN, info, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_set_view(fh, disp, etype, filetype, datarep_CLASS_SINGLE_IN, info);

    VT_UNIMCI_CHECK_POST(MPI_File_set_view,
      (fh, disp, etype, filetype, datarep_CLASS_SINGLE_IN, info, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_set_view(fh, disp, etype, filetype, datarep_CLASS_SINGLE_IN, info);
  }

  return result;
}

/* -- MPI_File_get_view -- */

VT_MPI_INT MPI_File_get_view(MPI_File fh, MPI_Offset* disp_CLASS_SINGLE_OUT, MPI_Datatype* etype_CLASS_SINGLE_OUT, MPI_Datatype* filetype_CLASS_SINGLE_OUT, char* datarep_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_VIEW]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_view,
      (fh, disp_CLASS_SINGLE_OUT, etype_CLASS_SINGLE_OUT, filetype_CLASS_SINGLE_OUT, datarep_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_view(fh, disp_CLASS_SINGLE_OUT, etype_CLASS_SINGLE_OUT, filetype_CLASS_SINGLE_OUT, datarep_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_File_get_view,
      (fh, disp_CLASS_SINGLE_OUT, etype_CLASS_SINGLE_OUT, filetype_CLASS_SINGLE_OUT, datarep_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_view(fh, disp_CLASS_SINGLE_OUT, etype_CLASS_SINGLE_OUT, filetype_CLASS_SINGLE_OUT, datarep_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_File_read_at -- not generated */

/* -- MPI_File_read_at_all -- not generated */

/* -- MPI_File_write_at -- not generated */

/* -- MPI_File_write_at_all -- not generated */

/* -- MPI_File_iread_at -- not generated */

/* -- MPI_File_iwrite_at -- not generated */

/* -- MPI_File_read -- not generated */

/* -- MPI_File_read_all -- not generated */

/* -- MPI_File_write -- not generated */

/* -- MPI_File_write_all -- not generated */

/* -- MPI_File_iread -- not generated */

/* -- MPI_File_iwrite -- not generated */

/* -- MPI_File_seek -- not generated */

/* -- MPI_File_get_position -- */

VT_MPI_INT MPI_File_get_position(MPI_File fh, MPI_Offset* offset_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_POSITION]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_position,
      (fh, offset_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_position(fh, offset_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_File_get_position,
      (fh, offset_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_position(fh, offset_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_File_get_byte_offset -- */

VT_MPI_INT MPI_File_get_byte_offset(MPI_File fh, MPI_Offset offset, MPI_Offset* disp_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_BYTE_OFFSET]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_byte_offset,
      (fh, offset, disp_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_byte_offset(fh, offset, disp_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_File_get_byte_offset,
      (fh, offset, disp_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_byte_offset(fh, offset, disp_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_File_read_shared -- not generated */

/* -- MPI_File_write_shared -- not generated */

/* -- MPI_File_iread_shared -- not generated */

/* -- MPI_File_iwrite_shared -- not generated */

/* -- MPI_File_read_ordered -- not generated */

/* -- MPI_File_write_ordered -- not generated */

/* -- MPI_File_seek_shared -- not generated */

/* -- MPI_File_get_position_shared -- */

VT_MPI_INT MPI_File_get_position_shared(MPI_File fh, MPI_Offset* offset_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_POSITION_SHARED]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_position_shared,
      (fh, offset_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_position_shared(fh, offset_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_File_get_position_shared,
      (fh, offset_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_position_shared(fh, offset_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_File_read_at_all_begin -- not generated */

/* -- MPI_File_read_at_all_end -- not generated */

/* -- MPI_File_write_at_all_begin -- not generated */

/* -- MPI_File_write_at_all_end -- not generated */

/* -- MPI_File_read_all_begin -- not generated */

/* -- MPI_File_read_all_end -- not generated */

/* -- MPI_File_write_all_begin -- not generated */

/* -- MPI_File_write_all_end -- not generated */

/* -- MPI_File_read_ordered_begin -- not generated */

/* -- MPI_File_read_ordered_end -- not generated */

/* -- MPI_File_write_ordered_begin -- not generated */

/* -- MPI_File_write_ordered_end -- not generated */

/* -- MPI_File_get_type_extent -- */

VT_MPI_INT MPI_File_get_type_extent(MPI_File fh, MPI_Datatype datatype, MPI_Aint* extent_CLASS_SINGLE_OUT)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_TYPE_EXTENT]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_type_extent,
      (fh, datatype, extent_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_type_extent(fh, datatype, extent_CLASS_SINGLE_OUT);

    VT_UNIMCI_CHECK_POST(MPI_File_get_type_extent,
      (fh, datatype, extent_CLASS_SINGLE_OUT, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_type_extent(fh, datatype, extent_CLASS_SINGLE_OUT);
  }

  return result;
}

/* -- MPI_File_set_atomicity -- */

VT_MPI_INT MPI_File_set_atomicity(MPI_File fh, VT_MPI_INT flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_SET_ATOMICITY]);

    VT_UNIMCI_CHECK_PRE(MPI_File_set_atomicity,
      (fh, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_set_atomicity(fh, flag);

    VT_UNIMCI_CHECK_POST(MPI_File_set_atomicity,
      (fh, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_set_atomicity(fh, flag);
  }

  return result;
}

/* -- MPI_File_get_atomicity -- */

VT_MPI_INT MPI_File_get_atomicity(MPI_File fh, VT_MPI_INT* flag)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_FILE_GET_ATOMICITY]);

    VT_UNIMCI_CHECK_PRE(MPI_File_get_atomicity,
      (fh, flag, "", 0, 0),
      was_recorded, &time);

    result = PMPI_File_get_atomicity(fh, flag);

    VT_UNIMCI_CHECK_POST(MPI_File_get_atomicity,
      (fh, flag, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_File_get_atomicity(fh, flag);
  }

  return result;
}

/* -- MPI_File_sync -- not generated */

#if defined(HAVE_MPI_REGISTER_DATAREP) && HAVE_MPI_REGISTER_DATAREP

/* -- MPI_Register_datarep -- */

VT_MPI_INT MPI_Register_datarep(char* datarep_CLASS_SINGLE_IN, MPI_Datarep_conversion_function* read_conversion_fn, MPI_Datarep_conversion_function* write_conversion_fn, MPI_Datarep_extent_function* dtype_file_extent_fn, void* extra_state)
{
  VT_MPI_INT result;
  uint32_t tid;

  GET_THREAD_ID(tid);

  if (IS_MPI_TRACE_ON(tid))
  {
    uint64_t time;
    uint8_t was_recorded;

    MPI_TRACE_OFF(tid);

    time = vt_pform_wtime();
    was_recorded = vt_enter(tid, &time, vt_mpi_regid[VT__MPI_REGISTER_DATAREP]);

    VT_UNIMCI_CHECK_PRE(MPI_Register_datarep,
      (datarep_CLASS_SINGLE_IN, read_conversion_fn, write_conversion_fn, dtype_file_extent_fn, extra_state, "", 0, 0),
      was_recorded, &time);

    result = PMPI_Register_datarep(datarep_CLASS_SINGLE_IN, read_conversion_fn, write_conversion_fn, dtype_file_extent_fn, extra_state);

    VT_UNIMCI_CHECK_POST(MPI_Register_datarep,
      (datarep_CLASS_SINGLE_IN, read_conversion_fn, write_conversion_fn, dtype_file_extent_fn, extra_state, "", 0, 0),
      was_recorded, &time);

    time = vt_pform_wtime();
    vt_exit(tid, &time);

    MPI_TRACE_ON(tid);
  }
  else
  {
    result = PMPI_Register_datarep(datarep_CLASS_SINGLE_IN, read_conversion_fn, write_conversion_fn, dtype_file_extent_fn, extra_state);
  }

  return result;
}

#endif

