#!/bin/bash
# Copyright (C) 2012 Intel Corporation. All rights reserved.

SCRIPT_NAME=$(basename ${0})
SCRIPT_DIR=$(cd $(dirname ${0}) 2>/dev/null; pwd)

PNAME="Intel(R) Software Manager"

if [ ! -w "$SCRIPT_DIR" ]; then
    echo -e "Super-user or \"root\" privileges are required in order to continue.\n"
    echo -n "Please enter \"root\" "
    exec su -c "/bin/bash '${SCRIPT_DIR}/${SCRIPT_NAME}' $@"
    echo
    return 1
fi

silent=0
to_delete=0

if echo $@ | grep "\-\-silent" 2>/dev/null 1>&2; then
    silent=1
    to_delete=1
fi

if [ $silent -eq 0 ]; then
    echo -n "Do you really want to uninstall ${PNAME}? ( Yes/No ) [ No ]: "
    read answer
    if echo $(echo $answer | tr [[:upper:]] [[:lower:]]) | grep -e "^y$" -e "^yes$" -e "^yep$" 2>/dev/null 1>&2; then
        to_delete=1
    fi
fi

if [ $to_delete -eq 1 ]; then
    rm -rf ${SCRIPT_DIR} 1>/dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo "   Successfully uninstalled."
    else
        echo "   Uninstall failed."
    fi
else
    echo "Uninstall cancelled..."
fi

exit $?

