#!/bin/bash
# Copyright (C) 2012 Intel Corporation. All rights reserved.

INSTALL_SCRIPT="$1"

if [ -z "$INSTALL_SCRIPT" ]; then
    echo "Error: Please specify path to product install.sh file"
    exit 1
fi

declare -r TERMINALS=(xterm gnome-terminal urxvt rxvt)

for TERM in $TERMINALS; do
    which $TERM 2>/dev/null 1>&2
    if [ $? -eq 0 ]; then
        tmpfile=$(mktemp)

        if [ "$TERM" = "gnome-terminal" ]; then
            $TERM -e "/bin/bash -c \"export skip_uid_check=yes ; $INSTALL_SCRIPT ; echo \$? > $tmpfile\""
        else
            $TERM -e /bin/bash -c "export skip_uid_check=yes ; $INSTALL_SCRIPT ; echo \$? > $tmpfile"
        fi

        status=$(cat $tmpfile 2>/dev/null)

        rm -rf $tmpfile 2>/dev/null 1>&2

        exit $status
    fi
done

exit 1
