#!/bin/csh
#
# Copyright 2005-2013 Intel Corporation.  All Rights Reserved.
#
# The source code contained or described herein and all documents related
# to the source code ("Material") are owned by Intel Corporation or its
# suppliers or licensors.  Title to the Material remains with Intel
# Corporation or its suppliers and licensors.  The Material is protected
# by worldwide copyright laws and treaty provisions.  No part of the
# Material may be used, copied, reproduced, modified, published, uploaded,
# posted, transmitted, distributed, or disclosed in any way without
# Intel's prior express written permission.
#
# No license under any patent, copyright, trade secret or other
# intellectual property right is granted to or conferred upon you by
# disclosure or delivery of the Materials, either expressly, by
# implication, inducement, estoppel or otherwise.  Any license under such
# intellectual property rights must be express and approved by Intel in
# writing.


setenv TBBROOT "/opt/intel/composer_xe_2013.2.146/tbb" 
if ( "$1" != "ia32" && "$1" != "intel64" ) then
  echo "ERROR: Unknown switch '$1'. Accepted values: ia32, intel64"
  exit 1
endif

if (! $?MIC_LD_LIBRARY_PATH) then 
    setenv MIC_LD_LIBRARY_PATH "${TBBROOT}/lib/mic" 
else 
    setenv MIC_LD_LIBRARY_PATH "${TBBROOT}/lib/mic:$MIC_LD_LIBRARY_PATH" 
endif 

if (! $?LD_LIBRARY_PATH) then 
    setenv LD_LIBRARY_PATH "${TBBROOT}/lib/${1}" 
else 
    setenv LD_LIBRARY_PATH "${TBBROOT}/lib/${1}:$LD_LIBRARY_PATH" 
endif 

if (! $?LIBRARY_PATH) then 
    setenv LIBRARY_PATH "${TBBROOT}/lib/${1}" 
else 
    setenv LIBRARY_PATH "${TBBROOT}/lib/${1}:$LIBRARY_PATH" 
endif 

if (! $?CPATH) then 
    setenv CPATH "${TBBROOT}/include" 
else 
    setenv CPATH "${TBBROOT}/include:$CPATH" 
endif 
