/*
**********************************************************************************
** Copyright (C) 1985-2011 Intel Corporation. All Rights Reserved.               **
** The source code contained or described herein and all documents related to   **
** the source code ("Material") are owned by Intel Corporation or its suppliers **
** or licensors. Title to the Material remains with Intel Corporation or its    **
** suppliers and licensors. The Material contains trade secrets and proprietary **
** and confidential information of Intel or its suppliers and licensors. The    **
** Material is protected by worldwide copyright and trade secret laws and       **
** treaty provisions. No part of the Material may be used, copied, reproduced,  **
** modified, published, uploaded, posted, transmitted, distributed, or          **
** disclosed in any way without Intels prior express written permission.       **
**                                                                              **
** No license under any patent, copyright, trade secret or other intellectual   **
** property right is granted to or conferred upon you by disclosure or delivery **
** of the Materials, either expressly, by implication, inducement, estoppel or  **
** otherwise. Any license under such intellectual property rights must be       **
** express and approved by Intel in writing.                                    **
**********************************************************************************
*/

#ifndef __TBK_BACKTRACE_H_INCLUDED

#define __TBK_BACKTRACE_H_INCLUDED


#if defined(_WIN32) || defined(_WIN64)

#ifndef _UINTPTR_T_DEFINED

#if defined (_M_IA64) || defined(_M_AMD64) || defined(__ia64) || defined(__x86_64)
typedef unsigned __int64    uintptr_t;
#else
typedef unsigned   int      uintptr_t;
#endif

#define _UINTPTR_T_DEFINED

#endif /*#ifndef _UINTPTR_T_DEFINED*/

#include <stdlib.h>
#define TBK_PATH_MAX _MAX_PATH

#else /* Linux */
#include <stdint.h>
#include <sys/param.h>

#define TBK_PATH_MAX PATH_MAX
#endif


typedef struct _tagPC_CORRELATION_INFO {
	char routine_name[TBK_PATH_MAX];
	char src_file_name[TBK_PATH_MAX];
	char src_line_num[33];
#if defined(_WIN32) || defined(_WIN64)
        int ilk_flag ;          /* incremental linked image flag */
#endif

} PC_CORRELATION_INFO ;

typedef  int (*TBK_STACK_CALLBACK) (void*, void*);


#ifdef __cplusplus
extern "C" {
#endif

 /*functions prototypes*/
  extern int  tbk_trace_stack ( void*, void*, TBK_STACK_CALLBACK); /*  The function to provide stack walking */


 /* The set of functions to retrieve information for given stack frame*/
  extern uintptr_t  tbk_getPC (void*);/* Program counter   */
  extern uintptr_t  tbk_getRetAddr (void*);/* Returned address  */
  extern void  tbk_getModuleName(uintptr_t, char*, size_t);/* Module name       */
  extern int   tbk_get_pc_info ( PC_CORRELATION_INFO*, uintptr_t);
  extern char* tbk_geterrorstring(void);   /* The function that returns error message string */  

#if defined(_WIN32) || defined(_WIN64)
  extern uintptr_t  tbk_getFramePtr(void*);/* Frame pointer     */
  extern uintptr_t  tbk_getSP      (void*);/* Stack pointer     */

#ifdef _M_IA64
  extern uintptr_t  tbk_getBStore  (void*);/* Intel(R) Itanium(R) architecture backing store */
#endif
#endif

 /* High level functions for preparing the string buffer by stack contents information */
  extern size_t tbk_string_stack_signal(void*, char*, size_t, int);


#ifdef __cplusplus
}
#endif


#endif
