! *
! **********************************************************************************
! * INTEL CORPORATION                                                              *
! * Copyright 2009-2011 Intel Corporation All Rights Reserved.                     *
! *                                                                                *
! * The source code contained or described herein and all documents related to     *
! * the source code ("Material") are owned by Intel Corporation or its suppliers   *
! * or licensors. Title to the Material remains with Intel Corporation or its      *
! * suppliers and licensors. The Material contains trade secrets and proprietary   *
! * and confidential information of Intel or its suppliers and licensors. The      *
! * Material is protected by worldwide copyright and trade secret laws and         *
! * treaty provisions. No part of the Material may be used, copied, reproduced,    *
! * modified, published, uploaded, posted, transmitted, distributed, or            *
! * disclosed in any way without Intel's prior express written permission.         *
! *                                                                                *
! * No license under any patent, copyright, trade secret or other intellectual     *
! * property right is granted to or conferred upon you by disclosure or delivery   *
! * of the Materials, either expressly, by implication, inducement, estoppel or    *
! * otherwise. Any license under such intellectual property rights must be         *
! * express and approved by Intel in writing.                                      *
! **********************************************************************************
! *

! **************************** Edit History ****************************************
!
! Aug-17-2010  Created 
! **********************************************************************************

! **********************************************************************************
! * This file is intended to support the Intel(r) Many Integrated Core Architecture.
! **********************************************************************************
! free form Fortran source - should be named .f90
! lines are longer than 72 characters

module mic_lib
use, intrinsic :: iso_c_binding

integer, parameter:: target_mic=2
integer, parameter:: default_target_type=target_mic
integer, parameter:: default_target_number=0

interface
function Offload_number_of_devices ()                                  &
           bind (C, name = "_Offload_number_of_devices")
  import :: c_int
  integer (kind=c_int)        :: Offload_number_of_devices
!dec$ attributes offload:mic :: Offload_number_of_devices
end function Offload_number_of_devices

function Offload_signaled(target_number, signal)                       &
           bind (C, name = "_Offload_signaled")
  import :: c_int
  integer (kind=c_int) :: Offload_signaled
  integer (kind=c_int) :: signal, target_number
!dec$ attributes offload:mic :: Offload_signaled
end function Offload_signaled

subroutine Offload_report(val)                                         &
           bind (C, name = "__Offload_report")
  import :: c_int
  integer (kind=c_int), value :: val
!dec$ attributes offload:mic :: Offload_report
end subroutine Offload_report

function Offload_get_device_number()                                   &
           bind (C, name = "_Offload_get_device_number")
  import :: c_int
  integer (kind=c_int)        :: Offload_get_device_number
!dec$ attributes offload:mic :: Offload_get_device_number
end function Offload_get_device_number

! OpenMP API

subroutine omp_set_device_num(num)                                     &
           bind (C, name = "omp_set_device_num")
  import :: c_int
  integer (kind=c_int), value :: num
end subroutine omp_set_device_num

function omp_get_device_num()                                          &
         bind (C, name = "omp_get_device_num")
  import :: c_int
  integer (kind=c_int)        :: omp_get_device_num
end function omp_get_device_num

! OpenMP API wrappers

subroutine omp_set_num_threads_target (target_type,                    &
                                       target_number,                  &
                                       num_threads)                    &
           bind (C, name = "omp_set_num_threads_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number, num_threads
end subroutine omp_set_num_threads_target

function omp_get_max_threads_target (target_type,                      &
                                     target_number)                    &
         bind (C, name = "omp_get_max_threads_target")
  import :: c_int
  integer (kind=c_int)        :: omp_get_max_threads_target
  integer (kind=c_int), value :: target_type, target_number
end function omp_get_max_threads_target

function omp_get_num_procs_target (target_type,                        &
                                   target_number)                      &
         bind (C, name = "omp_get_num_procs_target")
  import :: c_int
  integer (kind=c_int)        :: omp_get_num_procs_target
  integer (kind=c_int), value :: target_type, target_number
end function omp_get_num_procs_target

subroutine omp_set_dynamic_target (target_type,                        &
                                   target_number,                      &
                                   num_threads)                        &
           bind (C, name = "omp_set_dynamic_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number, num_threads
end subroutine omp_set_dynamic_target

function omp_get_dynamic_target (target_type,                          &
                                 target_number)                        &
         bind (C, name = "omp_get_dynamic_target")
  import :: c_int
  integer (kind=c_int)        :: omp_get_dynamic_target
  integer (kind=c_int), value :: target_type, target_number
end function omp_get_dynamic_target

subroutine omp_set_nested_target (target_type,                         &
                                  target_number,                       &
                                  nested)                              &
           bind (C, name = "omp_set_nested_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number, nested
end subroutine omp_set_nested_target

function omp_get_nested_target (target_type,                           &
                                target_number)                         &
         bind (C, name = "omp_get_nested_target")
  import :: c_int
  integer (kind=c_int)        :: omp_get_nested_target
  integer (kind=c_int), value :: target_type, target_number
end function omp_get_nested_target

subroutine omp_set_schedule_target (target_type,                       &
                                    target_number,                     &
                                    kind,                              &
                                    modifier)                          &
           bind (C, name = "omp_set_schedule_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number, kind, modifier
end subroutine omp_set_schedule_target

subroutine omp_get_schedule_target (target_type,                       &
                                    target_number,                     &
                                    kind,                              &
                                    modifier)                          &
           bind (C, name = "omp_get_schedule_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: kind, modifier
end subroutine omp_get_schedule_target

! lock API functions 

subroutine omp_init_lock_target (target_type,                          &
                                 target_number,                        &
                                 lock)                                 &
           bind (C, name = "omp_init_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end subroutine omp_init_lock_target

subroutine omp_destroy_lock_target (target_type,                       &
                                    target_number,                     &
                                    lock)                              &
           bind (C, name = "omp_destroy_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end subroutine omp_destroy_lock_target

subroutine omp_set_lock_target (target_type,                           &
                                target_number,                         &
                                lock)                                  &
           bind (C, name = "omp_set_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end subroutine omp_set_lock_target

subroutine omp_unset_lock_target (target_type,                         &
                                  target_number,                       &
                                  lock)                                &
           bind (C, name = "omp_unset_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end subroutine omp_unset_lock_target

function omp_test_lock_target (target_type,                            &
                               target_number,                          &
                               lock)                                   &
           bind (C, name = "omp_test_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int)        :: omp_test_lock_target
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end function omp_test_lock_target

! nested lock API functions 

subroutine omp_init_nest_lock_target (target_type,                     &
                                      target_number,                   &
                                      lock)                            &
           bind (C, name = "omp_init_nest_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end subroutine omp_init_nest_lock_target

subroutine omp_destroy_nest_lock_target (target_type,                  &
                                         target_number,                &
                                         lock)                         &
           bind (C, name = "omp_destroy_nest_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end subroutine omp_destroy_nest_lock_target

subroutine omp_set_nest_lock_target (target_type,                      &
                                     target_number,                    &
                                     lock)                             &
           bind (C, name = "omp_set_nest_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end subroutine omp_set_nest_lock_target

subroutine omp_unset_nest_lock_target (target_type,                    &
                                       target_number,                  &
                                       lock)                           &
           bind (C, name = "omp_unset_nest_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end subroutine omp_unset_nest_lock_target

function omp_test_nest_lock_target (target_type,                       &
                                    target_number,                     &
                                    lock)                              &
           bind (C, name = "omp_test_nest_lock_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int)        :: omp_test_nest_lock_target
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: lock
end function omp_test_nest_lock_target

! kmp API functions 

subroutine kmp_set_stacksize_target (target_type,                      &
                                     target_number,                    &
                                     size)                             &
           bind (C, name = "kmp_set_stacksize_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number, size
end subroutine kmp_set_stacksize_target

function kmp_get_stacksize_target (target_type,                        &
                                   target_number)                      &
         bind (C, name = "kmp_get_stacksize_target")
  import :: c_int
  integer (kind=c_int)        :: kmp_get_stacksize_target
  integer (kind=c_int), value :: target_type, target_number
end function kmp_get_stacksize_target

subroutine kmp_set_stacksize_s_target (target_type,                    &
                                       target_number,                  &
                                       size)                           &
           bind (C, name = "kmp_set_stacksize_s_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number, size
end subroutine kmp_set_stacksize_s_target

function kmp_get_stacksize_s_target (target_type,                      &
                                     target_number)                    &
         bind (C, name = "kmp_get_stacksize_s_target")
  import :: c_int
  integer (kind=c_int)        :: kmp_get_stacksize_s_target
  integer (kind=c_int), value :: target_type, target_number
end function kmp_get_stacksize_s_target

subroutine kmp_set_blocktime_target (target_type,                      &
                                     target_number,                    &
                                     time)                             &
           bind (C, name = "kmp_set_blocktime_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number, time
end subroutine kmp_set_blocktime_target

function kmp_get_blocktime_target (target_type,                        &
                                   target_number)                      &
         bind (C, name = "kmp_get_blocktime_target")
  import :: c_int
  integer (kind=c_int)        :: kmp_get_blocktime_target
  integer (kind=c_int), value :: target_type, target_number
end function kmp_get_blocktime_target

subroutine kmp_set_library_serial_target (target_type,                 &
                                          target_number)               &
           bind (C, name = "kmp_set_library_serial_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number
end subroutine kmp_set_library_serial_target

subroutine kmp_set_library_turnaround_target (target_type,             &
                                              target_number)           &
           bind (C, name = "kmp_set_library_turnaround_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number
end subroutine kmp_set_library_turnaround_target

subroutine kmp_set_library_throughput_target (target_type,             &
                                              target_number)           &
           bind (C, name = "kmp_set_library_throughput_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number
end subroutine kmp_set_library_throughput_target

subroutine kmp_set_library_target (target_type,                        &
                                   target_number,                      &
                                   mode)                               &
           bind (C, name = "kmp_set_library_target")
  import :: c_int
  integer (kind=c_int), value :: target_type, target_number, mode
end subroutine kmp_set_library_target

function kmp_get_library_target (target_type,                          &
                                 target_number)                        &
         bind (C, name = "kmp_get_library_target")
  import :: c_int
  integer (kind=c_int)        :: kmp_get_library_target
  integer (kind=c_int), value :: target_type, target_number
end function kmp_get_library_target

subroutine kmp_set_defaults_target (target_type,                       &
                                    target_number,                     &
                                    defaults)                          &
           bind (C, name = "kmp_set_defaults_target")
  import :: c_int, c_char
 character (kind=c_char) :: defaults(*)
 integer (kind=c_int), value :: target_type, target_number
end subroutine kmp_set_defaults_target

! affinity API functions 

subroutine kmp_create_affinity_mask_target (target_type,               &
                                            target_number,             &
                                            mask)                      &
           bind (C, name = "kmp_create_affinity_mask_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: mask
end subroutine kmp_create_affinity_mask_target

subroutine kmp_destroy_affinity_mask_target (target_type,              &
                                             target_number,            &
                                             mask)                     &
           bind (C, name = "kmp_destroy_affinity_mask_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: mask
end subroutine kmp_destroy_affinity_mask_target

function kmp_set_affinity_target (target_type,                         &
                                  target_number,                       &
                                  mask)                                &
           bind (C, name = "kmp_set_affinity_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int)        :: kmp_set_affinity_target
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: mask
end function kmp_set_affinity_target

function kmp_get_affinity_target (target_type,                         &
                                  target_number,                       &
                                  mask)                                &
           bind (C, name = "kmp_get_affinity_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int)        :: kmp_get_affinity_target
  integer (kind=c_int), value :: target_type, target_number
  integer (kind=c_intptr_t), value :: mask
end function kmp_get_affinity_target

function kmp_get_affinity_max_proc_target (target_type,                &
                                           target_number)              &
           bind (C, name = "kmp_get_affinity_max_proc_target")
  import :: c_int
  integer (kind=c_int)        :: kmp_get_affinity_max_proc_target
  integer (kind=c_int), value :: target_type, target_number
end function kmp_get_affinity_max_proc_target

function kmp_set_affinity_mask_proc_target (target_type,               &
                                            target_number,             &
                                            proc,                      &
                                            mask)                      &
           bind (C, name = "kmp_set_affinity_mask_proc_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int)        :: kmp_set_affinity_mask_proc_target
  integer (kind=c_int), value :: target_type, target_number, proc
  integer (kind=c_intptr_t), value :: mask
end function kmp_set_affinity_mask_proc_target

function kmp_unset_affinity_mask_proc_target (target_type,             &
                                              target_number,           &
                                              proc,                    &
                                              mask)                    &
           bind (C, name = "kmp_unset_affinity_mask_proc_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int)        :: kmp_unset_affinity_mask_proc_target
  integer (kind=c_int), value :: target_type, target_number, proc
  integer (kind=c_intptr_t), value :: mask
end function kmp_unset_affinity_mask_proc_target

function kmp_get_affinity_mask_proc_target (target_type,               &
                                            target_number,             &
                                            proc,                      &
                                            mask)                      &
           bind (C, name = "kmp_get_affinity_mask_proc_target")
  import :: c_int, c_intptr_t
  integer (kind=c_int)        :: kmp_get_affinity_mask_proc_target
  integer (kind=c_int), value :: target_type, target_number, proc
  integer (kind=c_intptr_t), value :: mask
end function kmp_get_affinity_mask_proc_target

end interface
end module mic_lib
