! *
! ********************************************************************************
! * INTEL CORPORATION                                                            *
! * Copyright 2004-2011 Intel Corporation All Rights Reserved.                   *
! *                                                                              *
! * The source code contained or described herein and all documents related to   *
! * the source code ("Material") are owned by Intel Corporation or its suppliers *
! * or licensors. Title to the Material remains with Intel Corporation or its    *
! * suppliers and licensors. The Material contains trade secrets and proprietary *
! * and confidential information of Intel or its suppliers and licensors. The    *
! * Material is protected by worldwide copyright and trade secret laws and       *
! * treaty provisions. No part of the Material may be used, copied, reproduced,  *
! * modified, published, uploaded, posted, transmitted, distributed, or          *
! * disclosed in any way without Intel's prior express written permission.       *
! *                                                                              *
! * No license under any patent, copyright, trade secret or other intellectual   *
! * property right is granted to or conferred upon you by disclosure or delivery *
! * of the Materials, either expressly, by implication, inducement, estoppel or  *
! * otherwise. Any license under such intellectual property rights must be       *
! * express and approved by Intel in writing.                                    *
! ********************************************************************************
! *

!
! This file provides an interface to Intel's
! implementation of IEEE POSIX Std 1003.9-1992 library routines.
!
! These routines provide the functionality of many
! common library extensions to the Fortran language, in a portable fashion.
!

!DEC$ IF .NOT. DEFINED(__IFLPOSIX_INCLUDE)
!DEC$ DEFINE __IFLPOSIX_INCLUDE


      MODULE IFPOSIX


! 3.1 Process Creation and Execution
!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only
        INTERFACE 
          SUBROUTINE  PXFFORK (IPID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFORK
          INTEGER(4) IPID, IERROR
          END SUBROUTINE PXFFORK
        END INTERFACE
!DEC$ ENDIF

        INTERFACE
          SUBROUTINE PXFEXECV (PATH, LENPATH, ARGV, LENARGV, IARGC,     &
     &                         IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEXECV
          INTEGER(4) LENPATH, LENARGV(0:IARGC-1), IARGC, IERROR
          CHARACTER(LEN=*) PATH, ARGV(0:IARGC-1)
          END SUBROUTINE PXFEXECV
        END INTERFACE

        INTERFACE
        SUBROUTINE PXFEXECVE(PATH,LPTH,ARGV,LARGV,IARGC,ENV,LENV,IENVC, &
     &                       IER)
!DEC$ ATTRIBUTES DEFAULT :: PXFEXECVE
          INTEGER(4) LPTH,LARGV(0:IARGC-1),IARGC,LENV(IENVC),IENVC,IER
          CHARACTER(LEN=*) PATH,ARGV(0:IARGC-1),ENV(IENVC)
          END SUBROUTINE PXFEXECVE
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEXECVP (FILE, LENFILE, ARGV, LENARGV, IARGC,    &
     &                          IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEXECVP
          INTEGER(4) LENFILE, LENARGV(0:IARGC-1), IARGC, IERROR
          CHARACTER(LEN=*) FILE, ARGV(0:IARGC-1)
          END SUBROUTINE PXFEXECVP
        END INTERFACE

!  3.2 Process Termination						
!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only
        INTERFACE
          SUBROUTINE PXFWAIT (ISTAT, IRETPID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFWAIT
          INTEGER(4) ISTAT, IRETPID, IERROR
          END SUBROUTINE PXFWAIT
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFWAITPID (IPID, ISTAT, IOPTIONS, IRETPID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFWAITPID
          INTEGER(4) IPID, ISTAT, IOPTIONS, IRETPID, IERROR
          END SUBROUTINE PXFWAITPID
        END INTERFACE

        INTERFACE
          LOGICAL(4) FUNCTION PXFWIFEXITED (ISTAT)
!DEC$ ATTRIBUTES DEFAULT :: PXFWIFEXITED
          INTEGER(4) ISTAT
          END FUNCTION PXFWIFEXITED
        END INTERFACE

        INTERFACE
          INTEGER(4) FUNCTION IPXFWEXITSTATUS (ISTAT)
!DEC$ ATTRIBUTES DEFAULT :: IPXFWEXITSTATUS
          INTEGER(4) ISTAT
          END FUNCTION IPXFWEXITSTATUS
        END INTERFACE

        INTERFACE
          LOGICAL(4) FUNCTION PXFWIFSIGNALED (ISTAT)
!DEC$ ATTRIBUTES DEFAULT :: PXFWIFSIGNALED
          INTEGER(4) ISTAT
          END FUNCTION PXFWIFSIGNALED
        END INTERFACE


        INTERFACE
          LOGICAL(4) FUNCTION PXFWIFSTOPPED (ISTAT)
!DEC$ ATTRIBUTES DEFAULT :: PXFWIFSTOPPED
          INTEGER(4) ISTAT
          END FUNCTION PXFWIFSTOPPED
        END INTERFACE

        INTERFACE
          INTEGER(4) FUNCTION IPXFWSTOPSIG (ISTAT)
!DEC$ ATTRIBUTES DEFAULT :: IPXFWSTOPSIG
          INTEGER(4) ISTAT
          END FUNCTION IPXFWSTOPSIG
        END INTERFACE

        INTERFACE
          INTEGER(4) FUNCTION IPXFWTERMSIG (ISTAT)
!DEC$ ATTRIBUTES DEFAULT :: IPXFWTERMSIG
          INTEGER(4) ISTAT
          END FUNCTION IPXFWTERMSIG
        END INTERFACE
!DEC$ ENDIF

       INTERFACE 
          SUBROUTINE PXFFASTEXIT (ISTATUS)
!DEC$ ATTRIBUTES DEFAULT :: PXFFASTEXIT
          INTEGER(4) ISTATUS
          END SUBROUTINE PXFFASTEXIT
        END INTERFACE

!  3.3 Signals	
        INTERFACE
          SUBROUTINE PXFKILL (IPID, ISIG, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFKILL
          INTEGER(4) IPID, ISIG, IERROR
          END SUBROUTINE PXFKILL
        END INTERFACE
					
!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only
        INTERFACE
          SUBROUTINE PXFSIGEMPTYSET (JSIGSET, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGEMPTYSET
          INTEGER(4) IERROR
          INTEGER(4)  JSIGSET
          END SUBROUTINE 
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSIGFILLSET (JSIGSET, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGFILLSET
          INTEGER(4) IERROR
          INTEGER(4)  JSIGSET
          END SUBROUTINE PXFSIGFILLSET
        END INTERFACE


        INTERFACE
          SUBROUTINE PXFSIGADDSET (JSIGSET, ISIGNO, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGADDSET
          INTEGER(4) ISIGNO, IERROR
          INTEGER(4)  JSIGSET
          END SUBROUTINE PXFSIGADDSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSIGDELSET (JSIGSET, ISIGNO, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGDELSET
          INTEGER(4) ISIGNO, IERROR
          INTEGER(4)  JSIGSET
          END SUBROUTINE PXFSIGDELSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSIGISMEMBER (JSIGSET, ISIGNO, ISMEMBER, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGISMEMBER
          INTEGER(4) ISIGNO, IERROR
          INTEGER(4)  JSIGSET
          LOGICAL(4) ISMEMBER
          END SUBROUTINE PXFSIGISMEMBER
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSIGACTION(ISIG, JSIGACT, JOSIGACT, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGACTION
          INTEGER(4) ISIG,  IERROR
          INTEGER(4)  JSIGACT, JOSIGACT
          END SUBROUTINE PXFSIGACTION
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSIGPROCMASK(IHOW, JSIGSET, JOSIGSET, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGPROCMASK
          INTEGER(4) IHOW,IERROR
          INTEGER(4)  JSIGSET, JOSIGSET
          END SUBROUTINE PXFSIGPROCMASK
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSIGPENDING( JSIGSET, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGPENDING
          INTEGER(4)  IERROR
          INTEGER(4)  JSIGSET
          END SUBROUTINE PXFSIGPENDING
        END INTERFACE
        
        INTERFACE
          SUBROUTINE PXFSIGSUSPEND( JSIGSET, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSIGSUSPEND
          INTEGER(4) IERROR
          INTEGER(4)  JSIGSET
          END SUBROUTINE PXFSIGSUSPEND
        END INTERFACE
!DEC$ ENDIF

!  3.4 Timer operations		
        INTERFACE
          SUBROUTINE PXFALARM( ISECONDS, ISECLEFT, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFALARM
          INTEGER(4) ISECONDS, ISIGLEFT, IERROR
          END SUBROUTINE PXFALARM
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFPAUSE( IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFPAUSE
          INTEGER(4) IERROR
          END SUBROUTINE PXFPAUSE
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSLEEP( ISECONDS, ISECLEFT, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSLEEP
          INTEGER(4)  ISECONDS, ISECLEFT, IERROR
          END SUBROUTINE PXFSLEEP
        END INTERFACE

!	4.1 Process identification	
        INTERFACE
          SUBROUTINE PXFGETPID( IPID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETPID
          INTEGER(4)  IPID, IERROR
          END SUBROUTINE PXFGETPID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETPPID( IPID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETPPID
          INTEGER(4)  IPID, IERROR
          END SUBROUTINE PXFGETPPID
        END INTERFACE
        
!      4.2 User identification						
!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only
        INTERFACE
          SUBROUTINE PXFGETUID( IUID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETUID
          INTEGER(4)  IUID, IERROR
          END SUBROUTINE PXFGETUID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETEUID( IEUID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETEUID
          INTEGER(4)  IEUID, IERROR
          END SUBROUTINE PXFGETEUID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETGID( IGID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETGID
          INTEGER(4)  IGID, IERROR
          END SUBROUTINE PXFGETGID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETEGID( IEGID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETEGID
          INTEGER(4)  IEGID, IERROR
          END SUBROUTINE PXFGETEGID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSETUID( IUID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSETUID
          INTEGER(4)  IUID, IERROR
          END SUBROUTINE PXFSETUID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSETGID( IGID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSETGID
          INTEGER(4)  IGID, IERROR
          END SUBROUTINE PXFSETGID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETGROUPS( IGIDSETSIZE,IGROUPLIST,NGROUPS,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETGROUPS
          INTEGER(4)  IGIDSETSIZE,IGROUPLIST(IGIDSETSIZE),NGROUPS,IERROR
          END SUBROUTINE PXFGETGROUPS
        END INTERFACE
!DEC$ ENDIF

        INTERFACE
          SUBROUTINE PXFGETLOGIN( S,ILEN,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETLOGIN
          CHARACTER*(*) S 
          INTEGER(4)  ILEN,IERROR
          END SUBROUTINE PXFGETLOGIN
        END INTERFACE
       

!	4.3 Process Groups						
!DEC$ IF .NOT. DEFINED(_WIN32)
        INTERFACE
          SUBROUTINE PXFGETPGRP( IPGRP,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETPGRP
          INTEGER(4)  IPGRP, IERROR
          END SUBROUTINE PXFGETPGRP
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSETSID( ISID,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSETSID
          INTEGER(4)  ISID, IERROR
          END SUBROUTINE PXFSETSID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSETPGID( IPID,IPGID,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSETPGID
          INTEGER(4)  IPID,IPGID, IERROR
          END SUBROUTINE PXFSETPGID
        END INTERFACE
!DEC$ ENDIF

!	4.4 System Identification					
        INTERFACE
          SUBROUTINE PXFUNAME( JUTSNAME,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFUNAME
          INTEGER(4)  JUTSNAME 
          INTEGER(4)  IERROR
          END SUBROUTINE PXFUNAME
        END INTERFACE

!	4.5 Time	
        INTERFACE
          SUBROUTINE PXFTIME( ITIME,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTIME
          INTEGER(4)  ITIME
          INTEGER(4)  IERROR
          END SUBROUTINE PXFTIME
        END INTERFACE

!	4.5 Time	
        INTERFACE
          SUBROUTINE PXFTIMES( JTMS,ITIME,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTIMES
           INTEGER(4)  JTMS
           INTEGER(4)  ITIME
           INTEGER(4)  IERROR
          END SUBROUTINE PXFTIMES
        END INTERFACE

!	4.6 Environment variables						
        INTERFACE
          SUBROUTINE PXFGETENV( NAME,LENNAME,VALUE,LENVAL,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETENV
          CHARACTER*(*) NAME,VALUE 
          INTEGER(4)  LENNAME,LENVAL,IERROR
          END SUBROUTINE PXFGETENV
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSETENV( NAME,LENNAME,NEW,LENNEW,IOVERWRITE,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSETENV
          CHARACTER*(*) NAME,NEW
          INTEGER(4)  LENNAME,LENNEW,IOVERWRITE,IERROR
          END SUBROUTINE PXFSETENV
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCLEARENV( IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCLEARENV
          INTEGER(4)  IERROR
          END SUBROUTINE PXFCLEARENV
        END INTERFACE

!	4.7 Terminal identification						
!DEC$ IF .NOT. DEFINED(_WIN32)
        INTERFACE
          SUBROUTINE PXFCTERMID(S,ILEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCTERMID
          CHARACTER*(*) S
          INTEGER(4)  ILEN,IERROR
          END SUBROUTINE PXFCTERMID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFTTYNAME(IFILDES,S,ILEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTTYNAME
          CHARACTER*(*) S
          INTEGER(4)  IFILDES,ILEN,IERROR
          END SUBROUTINE PXFTTYNAME
        END INTERFACE
!DEC$ ENDIF         

        INTERFACE
          SUBROUTINE PXFISATTY(IFILDES,ISATTY, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFISATTY
          INTEGER(4)  IFILDES,IERROR
          LOGICAL(4)  ISATTY 
          END SUBROUTINE PXFISATTY
        END INTERFACE

!	4.8 configurable System Variables	
        INTERFACE
          SUBROUTINE PXFSYSCONF(NAME, IVAL, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSYSCONF
          INTEGER(4)  NAME, IERROR
!!DEC$ IF DEFINED(IA32)
          INTEGER(4)  IVAL
!!DEC  ELSE
!! Intel(R) IA-64 architecture
!          INTEGER(8)  IVAL 
!!DEC$ ENDIF         
          END SUBROUTINE PXFSYSCONF
        END INTERFACE

!	5.1 Directories		
        INTERFACE
          SUBROUTINE PXFOPENDIR (DIRNAME, LENDIRNAME, OPENDIRID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFOPENDIR
          CHARACTER*(*) DIRNAME
          INTEGER(4) LENDIRNAME, IERROR
          INTEGER(4) OPENDIRID
          END SUBROUTINE PXFOPENDIR
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFREADDIR (IDIRID, JDIRENT, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFREADDIR
          INTEGER(4)  IERROR
          INTEGER(4) IDIRID, JDIRENT
          END SUBROUTINE PXFREADDIR
        END INTERFACE
        INTERFACE

          SUBROUTINE PXFREWINDDIR (IDIRID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFREWINDDIR
          INTEGER(4)  IERROR
          INTEGER(4)  IDIRID
          END SUBROUTINE PXFREWINDDIR
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCLOSEDIR (IDIRID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCLOSEDIR
          INTEGER(4)  IDIRID
          INTEGER(4)  IERROR
          END SUBROUTINE PXFCLOSEDIR
        END INTERFACE

!	5.2 Get working directory		
        INTERFACE
          SUBROUTINE PXFCHDIR(PATH, ILEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCHDIR
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IERROR
          END SUBROUTINE PXFCHDIR
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETCWD (BUF, ILEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETCWD
          CHARACTER*(*) BUF
          INTEGER(4) ILEN, IERROR
          END SUBROUTINE PXFGETCWD
        END INTERFACE

!	5.3 Genaral File creation		
        INTERFACE
        SUBROUTINE PXFOPEN(PATH,ILEN,IOPENFLAG,IMODE,IFILDES,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFOPEN
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IOPENFLAG, IMODE, IFILDES, IERROR
          END SUBROUTINE
        END INTERFACE

        INTERFACE
          SUBROUTINE PFXCREAT (PATH, ILEN, IMODE, IFILDES, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PFXCREAT
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IMODE, IFILDES, IERROR
          END SUBROUTINE PFXCREAT
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFUMASK (ICMASK, IPREVCMASK, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFUMASK
          INTEGER(4) ICMASK, IPREVCMASK, IERROR
          END SUBROUTINE PXFUMASK
        END INTERFACE

!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only
        INTERFACE
          SUBROUTINE PXFLINK (EXISTING, LENEXIST, NEW, LENNEW, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFLINK
          CHARACTER*(*) EXISTING, NEW
          INTEGER(4) LENEXIST, LENNEW, IERROR
          END SUBROUTINE PXFLINK
        END INTERFACE
!DEC$ ENDIF

!	5.4 Special File creation		
        INTERFACE
          SUBROUTINE PXFMKDIR (PATH, ILEN, IMODE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFMKDIR
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IMODE, IERROR
          END SUBROUTINE PXFMKDIR
        END INTERFACE

!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only
        INTERFACE
          SUBROUTINE PXFMKFIFO (PATH, ILEN, IMODE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFMKFIFO
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IMODE, IERROR
          END SUBROUTINE
        END INTERFACE
!DEC$ ENDIF

!	5.5 File removal		
        INTERFACE
          SUBROUTINE PXFUNLINK (PATH, ILEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFUNLINK
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IERROR
          END SUBROUTINE PXFUNLINK
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFRMDIR (PATH, ILEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFRMDIR
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IERROR
          END SUBROUTINE PXFRMDIR
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFRENAME (OLD, LENOLD, NEW, LENNEW, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFRENAME
          CHARACTER*(*) OLD, NEW
          INTEGER(4) LENOLD, LENNEW, IERROR
          END SUBROUTINE PXFRENAME
        END INTERFACE

!	5.6 File characteristics		

        INTERFACE
          LOGICAL(4) FUNCTION PXFISDIR (M)
!DEC$ ATTRIBUTES DEFAULT :: PXFISDIR
          INTEGER(4) M
          END FUNCTION PXFISDIR
        END INTERFACE

        INTERFACE
          LOGICAL(4) FUNCTION PXFISCHR (M)
!DEC$ ATTRIBUTES DEFAULT :: PXFISCHR
          INTEGER(4) M
          END FUNCTION PXFISCHR
        END INTERFACE

        INTERFACE
          LOGICAL(4) FUNCTION PXFISBLK (M)
!DEC$ ATTRIBUTES DEFAULT :: PXFISBLK
          INTEGER(4) M
          END FUNCTION PXFISBLK
        END INTERFACE


        INTERFACE
          LOGICAL(4) FUNCTION PXFISREG (M)
!DEC$ ATTRIBUTES DEFAULT :: PXFISREG
          INTEGER(4) M
          END FUNCTION PXFISREG
        END INTERFACE

        INTERFACE
          LOGICAL(4) FUNCTION PXFISFIFO (M)
!DEC$ ATTRIBUTES DEFAULT :: PXFISFIFO
          INTEGER(4) M
          END FUNCTION PXFISFIFO
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSTAT (PATH, ILEN, JSTAT, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSTAT
          CHARACTER(LEN=*) PATH
          INTEGER(4) ILEN, IERROR
          INTEGER(4) JSTAT
          END SUBROUTINE PXFSTAT
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFFSTAT (IFILDES, JSTAT, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFSTAT
          INTEGER(4) IFILDES, IERROR
          INTEGER(4) JSTAT
          END SUBROUTINE PXFFSTAT
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFACCESS (PATH, ILEN, IAMODE,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFACCESS
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IAMODE, IERROR
          END SUBROUTINE PXFACCESS
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCHMOD (PATH, ILEN, IMODE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCHMOD
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IMODE, IERROR
          END SUBROUTINE PXFCHMOD
        END INTERFACE

!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only
        INTERFACE
          SUBROUTINE PXFCHOWN(PATH, ILEN, IOWNER, IGROUP, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCHOWN
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, IOWNER, IGROUP, IERROR
          END SUBROUTINE PXFCHOWN
        END INTERFACE
!DEC$ ENDIF

        INTERFACE
          SUBROUTINE PXFUTIME (PATH, ILEN, JUTIMBUF, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFUTIME
           CHARACTER*(*) PATH
           INTEGER(4)  ILEN, IERROR
           INTEGER(4)  JUTIMBUF
          END SUBROUTINE PXFUTIME
        END INTERFACE

!	5.7 configurable Pathname Variables	
       INTERFACE
          SUBROUTINE PXFPATHCONF(PATH, ILEN, NAME, IVAL, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFPATHCONF
          CHARACTER*(*) PATH
          INTEGER(4) ILEN, NAME, IVAL, IERROR
          END SUBROUTINE PXFPATHCONF
       END INTERFACE

       INTERFACE
          SUBROUTINE PXFFPATHCONF( IFILDES, NAME, IVAL, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFPATHCONF
          INTEGER(4) IFILDES, NAME, IVAL, IERROR
          END SUBROUTINE PXFFPATHCONF
       END INTERFACE

!	6.1 Pipes
!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only
         INTERFACE
          SUBROUTINE PXFPIPE (IREADFD, IWRITEFD, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFPIPE
          INTEGER(4) IREADFD, IWRITEFD, IERROR
          END SUBROUTINE PXFPIPE
        END INTERFACE
!DEC$ ENDIF
 
!	6.2 File descriptor manipulation	
        INTERFACE
          SUBROUTINE PXFDUP (IFILDES, IFID, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFDUP
          INTEGER(4) IFILDES, IFID, IERROR
          END SUBROUTINE PXFDUP
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFDUP2 (IFILDES, IFILDES2, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFDUP2
          INTEGER(4) IFILDES, IFILDES2, IERROR
          END SUBROUTINE PXFDUP2
        END INTERFACE

!	6.3 File descriptor deassignment		
        INTERFACE
          SUBROUTINE PXFCLOSE (IFILDES, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCLOSE
          INTEGER(4) IFILDES, IERROR
          END SUBROUTINE PXFCLOSE
        END INTERFACE

!	6.4 I/O		
        INTERFACE
          SUBROUTINE PXFREAD (IFILDES, BUF, NBYTE, NREAD, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFREAD
          INTEGER(4) IFILDES
          CHARACTER  BUF(*)
          INTEGER(4) NBYTE, NREAD, IERROR
          END SUBROUTINE
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFWRITE (IFILDES, BUF, NBYTE, NWRITTEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFWRITE
          INTEGER(4) IFILDES, NBYTE, NWRITTEN, IERROR
          CHARACTER BUF(*)
          END SUBROUTINE PXFWRITE
        END INTERFACE

!	6.5 Control Operations on files		
!DEC$ IF .NOT. DEFINED(_WIN32)
        INTERFACE
          SUBROUTINE PXFFCNTL (IFILDES, ICMD, IARGIN, IARGOUT, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFCNTL
          INTEGER(4)  IFILDES, ICMD, IARGOUT, IERROR
          INTEGER(4)  IARGIN
          END SUBROUTINE PXFFCNTL
        END INTERFACE
!DEC$ ENDIF

        INTERFACE 
          SUBROUTINE PXFLSEEK (IFILDES, IOFFSET, IWHENCE, IPOSITION,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFLSEEK
          INTEGER(4) IFILDES, IWHENCE, IERROR
!!DEC$ IF DEFINED(IA32)
          INTEGER(4) IOFFSET, IPOSITION
!!DEC$ ELSE
!          INTEGER(8) IOFFSET, IPOSITION
!!DEC$ ENDIF
          END SUBROUTINE PXFLSEEK
        END INTERFACE

!DEC$ IF .NOT. DEFINED(_WIN32)
! For UNIX platforms only

!	7.1 Baud Rate Subroutines				
        INTERFACE
          SUBROUTINE PXFCFGETOSPEED (JTERMIOS, IOSPEED, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCFGETOSPEED
          INTEGER(4) JTERMIOS
          INTEGER(4) IOSPEED, IERROR
          END SUBROUTINE PXFCFGETOSPEED
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCFSETOSPEED (JTERMIOS, ISPEED, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCFSETOSPEED
          INTEGER(4) JTERMIOS
          INTEGER(4) ISPEED, IERROR
          END SUBROUTINE PXFCFSETOSPEED
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCFGETISPEED (JTERMIOS, IOSPEED, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCFGETISPEED
          INTEGER(4) JTERMIOS
          INTEGER(4) IOSPEED, IERROR
          END SUBROUTINE PXFCFGETISPEED
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCFSETISPEED (JTERMIOS, ISPEED, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCFSETISPEED
          INTEGER(4) JTERMIOS
          INTEGER(4) ISPEED, IERROR
          END SUBROUTINE PXFCFSETISPEED
        END INTERFACE

!	7.2 General Terminal Interface Control Sobroutines				
        INTERFACE
          SUBROUTINE PXFTCGETATTR (IFILDES, JTERMIOS, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTCGETATTR
          INTEGER(4) IFILDES,  IERROR
          INTEGER(4) JTERMIOS  
          END SUBROUTINE PXFTCGETATTR
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFTCSETATTR (IFILDES,IOPTACTS, JTERMIOS, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTCSETATTR
          INTEGER(4) IFILDES,IOPTACTS, IERROR
          INTEGER(4) JTERMIOS
          END SUBROUTINE PXFTCSETATTR
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFTCSENDBREAK (IFILDES,IDURATION, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTCSENDBREAK
          INTEGER(4) IFILDES,IDURATION, IERROR
          END SUBROUTINE PXFTCSENDBREAK
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFTCDRAIN (IFILDES, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTCDRAIN
          INTEGER(4) IFILDES, IERROR
          END SUBROUTINE PXFTCDRAIN
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFTCFLUSH(IFILDES,IQUEUE,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTCFLUSH
          INTEGER(4) IFILDES, IQUEUE, IERROR
          END SUBROUTINE PXFTCFLUSH
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFTCFLOW(IFILDES,IACTION,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTCFLOW
          INTEGER(4) IFILDES, IACTION, IERROR
          END SUBROUTINE PXFTCFLOW
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFTCGETPGRP(IFILDES,IPGID,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTCGETPGRP
          INTEGER(4) IFILDES, IPGID, IERROR
          END SUBROUTINE PXFTCGETPGRP
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFTCSETPGRP(IFILDES,IPGID,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFTCSETPGRP
          INTEGER(4) IFILDES, IPGID, IERROR
          END SUBROUTINE PXFTCSETPGRP
        END INTERFACE
!DEC$ ENDIF

!	8.2 Fortran77 (System simbolic constant access)		
        INTERFACE
          INTEGER(4) FUNCTION IPXFCONST(CONSTNAME)
!DEC$ ATTRIBUTES DEFAULT :: IPXFCONST
          CHARACTER*(*) CONSTNAME    
          END FUNCTION IPXFCONST
        END INTERFACE

        INTERFACE
          LOGICAL(4) FUNCTION PXFISCONST(CONSTNAME)
!DEC$ ATTRIBUTES DEFAULT :: PXFISCONST
          CHARACTER*(*) CONSTNAME    
          END FUNCTION PXFISCONST
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCONST (CONSTNAME, IVAL, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCONST
          CHARACTER(LEN=*) CONSTNAME
          INTEGER(4) IVAL, IERROR
          END SUBROUTINE PXFCONST
        END INTERFACE

!	8.3 Structure Creation				
        INTERFACE
          SUBROUTINE PXFSTRUCTCREATE (STRUCTNAME, JHANDLE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSTRUCTCREATE
          CHARACTER*(*) STRUCTNAME
          INTEGER(4) JHANDLE
          INTEGER(4) IERROR
          END SUBROUTINE PXFSTRUCTCREATE
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFINTGET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFINTGET
          INTEGER(4)  VALUE, IERROR
          INTEGER(4)  JHANDLE
          CHARACTER*(*) COMPNAME
          END SUBROUTINE PXFINTGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFINTSET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFINTSET
          INTEGER(4)  IERROR, VALUE
          INTEGER(4)  JHANDLE
          CHARACTER*(*) COMPNAME
          END SUBROUTINE
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFAINTGET (JHANDLE, COMPNAME, VALUE, IALEN,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFAINTGET
          INTEGER(4) JHANDLE
          INTEGER(4)  IALEN, IERROR
          CHARACTER*(*) COMPNAME
          INTEGER(4) VALUE(IALEN)
          END SUBROUTINE PXFAINTGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFAINTSET(JHANDLE, COMPNAME, VALUE, IALEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFAINTSET
          INTEGER(4) JHANDLE
          INTEGER(4) IALEN, IERROR
          CHARACTER*(*) COMPNAME
          INTEGER(4) VALUE(IALEN)
          END SUBROUTINE PXFAINTSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEINTGET (JHANDLE, COMPNAME, INDEX, VALUE,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEINTGET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, VALUE, IERROR 
        END SUBROUTINE PXFEINTGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEINTSET (JHANDLE, COMPNAME, INDEX,VALUE,     &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEINTSET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) VALUE, INDEX, IERROR
          END SUBROUTINE PXFEINTSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFINT8GET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFINT8GET
          INTEGER(4) JHANDLE
          INTEGER(4) IERROR
          INTEGER(8) VALUE
          CHARACTER*(*) COMPNAME
          END SUBROUTINE PXFINT8GET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFINT8SET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFINT8SET
          INTEGER(4) JHANDLE
          INTEGER(4) IERROR
          INTEGER(8) VALUE
          CHARACTER*(*) COMPNAME
          END SUBROUTINE
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFAINT8GET (JHANDLE, COMPNAME, VALUE, IALEN,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFAINT8GET
          INTEGER(4)   JHANDLE
          INTEGER(4)   IALEN, IERROR
          CHARACTER*(*) COMPNAME
          INTEGER(8) VALUE(IALEN)
          END SUBROUTINE PXFAINT8GET
        END INTERFACE


        INTERFACE
          SUBROUTINE PXFAINT8SET(JHANDLE, COMPNAME, VALUE, IALEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFAINT8SET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IALEN, IERROR
          CHARACTER*(*) COMPNAME
          INTEGER(8) VALUE(IALEN)
          END SUBROUTINE PXFAINT8SET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEINT8GET (JHANDLE, COMPNAME, INDEX, VALUE,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEINT8GET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR 
          INTEGER(8) VALUE
        END SUBROUTINE PXFEINT8GET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEINT8SET (JHANDLE, COMPNAME, INDEX, VALUE,     &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEINT8SET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR
          INTEGER(8) VALUE
          END SUBROUTINE PXFEINT8SET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFREALGET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFREALGET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IERROR
          CHARACTER*(*) COMPNAME
          REAL(4) VALUE
          END SUBROUTINE PXFREALGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFREALSET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFREALSET
          INTEGER(4) JHANDLE
          INTEGER(4) IERROR
          CHARACTER*(*) COMPNAME
          REAL(4) VALUE
          END SUBROUTINE PXFREALSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFAREALGET (JHANDLE, COMPNAME, VALUE, IALEN,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFAREALGET
          INTEGER(4) JHANDLE
          INTEGER(4) IALEN, IERROR
          CHARACTER*(*) COMPNAME
          REAL(4) VALUE(IALEN)
          END SUBROUTINE PXFAREALGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFAREALSET(JHANDLE, COMPNAME, VALUE, IALEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFAREALSET
          INTEGER(4) JHANDLE
          INTEGER(4) IALEN, IERROR
          CHARACTER*(*) COMPNAME
          REAL(4) VALUE(IALEN)
          END SUBROUTINE PXFAREALSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEREALGET (JHANDLE, COMPNAME, INDEX, VALUE,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEREALGET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR 
          REAL(4) VALUE   
        END SUBROUTINE PXFEREALGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEREALSET (JHANDLE, COMPNAME, INDEX,VALUE,     &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEREALSET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR
          REAL(4) VALUE   
          END SUBROUTINE PXFEREALSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFLGCLGET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFLGCLGET
          INTEGER(4) JHANDLE
          INTEGER(4) IERROR
          CHARACTER*(*) COMPNAME
          LOGICAL(4) VALUE
          END SUBROUTINE PXFLGCLGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFLGCLSET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFLGCLSET
          INTEGER(4) JHANDLE
          INTEGER(4) IERROR
          CHARACTER*(*) COMPNAME
          LOGICAL(4) VALUE
          END SUBROUTINE PXFLGCLSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFALGCLGET (JHANDLE, COMPNAME, VALUE, IALEN,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFALGCLGET
          INTEGER(4) JHANDLE
          INTEGER(4) IALEN, IERROR
          CHARACTER*(*) COMPNAME
          LOGICAL(4) VALUE(IALEN)
          END SUBROUTINE PXFALGCLGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFALGCLSET(JHANDLE, COMPNAME, VALUE, IALEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFALGCLSET
          INTEGER(4) JHANDLE
          INTEGER(4) IALEN, IERROR
          CHARACTER*(*) COMPNAME
          LOGICAL(4) VALUE(IALEN)
          END SUBROUTINE PXFALGCLSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFELGCLGET (JHANDLE, COMPNAME, INDEX, VALUE,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFELGCLGET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR 
          LOGICAL(4) VALUE   
        END SUBROUTINE PXFELGCLGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFELGCLSET (JHANDLE, COMPNAME, INDEX,VALUE,     &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFELGCLSET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR
          LOGICAL(4) VALUE   
          END SUBROUTINE PXFELGCLSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSTRGET (JHANDLE, COMPNAME, VALUE,ILEN,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSTRGET
          INTEGER(4) JHANDLE
          INTEGER(4) ILEN,IERROR
          CHARACTER*(*) COMPNAME
          CHARACTER*(*) VALUE
          END SUBROUTINE PXFSTRGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSTRSET (JHANDLE, COMPNAME, VALUE,ILEN,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSTRSET
          INTEGER(4) JHANDLE
          INTEGER(4) ILEN,IERROR
          CHARACTER*(*) COMPNAME
          CHARACTER*(*) VALUE
          END SUBROUTINE PXFSTRSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFASTRGET (JHANDLE, COMPNAME, VALUE, IALEN,       &
     &                           ILEN,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFASTRGET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IALEN, ILEN(IALEN),IERROR
          CHARACTER*(*) COMPNAME
          CHARACTER*(*) VALUE(IALEN)
          END SUBROUTINE PXFASTRGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFASTRSET(JHANDLE, COMPNAME, VALUE, IALEN,ILEN,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFASTRSET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IALEN,ILEN(IALEN),IERROR
          CHARACTER*(*) COMPNAME
          CHARACTER*(*) VALUE(IALEN)
          END SUBROUTINE PXFASTRSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFESTRGET (JHANDLE, COMPNAME, INDEX, VALUE,       &
     &                           ILEN,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFESTRGET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, ILEN,IERROR 
          CHARACTER*(*) VALUE   
        END SUBROUTINE PXFESTRGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFESTRSET (JHANDLE, COMPNAME, INDEX,VALUE,     &
     &                           ILEN,IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFESTRSET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, ILEN, IERROR
          CHARACTER*(*) VALUE   
          END SUBROUTINE PXFESTRSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCHARGET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCHARGET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IERROR
          CHARACTER*(*) COMPNAME
          CHARACTER(1) VALUE
          END SUBROUTINE PXFCHARGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCHARSET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCHARSET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IERROR
          CHARACTER*(*) COMPNAME
          CHARACTER(1) VALUE
          END SUBROUTINE PXFCHARSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFACHARGET (JHANDLE, COMPNAME, VALUE, IALEN,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFACHARGET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IALEN, IERROR
          CHARACTER*(*) COMPNAME
          CHARACTER(1) VALUE(IALEN)
          END SUBROUTINE PXFACHARGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFACHARSET(JHANDLE, COMPNAME, VALUE, IALEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFACHARSET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IALEN, IERROR
          CHARACTER*(*) COMPNAME
          CHARACTER(1) VALUE(IALEN)
          END SUBROUTINE PXFACHARSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFECHARGET (JHANDLE, COMPNAME, INDEX, VALUE,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFECHARGET
          CHARACTER*(*) COMPNAME
          INTEGER(4)  JHANDLE
          INTEGER(4)  INDEX, IERROR 
          CHARACTER(1) VALUE   
        END SUBROUTINE PXFECHARGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFECHARSET (JHANDLE, COMPNAME, INDEX,VALUE,     &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFECHARSET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR
          CHARACTER(1) VALUE   
          END SUBROUTINE PXFECHARSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFDBLGET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFDBLGET
          INTEGER(4) JHANDLE
          INTEGER(4) IERROR
          CHARACTER*(*) COMPNAME
          REAL(8) VALUE
          END SUBROUTINE PXFDBLGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFDBLSET (JHANDLE, COMPNAME, VALUE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFDBLSET
          INTEGER(4) JHANDLE
          INTEGER(4) IERROR
          CHARACTER*(*) COMPNAME
          REAL(8) VALUE
          END SUBROUTINE PXFDBLSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFADBLGET (JHANDLE, COMPNAME, VALUE, IALEN,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFADBLGET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IALEN, IERROR
          CHARACTER*(*) COMPNAME
          REAL(8) VALUE(IALEN)
          END SUBROUTINE PXFADBLGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFADBLSET(JHANDLE, COMPNAME, VALUE, IALEN, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFADBLSET
          INTEGER(4)  JHANDLE
          INTEGER(4)  IALEN, IERROR
          CHARACTER*(*) COMPNAME
          REAL(8) VALUE(IALEN)
          END SUBROUTINE PXFADBLSET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEDBLGET (JHANDLE, COMPNAME, INDEX, VALUE,       &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEDBLGET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR 
          REAL(8) VALUE   
        END SUBROUTINE PXFEDBLGET
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFEDBLSET (JHANDLE, COMPNAME, INDEX,VALUE,     &
     &                           IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFEDBLSET
          CHARACTER*(*) COMPNAME
          INTEGER(4) JHANDLE
          INTEGER(4) INDEX, IERROR
          REAL(8) VALUE   
          END SUBROUTINE PXFEDBLSET
        END INTERFACE
					
        INTERFACE
          SUBROUTINE PXFSTRUCTCOPY (STRUCTNAME, JHANDLE1, JHANDLE2,     &
     &                              IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSTRUCTCOPY
          INTEGER(4) JHANDLE1, JHANDLE2
          INTEGER(4) IERROR
          CHARACTER*(*) STRUCTNAME
          END SUBROUTINE PXFSTRUCTCOPY
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFSTRUCTFREE (JHANDLE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFSTRUCTFREE
          INTEGER(4)  IERROR
          INTEGER(4)  JHANDLE  
          END SUBROUTINE PXFSTRUCTFREE
        END INTERFACE

!	8.4 Subroutine-Handle Manipulation				
        INTERFACE
          SUBROUTINE PXFGETSUBHANDLE (SUB, JHANDLE1, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETSUBHANDLE
          INTEGER(4)  IERROR
          INTEGER(4)  JHANDLE1 
          EXTERNAL SUB
          END SUBROUTINE PXFGETSUBHANDLE
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFCALLSUBHANDLE(JHANDLE2, IVAL, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFCALLSUBHANDLE
          INTEGER(4) JHANDLE2
          INTEGER(4) IVAL, IERROR
          END SUBROUTINE PXFCALLSUBHANDLE
        END INTERFACE

!	8.5 External Unit and File Descriptor Interaction		
        INTERFACE
          SUBROUTINE PXFPOSIXIO(NEW, OLD, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFPOSIXIO
          INTEGER(4) NEW, OLD, IERROR
          END SUBROUTINE PXFPOSIXIO
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFFILENO (IUNIT, IFILDES, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFILENO
          INTEGER(4) IUNIT, IFILDES, IERROR
          END SUBROUTINE PXFFILENO
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFFDOPEN (IFILDES, IUNIT, ACCESS, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFDOPEN
          INTEGER(4) IUNIT, IFILDES, IERROR
           CHARACTER*(*) ACCESS
          END SUBROUTINE PXFFDOPEN
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFFFLUSH (IUNIT, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFFLUSH
          INTEGER(4) IUNIT, IERROR
          END SUBROUTINE PXFFFLUSH
        END INTERFACE

!	8.6 Stream I/O			
        INTERFACE
          SUBROUTINE PXFFSEEK (IUNIT, IOFFSET, IWHENCE, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFSEEK
          INTEGER(4) IUNIT, IOFFSET, IWHENCE, IERROR
          END SUBROUTINE PXFFSEEK
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFFTELL (IUNIT, IOFFSET, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFTELL
          INTEGER(4) IUNIT, IOFFSET, IERROR
          END SUBROUTINE PXFFTELL
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETC (CHAR, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETC
          CHARACTER  CHAR
          INTEGER(4) IERROR
          END SUBROUTINE PXFGETC
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFFGETC (IUNIT, CHAR, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFGETC
        INTEGER(4) IUNIT
          CHARACTER  CHAR
          INTEGER(4) IERROR
          END SUBROUTINE PXFFGETC
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFFPUTC (IUNIT, CHAR, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFFPUTC
          CHARACTER  CHAR
          INTEGER(4) IUNIT, IERROR
          END SUBROUTINE PXFFPUTC
        END INTERFACE

       INTERFACE
          SUBROUTINE PXFPUTC (CHAR, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFPUTC
          CHARACTER  CHAR
          INTEGER(4) IERROR
          END SUBROUTINE PXFPUTC
        END INTERFACE

!	8.8 System Date and Time		
       INTERFACE
          SUBROUTINE PXFLOCALTIME (ISECONDS, IATIME, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFLOCALTIME
          INTEGER(4) ISECONDS, IATIME(9), IERROR
          END SUBROUTINE PXFLOCALTIME
        END INTERFACE
        
!	8.9 Command-Line arguments	
        INTERFACE
          SUBROUTINE PXFGETARG (M, BUF, ILEN,  IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETARG
          INTEGER(4) M, ILEN, IERROR
          CHARACTER*(*) BUF
          END SUBROUTINE PXFGETARG
        END INTERFACE

        INTERFACE
          INTEGER(4) FUNCTION IPXFARGC()
!DEC$ ATTRIBUTES DEFAULT :: IPXFARGC
          END FUNCTION IPXFARGC
        END INTERFACE

!	8.10 Character String Procedures	
        INTERFACE
          INTEGER(4) FUNCTION IPXFLENTRIM(STRING)
!DEC$ ATTRIBUTES DEFAULT :: IPXFLENTRIM
          CHARACTER*(*) STRING 
          END FUNCTION IPXFLENTRIM
        END INTERFACE
       
!	8.11 Unsigned comparison
        INTERFACE
          SUBROUTINE PXFUCOMPARE (I1, I2, ICMPR, IDIFF)
!DEC$ ATTRIBUTES DEFAULT :: PXFUCOMPARE
          INTEGER(4) I1, I2, ICMPR, IDIFF
          END SUBROUTINE PXFUCOMPARE
        END INTERFACE

!    8.12 Process Termination	
        INTERFACE
          SUBROUTINE PXFEXIT (ISTATUS)
!DEC$ ATTRIBUTES DEFAULT :: PXFEXIT
          INTEGER(4) ISTATUS
          END SUBROUTINE PXFEXIT
        END INTERFACE

!	9.2.1 Group Database Access	
!DEC$ IF .NOT. DEFINED(_WIN32)

        INTERFACE
          SUBROUTINE PXFGETGRGID (IGID, JGROUP, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETGRGID
          INTEGER(4) IGID, IERROR
          INTEGER(4) JGROUP
          END SUBROUTINE PXFGETGRGID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETGRNAM (NAME, ILEN, JGROUP, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETGRNAM
          CHARACTER*(*) NAME
          INTEGER(4) ILEN, IERROR
          INTEGER(4) JGROUP
          END SUBROUTINE PXFGETGRNAM
        END INTERFACE

!	9.2.1 User Database Access	
       INTERFACE
          SUBROUTINE PXFGETPWUID (IUID, JPASSWD, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETPWUID
          INTEGER(4) IUID, IERROR
          INTEGER(4) JPASSWD
          END SUBROUTINE PXFGETPWUID
        END INTERFACE

        INTERFACE
          SUBROUTINE PXFGETPWNAM (NAME, ILEN, JPASSWD, IERROR)
!DEC$ ATTRIBUTES DEFAULT :: PXFGETPWNAM
          CHARACTER*(*) NAME
          INTEGER(4) ILEN, IERROR
          INTEGER(4) JPASSWD
          END SUBROUTINE
        END INTERFACE
!DEC$ ENDIF

      END MODULE IFPOSIX
!DEC$ ENDIF


