#! /bin/sh
#
# Copyright  (C) 1985-2013 Intel Corporation. All rights reserved.
#
# The information and source code contained herein is the exclusive property
# of Intel Corporation and may not be disclosed, examined, or reproduced in
# whole or in part without explicit written authorization from the Company.
#

INTEL_INSTALL_DIR_ORIG=$INSTALL_DIR
INSTALL_DIR=~/intel-test/intel/composer_xe_2013.2.146


if [ -z "${PATH}" ]
  then
      PATH="$INSTALL_DIR/bin/$1:$INSTALL_DIR/mpirt/bin/$1"; export PATH
      if [ "${I_MPI_ROOT}" ]
      then
         PATH="$I_MPI_ROOT/$1/bin:${PATH}"; export PATH
      fi
  else
     PATH="$INSTALL_DIR/bin/$1:$INSTALL_DIR/mpirt/bin/$1:${PATH}"; export PATH
     if [ "${I_MPI_ROOT}" ]
     then
        PATH="$I_MPI_ROOT/$1/bin:${PATH}"; export PATH
     fi
fi

if [ "`uname`" = "Darwin" ]; then
   # DYLD_LIBRARY_PATH is used on MAC OS*
   if [ -z "${DYLD_LIBRARY_PATH}" ]
   then
       DYLD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib:$INSTALL_DIR/compiler/lib/$1"; export DYLD_LIBRARY_PATH
   else
       DYLD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib:$INSTALL_DIR/compiler/lib/$1:${DYLD_LIBRARY_PATH}"; export DYLD_LIBRARY_PATH
   fi
   if [ -z "${LIBRARY_PATH}" ]
   then
       LIBRARY_PATH="$INSTALL_DIR/compiler/lib"; export LIBRARY_PATH
   else
       LIBRARY_PATH="$INSTALL_DIR/compiler/lib:${LIBRARY_PATH}"; export LIBRARY_PATH
   fi
   if [ -z "${NLSPATH}" ] 
   then
       NLSPATH="$INSTALL_DIR/compiler/lib/locale/en_US/%N"; export NLSPATH
   else
       NLSPATH="$INSTALL_DIR/compiler/lib/locale/en_US/%N:${NLSPATH}"; export NLSPATH
   fi
   if [ -z "${INTEL_LICENSE_FILE}" ]
   then
       INTEL_LICENSE_FILE="$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:/Users/Shared/Library/Application Support/Intel/Licenses"; export INTEL_LICENSE_FILE 
   else
       INTEL_LICENSE_FILE="${INTEL_LICENSE_FILE}:$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:/Users/Shared/Library/Application Support/Intel/Licenses"; export INTEL_LICENSE_FILE
   fi
   if [ -z "${MANPATH}" ]
   then
      MANPATH="$INSTALL_DIR/man/en_US":$(manpath):; export MANPATH
   else
      MANPATH="$INSTALL_DIR/man/en_US:${MANPATH}:"; export MANPATH
   fi
else
   if [ -z "${MIC_LD_LIBRARY_PATH}" ]
   then
      MIC_LD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/mic:/opt/intel/mic/coi/device-linux-release/lib:/opt/intel/mic/myo/lib"; export MIC_LD_LIBRARY_PATH
   else
      MIC_LD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/mic:/opt/intel/mic/coi/device-linux-release/lib:/opt/intel/mic/myo/lib:${MIC_LD_LIBRARY_PATH}"; export MIC_LD_LIBRARY_PATH
   fi
   if [ -z "${LD_LIBRARY_PATH}" ]
   then
      LD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/$1:/opt/intel/mic/coi/host-linux-release/lib:/opt/intel/mic/myo/lib:$INSTALL_DIR/mpirt/lib/$1"; export LD_LIBRARY_PATH
      if [ "${I_MPI_ROOT}" ]
      then
          LD_LIBRARY_PATH="$I_MPI_ROOT/$1/lib:${LD_LIBRARY_PATH}"; export LD_LIBRARY_PATH
      fi
   else
      LD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/$1:/opt/intel/mic/coi/host-linux-release/lib:/opt/intel/mic/myo/lib:$INSTALL_DIR/mpirt/lib/$1:${LD_LIBRARY_PATH}"; export LD_LIBRARY_PATH
      if [ "${I_MPI_ROOT}" ]
      then
         LD_LIBRARY_PATH="$I_MPI_ROOT/$1/lib:${LD_LIBRARY_PATH}"; export LD_LIBRARY_PATH
      fi 
   fi
   if [ -z "${LIBRARY_PATH}" ]
   then
       LIBRARY_PATH="$INSTALL_DIR/compiler/lib/$1"; export LIBRARY_PATH
   else
       LIBRARY_PATH="$INSTALL_DIR/compiler/lib/$1:${LIBRARY_PATH}"; export LIBRARY_PATH
   fi
   if [ -z "${NLSPATH}" ] 
   then
      NLSPATH="$INSTALL_DIR/compiler/lib/$1/locale/%l_%t/%N"; export NLSPATH 
   else
      NLSPATH="$INSTALL_DIR/compiler/lib/$1/locale/%l_%t/%N:${NLSPATH}"; export NLSPATH
   fi
   if [ -z "${INTEL_LICENSE_FILE}" ]
   then
      INTEL_LICENSE_FILE="$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses"; export INTEL_LICENSE_FILE 
   else
      INTEL_LICENSE_FILE="${INTEL_LICENSE_FILE}:$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses"; export INTEL_LICENSE_FILE
   fi
   if [ "$LC_CTYPE" ]
   then
      LANGUAGE_TERRITORY=`echo $LC_CTYPE | sed s/\\\\..\\*//`
   else  if [ "$LANG" ]
      then
        LANGUAGE_TERRITORY=`echo $LANG | sed s/\\\\..\\*//`
      fi
   fi

   if [ "$LANGUAGE_TERRITORY" != "en_US" ]
   then
      if [ "$LANGUAGE_TERRITORY" != "ja_JP" ]
      then
         LANGUAGE_TERRITORY="en_US"
      fi
   fi

   if [ -z "${MANPATH}" ]
   then
      MANPATH="$INSTALL_DIR/man/$LANGUAGE_TERRITORY":$(manpath):; export MANPATH
   else
      MANPATH="$INSTALL_DIR/man/$LANGUAGE_TERRITORY:${MANPATH}:"; export MANPATH
   fi
fi

INSTALL_DIR=$INTEL_INSTALL_DIR_ORIG
