#
# Copyright  (C) 1985-2013 Intel Corporation. All rights reserved.
#
# The information and source code contained herein is the exclusive property
# of Intel Corporation and may not be disclosed, examined, or reproduced in
# whole or in part without explicit written authorization from the Company.
#

#!/bin/csh

if ($?INSTALL_DIR) then
        set INTEL_INSTALL_DIR_SAVED=$INSTALL_DIR
endif

set INSTALL_DIR=/opt/intel/composer_xe_2013.2.146


if !($?PATH) then
    setenv PATH $INSTALL_DIR/bin/${1}:$INSTALL_DIR/mpirt/bin/${1}
    if ($?I_MPI_ROOT) then
      setenv PATH $I_MPI_ROOT/${1}/bin:${PATH}
    endif
else
    setenv PATH $INSTALL_DIR/bin/${1}:$INSTALL_DIR/mpirt/bin/${1}:${PATH}
    if ($?I_MPI_ROOT) then
      setenv PATH $I_MPI_ROOT/${1}/bin:${PATH}
    endif
endif

if ( "`uname`" == "Darwin" ) then
   # DYLD_LIBRARY_PATH is used on MAC OS*
   if !($?DYLD_LIBRARY_PATH) then
       setenv DYLD_LIBRARY_PATH $INSTALL_DIR/compiler/lib:$INSTALL_DIR/compiler/lib/${1}
   else
       setenv DYLD_LIBRARY_PATH $INSTALL_DIR/compiler/lib:$INSTALL_DIR/compiler/lib/${1}:${DYLD_LIBRARY_PATH}
   endif
   if !($?LIBRARY_PATH) then
       setenv LIBRARY_PATH $INSTALL_DIR/compiler/lib
   else
       setenv LIBRARY_PATH $INSTALL_DIR/compiler/lib:${LIBRARY_PATH}
   endif
   if !($?NLSPATH) then
       setenv NLSPATH $INSTALL_DIR/compiler/lib/locale/en_US/%N
   else
       setenv NLSPATH $INSTALL_DIR/compiler/lib/locale/en_US/%N:${NLSPATH}
   endif
   if !($?INTEL_LICENSE_FILE) then
       setenv INTEL_LICENSE_FILE "$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:/Users/Shared/Library/Application Support/Intel/Licenses"
   else
       setenv INTEL_LICENSE_FILE "$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:/Users/Shared/Library/Application Support/Intel/Licenses:${INTEL_LICENSE_FILE}"
   endif
   if !($?MANPATH) then
       setenv MANPATH $INSTALL_DIR/man/en_US:`manpath`:
   else
       setenv MANPATH $INSTALL_DIR/man/en_US:${MANPATH}:
   endif
else
   if !($?MIC_LD_LIBRARY_PATH) then
     setenv MIC_LD_LIBRARY_PATH $INSTALL_DIR/compiler/lib/mic:/opt/intel/mic/coi/device-linux-release/lib:/opt/intel/mic/myo/lib
   else
     setenv MIC_LD_LIBRARY_PATH $INSTALL_DIR/compiler/lib/mic:/opt/intel/mic/coi/device-linux-release/lib:/opt/intel/mic/myo/lib:${MIC_LD_LIBRARY_PATH}
   endif
   if !($?LD_LIBRARY_PATH) then
     setenv LD_LIBRARY_PATH $INSTALL_DIR/compiler/lib/${1}:/opt/intel/mic/coi/host-linux-release/lib:/opt/intel/mic/myo/lib:$INSTALL_DIR/mpirt/lib/${1}
     if ($?I_MPI_ROOT) then
       setenv LD_LIBRARY_PATH $I_MPI_ROOT/${1}/lib:${LD_LIBRARY_PATH}
     endif
   else
     setenv LD_LIBRARY_PATH $INSTALL_DIR/compiler/lib/${1}:/opt/intel/mic/coi/host-linux-release/lib:/opt/intel/mic/myo/lib:$INSTALL_DIR/mpirt/lib/${1}:${LD_LIBRARY_PATH}
     if ($?I_MPI_ROOT) then
       setenv LD_LIBRARY_PATH $I_MPI_ROOT/${1}/lib:${LD_LIBRARY_PATH}
     endif
   endif
   if !($?LIBRARY_PATH) then
       setenv LIBRARY_PATH $INSTALL_DIR/compiler/lib/${1}
   else
       setenv LIBRARY_PATH $INSTALL_DIR/compiler/lib/${1}:${LIBRARY_PATH}
   endif
   if !($?NLSPATH) then
       setenv NLSPATH $INSTALL_DIR/compiler/lib/${1}/locale/%l_%t/%N
   else
       setenv NLSPATH $INSTALL_DIR/compiler/lib/${1}/locale/%l_%t/%N:${NLSPATH}
   endif
   if !($?INTEL_LICENSE_FILE) then
       setenv INTEL_LICENSE_FILE "$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses"
   else
       setenv INTEL_LICENSE_FILE "$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:${INTEL_LICENSE_FILE}"
   endif
   if ($?LC_CTYPE) then
     if ("$LC_CTYPE" != "") then
       set LANGUAGE_TERRITORY=`echo $LC_CTYPE | sed s/\\..\*//`
     endif
   else if ($?LANG) then
     if ("$LANG" != "") then
       set LANGUAGE_TERRITORY=`echo $LANG | sed s/\\..\*//`
     endif
   endif
   if ("$LANGUAGE_TERRITORY" != "en_US") then
      if ("$LANGUAGE_TERRITORY" != "ja_JP") then
         set LANGUAGE_TERRITORY="en_US"
      endif
   endif
   if !($?MANPATH) then
        setenv MANPATH $INSTALL_DIR/man/${LANGUAGE_TERRITORY}:`manpath`:
   else
        setenv MANPATH $INSTALL_DIR/man/${LANGUAGE_TERRITORY}:${MANPATH}:
   endif
endif

if ($?INTEL_INSTALL_DIR_SAVED) then
        set INSTALL_DIR=$INTEL_INSTALL_DIR_SAVED
endif

