/*
 * Decompiled with CFR 0.152.
 */
package isus.util.validation;

import isus.Strings;
import isus.UpdateServiceException;
import isus.shared.UpdateServiceProperties;
import isus.shared.Util;
import isus.util.validation.CertificateCache;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;

public class MessageValidator {
    public static final String SIGNATURE_HEADER_NAME = "X-FNC-Sig";
    public static final String SECURE_SERVER_PROP_NAME = "SecureServer";

    public static boolean validateContent(byte[] byArray, String string, UpdateServiceProperties updateServiceProperties) throws UpdateServiceException {
        InputStream inputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        updateServiceProperties.setProperty(SECURE_SERVER_PROP_NAME, "true");
        try {
            Object object;
            Object object2;
            String string2;
            X509Certificate x509Certificate;
            inputStream = CertificateCache.getPKCS7Certificates(updateServiceProperties);
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray2 = bASE64Decoder.decodeBuffer(string);
            byteArrayInputStream = new ByteArrayInputStream(byArray2);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            CertPath certPath = certificateFactory.generateCertPath(inputStream, "PKCS7");
            List<? extends Certificate> list = certPath.getCertificates();
            X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
            Iterator<? extends Certificate> iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                x509Certificate = (X509Certificate)iterator.next();
                try {
                    x509Certificate.checkValidity();
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    throw new UpdateServiceException(Strings.getUIString("IDS_E_RESULT_UNTRUSTED_CERTEXPIRED"));
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    throw new UpdateServiceException(Strings.getUIString("IDS_E_RESULT_UNTRUSTED_CERTEXPIRED"));
                }
                x509CertificateArray[n] = x509Certificate;
                ++n;
            }
            x509Certificate = null;
            String string3 = new URL(Util.getHost(updateServiceProperties)).getHost();
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                string2 = x509CertificateArray[i].getSubjectDN().getName();
                if (string2.indexOf("CN=") <= -1) continue;
                object2 = new StringTokenizer(string2, "=,");
                object = "";
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object2).nextToken();
                    if (string4.trim().equals("CN")) {
                        object = ((StringTokenizer)object2).nextToken();
                        break;
                    }
                    ((StringTokenizer)object2).nextToken();
                }
                if (((String)object).startsWith("*") || ((String)object).startsWith("\\2A")) {
                    if (!string3.endsWith(((String)object).substring(((String)object).indexOf(46)))) continue;
                    x509Certificate = x509CertificateArray[i];
                    continue;
                }
                if (!string3.equals(object)) continue;
                x509Certificate = x509CertificateArray[i];
            }
            if (x509Certificate == null) {
                throw new UpdateServiceException(Strings.getUIString("IDS_E_RESULT_UNTRUSTED_WRONGCERT"));
            }
            try {
                MessageValidator.verifyRootCertificate(x509Certificate, list);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new UpdateServiceException(Strings.getUIString("IDS_E_RESULT_UNTRUSTED_BADCHAIN"));
            }
            catch (CertPathBuilderException certPathBuilderException) {
                throw new UpdateServiceException(Strings.getUIString("IDS_E_RESULT_UNTRUSTED_BADCHAIN"));
            }
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(byArray);
            string2 = new CMSSignedData((CMSProcessable)cMSProcessableByteArray, (InputStream)byteArrayInputStream);
            object2 = string2.getSignerInfos().getSigners();
            object = object2.iterator();
            Security.addProvider((Provider)new BouncyCastleProvider());
            boolean bl = false;
            while (object.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)object.next();
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    try {
                        if (!signerInformation.verify(x509CertificateArray[i].getPublicKey(), "BC")) continue;
                        bl = true;
                        continue;
                    }
                    catch (CMSException cMSException) {
                        continue;
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        // empty catch block
                    }
                }
            }
            Security.removeProvider("BC");
            boolean bl2 = bl;
            return bl2;
        }
        catch (IOException iOException) {
            throw new UpdateServiceException(iOException.getMessage());
        }
        catch (CMSException cMSException) {
            throw new UpdateServiceException(cMSException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UpdateServiceException(noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new UpdateServiceException(certificateException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void verifyRootCertificate(X509Certificate x509Certificate, List list) throws UpdateServiceException, CertPathValidatorException, CertPathBuilderException {
        try {
            String string = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
            FileInputStream fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, null);
            PKIXParameters pKIXParameters = new PKIXParameters(keyStore);
            pKIXParameters.setRevocationEnabled(false);
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(list);
            CertStore certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x509Certificate.getSubjectX500Principal());
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)x509CertSelector);
            pKIXBuilderParameters.addCertStore(certStore);
            pKIXBuilderParameters.setRevocationEnabled(false);
            CertPathBuilderResult certPathBuilderResult = certPathBuilder.build(pKIXBuilderParameters);
            CertPath certPath = certPathBuilderResult.getCertPath();
            CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            certPathValidator.validate(certPath, pKIXParameters);
        }
        catch (CertificateException certificateException) {
            throw new UpdateServiceException("Unable to read the trusted certificate keystore.");
        }
        catch (KeyStoreException keyStoreException) {
            throw new UpdateServiceException("No provider available to read trusted certificate keystore.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UpdateServiceException("No provider available to validate certificate path.");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new UpdateServiceException("There was a problem validating against the trusted certificate keystore.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UpdateServiceException("Could not find trusted certificate keystore.");
        }
        catch (IOException iOException) {
            throw new UpdateServiceException("Unable to read the trusted certificate keystore.");
        }
    }
}

