/*
 * Decompiled with CFR 0.152.
 */
package isus.util.validation;

import isus.UpdateServiceException;
import isus.rpc.RPCGetCertificate;
import isus.shared.UpdateServiceProperties;
import isus.shared.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;

public class CertificateCache {
    private static final String CERT_CACHE_FILE_NAME = "fnc-notification.cer";
    private static File certCacheFile = new File(Util.getHome() + File.separator + "fnc-notification.cer");

    public static InputStream getPKCS7Certificates(UpdateServiceProperties updateServiceProperties) throws IOException, UpdateServiceException {
        if (certCacheFile.exists()) {
            long l = certCacheFile.lastModified();
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(l);
            calendar2.add(10, 24);
            if (calendar.getTimeInMillis() > calendar2.getTimeInMillis()) {
                CertificateCache.updateCertificateCache(updateServiceProperties);
            }
        } else {
            CertificateCache.updateCertificateCache(updateServiceProperties);
        }
        return new FileInputStream(certCacheFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCertificateCache(UpdateServiceProperties updateServiceProperties) throws IOException, UpdateServiceException {
        if (!certCacheFile.exists()) {
            certCacheFile.createNewFile();
        }
        RPCGetCertificate rPCGetCertificate = new RPCGetCertificate(updateServiceProperties);
        rPCGetCertificate.Run(true);
        byte[] byArray = rPCGetCertificate.getResultBytes();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(certCacheFile);
            fileOutputStream.write(byArray);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

