/*
 * Decompiled with CFR 0.152.
 */
package isus.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;

public final class MultiLabel
extends Component {
    private Dimension prefSize = new Dimension();
    private String[] lines = new String[0];
    private boolean drawBorder = false;
    private int maxChars = 0;

    public MultiLabel() {
    }

    public MultiLabel(String string, int n) {
        this.maxChars = n;
        this.setText(string, false);
    }

    public void setMaxChars(int n) {
        this.maxChars = n;
    }

    public void setText(String string, boolean bl) {
        this.drawBorder = bl;
        string = string.replace('\t', ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        if (this.maxChars <= 0 || string.length() <= this.maxChars) {
            this.lines = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.lines[n++] = stringTokenizer.nextToken();
            }
        } else {
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ", false);
                String string3 = new String("");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    if (string3.length() + string4.length() < this.maxChars) {
                        string3 = string3 + string4 + " ";
                        continue;
                    }
                    if (string3.length() > 0) {
                        vector.addElement(string3);
                    }
                    string3 = string4 + " ";
                }
                vector.addElement(string3);
            }
            this.lines = new String[vector.size()];
            vector.copyInto(this.lines);
        }
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String[] stringArray = this.lines;
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = fontMetrics.stringWidth(stringArray[i]);
            if (n3 > n) {
                n = n3;
            }
            n2 += fontMetrics.getHeight();
        }
        this.prefSize.width = n + 6;
        this.prefSize.height = n2 + 2;
        return this.prefSize;
    }

    public void paint(Graphics graphics) {
        String[] stringArray = this.lines;
        if (stringArray == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getHeight();
        int n3 = 0;
        while (n3 < stringArray.length) {
            graphics.drawString(stringArray[n3], 3, n);
            ++n3;
            n += n2;
        }
        if (this.drawBorder) {
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
    }
}

