/*
 * Decompiled with CFR 0.152.
 */
package isus.util;

import isus.Strings;
import isus.util.MultiLabel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;

public class MessageBox
extends JDialog
implements ActionListener {
    private static int emptySpace = 5;
    private static int buttonHeight = 25;
    private static int buttonWidth = 100;
    private static int mainPaneHeight = 150;
    private static int mainPaneWidth = 400;
    private static int secondaryPaneHeight = mainPaneHeight - buttonHeight - emptySpace * 3;
    private static int secondaryPaneWidth = mainPaneWidth - emptySpace * 2;
    public static final int MB_YES = 1;
    public static final int MB_NO = 2;
    public static final int MB_OK = 1;
    public static final int MB_YESNO = 2;
    boolean frameSizeAdjusted = false;
    private int m_mode;
    JScrollPane scrollPane = new JScrollPane();
    MultiLabel textArea = new MultiLabel();
    JButton yesButton = new JButton("Yes");
    JButton noButton = new JButton("No");
    private int m_response = 0;

    public MessageBox(Frame frame, int n) {
        super(frame);
        this.m_mode = n;
        this.setModal(true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setBounds(dimension.width / 2 - 200, dimension.height / 2 - 150, 400, 300);
        this.textArea.setMaxChars(70);
        this.getContentPane().setLayout(null);
        this.setSize(mainPaneWidth, mainPaneHeight);
        this.setVisible(false);
        this.getContentPane().add(this.scrollPane);
        this.scrollPane.setBounds(emptySpace, emptySpace, secondaryPaneWidth, secondaryPaneHeight);
        this.scrollPane.getViewport().add(this.textArea);
        this.textArea.setBounds(0, 0, secondaryPaneWidth - 3, secondaryPaneHeight - 3);
        this.getContentPane().add(this.yesButton);
        this.yesButton.setBounds((mainPaneWidth - buttonWidth) / 2, mainPaneHeight - buttonHeight - emptySpace, buttonWidth, buttonHeight);
        this.yesButton.addActionListener(this);
        if (this.m_mode == 1) {
            this.yesButton.setText("OK");
        }
        if (this.m_mode == 2) {
            this.getContentPane().add(this.noButton);
            this.noButton.setBounds((mainPaneWidth - buttonWidth) / 2 + buttonWidth + 20, mainPaneHeight - buttonHeight - emptySpace, buttonWidth, buttonHeight);
            this.yesButton.setText(Strings.getUIString("IDS_YES"));
            this.noButton.setText(Strings.getUIString("IDS_NO"));
            this.noButton.addActionListener(this);
        }
    }

    public MessageBox(int n) {
        this((Frame)null, n);
    }

    public MessageBox(String string, int n) {
        this(n);
        this.setTitle(string);
    }

    public MessageBox(String string, String string2, int n) {
        this(n);
        this.setTitle(string);
        this.textArea.setText(string2, false);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.yesButton) {
            this.m_response = 1;
            this.dispose();
        }
        if (object == this.noButton) {
            this.m_response = 2;
            this.dispose();
        }
    }

    public void setText(String string) {
        this.textArea.setText(string, false);
    }

    public int getResponse() {
        return this.m_response;
    }

    public void setButtonText(String string, int n) {
        switch (n) {
            case 1: {
                this.yesButton.setText(string);
                break;
            }
            case 2: {
                this.noButton.setText(string);
            }
        }
    }
}

