/*
 * Decompiled with CFR 0.152.
 */
package isus.util;

import isus.ProcessOutputHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryProcessOutputHandler
implements ProcessOutputHandler {
    private ByteArrayOutputStream stdoutStream;
    private ByteArrayOutputStream stderrStream;
    private int SLEEP_TIME = 5;

    public MemoryProcessOutputHandler(ByteArrayOutputStream byteArrayOutputStream, ByteArrayOutputStream byteArrayOutputStream2) {
        this.stdoutStream = byteArrayOutputStream;
        this.stderrStream = byteArrayOutputStream2;
    }

    public void processOutputData(InputStream inputStream) {
        if (this.stdoutStream != null) {
            this.stdoutStream.reset();
        }
        this.readProcessStream(inputStream, this.stdoutStream);
    }

    public void processErrorData(InputStream inputStream) {
        if (this.stderrStream != null) {
            this.stderrStream.reset();
        }
        this.readProcessStream(inputStream, this.stderrStream);
    }

    private void readProcessStream(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                if (outputStream != null) {
                    outputStream.write(byArray, 0, n);
                }
                try {
                    Thread.sleep(this.SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (outputStream == null) continue;
                outputStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

