/*
 * Decompiled with CFR 0.152.
 */
package isus.shared;

import isus.shared.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Tracer {
    private static boolean m_bInitialized = false;
    private static boolean m_bTraceOn = false;

    public static void initialize() {
        Util.getHome();
        File file = new File(Util.getHome(), "trace.on");
        m_bTraceOn = file.exists();
        m_bInitialized = true;
    }

    public static void trace(Object object, String string) {
        if (!m_bInitialized) {
            Tracer.initialize();
        }
        if (m_bTraceOn) {
            String string2 = "NULL";
            if (object != null) {
                string2 = object.getClass().toString();
            }
            Long l = new Long(System.currentTimeMillis());
            String string3 = "Thread: " + Thread.currentThread().toString() + " - Time: " + l.toString();
            string3 = string3 + " - Class: " + string2 + " - Trace Message: " + string;
            try {
                File file = new File(Util.getHome(), "trace.txt");
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath(), true);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(string3);
                printWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void traceException(Throwable throwable) {
        if (!m_bInitialized) {
            Tracer.initialize();
        }
        if (m_bTraceOn) {
            Long l = new Long(System.currentTimeMillis());
            String string = "Thread ID: " + Thread.currentThread().toString() + " - Time: " + l.toString();
            string = string + " - EXCEPTION: " + throwable.getMessage();
            try {
                File file = new File(Util.getHome(), "trace.txt");
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath(), true);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(string);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

