/*
 * Decompiled with CFR 0.152.
 */
package isus.shared;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public final class CrypterHelper {
    static int iBufferSize = 1024;
    static String[] sAlgorithms = new String[]{"AES", "Blowfish", "DES", "DESede", "PBEWithMD5AndDES", "RC2", "RC4", "RC5", "RSA"};
    static String[] sModes = new String[]{"NONE", "CBC", "CFB", "ECB", "OFB", "PCBC"};
    static String[] sPaddings = new String[]{"NoPadding", "PKCS5Padding", "SSL3Padding"};
    static String sHashAlgorithm = "MD5";
    static String sKeyAlgorithm = "DES";
    static String sTransformation = "DES/ECB/NoPadding";
    static String TYPE1_SIGNATURE_HEADER = "aLuZgUrU";
    static String TYPE2_SIGNATURE_HEADER = "gUrUaLuZ";
    static int SIZEOF_INT = 4;
    static int KEYSIZE = 1024;
    static String sSignatureKeyAlgorithm = "RSA";
    static String sSignatureAlgorithm = "SHA1withRSA";

    public boolean Encrypt(String string, String string2, String string3) {
        return this.Encrypt(string, string2, string3, sHashAlgorithm, sKeyAlgorithm, sTransformation);
    }

    public boolean Encrypt(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            File file2 = new File(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            return this.Encrypt(fileInputStream, (int)file.length(), fileOutputStream, string3, string4, string5, string6);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    public boolean Encrypt(InputStream inputStream, int n, OutputStream outputStream, String string) {
        return this.Encrypt(inputStream, n, outputStream, string, sHashAlgorithm, sKeyAlgorithm, sTransformation);
    }

    public boolean Encrypt(InputStream inputStream, int n, OutputStream outputStream, String string, String string2, String string3, String string4) {
        try {
            byte[] byArray;
            int n2;
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            messageDigest.update(string.getBytes());
            byte[] byArray2 = messageDigest.digest();
            DESKeySpec dESKeySpec = new DESKeySpec(byArray2);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string3);
            SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
            Cipher cipher = Cipher.getInstance(string4);
            cipher.init(1, secretKey);
            outputStream.write(n & 0xFF);
            outputStream.write((n & 0xFF00) >> 8);
            outputStream.write((n & 0xFF0000) >> 16);
            outputStream.write((n & 0xFF000000) >> 24);
            byte[] byArray3 = new byte[iBufferSize];
            int n3 = 0;
            int n4 = 0;
            while ((n2 = inputStream.read(byArray3)) != -1) {
                if (n2 % 8 > 0) {
                    int n5 = 8 - n2 % 8;
                    for (int i = 0; i < n5; ++i) {
                        byArray3[n2 + i] = 0;
                    }
                    n2 += n5;
                }
                byArray = cipher.update(byArray3, 0, n2);
                n3 += n2;
                n4 += byArray.length;
                outputStream.write(byArray);
            }
            byArray = cipher.doFinal();
            n4 += byArray.length;
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
        return true;
    }

    public boolean Decrypt(String string, String string2, String string3) {
        return this.Decrypt(string, string2, string3, sHashAlgorithm, sKeyAlgorithm, sTransformation);
    }

    public boolean Decrypt(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            File file2 = new File(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            return this.Decrypt(fileInputStream, (int)file.length(), fileOutputStream, string3, string4, string5, string6);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    public boolean Decrypt(InputStream inputStream, int n, OutputStream outputStream, String string) {
        return this.Decrypt(inputStream, n, outputStream, string, sHashAlgorithm, sKeyAlgorithm, sTransformation);
    }

    public boolean Decrypt(InputStream inputStream, int n, OutputStream outputStream, String string, String string2, String string3, String string4) {
        try {
            byte[] byArray;
            int n2;
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            messageDigest.update(string.getBytes());
            byte[] byArray2 = messageDigest.digest();
            DESKeySpec dESKeySpec = new DESKeySpec(byArray2);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string3);
            SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
            Cipher cipher = Cipher.getInstance(string4);
            cipher.init(2, secretKey);
            byte[] byArray3 = new byte[4];
            inputStream.read(byArray3);
            int n3 = CrypterHelper.ByteArrayToInt(CrypterHelper.ConvertLittleEndian(byArray3), 0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray4 = new byte[iBufferSize];
            int n4 = 0;
            int n5 = 0;
            while ((n2 = inputStream.read(byArray4)) != -1) {
                byArray = cipher.update(byArray4, 0, n2);
                n4 += n2;
                n5 += byArray.length;
                byteArrayOutputStream.write(byArray);
            }
            byArray = cipher.doFinal();
            n5 += byArray.length;
            byteArrayOutputStream.write(byArray);
            outputStream.write(byteArrayOutputStream.toByteArray(), 0, n3);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
        return true;
    }

    public boolean GenerateKeys(String string, String string2) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(sSignatureKeyAlgorithm);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            keyPairGenerator.initialize(KEYSIZE, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(privateKey.getEncoded());
            fileOutputStream.close();
            FileOutputStream fileOutputStream2 = new FileOutputStream(string2);
            fileOutputStream2.write(publicKey.getEncoded());
            fileOutputStream2.close();
            System.out.println("Private Key : algorithm = " + privateKey.getAlgorithm() + " format = " + privateKey.getFormat());
            System.out.println("Public Key : algorithm = " + publicKey.getAlgorithm() + " format = " + publicKey.getFormat());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean Sign(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(sSignatureKeyAlgorithm);
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            Signature signature = Signature.getInstance(sSignatureAlgorithm);
            signature.initSign(privateKey);
            FileInputStream fileInputStream2 = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream2);
            byte[] byArray2 = new byte[iBufferSize];
            while (bufferedInputStream.available() != 0) {
                int n = bufferedInputStream.read(byArray2);
                signature.update(byArray2, 0, n);
            }
            bufferedInputStream.close();
            fileInputStream2.close();
            byte[] byArray3 = signature.sign();
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            fileOutputStream.write(byArray3);
            fileOutputStream.write(byArray3.length);
            fileOutputStream.write(TYPE1_SIGNATURE_HEADER.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean VerifySignature(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(sSignatureKeyAlgorithm);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Signature signature = Signature.getInstance(sSignatureAlgorithm);
            signature.initVerify(publicKey);
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
            randomAccessFile.seek(randomAccessFile.length() - (long)TYPE1_SIGNATURE_HEADER.length() - 1L);
            int n = randomAccessFile.read();
            byte[] byArray2 = new byte[TYPE1_SIGNATURE_HEADER.length()];
            randomAccessFile.read(byArray2);
            if (!TYPE1_SIGNATURE_HEADER.equals(new String(byArray2))) {
                return false;
            }
            randomAccessFile.seek(randomAccessFile.length() - (long)TYPE1_SIGNATURE_HEADER.length() - 1L - (long)n);
            byte[] byArray3 = new byte[n];
            randomAccessFile.read(byArray3);
            randomAccessFile.setLength(randomAccessFile.length() - (long)TYPE1_SIGNATURE_HEADER.length() - 1L - (long)n);
            randomAccessFile.close();
            FileInputStream fileInputStream2 = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream2);
            byte[] byArray4 = new byte[iBufferSize];
            while (bufferedInputStream.available() != 0) {
                int n2 = bufferedInputStream.read(byArray4);
                signature.update(byArray4, 0, n2);
            }
            bufferedInputStream.close();
            fileInputStream2.close();
            return signature.verify(byArray3);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public boolean Sign(String string, String string2, String string3) {
        try {
            Object object;
            FileInputStream fileInputStream = new FileInputStream(string2);
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "SunJSSE");
            keyStore.load(fileInputStream, string3.toCharArray());
            ((InputStream)fileInputStream).close();
            Enumeration<String> enumeration = keyStore.aliases();
            String string4 = null;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!keyStore.isKeyEntry((String)object)) continue;
                string4 = object;
            }
            if (string4 == null) {
                return false;
            }
            object = (RSAPrivateCrtKey)keyStore.getKey(string4, string3.toCharArray());
            Signature signature = Signature.getInstance(sSignatureAlgorithm);
            signature.initSign((PrivateKey)object);
            FileInputStream fileInputStream2 = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream2);
            byte[] byArray = new byte[iBufferSize];
            while (bufferedInputStream.available() != 0) {
                signature.update(byArray, 0, bufferedInputStream.read(byArray));
            }
            bufferedInputStream.close();
            fileInputStream2.close();
            byte[] byArray2 = signature.sign();
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string, true));
            dataOutputStream.writeInt(CrypterHelper.ConvertLittleEndian(byArray2.length));
            dataOutputStream.write(CrypterHelper.Reverse(byArray2));
            dataOutputStream.writeInt(CrypterHelper.ConvertLittleEndian(byArray2.length + SIZEOF_INT));
            dataOutputStream.write(TYPE2_SIGNATURE_HEADER.getBytes());
            dataOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean VerifySignature2(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            PublicKey publicKey = CertificateFactory.getInstance("X.509").generateCertificate(fileInputStream).getPublicKey();
            fileInputStream.close();
            Signature signature = Signature.getInstance(sSignatureAlgorithm);
            signature.initVerify(publicKey);
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
            randomAccessFile.seek(randomAccessFile.length() - (long)TYPE2_SIGNATURE_HEADER.length());
            byte[] byArray = new byte[TYPE2_SIGNATURE_HEADER.length()];
            randomAccessFile.read(byArray);
            if (!TYPE2_SIGNATURE_HEADER.equals(new String(byArray))) {
                return false;
            }
            randomAccessFile.seek(randomAccessFile.length() - (long)TYPE2_SIGNATURE_HEADER.length() - (long)SIZEOF_INT);
            byte[] byArray2 = new byte[SIZEOF_INT];
            randomAccessFile.read(byArray2);
            int n = CrypterHelper.ByteArrayToInt(CrypterHelper.ConvertLittleEndian(byArray2), 0);
            randomAccessFile.seek(randomAccessFile.length() - (long)TYPE2_SIGNATURE_HEADER.length() - (long)n);
            byte[] byArray3 = new byte[n - SIZEOF_INT];
            randomAccessFile.read(byArray3);
            randomAccessFile.setLength(randomAccessFile.length() - (long)TYPE2_SIGNATURE_HEADER.length() - (long)SIZEOF_INT - (long)n);
            randomAccessFile.close();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            byte[] byArray4 = new byte[iBufferSize];
            while (bufferedInputStream.available() != 0) {
                signature.update(byArray4, 0, bufferedInputStream.read(byArray4));
            }
            bufferedInputStream.close();
            return signature.verify(CrypterHelper.Reverse(byArray3));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public boolean verifySHAHash(String string, String string2) {
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            FileInputStream fileInputStream = new FileInputStream(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            messageDigest.update(byteArrayOutputStream.toByteArray());
            byte[] byArray2 = messageDigest.digest();
            return string2.equals(this.encode(byArray2));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(CrypterHelper.byteToHex(byArray[i] >>> 4 & 0xF));
            stringBuffer.append(CrypterHelper.byteToHex(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    private static char byteToHex(int n) {
        return (char)(n >= 0 && n <= 9 ? 48 + n : 65 + (n - 10));
    }

    public static int ConvertLittleEndian(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    public static byte[] ConvertLittleEndian(byte[] byArray) {
        byte by = byArray[3];
        byArray[3] = byArray[0];
        byArray[0] = by;
        by = byArray[2];
        byArray[2] = byArray[1];
        byArray[1] = by;
        return byArray;
    }

    public static byte[] Reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        return byArray2;
    }

    public static int ByteArrayToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n3 = (3 - i) * 8;
            n2 += (byArray[i + n] & 0xFF) << n3;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (0 == stringArray[0].compareToIgnoreCase("-e") || 0 == stringArray[0].compareToIgnoreCase("/e")) {
            bl = true;
        } else if (0 == stringArray[0].compareToIgnoreCase("-d") || 0 == stringArray[0].compareToIgnoreCase("/d")) {
            bl2 = true;
        } else if (0 == stringArray[0].compareToIgnoreCase("-g") || 0 == stringArray[0].compareToIgnoreCase("/g")) {
            bl3 = true;
        } else if (0 == stringArray[0].compareToIgnoreCase("-s1") || 0 == stringArray[0].compareToIgnoreCase("/s1")) {
            bl4 = true;
        } else if (0 == stringArray[0].compareToIgnoreCase("-s2") || 0 == stringArray[0].compareToIgnoreCase("/s2")) {
            bl5 = true;
        } else if (0 == stringArray[0].compareToIgnoreCase("-v1") || 0 == stringArray[0].compareToIgnoreCase("/v1")) {
            bl6 = true;
        } else if (0 == stringArray[0].compareToIgnoreCase("-v2") || 0 == stringArray[0].compareToIgnoreCase("/v2")) {
            bl7 = true;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 1; i < stringArray.length; ++i) {
            if (0 == stringArray[i].compareToIgnoreCase("-i") || 0 == stringArray[i].compareToIgnoreCase("/i")) {
                string = new String(stringArray[++i]);
                continue;
            }
            if (0 == stringArray[i].compareToIgnoreCase("-o") || 0 == stringArray[i].compareToIgnoreCase("/o")) {
                string2 = new String(stringArray[++i]);
                continue;
            }
            if (0 == stringArray[i].compareToIgnoreCase("-p") || 0 == stringArray[i].compareToIgnoreCase("/p")) {
                string3 = new String(stringArray[++i]);
                continue;
            }
            if (0 == stringArray[i].compareToIgnoreCase("-u") || 0 == stringArray[i].compareToIgnoreCase("/u")) {
                string4 = new String(stringArray[++i]);
                continue;
            }
            if (0 != stringArray[i].compareToIgnoreCase("-r") && 0 != stringArray[i].compareToIgnoreCase("/r")) continue;
            string5 = new String(stringArray[++i]);
        }
        CrypterHelper crypterHelper = new CrypterHelper();
        if (bl) {
            if (crypterHelper.Encrypt(string, string2, string3)) {
                System.out.println("Encrypted file successfully!");
            }
        } else if (bl2) {
            if (crypterHelper.Decrypt(string, string2, string3)) {
                System.out.println("Decrypted file successfully!");
            }
        } else if (bl3) {
            if (crypterHelper.GenerateKeys(string5, string4)) {
                System.out.println("Generated private and public keys successfully!");
            }
        } else if (bl4) {
            if (crypterHelper.Sign(string, string5)) {
                System.out.println("Signed file successfully!");
            }
        } else if (bl5) {
            if (crypterHelper.Sign(string, string5, string3)) {
                System.out.println("Signed file successfully!");
            }
        } else if (bl6) {
            if (crypterHelper.VerifySignature(string, string4)) {
                System.out.println("Verified file successfully!");
            }
        } else if (bl7 && crypterHelper.VerifySignature2(string, string4)) {
            System.out.println("Verified file successfully!");
        }
    }
}

