/*
 * Decompiled with CFR 0.152.
 */
package isus.rpc;

import isus.HeaderElement;
import isus.ProxyInfo;
import isus.Strings;
import isus.UpdateServiceException;
import isus.rpc.IRPCObject;
import isus.shared.Tracer;
import isus.shared.UpdateServiceProperties;
import isus.shared.Util;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class RPCObject
implements IRPCObject {
    private String responseSignature;
    private byte[] resultBytes;
    protected String m_proxy;
    protected int m_proxyport;
    private String m_host;
    private String m_hostfile;
    private String m_result;
    protected boolean m_bUsePost = true;

    protected String getUserID() {
        String string = null;
        try {
            string = Util.getUserID();
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
        }
        return string;
    }

    public RPCObject() {
        if (System.getProperty("isushost") == null) {
            this.setHost(Strings.getString("RPCObject.http//updates.installshield.com/"));
        } else {
            this.setHost(System.getProperty("isushost"));
        }
        this.m_result = "";
    }

    public String GetResult() {
        return this.m_result;
    }

    public byte[] getResultBytes() {
        return this.resultBytes;
    }

    public String GetFileName() {
        return this.m_hostfile;
    }

    protected String getResponseSignature() {
        return this.responseSignature;
    }

    protected void setResponseSignature(String string) {
        this.responseSignature = string;
    }

    public String GetHost(UpdateServiceProperties updateServiceProperties) {
        String string = updateServiceProperties.getProperty("Server");
        if (string.length() == 0) {
            string = System.getProperty("isushost") == null ? Strings.getString("RPCObject.http//updates.installshield.com/") : System.getProperty("isushost");
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        Tracer.trace(this, "GetHost return: " + string);
        return string;
    }

    public void Execute(UpdateServiceProperties updateServiceProperties, String string, String string2, String string3) throws UpdateServiceException {
        Object object;
        String string4;
        if (this.m_bUsePost) {
            this.ExecuteWithPost(updateServiceProperties, string, string2, string3);
            return;
        }
        URL uRL = null;
        URLConnection uRLConnection = null;
        String string5 = string;
        if (string.indexOf("http://") == -1) {
            string5 = this.GetHost(updateServiceProperties);
            if (!string5.endsWith("/")) {
                string5 = string5 + "/";
            }
            string5 = string5 + string;
        }
        string5 = string5 + "?v=ISUA 12.00MP";
        if (string2.length() > 0) {
            string5 = string5 + "&" + string2;
        }
        if ((string4 = this.getUserID()) != null) {
            string5 = string2.length() == 0 ? string5 + "?" : string5 + "&";
            string5 = string5 + "u=" + string4;
        }
        ProxyInfo proxyInfo = new ProxyInfo(updateServiceProperties);
        Tracer.trace(this, "Execute - URL:" + string5);
        try {
            uRL = new URL(string5);
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "ISUA 12.00MP");
            if (string4 != null) {
                uRLConnection.setRequestProperty("Cookie", "UID=" + string4);
            }
            proxyInfo.InitProxy(uRLConnection);
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
            throw new UpdateServiceException(iOException.getMessage());
        }
        if (uRLConnection == null) {
            return;
        }
        uRLConnection.setDefaultUseCaches(false);
        int n = 0;
        String string6 = null;
        String string7 = null;
        while ((string6 = uRLConnection.getHeaderField(n)) != null) {
            object = null;
            try {
                object = HeaderElement.parse(string6);
            }
            catch (IOException iOException) {
                break;
            }
            for (int i = 0; i < ((HeaderElement[])object).length; ++i) {
                if (!object[i].getName().equals("UID")) continue;
                string7 = object[i].getValue();
                break;
            }
            ++n;
        }
        if (string7 != null && updateServiceProperties != null) {
            updateServiceProperties.setProperty("UID", string7);
        }
        this.responseSignature = uRLConnection.getHeaderField("X-FNC-Sig");
        object = null;
        try {
            int n2;
            object = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = ((InputStream)object).read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            this.resultBytes = byteArrayOutputStream.toByteArray();
            this.m_result = new String(this.resultBytes, "UTF-8");
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
            throw new UpdateServiceException("Not Connected or Update Service is not available");
        }
        Tracer.trace(this, "Execute result: " + this.m_result);
        if (this.m_result.equals("-1")) {
            throw new UpdateServiceException(Strings.getUIString("IDS_E_PRODUCT_NOT_REGISTERED_SERVER"));
        }
        if (this.m_result.equals("-2")) {
            throw new UpdateServiceException(Strings.getUIString("IDS_E_VERSION_NOT_REGISTERED"));
        }
    }

    public void setHost(String string) {
        this.m_host = string;
        if (!this.m_host.endsWith("/")) {
            this.m_host = this.m_host + "/";
        }
    }

    public String getHost() {
        return this.m_host;
    }

    public void setProxy(String string, int n) {
        Integer n2 = new Integer(n);
        Tracer.trace(this, "setProxy(" + string + ", " + n2.toString() + ") called");
        this.m_proxy = string;
        this.m_proxyport = n;
    }

    private void ExecuteWithPost(UpdateServiceProperties updateServiceProperties, String string, String string2, String string3) throws UpdateServiceException {
        Closeable closeable;
        URL uRL = null;
        URLConnection uRLConnection = null;
        String string4 = string;
        if (string.indexOf("http://") == -1) {
            string4 = this.GetHost(updateServiceProperties);
            if (!string4.endsWith("/")) {
                string4 = string4 + "/";
            }
            string4 = string4 + string;
        }
        string2 = string2 + "&v=ISUA 12.00MP";
        String string5 = this.getUserID();
        if (string5 != null) {
            string2 = string2 + "&u=" + string5;
        }
        ProxyInfo proxyInfo = new ProxyInfo(updateServiceProperties);
        Tracer.trace(this, "ExecuteWithPost URL: " + string4);
        try {
            uRL = new URL(string4);
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "ISUA 12.00MP");
            uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setAllowUserInteraction(false);
            proxyInfo.InitProxy(uRLConnection);
            closeable = new DataOutputStream(uRLConnection.getOutputStream());
            ((DataOutputStream)closeable).writeBytes(string2);
            ((FilterOutputStream)closeable).close();
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
            throw new UpdateServiceException(iOException.getMessage());
        }
        if (uRLConnection == null) {
            return;
        }
        uRLConnection.setDefaultUseCaches(false);
        this.responseSignature = uRLConnection.getHeaderField("X-FNC-Sig");
        closeable = null;
        try {
            int n;
            closeable = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)closeable).read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.resultBytes = byteArrayOutputStream.toByteArray();
            this.m_result = new String(this.resultBytes, "UTF-8");
            ((InputStream)closeable).close();
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
            throw new UpdateServiceException("Not Connected or Update Service is not available");
        }
        Tracer.trace(this, "ExecuteWithPost result: " + this.m_result);
        if (this.m_result.equals("-1")) {
            throw new UpdateServiceException(Strings.getUIString("IDS_E_PRODUCT_NOT_REGISTERED_SERVER"));
        }
        if (this.m_result.equals("-2")) {
            throw new UpdateServiceException(Strings.getUIString("IDS_E_VERSION_NOT_REGISTERED"));
        }
    }
}

