/*
 * Decompiled with CFR 0.152.
 */
package isus.demographics;

import isus.demographics.DemographicCollector;
import java.text.NumberFormat;
import java.util.TimeZone;

public class TimeZoneCollector
implements DemographicCollector {
    protected static final String DEFAULT_PROFILE_TIMEZONE = "FNC:TIMEZONE";

    public String getName() {
        return DEFAULT_PROFILE_TIMEZONE;
    }

    public String getValue() {
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        int n2 = n / 3600000;
        int n3 = n - n2 * 3600000;
        n3 /= 60000;
        n3 = Math.abs(n3);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setMinimumIntegerDigits(2);
        String string = numberFormat.format(n3);
        String string2 = "";
        if (n2 >= 0) {
            string2 = "+";
        }
        return timeZone.getDisplayName(false, 0) + ";GMT" + string2 + n2 + ":" + string;
    }
}

