/*
 * Decompiled with CFR 0.152.
 */
package isus.demographics;

import isus.demographics.DemographicCollector;
import isus.shared.Tracer;
import isus.util.DownloadClassLoader;

public class DemographicCollectorFactory {
    private static String COLLECTOR_PACKAGE = "isus.demographics";
    private static String COLLECTOR_MANIFEST = "collector-class";

    public static DemographicCollector getDemographicCollector(String string) {
        try {
            if (string.indexOf(".class") == -1 && string.indexOf(".jar") == -1) {
                string = string + "Collector";
            }
            DownloadClassLoader downloadClassLoader = new DownloadClassLoader();
            downloadClassLoader.setLocalPackageName(COLLECTOR_PACKAGE);
            downloadClassLoader.setManifestClassAttribute(COLLECTOR_MANIFEST);
            Class clazz = downloadClassLoader.loadClass(string);
            Object t = clazz.newInstance();
            if (t instanceof DemographicCollector) {
                return (DemographicCollector)t;
            }
            Tracer.trace(DemographicCollectorFactory.class, "Class was not assignable from DemographicCollector");
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tracer.trace(DemographicCollectorFactory.class, "Class class not found");
            return null;
        }
        catch (InstantiationException instantiationException) {
            Tracer.trace(DemographicCollectorFactory.class, "Unable to instantiate class");
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Tracer.trace(DemographicCollectorFactory.class, "No permission to create class");
            return null;
        }
    }
}

