/*
 * Decompiled with CFR 0.152.
 */
package isus.demographics;

import isus.demographics.DemographicCollector;
import isus.shared.Tracer;
import isus.shared.WindowsHelper;
import isus.util.CommandResult;
import isus.util.CommandUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;

public class DefaultBrowserCollector
implements DemographicCollector {
    protected static final String DEFAULT_PROFILE_BROWSER = "FNC:BROWSER";
    private HashMap browserMapping = this.initMapping();

    private HashMap initMapping() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(".*iexplore.*", "Internet Explorer");
        hashMap.put(".*firefox.*", "Firefox");
        hashMap.put(".*opera.*", "Opera");
        hashMap.put(".*chrome.*", "Google Chrome");
        hashMap.put(".*safari.*", "Safari");
        hashMap.put(".*konquerer.*", "Konquerer");
        return hashMap;
    }

    public String getName() {
        return DEFAULT_PROFILE_BROWSER;
    }

    public String getValue() {
        String string = "";
        if (System.getProperty("os.name").indexOf("Windows") > -1) {
            string = this.getWindowsDefaultBrowser();
        } else if (System.getProperty("os.name").indexOf("Linux") > -1) {
            string = this.getLinuxDefaultBrowser();
        } else {
            return "Unimplemented";
        }
        return this.mapBrowserToCommonName(string);
    }

    private String getWindowsDefaultBrowser() {
        try {
            WindowsHelper windowsHelper = new WindowsHelper();
            String string = windowsHelper.getRegistryValueString(2, "Software\\Clients\\StartMenuInternet", "");
            if (string == null || string.equals("")) {
                string = windowsHelper.getRegistryValueString(3, "Software\\Clients\\StartMenuInternet", "");
                if (string == null || string.equals("")) {
                    return "Undetermined";
                }
                return string;
            }
            return string;
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
            return "Undetermined";
        }
    }

    private String getLinuxDefaultBrowser() {
        try {
            String[] stringArray;
            String string = "ls";
            String[] stringArray2 = new String[]{"-l", "/etc/alternatives/x-www-browser"};
            CommandResult commandResult = CommandUtils.executeCommand(string, stringArray2);
            if (commandResult.getExitCode() == 0 && (stringArray = commandResult.getStdout().split("\\s")).length > 0) {
                return stringArray[stringArray.length - 1];
            }
            stringArray = "gconftool-1";
            String string2 = "gconftool-2";
            String[] stringArray3 = new String[]{"--get", "/desktop/gnome/url-handlers/http/command"};
            try {
                commandResult = CommandUtils.executeCommand((String)stringArray, stringArray3);
                if (commandResult.getExitCode() == 0) {
                    return commandResult.getStdout();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            commandResult = CommandUtils.executeCommand(string2, stringArray3);
            if (commandResult.getExitCode() == 0) {
                return commandResult.getStdout();
            }
            return "Undetermined";
        }
        catch (Exception exception) {
            Tracer.traceException(exception);
            return "Undetermined";
        }
    }

    private String mapBrowserToCommonName(String string) {
        Iterator iterator = this.browserMapping.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!Pattern.matches(string2, string.trim().toLowerCase())) continue;
            return (String)this.browserMapping.get(string2);
        }
        return string;
    }
}

