/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.UpdateServiceException;
import isus.shared.EncryptedFileInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLWrapper {
    private Document m_xmldoc = null;
    private String m_roottag;
    private boolean m_bUseEncryption;

    public XMLWrapper(File file, String string, boolean bl) {
        this.m_roottag = string;
        this.m_bUseEncryption = bl;
        Object var4_4 = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UpdateServiceException(parserConfigurationException);
        }
        try {
            FileInputStream fileInputStream;
            if (bl) {
                fileInputStream = new FileInputStream(file.getAbsolutePath());
                byte[] byArray = new byte[3];
                fileInputStream.skip(file.length() - 3L);
                fileInputStream.read(byArray);
                if (new String(byArray).compareTo("v01") == 0) {
                    EncryptedFileInputStream encryptedFileInputStream = new EncryptedFileInputStream(file);
                    this.m_xmldoc = documentBuilder.parse(encryptedFileInputStream);
                    encryptedFileInputStream.close();
                    fileInputStream.close();
                    return;
                }
                fileInputStream.close();
            }
            fileInputStream = new FileInputStream(file.getAbsolutePath());
            this.m_xmldoc = documentBuilder.parse(fileInputStream);
            fileInputStream.close();
        }
        catch (SAXException sAXException) {
            throw new UpdateServiceException(sAXException);
        }
        catch (IOException iOException) {
            throw new UpdateServiceException(iOException);
        }
    }

    public XMLWrapper(String string, String string2) {
        this.m_roottag = string2;
        Object var3_3 = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UpdateServiceException(parserConfigurationException);
        }
        try {
            if (string.length() != 0 && !string.startsWith("<HTML>")) {
                File file = File.createTempFile("ISUSMP_", "_TEMP");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(string.trim());
                outputStreamWriter.flush();
                outputStreamWriter.close();
                this.m_xmldoc = documentBuilder.parse(file.getAbsolutePath());
                file.deleteOnExit();
            }
        }
        catch (SAXException sAXException) {
            throw new UpdateServiceException(sAXException);
        }
        catch (IOException iOException) {
            throw new UpdateServiceException(iOException);
        }
    }

    long getCount() {
        int n = 0;
        Node node = this.getRootRecordset();
        if (node == null) {
            return 0L;
        }
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            if (node.getChildNodes().item(i).getNodeType() != 1) continue;
            ++n;
        }
        return n;
    }

    public Node getRootRecordset() {
        if (this.m_xmldoc == null) {
            return null;
        }
        return this.m_xmldoc.getDocumentElement().getElementsByTagName(this.m_roottag).item(0);
    }

    public Document getDocument() {
        return this.m_xmldoc;
    }

    public void Save(File file) {
        try {
            StreamResult streamResult;
            FileOutputStream fileOutputStream = null;
            OutputStream outputStream = null;
            boolean bl = false;
            if (this.m_bUseEncryption) {
                // empty if block
            }
            if (outputStream == null) {
                fileOutputStream = new FileOutputStream(file);
                streamResult = new StreamResult(fileOutputStream);
            } else {
                streamResult = new StreamResult(outputStream);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(this.getDocument());
            transformer.transform(dOMSource, streamResult);
            if (outputStream != null) {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
                outputStream = null;
            } else {
                fileOutputStream.flush();
                fileOutputStream.close();
                fileOutputStream = null;
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new UpdateServiceException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new UpdateServiceException(transformerException);
        }
        catch (IOException iOException) {
            throw new UpdateServiceException(iOException);
        }
    }

    public Element getRootElement() {
        return this.getDocument().getDocumentElement();
    }

    public Element getNthElementByTagName(Element element, int n, String string) {
        return (Element)element.getElementsByTagName(string).item(n);
    }
}

