/*
 * Decompiled with CFR 0.152.
 */
package isus;

import ice.storm.ScripterCallback;
import ice.storm.Viewport;
import isus.shared.Tracer;
import isus.util.MessageBox;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class WebUIScripterCallback
implements ScripterCallback {
    private static final int ACTION_CANCEL = 1;
    private static final int ACTION_OK = 2;

    WebUIScripterCallback() {
    }

    public boolean allowScriptClose(Viewport viewport, boolean bl) {
        return true;
    }

    public long getMaxScriptRunningTime() {
        return 5000L;
    }

    public boolean interruptLongRunningScript(Viewport viewport, long l) {
        return true;
    }

    public void reportScriptError(Viewport viewport, boolean bl, String string, String string2, int n, String string3, int n2) {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("reportScriptError");
        stringBuffer.append("\r\n\tLine:" + new Integer(n).toString());
        if (string2 != null) {
            stringBuffer.append("\r\n\tscript:" + string2);
        }
        if (string != null) {
            stringBuffer.append("\r\n\tscripterror:" + string);
        }
        Tracer.trace(this, stringBuffer.toString());
        stringBuffer = null;
    }

    public void scriptAlert(Viewport viewport, String string) {
        this.showAlert(viewport, string);
    }

    public boolean scriptConfirm(Viewport viewport, String string) {
        return this.showConfirmation(viewport, string);
    }

    public void scriptPrint(Viewport viewport) {
        System.out.println("window.print is called from script");
    }

    public String scriptPrompt(Viewport viewport, String string, String string2) {
        return this.showPrompt(viewport, string, string2);
    }

    private Frame findFrame(Viewport viewport) {
        Container container = viewport.getTopLevelContainer();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return null;
    }

    private void packAndShow(Dialog dialog, Frame frame) {
        dialog.pack();
        Dimension dimension = dialog.getSize();
        Dimension dimension2 = frame.getSize();
        Point point = frame.getLocation();
        int n = point.x + (dimension2.width - dimension.width) / 2;
        int n2 = point.y + (dimension2.height - dimension.height) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        dialog.setLocation(n, n2);
        dialog.show();
        dialog.dispose();
    }

    private void showAlert(Viewport viewport, String string) {
        Frame frame = this.findFrame(viewport);
        if (frame != null) {
            MessageBox messageBox = new MessageBox(frame, 1);
            messageBox.setText(string);
            messageBox.setTitle("Alert");
            messageBox.show();
        }
    }

    private boolean showConfirmation(Viewport viewport, String string) {
        boolean[] blArray = new boolean[]{false};
        Frame frame = this.findFrame(viewport);
        boolean bl = false;
        if (frame != null) {
            MessageBox messageBox = new MessageBox(frame, 2);
            messageBox.setText(string);
            messageBox.setTitle("Confirmation");
            messageBox.setButtonText("OK", 1);
            messageBox.setButtonText("Cancel", 2);
            messageBox.show();
            if (messageBox.getResponse() == 1) {
                bl = true;
            }
        }
        return bl;
    }

    private String showPrompt(Viewport viewport, String string, String string2) {
        Frame frame = this.findFrame(viewport);
        if (frame != null) {
            boolean[] blArray = new boolean[]{false};
            Dialog dialog = new Dialog(frame, "Script prompt", true);
            Panel panel = new Panel();
            TextField textField = new TextField(string2, 30);
            textField.addActionListener(new Action(dialog, 2, blArray));
            panel.setLayout(new GridLayout(2, 1));
            panel.add(new Label(string));
            panel.add(textField);
            Panel panel2 = new Panel();
            Button button = new Button("Ok");
            button.addActionListener(new Action(dialog, 2, blArray));
            Button button2 = new Button("Cancel");
            button2.addActionListener(new Action(dialog, 1, blArray));
            panel2.add(button);
            panel2.add(button2);
            dialog.add((Component)panel, "North");
            dialog.add((Component)panel, "South");
            this.packAndShow(dialog, frame);
            return blArray[0] ? textField.getText() : string2;
        }
        return string2;
    }

    private class Action
    implements ActionListener {
        private Dialog dialog;
        private int actionId;
        private boolean[] result;

        private Action(Dialog dialog, int n, boolean[] blArray) {
            this.dialog = dialog;
            this.actionId = n;
            this.result = blArray;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.actionId) {
                case 2: {
                    this.result[0] = true;
                }
                case 1: {
                    this.dialog.setVisible(false);
                }
            }
        }
    }
}

