/*
 * Decompiled with CFR 0.152.
 */
package isus;

import ice.net.HttpMessage;
import ice.net.HttpRequest;
import ice.net.HttpResponse;
import ice.net.HttpURLConnectionEvent;
import ice.net.HttpURLConnectionListener;
import ice.util.net.HeaderMap;
import isus.Strings;
import isus.UpdateServiceException;
import isus.rpc.RPCObject;
import isus.shared.Tracer;
import isus.shared.UpdateServiceProperties;
import isus.util.validation.MessageValidator;

class WebConnectionListener
implements HttpURLConnectionListener {
    private static final String VALIDATION_FAILED_ERROR = "IDS_VALIDATION_FAILED";
    private UpdateServiceProperties properties;
    private RPCObject rpc;

    public WebConnectionListener(UpdateServiceProperties updateServiceProperties, RPCObject rPCObject) {
        this.properties = updateServiceProperties;
        this.rpc = rPCObject;
    }

    public void onHttpURLConnectionEvent(HttpURLConnectionEvent httpURLConnectionEvent) {
        if (httpURLConnectionEvent.getEventType() == 3) {
            HttpRequest httpRequest = httpURLConnectionEvent.getRequest();
            String string = null;
            for (int i = 0; i < httpRequest.getHeaderCount(); ++i) {
                HeaderMap.Header header = httpRequest.getHeader(i);
                if (!header.getFieldName().equals("Host")) continue;
                string = header.getFieldValue();
                break;
            }
            if (this.rpc.GetHost(this.properties).indexOf(string) == -1 || httpRequest.getRequestUri().toLowerCase().indexOf(".asp") == -1 || httpRequest.getRequestUri().indexOf(Strings.getString("RPCGetCertificate.GetCertificate.asp")) > -1 || httpRequest.getRequestUri().toLowerCase().indexOf("ping.asp") > -1) {
                return;
            }
            HttpResponse httpResponse = httpURLConnectionEvent.getResponse();
            String string2 = null;
            for (int i = 0; i < httpResponse.getHeaderCount(); ++i) {
                HeaderMap.Header header = httpResponse.getHeader(i);
                if (!header.getFieldName().equals("X-FNC-Sig")) continue;
                string2 = header.getFieldValue();
                break;
            }
            if (string2 == null) {
                if (this.properties.getProperty("SecureServer").equals("true")) {
                    this.rewriteContentOnError(httpResponse, Strings.getUIString("IDS_E_RESULT_UNSIGNED"));
                    return;
                }
                return;
            }
            if (this.properties.getProperty("SecureServer").equals("false")) {
                return;
            }
            try {
                Class.forName("org.bouncycastle.cms.CMSSignedData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tracer.trace(this, "Could not find security libraries.  Communication will continue, but will not be verified as secure.");
                return;
            }
            HttpMessage.EntityBody entityBody = httpResponse.getEntityBody();
            try {
                if (!MessageValidator.validateContent(entityBody.getBytes(), string2, this.properties)) {
                    this.rewriteContentOnError(httpResponse, Strings.getUIString("IDS_E_RESULT_UNTRUSTED"));
                }
            }
            catch (UpdateServiceException updateServiceException) {
                this.rewriteContentOnError(httpResponse, updateServiceException.getMessage());
            }
        }
    }

    private void rewriteContentOnError(HttpResponse httpResponse, String string) {
        String string2 = "<html><head></head><body>" + string + "</body></html>";
        HttpMessage.EntityBody entityBody = new HttpMessage.EntityBody(string2.getBytes());
        httpResponse.setEntityBody(entityBody);
    }
}

