/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.shared.UpdateServiceProperties;
import isus.util.MessageBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class USPreferencesDialog
extends JDialog {
    private JPanel m_mainpanel = new JPanel();
    private JPanel m_buttonpanel = new JPanel();
    private JPanel m_proxypanel = new JPanel();
    private JLabel m_srvlabel = new JLabel();
    private JLabel m_portlabel = new JLabel();
    private JCheckBox m_proxyAuth = new JCheckBox();
    private JLabel m_usrlabel = new JLabel();
    private JLabel m_passwdlabel = new JLabel();
    private JTextField m_proxyServer = new JTextField();
    private JTextField m_proxyPort = new JTextField();
    private JTextField m_proxyUserName = new JTextField();
    private JPasswordField m_proxyPassword = new JPasswordField();
    private JCheckBox m_proxyCheck = new JCheckBox();
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private JPanel m_generalpanel = new JPanel();
    private JLabel m_schlabel = new JLabel();
    private JTextField m_scheduledInterval = new JTextField();
    private JCheckBox m_servicelevel = new JCheckBox();
    private boolean m_bCancel = false;

    public USPreferencesDialog() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void AskUserPreferences(LookAndFeel lookAndFeel, UpdateServiceProperties updateServiceProperties) {
        LookAndFeel lookAndFeel2 = UIManager.getLookAndFeel();
        try {
            if (lookAndFeel != null) {
                UIManager.setLookAndFeel(lookAndFeel);
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        if (updateServiceProperties != null) {
            this.m_scheduledInterval.setText(updateServiceProperties.getProperty("ScheduleInterval"));
            if (updateServiceProperties.getProperty("UseProxy").indexOf("1") == 0) {
                this.m_proxyCheck.doClick();
            }
            if (updateServiceProperties.getProperty("ProxyAuthentication").indexOf("1") == 0) {
                this.m_proxyAuth.doClick();
            }
            this.m_proxyServer.setText(updateServiceProperties.getProperty("ProxyServer"));
            this.m_proxyPort.setText(updateServiceProperties.getProperty("ProxyPort"));
            this.m_proxyUserName.setText(updateServiceProperties.getProperty("ProxyUserName"));
            this.m_proxyPassword.setText(updateServiceProperties.getProperty("ProxyPassword"));
            if (updateServiceProperties.getProperty("UseProxy") == "1") {
                this.enableProxySettings(true);
            }
        }
        this.show();
        try {
            UIManager.setLookAndFeel(lookAndFeel2);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        if (!this.m_bCancel && updateServiceProperties != null) {
            updateServiceProperties.setProperty("ScheduleInterval", this.m_scheduledInterval.getText());
            updateServiceProperties.setProperty("UseProxy", this.m_proxyCheck.isSelected() ? "1" : "0");
            if (this.m_proxyCheck.isSelected()) {
                updateServiceProperties.setProperty("ProxyServer", this.m_proxyServer.getText().trim());
                updateServiceProperties.setProperty("ProxyPort", this.m_proxyPort.getText().trim());
                updateServiceProperties.setProperty("ProxyAuthentication", this.m_proxyAuth.isSelected() ? "1" : "0");
                if (this.m_proxyAuth.isSelected()) {
                    updateServiceProperties.setProperty("ProxyUserName", this.m_proxyUserName.getText().trim());
                    updateServiceProperties.setProperty("ProxyPassword", this.m_proxyPassword.getText().trim());
                }
            }
        }
    }

    private void jbInit() throws Exception {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setBounds(dimension.width / 2 - 223, dimension.height / 2 - 237, 447, 478);
        this.setModal(true);
        this.setTitle("InstallShield Update Service Configuration");
        this.m_mainpanel.setLayout(this.gridBagLayout2);
        this.m_buttonpanel.setLayout(this.gridBagLayout4);
        this.m_mainpanel.setToolTipText("Proxy Server Configuration");
        this.m_mainpanel.setBorder(BorderFactory.createBevelBorder(0));
        this.m_proxypanel.setLayout(this.gridBagLayout1);
        this.m_srvlabel.setText("Server");
        this.m_srvlabel.setFont(new Font("Verdana", 1, 11));
        this.m_portlabel.setText("Port");
        this.m_portlabel.setFont(new Font("Verdana", 1, 11));
        this.m_proxyAuth.setText("Proxy Server Authentication");
        this.m_proxyAuth.setFont(new Font("Verdana", 1, 11));
        this.m_usrlabel.setText("Username");
        this.m_usrlabel.setFont(new Font("Verdana", 1, 11));
        this.m_passwdlabel.setText("Password");
        this.m_passwdlabel.setFont(new Font("Verdana", 1, 11));
        this.m_proxyPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                USPreferencesDialog.this.jTextField2_actionPerformed(actionEvent);
            }
        });
        this.m_proxyCheck.setText("I am using HTTP Proxy to connect to the Internet");
        this.m_proxyCheck.setFont(new Font("Verdana", 1, 11));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFont(new Font("Verdana", 1, 11));
        this.okButton.setText("OK");
        this.okButton.setFont(new Font("Verdana", 1, 11));
        this.m_servicelevel.setText("Please disable Update Service.");
        this.m_servicelevel.setFont(new Font("Verdana", 1, 11));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                USPreferencesDialog.this.jButton2_actionPerformed(actionEvent);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                USPreferencesDialog.this.jButton3_actionPerformed(actionEvent);
            }
        });
        this.m_proxyCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                USPreferencesDialog.this.ProxyCheck_actionPerformed(actionEvent);
            }
        });
        this.m_proxyAuth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                USPreferencesDialog.this.ProxyAuth_actionPerformed(actionEvent);
            }
        });
        this.m_generalpanel.setLayout(this.gridBagLayout2);
        this.m_schlabel.setText(" Scheduled Interval(in days)");
        this.m_schlabel.setFont(new Font("Verdana", 1, 11));
        this.m_scheduledInterval.setText("30");
        this.m_proxypanel.add((Component)this.m_proxyCheck, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 0, 0), 26, 2));
        this.m_proxypanel.add((Component)this.m_srvlabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 14, 15));
        this.m_proxypanel.add((Component)this.m_proxyServer, new GridBagConstraints(4, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 15), 237, 6));
        this.m_proxypanel.add((Component)this.m_portlabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 6, 5));
        this.m_proxypanel.add((Component)this.m_proxyPort, new GridBagConstraints(4, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 15), 237, 6));
        this.m_proxypanel.add((Component)this.m_proxyAuth, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 0, new Insets(15, 15, 0, 0), 24, -8));
        this.m_proxypanel.add((Component)this.m_usrlabel, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 17, 5));
        this.m_proxypanel.add((Component)this.m_proxyUserName, new GridBagConstraints(4, 5, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 0, 15), 237, 6));
        this.m_proxypanel.add((Component)this.m_passwdlabel, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 16, 5));
        this.m_proxypanel.add((Component)this.m_proxyPassword, new GridBagConstraints(4, 7, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 0, 15), 237, 6));
        this.m_generalpanel.add((Component)this.m_schlabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 1, 0));
        this.m_generalpanel.add((Component)this.m_scheduledInterval, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 0, 5), 200, 6));
        this.m_buttonpanel.add((Component)this.okButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(195, 120, 12, 0), 44, 5));
        this.m_buttonpanel.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(195, 10, 12, 0), 18, 5));
        this.m_mainpanel.add((Component)this.m_proxypanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_mainpanel.add((Component)this.m_generalpanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_mainpanel.add((Component)this.m_buttonpanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.enableProxySettings(false);
        this.getContentPane().add((Component)this.m_mainpanel, "Center");
    }

    private void enableProxyAuthSettings() {
        boolean bl = this.m_proxyAuth.isEnabled() && this.m_proxyAuth.isSelected();
        this.m_usrlabel.setEnabled(bl);
        this.m_passwdlabel.setEnabled(bl);
        this.m_proxyPassword.setEnabled(bl);
        this.m_proxyUserName.setEnabled(bl);
    }

    private void enableProxySettings(boolean bl) {
        this.m_srvlabel.setEnabled(bl);
        this.m_portlabel.setEnabled(bl);
        this.m_proxyServer.setEnabled(bl);
        this.m_proxyAuth.setEnabled(bl);
        this.m_proxyPort.setEnabled(bl);
        this.enableProxyAuthSettings();
    }

    private void jTextField2_actionPerformed(ActionEvent actionEvent) {
    }

    private void ProxyCheck_actionPerformed(ActionEvent actionEvent) {
        this.enableProxySettings(this.m_proxyCheck.isSelected());
    }

    private void ProxyAuth_actionPerformed(ActionEvent actionEvent) {
        this.enableProxyAuthSettings();
    }

    private void jButton3_actionPerformed(ActionEvent actionEvent) {
        if (this.CheckValues()) {
            this.dispose();
        }
    }

    private void jButton2_actionPerformed(ActionEvent actionEvent) {
        this.m_bCancel = true;
        this.dispose();
    }

    private void jCheckBox2_actionPerformed(ActionEvent actionEvent) {
    }

    private void jButton1_actionPerformed(ActionEvent actionEvent) {
        if (this.CheckValues()) {
            this.dispose();
        }
    }

    private boolean CheckValues() {
        String string = "";
        try {
            if (new Integer(this.m_scheduledInterval.getText()) < 0) {
                string = string + "Invalid Scheduled Interval is specified.\n";
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = string + "Invalid Scheduled Interval is specified.\n";
        }
        if (!this.m_proxyCheck.isSelected()) {
            return true;
        }
        if (this.m_proxyServer.getText().length() == 0) {
            string = string + "Please specify Proxy Server.\n";
        }
        try {
            if (new Integer(this.m_proxyPort.getText()) <= 0) {
                string = string + "Invalid Proxy Port.\n";
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = string + "Invalid Proxy Port.\n";
        }
        if (this.m_proxyAuth.isSelected()) {
            if (this.m_proxyUserName.getText().length() == 0) {
                string = string + "Please specify UserName.";
            }
            if (this.m_proxyUserName.getText().length() == 0) {
                string = string + "Please specify Password.";
            }
        }
        if (string.length() != 0) {
            MessageBox messageBox = new MessageBox("InstallShield Update Service", 1);
            messageBox.setText(string);
            messageBox.show();
        }
        return string.length() == 0;
    }
}

