/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.AgentEx;
import isus.INotification;
import isus.INotificationCollection;
import isus.IUSAgent;
import isus.NotificationProperty;
import isus.UpdateServiceException;
import isus.shared.Tracer;
import isus.util.MessageBox;
import java.util.Stack;

public class USAgent
implements IUSAgent {
    private AgentEx m_agent = new AgentEx();
    private static String m_javaVersion;
    static final String JAVA_1_0 = "1.0";
    static final String JAVA_1_1 = "1.1";
    static final String JAVA_1_2 = "1.2";
    static final String JAVA_1_3 = "1.3";
    static final String JAVA_1_4 = "1.4";
    static final String SHUT_DOWN = "SHUT_DOWN";

    static String convert2GUID(String string) {
        String string2 = string.toUpperCase();
        if (string.startsWith("{")) {
            return string2;
        }
        if (string.length() != 32) {
            return string2;
        }
        string2 = "{" + string2.substring(0, 8) + "-" + string2.substring(8, 12) + "-" + string2.substring(12, 16) + "-" + string2.substring(16, 20) + "-" + string2.substring(20) + "}";
        return string2;
    }

    static String getJavaVersion() {
        return m_javaVersion;
    }

    boolean CheckVersion(boolean bl) {
        if (m_javaVersion.equals(JAVA_1_2) || m_javaVersion.equals(JAVA_1_3) || m_javaVersion.equals(JAVA_1_4)) {
            return true;
        }
        if (bl) {
            MessageBox messageBox = new MessageBox("FLEXnet Connect", 1);
            messageBox.setText("Currently this feature is available only when the product is run using \nJava 1.4 and above.");
            messageBox.show();
        }
        return false;
    }

    public INotificationCollection getNotificationCollection(String string) throws UpdateServiceException {
        return this.m_agent.GetNotificationCollection(string);
    }

    public boolean showNotifications(String string, int n) throws UpdateServiceException {
        return this.m_agent.AppUpdate(string, n);
    }

    public boolean isConnectedToNotificationServer(String string) {
        boolean bl = this.m_agent.IsConnected(string);
        String string2 = bl ? "true" : "false";
        Tracer.trace(this, "IsConnected(" + string + ") returned " + string2);
        return bl;
    }

    public void setProductBaseDir(String string) {
        Tracer.trace(this, "setProductBaseDir(" + string + ") called");
        this.m_agent.setProductBaseDir(string);
    }

    public void register(String string, String string2, String string3, String string4, String string5) {
        Tracer.trace(this, "Register(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ") called");
        if (this.CheckVersion(false)) {
            if (string5.compareTo("Default") == 0) {
                this.m_agent.Register(string, string2, string3);
            } else {
                this.m_agent.RegisterEx(string, string2, string3, string5);
            }
            if (string4.compareTo("") == 0) {
                string4 = "http://updates.installshield.com";
            }
            this.m_agent.SetHost(string, string4);
        }
    }

    public void setNotificationServerURL(String string, String string2) {
        Tracer.trace(this, "SetHost(" + string + ", " + string2 + ") called");
        this.m_agent.SetHost(string, string2);
    }

    public boolean hasIntervalElapsed(String string) {
        boolean bl = this.m_agent.HasIntervalElapsed(string);
        String string2 = bl ? "true" : "false";
        Tracer.trace(this, "HasIntervalElapsed(" + string + ") returned " + string2);
        return bl;
    }

    private static void syntax() {
        System.out.println("Syntax Error - Acceptable syntax below:");
        System.out.println("agent -p <PRODUCTUID> -[appmenu|appstart]");
        System.out.println("agent -r<PRODUCTUID>,<VERSION>");
        System.out.println("agent -p <PRODUCTUID> -cfg <CONFIGFILE>");
    }

    public String getDatabaseDir() {
        return this.m_agent.getDatabaseDir();
    }

    public static void main(String[] stringArray) {
        Tracer.trace(null, "Agent run from command line.  Args: " + stringArray.toString());
        String string = "";
        String string2 = "-autoupdate";
        String string3 = "";
        String string4 = "";
        String string5 = "1033";
        String string6 = "";
        Stack<String> stack = new Stack<String>();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stack.push(stringArray[i]);
        }
        while (!stack.isEmpty()) {
            String string7 = (String)stack.pop();
            if (string7.equals("-p")) {
                string7 = (String)stack.peek();
                if (string7.startsWith("-")) {
                    USAgent.syntax();
                }
                string = USAgent.convert2GUID((String)stack.pop());
                continue;
            }
            if (string7.equals("-appmenu")) {
                string2 = string7;
                continue;
            }
            if (string7.equals("-cfg")) {
                string2 = string7;
                string3 = (String)stack.pop();
                continue;
            }
            if (string7.equals("-i")) {
                string7 = (String)stack.peek();
                if (string7.startsWith("-")) {
                    USAgent.syntax();
                }
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append((String)stack.pop());
                string7 = !stack.empty() ? (String)stack.peek() : "-done";
                while (!string7.startsWith("-")) {
                    stringBuffer.append(" " + (String)stack.pop());
                    if (!stack.empty()) {
                        string7 = (String)stack.peek();
                        continue;
                    }
                    string7 = "-done";
                }
                string6 = stringBuffer.toString();
                stringBuffer = null;
                continue;
            }
            if (!string7.startsWith("-r")) continue;
            int n = string7.indexOf(",");
            if (n <= 0) {
                USAgent.syntax();
            }
            string2 = "-r";
            string = string7.substring(2, n);
            string4 = string7.substring(n + 1);
            if ((n = string4.indexOf(",")) <= 0) continue;
            string5 = string4.substring(n + 1);
            string4 = string4.substring(0, n - 1);
        }
        if (!(string.length() != 0 && (string2.equalsIgnoreCase("-appmenu") || string2.equalsIgnoreCase("-appstart") || string2.equalsIgnoreCase("-ns") || string2.equalsIgnoreCase("-r") || string2.equalsIgnoreCase("-cfg") || string2.equalsIgnoreCase("-autoupdate")))) {
            USAgent.syntax();
        }
        USAgent uSAgent = new USAgent();
        if (string2.equalsIgnoreCase("-r")) {
            uSAgent.register(string, string4, string5, "", "Default");
        } else if (string2.equalsIgnoreCase("-cfg")) {
            AgentEx agentEx = new AgentEx();
            agentEx.setConfigProperties(string, string3);
        } else if (string2.equalsIgnoreCase("-appmenu")) {
            System.getProperties().put(SHUT_DOWN, "true");
        } else {
            INotification iNotification = null;
            if (uSAgent.isConnectedToNotificationServer(string)) {
                INotificationCollection iNotificationCollection = null;
                try {
                    iNotificationCollection = uSAgent.getNotificationCollection(string);
                }
                catch (UpdateServiceException updateServiceException) {
                    MessageBox messageBox = new MessageBox("FLEXnet Connect", 1);
                    messageBox.setText("No Messages - reason : " + updateServiceException.getMessage());
                    messageBox.show();
                    System.exit(1);
                }
                if (iNotificationCollection != null) {
                    for (int i = 0; i < iNotificationCollection.getCount(); ++i) {
                        iNotification = iNotificationCollection.item(i);
                        if (!iNotification.isUpdate()) continue;
                        if (iNotification.getProperty(NotificationProperty.NP_DOWNLOAD_URL).startsWith("file://")) {
                            iNotification.execute();
                        } else {
                            iNotification.downloadAndExecute(false);
                        }
                        break;
                    }
                } else {
                    System.out.println("Agent returned null messages");
                }
            }
        }
    }

    private static void logException(Exception exception) {
    }

    public void setValue(String string, String string2, String string3) {
        this.m_agent.setProperty(string, string2, string3);
    }

    public String getValue(String string, String string2) {
        return this.m_agent.getProperty(string, string2);
    }

    public int setUserID(String string) {
        return this.m_agent.setUserID(string);
    }

    public String getUserID() {
        return this.m_agent.getUserID();
    }

    public void unRegister(String string, String string2) {
        this.m_agent.UnRegister(string, string2);
    }

    public void setCentralHome(String string) {
        this.m_agent.setCentralHome(string);
    }

    public String getVersion() {
        return this.m_agent.getVersion();
    }

    public String getNotificationServerURL(String string) {
        return this.m_agent.GetHost(string);
    }

    public void setIntervalElapse(String string, long l) {
        this.m_agent.setIntervalElapse(string, l);
    }

    public long getIntervalElapse(String string) {
        return this.m_agent.getIntervalElapse(string);
    }

    public void setActiveInstance(String string, String string2) {
        this.m_agent.setActiveInstance(string, string2);
    }

    static {
        try {
            m_javaVersion = JAVA_1_0;
            Class.forName("java.lang.Void");
            m_javaVersion = JAVA_1_1;
            Class.forName("java.lang.ThreadLocal");
            m_javaVersion = JAVA_1_2;
            Class.forName("java.lang.StrictMath");
            m_javaVersion = JAVA_1_3;
            Class.forName("java.lang.CharSequence");
            m_javaVersion = JAVA_1_4;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

