/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.UpdateServiceException;
import isus.XMLWrapper;
import isus.rpc.RPCSendTransactionLog;
import isus.shared.EncryptedFileInputStream;
import isus.shared.Tracer;
import isus.shared.UpdateServiceProperties;
import isus.shared.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Calendar;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionLogManager {
    private String m_instance = "Default";
    private File file;
    private XMLWrapper xml;
    private String m_productCode;
    private String m_pfFile;

    public void setActiveInstance(String string) {
        this.m_instance = string;
    }

    public TransactionLogManager(String string) {
        this.m_productCode = string;
        this.m_pfFile = Util.getHome() + System.getProperty("file.separator") + Util.convert2UID(this.m_productCode) + ".trl";
        this.file = new File(this.m_pfFile);
        this.xml = this.file.exists() ? new XMLWrapper(this.file, "rs:data", true) : null;
    }

    public TransactionLogManager(String string, String string2) {
        this.m_productCode = string;
        this.m_pfFile = string2 + System.getProperty("file.separator") + Util.convert2UID(this.m_productCode) + ".trl";
        this.file = new File(this.m_pfFile);
        this.xml = this.file.exists() ? new XMLWrapper(this.file, "rs:data", true) : null;
    }

    public void log(String string, String string2, Integer n, String string3) {
        Tracer.trace(this, "log( " + string + "," + string2 + "," + n.toString() + "," + string3 + ") called");
        if (this.xml == null) {
            this.createFile();
        }
        long l = Calendar.getInstance().getTime().getTime();
        Timestamp timestamp = new Timestamp(l);
        Element element = this.xml.getDocument().createElement("z:row");
        element.setAttribute("timestamp", timestamp.toString());
        element.setAttribute("group", string);
        element.setAttribute("action", string2);
        element.setAttribute("stage", n.toString());
        element.setAttribute("value", string3 == null ? "" : string3);
        this.xml.getRootElement().getElementsByTagName("rs:data").item(0).appendChild(element);
        this.xml.Save(this.file);
    }

    public void upload() throws UpdateServiceException {
        Tracer.trace(this, "upload called");
        if (this.xml == null) {
            return;
        }
        UpdateServiceProperties updateServiceProperties = new UpdateServiceProperties(Util.getHome(), this.m_productCode);
        RPCSendTransactionLog rPCSendTransactionLog = new RPCSendTransactionLog(updateServiceProperties, this);
        try {
            rPCSendTransactionLog.Run(true);
        }
        catch (IOException iOException) {
            throw new UpdateServiceException(iOException);
        }
    }

    public boolean isUploadRequired() {
        Node node;
        if (this.xml == null) {
            return false;
        }
        NodeList nodeList = this.xml.getRootElement().getElementsByTagName("z:row");
        Element element = (Element)nodeList.item(nodeList.getLength() - 1);
        return element == null || (node = element.getAttributes().getNamedItem("uploadmarker")) == null;
    }

    public String buildRequestData() {
        if (this.xml == null) {
            return "";
        }
        Tracer.trace(this, "buildRequestData called");
        String string = "p=";
        string = string + this.m_productCode;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file.getAbsolutePath());
            byte[] byArray = new byte[3];
            fileInputStream.skip(this.file.length() - 3L);
            fileInputStream.read(byArray);
            if (new String(byArray).compareTo("v01") == 0) {
                fileInputStream.close();
                fileInputStream = new EncryptedFileInputStream(this.file);
            } else {
                fileInputStream.close();
                fileInputStream = new FileInputStream(this.file.getAbsolutePath());
            }
            byte[] byArray2 = new byte[fileInputStream.available()];
            int n = fileInputStream.read(byArray2);
            fileInputStream.close();
            if (n != -1) {
                String string2 = new String(byArray2);
                Tracer.trace(this, "buildRequestData - trl contents: " + string2);
                String string3 = "";
                int n2 = string2.lastIndexOf("uploadmarker=");
                if (n2 != -1) {
                    int n3 = string2.indexOf("<rs:data>");
                    int n4 = string2.indexOf("/>", n2);
                    string3 = string2.substring(0, n3 + 10);
                    string3 = string3 + string2.substring(n4 + 2);
                } else {
                    string3 = string2;
                }
                string = string + "&instrument=";
                string = string + URLEncoder.encode(string3);
                UpdateServiceProperties updateServiceProperties = new UpdateServiceProperties(Util.getHome(), this.m_productCode);
                string = string + "&r=";
                string = string + URLEncoder.encode(updateServiceProperties.getProperty("Version", this.m_instance));
                string = string + "&l=";
                string = string + URLEncoder.encode(updateServiceProperties.getProperty("Language", this.m_instance));
            }
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
        }
        Tracer.trace(this, "Transaction request data: " + string);
        return string;
    }

    public void putUploadMarker() {
        Object object;
        if (this.xml == null) {
            return;
        }
        NodeList nodeList = this.xml.getRootElement().getElementsByTagName("z:row");
        int n = nodeList.getLength();
        for (int i = n - 1; i >= 0; --i) {
            Element element = (Element)nodeList.item(i);
            if (element == null || (object = element.getAttributes().getNamedItem("uploadmarker")) == null) continue;
            element.getParentNode().removeChild(element);
            this.xml.getDocument().normalize();
            break;
        }
        long l = Calendar.getInstance().getTime().getTime();
        object = new Timestamp(l);
        Element element = this.xml.getDocument().createElement("z:row");
        element.setAttribute("timestamp", ((Timestamp)object).toString());
        element.setAttribute("uploadmarker", "1");
        this.xml.getRootElement().getElementsByTagName("rs:data").item(0).appendChild(element);
        this.xml.Save(this.file);
    }

    public void deleteFile() {
        Tracer.trace(this, "deleting transaction log: " + this.file.toString());
        this.xml = null;
        System.gc();
        this.file.delete();
    }

    private void createFile() {
        try {
            Tracer.trace(this, "Creating transaction log: " + this.file.toString());
            FileWriter fileWriter = new FileWriter(this.file);
            fileWriter.write("<xml xmlns:rs=\"urn:schemas-microsoft-com:rowset\" xmlns:z=\"urn:schemas-microsoft-com:rowset#RowsetSchema\">\r\n\t<rs:data>\r\n\t</rs:data>\r\n</xml>");
            fileWriter.close();
            String string = System.getProperty("os.name").toLowerCase();
            if (!string.startsWith("window") && !string.startsWith("mac")) {
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("/bin/chmod 666 " + this.m_pfFile);
            }
            this.xml = new XMLWrapper(this.file, "rs:data", true);
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
        }
    }
}

