/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.MyAuthenticator;
import isus.shared.Tracer;
import isus.shared.UpdateServiceProperties;
import isus.shared.WindowsHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.Authenticator;
import java.net.URLConnection;
import java.util.HashMap;
import sun.misc.BASE64Encoder;

public class ProxyInfo {
    String m_proxyServer = null;
    String m_proxyPort = "80";
    String m_proxyUserName = null;
    String m_proxyPassword = null;
    UpdateServiceProperties m_propset;
    boolean m_useProxy = false;

    public ProxyInfo(UpdateServiceProperties updateServiceProperties) {
        this.m_propset = updateServiceProperties;
    }

    public void InitProxy(URLConnection uRLConnection) {
        UpdateServiceProperties updateServiceProperties = this.m_propset;
        if (updateServiceProperties.getProperty("UseProxy").trim().length() == 0) {
            this.discoverProxy();
        } else if (updateServiceProperties.getProperty("UseProxy").trim().indexOf("1") == 0) {
            this.m_useProxy = true;
            this.m_proxyServer = updateServiceProperties.getProperty("ProxyServer").trim().toLowerCase();
            if (this.m_proxyServer.startsWith("http://")) {
                this.m_proxyServer = this.m_proxyServer.substring(7);
            }
            if (updateServiceProperties.getProperty("ProxyPort").trim().length() != 0) {
                this.m_proxyPort = updateServiceProperties.getProperty("ProxyPort").trim();
            }
        } else {
            this.discoverProxy();
        }
        if (this.m_useProxy) {
            System.setProperty("proxySet", "true");
            if (this.m_proxyServer.length() != 0) {
                System.setProperty("http.proxyHost", this.m_proxyServer);
            }
            System.setProperty("http.proxyPort", this.m_proxyPort);
            if (updateServiceProperties.getProperty("ProxyAuthentication").trim().indexOf("1") == 0) {
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                String string = updateServiceProperties.getProperty("ProxyUserName").trim() + ":" + updateServiceProperties.getProperty("ProxyPassword").trim();
                String string2 = bASE64Encoder.encode(string.getBytes());
                uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string2);
                uRLConnection.setRequestProperty("Proxy-Connection", "Keep-Alive");
            }
            Authenticator.setDefault(new MyAuthenticator());
        }
    }

    private boolean discoverProxy() {
        block8: {
            boolean bl = false;
            String string = new String(System.getProperty("os.name")).toLowerCase();
            if (string.startsWith("windows")) {
                try {
                    WindowsHelper windowsHelper = new WindowsHelper();
                    long l = windowsHelper.getRegistryValueLong(2, "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings", "ProxyEnable");
                    if (l != 1L) break block8;
                    this.m_useProxy = true;
                    String string2 = windowsHelper.getRegistryValueString(2, "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings", "ProxyServer");
                    if (string2.length() > 0) {
                        if (string2.startsWith("http://")) {
                            string2 = string2.substring(7);
                        }
                        if (string2.indexOf(":") > 0) {
                            this.m_proxyServer = string2.substring(0, string2.indexOf(":"));
                            this.m_proxyPort = string2.substring(string2.indexOf(":") + 1);
                        } else {
                            this.m_proxyServer = string2;
                        }
                        Tracer.trace(this, "Proxy settings from IE: " + this.m_proxyServer + ":" + this.m_proxyPort);
                    }
                }
                catch (IOException iOException) {
                    this.m_useProxy = false;
                    Tracer.traceException(iOException);
                }
            } else {
                this.setProxyFromFireFox(string);
            }
        }
        return this.m_useProxy;
    }

    private void setProxyFromFireFox(String string) {
        File file;
        File file2 = null;
        file2 = string.startsWith("mac") ? new File("~/Library/Application Support/Firefox") : new File("~/.mozilla/firefox");
        if (file2.exists() && (file = new File(file2, "profiles.ini")).exists()) {
            try {
                String string2;
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string3 = null;
                boolean bl = false;
                boolean bl2 = false;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).startsWith("[")) {
                        if (bl) break;
                        string3 = "";
                        bl = false;
                        bl2 = false;
                        continue;
                    }
                    if (string2.equals("IsRelative=1")) {
                        bl2 = true;
                        continue;
                    }
                    if (string2.startsWith("Path=")) {
                        string3 = string2.substring(string2.indexOf("=") + 1);
                        continue;
                    }
                    if (!string2.equals("Default=1")) continue;
                    bl = true;
                }
                bufferedReader.close();
                fileReader.close();
                if (string3.length() > 0) {
                    String string4;
                    Integer n;
                    File file3;
                    HashMap hashMap;
                    File file4 = new File(string3);
                    if (bl2) {
                        file4 = new File(file2, string3);
                    }
                    if ((hashMap = this.readFireFoxPrefs(file3 = new File(file4, "prefs.js"))).containsKey("network.proxy.type") && (n = new Integer(string4 = (String)hashMap.get("network.proxy.type"))) == 1) {
                        this.m_proxyServer = (String)hashMap.get("network.proxy.http");
                        this.m_proxyPort = (String)hashMap.get("network.proxy.http_port");
                        Tracer.trace(this, "Proxy settings from FireFox: " + this.m_proxyServer + ":" + this.m_proxyPort);
                        this.m_useProxy = true;
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Tracer.traceException(fileNotFoundException);
            }
            catch (IOException iOException) {
                Tracer.traceException(iOException);
            }
        }
    }

    private HashMap readFireFoxPrefs(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            if (file.exists()) {
                String string;
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("user_pref(")) continue;
                    String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(","));
                    if ((string2 = string2.trim()).startsWith("\"")) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    String string3 = string.substring(string.indexOf(",") + 1, string.indexOf(")"));
                    if ((string3 = string3.trim()).startsWith("\"")) {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    hashMap.put(string2, string3);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
    }
}

