/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.Profile;
import isus.ProfileCollection;
import isus.ProfileList;
import isus.UpdateServiceException;
import isus.XMLWrapper;
import isus.demographics.DemographicCollector;
import isus.demographics.DemographicCollectorFactory;
import isus.rpc.RPCGetDemographics;
import isus.rpc.RPCSendProfiles;
import isus.shared.Tracer;
import isus.shared.UpdateServiceProperties;
import isus.shared.Util;
import isus.util.LinuxUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Date;
import org.w3c.dom.Element;

public class ProfileManager {
    private File file;
    private XMLWrapper xml;
    private String m_productCode;
    private String m_pfFile;
    private boolean recordDemographics = true;
    protected static final String DEFAULT_PROFILE_NAME = "Default";
    protected static final String DEFAULT_PROFILE_PRODUCT = "PRODUCT_GUID";
    protected static final String DEFAULT_PROFILE_VERSION = "PRODUCT_VERSION";
    protected static final String DEFAULT_PROFILE_OS = "OS";
    protected static final String DEFAULT_PROFILE_MACHINE = "MACHINE_NAME";
    protected static final String DEFAULT_PROFILE_IP = "MACHINE_IP";
    protected static final String DEFAULT_PROFILE_TARGETING = "TARGETING_PROFILE";
    protected static final String DEFAULT_PROFILE_INSTANCES = "PRODUCT_INSTANCES";
    protected static final String DEFAULT_PROFILE_LOCALE = "FNC:LOCALE";
    protected static final String DEFAULT_PROFILE_TIMEZONE = "FNC:TIMEZONE";

    public ProfileManager(String string) {
        this.m_productCode = string;
        this.m_pfFile = Util.getHome() + System.getProperty("file.separator") + Util.convert2UID(this.m_productCode) + ".pf";
        this.file = new File(this.m_pfFile);
        this.xml = this.file.exists() ? new XMLWrapper(this.file, "profiles", true) : null;
    }

    public ProfileList enumProfile() {
        ProfileList profileList = new ProfileList();
        if (this.xml == null) {
            this.createFile();
            return profileList;
        }
        Element element = this.xml.getRootElement();
        for (int i = 0; i < this.getProfileCount(); ++i) {
            Element element2 = this.xml.getNthElementByTagName(element, i, "profile");
            String string = element2.getAttribute("id");
            for (int j = 0; j < this.getProfileDataCount(element2); ++j) {
                Element element3 = this.xml.getNthElementByTagName(element2, j, "data");
                Profile profile = new Profile(string, element3.getAttribute("id"), element3.getAttribute("value"));
                profileList.add(profile);
            }
        }
        return profileList;
    }

    public void profileSetValue(String string, String string2, String string3) {
        if (this.xml == null) {
            this.createFile();
        }
        if (string.equalsIgnoreCase("")) {
            string = DEFAULT_PROFILE_NAME;
        }
        Element element = this.xml.getRootElement();
        boolean bl = false;
        Element element2 = null;
        for (int i = 0; i < this.getProfileCount(); ++i) {
            element2 = this.xml.getNthElementByTagName(element, i, "profile");
            if (!element2.getAttribute("id").equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            element2 = this.addProfile(string);
        }
        bl = false;
        for (int i = 0; i < this.getProfileDataCount(element2); ++i) {
            Element element3 = this.xml.getNthElementByTagName(element2, i, "data");
            if (!element3.getAttribute("id").equalsIgnoreCase(string2)) continue;
            bl = true;
            if (string3.equalsIgnoreCase("")) {
                element2.removeChild(element3);
                this.resetProfileDate(1);
                break;
            }
            if (element3.getAttribute("value").equals(string3)) break;
            element3.setAttribute("value", string3);
            element3.setAttribute("updated", "true");
            this.resetProfileDate(1);
            break;
        }
        if (!bl) {
            this.addProfileData(element2, string2, string3);
            this.resetProfileDate(1);
        }
        this.xml.Save(this.file);
    }

    public int getProfileCount() {
        return this.xml.getDocument().getDocumentElement().getElementsByTagName("profile").getLength();
    }

    public int getProfileDataCount(Element element) {
        return element.getElementsByTagName("data").getLength();
    }

    public void profileAdd(String string) {
        if (this.xml == null) {
            this.createFile();
        }
        Element element = this.xml.getRootElement();
        Element element2 = null;
        for (int i = 0; i < this.getProfileCount(); ++i) {
            element2 = this.xml.getNthElementByTagName(element, i, "profile");
            if (!element2.getAttribute("id").equalsIgnoreCase(string)) continue;
            return;
        }
        this.addProfile(string);
        this.xml.Save(this.file);
        this.resetProfileDate(1);
    }

    public void profileDelete(String string) {
        if (this.xml == null) {
            return;
        }
        Element element = this.xml.getRootElement();
        Element element2 = null;
        for (int i = 0; i < this.getProfileCount(); ++i) {
            element2 = this.xml.getNthElementByTagName(element, i, "profile");
            if (!element2.getAttribute("id").equalsIgnoreCase(string)) continue;
            element.removeChild(element2);
            this.xml.Save(this.file);
            this.resetProfileDate(1);
        }
    }

    public String buildRequestData() throws UnsupportedEncodingException {
        if (this.xml == null) {
            return "";
        }
        String string = "p=";
        string = string + this.m_productCode;
        Element element = this.xml.getRootElement();
        Element element2 = null;
        for (int i = 0; i < this.getProfileCount(); ++i) {
            element2 = this.xml.getNthElementByTagName(element, i, "profile");
            for (int j = 0; j < this.getProfileDataCount(element2); ++j) {
                Element element3 = this.xml.getNthElementByTagName(element2, j, "data");
                if (!element3.getAttribute("updated").equals("true")) continue;
                string = string + "&";
                string = string + URLEncoder.encode(element2.getAttribute("id"));
                string = string + "___";
                string = string + URLEncoder.encode(element3.getAttribute("id"));
                string = string + "=";
                string = element3.getAttribute("id").compareTo(DEFAULT_PROFILE_VERSION) == 0 || element3.getAttribute("id").compareTo(DEFAULT_PROFILE_INSTANCES) == 0 ? string + URLEncoder.encode(element3.getAttribute("value").replace('\u00a6', '|')) : string + URLEncoder.encode(element3.getAttribute("value"));
            }
        }
        if (string.equalsIgnoreCase("?p")) {
            return "";
        }
        return string;
    }

    private void removeUpdatedFlagsFromData() {
        Element element = this.xml.getRootElement();
        Element element2 = null;
        for (int i = 0; i < this.getProfileCount(); ++i) {
            element2 = this.xml.getNthElementByTagName(element, i, "profile");
            for (int j = 0; j < this.getProfileDataCount(element2); ++j) {
                Element element3 = this.xml.getNthElementByTagName(element2, j, "data");
                if (!element3.getAttribute("updated").equals("true")) continue;
                element3.removeAttribute("updated");
            }
        }
        this.xml.Save(this.file);
    }

    public boolean isUploadRequired() {
        if (this.xml == null) {
            return false;
        }
        Date date = this.getLastUpdateDate();
        Date date2 = this.getLastUploadDate();
        return date2.compareTo(date) < 0;
    }

    public void synchProfiles() throws UpdateServiceException {
        this.collectDemographics();
        if (this.xml == null) {
            return;
        }
        UpdateServiceProperties updateServiceProperties = this.getUpdateServiceProperties();
        RPCSendProfiles rPCSendProfiles = this.getRPCSendProfiles(updateServiceProperties, this);
        try {
            rPCSendProfiles.Run(false);
            if (rPCSendProfiles.GetResult().trim().equals("FINE")) {
                this.removeUpdatedFlagsFromData();
            }
        }
        catch (IOException iOException) {
            throw new UpdateServiceException(iOException);
        }
    }

    private void collectDemographics() throws UpdateServiceException {
        UpdateServiceProperties updateServiceProperties = this.getUpdateServiceProperties();
        if (!updateServiceProperties.getProperty("RecordDemographics").equals("false") && this.recordDemographics) {
            RPCGetDemographics rPCGetDemographics = this.getRPCGetDemographics(updateServiceProperties);
            try {
                rPCGetDemographics.Run(true);
            }
            catch (IOException iOException) {
                throw new UpdateServiceException(iOException);
            }
            String string = rPCGetDemographics.GetResult().trim();
            if (string.equals("") || string.equals("ACK")) {
                return;
            }
            XMLWrapper xMLWrapper = new XMLWrapper(string, "xml");
            int n = xMLWrapper.getDocument().getElementsByTagName("demographic").getLength();
            for (int i = 0; i < n; ++i) {
                Element element = xMLWrapper.getNthElementByTagName(xMLWrapper.getRootElement(), i, "demographic");
                String string2 = element.getAttribute("type");
                if (string2.equals("Disallow")) {
                    return;
                }
                this.profileAdd(DEFAULT_PROFILE_NAME);
                DemographicCollector demographicCollector = DemographicCollectorFactory.getDemographicCollector(string2);
                if (demographicCollector == null) continue;
                this.profileSetValue(DEFAULT_PROFILE_NAME, demographicCollector.getName(), demographicCollector.getValue());
            }
        }
    }

    private Date getLastUpdateDate() {
        Element element = this.xml.getRootElement();
        Long l = new Long(element.getAttribute("LastUpdate"));
        Date date = new Date(l);
        return date;
    }

    private Date getLastUploadDate() {
        Element element = this.xml.getRootElement();
        Long l = new Long(element.getAttribute("LastUpload"));
        Date date = new Date(l);
        return date;
    }

    public void resetProfileDate(int n) {
        Date date = new Date();
        Long l = new Long(date.getTime());
        Element element = this.xml.getRootElement();
        if (n == 1) {
            element.setAttribute("LastUpdate", l.toString());
        } else {
            element.setAttribute("LastUpload", l.toString());
        }
        this.xml.Save(this.file);
    }

    private Element addProfile(String string) {
        Element element = this.xml.getDocument().createElement("profile");
        element.setAttribute("id", string);
        return (Element)this.xml.getRootElement().appendChild(element);
    }

    private Element addProfileData(Element element, String string, String string2) {
        Element element2 = this.xml.getDocument().createElement("data");
        element2 = (Element)element.appendChild(element2);
        element2.setAttribute("id", string);
        element2.setAttribute("value", string2);
        element2.setAttribute("updated", "true");
        return element2;
    }

    private void createFile() {
        try {
            FileWriter fileWriter = new FileWriter(this.file);
            fileWriter.write("<profiles LastUpdate=\"0\" LastUpload=\"0\"/>");
            fileWriter.flush();
            fileWriter.close();
            String string = System.getProperty("os.name").toLowerCase();
            if (!string.startsWith("window")) {
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("/bin/chmod 666 " + this.m_pfFile);
            }
            this.xml = new XMLWrapper(this.file, "profiles", true);
        }
        catch (IOException iOException) {
            throw new UpdateServiceException(iOException);
        }
    }

    public ProfileCollection getCollection() {
        ProfileCollection profileCollection = new ProfileCollection();
        if (this.xml == null) {
            this.createFile();
            return profileCollection;
        }
        Element element = this.xml.getRootElement();
        for (int i = 0; i < this.getProfileCount(); ++i) {
            Element element2 = this.xml.getNthElementByTagName(element, i, "profile");
            String string = element2.getAttribute("id");
            for (int j = 0; j < this.getProfileDataCount(element2); ++j) {
                Element element3 = this.xml.getNthElementByTagName(element2, j, "data");
                Profile profile = new Profile(string, element3.getAttribute("id"), element3.getAttribute("value"));
                profileCollection.add(profile);
            }
        }
        return profileCollection;
    }

    public void collectDefaultProfileData(boolean bl) {
        try {
            this.collectDemographics();
        }
        catch (UpdateServiceException updateServiceException) {
            Tracer.trace(this, "collectDemographics threw an exception from within collectDefaultProfileData");
            Tracer.traceException(updateServiceException);
        }
        System.gc();
        Tracer.trace(this, "collectDefaultProfileData(" + this.m_productCode + ") called");
        UpdateServiceProperties updateServiceProperties = this.getUpdateServiceProperties();
        this.profileAdd(DEFAULT_PROFILE_NAME);
        if (bl) {
            this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_TARGETING, "yes");
        }
        this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_PRODUCT, this.m_productCode);
        this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_VERSION, updateServiceProperties.getProperty("Version", null));
        this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_OS, System.getProperty("os.name").toString());
        if (updateServiceProperties.EnumInstances().getlength() != 1 || !updateServiceProperties.EnumInstances().item(0).getName().equalsIgnoreCase("default")) {
            this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_INSTANCES, updateServiceProperties.getProperty("Instances", null));
        }
        updateServiceProperties.setProperty("IncludeDefault", "1");
        try {
            this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_MACHINE, InetAddress.getLocalHost().getHostName());
            String string = InetAddress.getLocalHost().getHostAddress();
            if (string.equals("127.0.0.1")) {
                try {
                    URL uRL = new URL(Util.getHost(updateServiceProperties));
                    Socket socket = new Socket(uRL.getHost(), 80);
                    string = socket.getLocalAddress().toString();
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    socket.close();
                    socket = null;
                }
                catch (Exception exception) {
                    Tracer.traceException(exception);
                    try {
                        String string2;
                        String string3 = LinuxUtil.alternateGetHostName();
                        if (string3 != null) {
                            this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_MACHINE, string3);
                        }
                        if ((string2 = LinuxUtil.alternateGetIPAddr()) != null) {
                            this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_IP, string2);
                            string = string2;
                        }
                    }
                    catch (Exception exception2) {
                        Tracer.traceException(exception2);
                    }
                }
            }
            this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_IP, string);
        }
        catch (UnknownHostException unknownHostException) {
            Tracer.traceException(unknownHostException);
            try {
                String string;
                String string4 = LinuxUtil.alternateGetHostName();
                if (string4 != null) {
                    this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_MACHINE, string4);
                }
                if ((string = LinuxUtil.alternateGetIPAddr()) != null) {
                    this.profileSetValue(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_IP, string);
                }
            }
            catch (Exception exception) {
                Tracer.traceException(exception);
            }
        }
    }

    protected UpdateServiceProperties getUpdateServiceProperties() {
        return new UpdateServiceProperties(Util.getHome(), this.m_productCode);
    }

    protected RPCSendProfiles getRPCSendProfiles(UpdateServiceProperties updateServiceProperties, ProfileManager profileManager) {
        return new RPCSendProfiles(updateServiceProperties, profileManager);
    }

    protected RPCGetDemographics getRPCGetDemographics(UpdateServiceProperties updateServiceProperties) {
        return new RPCGetDemographics(updateServiceProperties);
    }

    public void setRecordDemographics(boolean bl) {
        this.recordDemographics = bl;
    }
}

