/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.ProcessExecException;
import isus.ProcessOutputHandler;
import java.io.IOException;
import java.io.InputStream;

public class ProcessExec
implements ProcessOutputHandler {
    public static final int NOT_STARTED = 0;
    public static final int STARTED = 1;
    public static final int FINISHED = 2;
    public static final int ERROR = 3;
    private long processExecDelay = 500L;
    private String command = "";
    private String[] arguments = new String[0];
    private String outputDestination = null;
    private String errDestination = null;
    private ProcessOutputHandler outputHandler = null;
    private String[] createdDirsAndFiles = new String[0];
    private Process process;
    private ProcessStatus processStatus = new ProcessStatus();
    private final int CAPTURE_OUTPUT = 0;
    private final int CAPTURE_ERROR = 1;
    private int exitCode;
    private int status = 0;
    private int SLEEP_TIME = 5;
    public int PROCESSIO_BUFFERSIZE = 512;

    public ProcessExec(String string) {
        this(string, null);
    }

    public ProcessExec(String string, String[] stringArray) {
        this(string, stringArray, null, null);
    }

    public ProcessExec(String string, String[] stringArray, String string2, String string3) {
        int n = stringArray.length;
        int n2 = 0;
        if (string.length() == 0) {
            n = stringArray.length - 1;
            n2 = 1;
            this.command = stringArray[0];
        } else {
            this.command = string;
        }
        if (stringArray != null) {
            this.arguments = new String[n];
            System.arraycopy(stringArray, n2, this.arguments, 0, n);
        }
        this.outputDestination = string2;
        this.errDestination = string3;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public void setProcessExecDelay(long l) {
        if (l >= 0L) {
            this.processExecDelay = l;
        }
    }

    public String[] getCreatedDirectories() {
        return this.createdDirsAndFiles;
    }

    public void setProcessOutputHandler(ProcessOutputHandler processOutputHandler) {
        this.outputHandler = processOutputHandler;
    }

    public void executeProcess() throws ProcessExecException {
        try {
            String[] stringArray = new String[this.arguments.length + 1];
            stringArray[0] = this.command;
            System.arraycopy(this.arguments, 0, stringArray, 1, this.arguments.length);
            this.process = Runtime.getRuntime().exec(stringArray);
            this.status = 1;
            try {
                Thread.sleep(this.processExecDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.processStatus.setProcessStarted();
            if (this.outputHandler == null) {
                this.outputHandler = this;
            }
            ProcessOutputThread processOutputThread = new ProcessOutputThread(this.process.getInputStream(), 0);
            ProcessOutputThread processOutputThread2 = new ProcessOutputThread(this.process.getErrorStream(), 1);
            processOutputThread.start();
            processOutputThread2.start();
            this.process.waitFor();
            processOutputThread.join();
            processOutputThread2.join();
            this.exitCode = this.process.exitValue();
            this.status = 2;
        }
        catch (Exception exception) {
            this.status = 3;
            throw new ProcessExecException(exception.getMessage());
        }
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private synchronized void updateCreatedDirsAndFiles(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = this.createdDirsAndFiles;
            this.createdDirsAndFiles = new String[this.createdDirsAndFiles.length + stringArray.length];
            System.arraycopy(stringArray2, 0, this.createdDirsAndFiles, 0, stringArray2.length);
            System.arraycopy(stringArray, 0, this.createdDirsAndFiles, stringArray2.length, stringArray.length);
        }
    }

    public synchronized boolean getProcessStarted() {
        return this.processStatus.getProcessStarted();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public int getStatus() {
        return this.status;
    }

    public void processOutputData(InputStream inputStream) {
        this.readProcessStream(inputStream);
    }

    public void processErrorData(InputStream inputStream) {
        this.readProcessStream(inputStream);
    }

    private void readProcessStream(InputStream inputStream) {
        int n = 0;
        byte[] byArray = new byte[this.PROCESSIO_BUFFERSIZE];
        try {
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                try {
                    Thread.sleep(this.SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class ProcessStatus {
        boolean processStarted = false;

        ProcessStatus() {
        }

        public synchronized void setProcessStarted() {
            this.processStarted = true;
        }

        public synchronized boolean getProcessStarted() {
            return this.processStarted;
        }
    }

    class ProcessOutputThread
    extends Thread {
        private int type = -1;
        private InputStream stream = null;

        public ProcessOutputThread(InputStream inputStream, int n) {
            this.stream = inputStream;
            this.type = n;
        }

        public void run() {
            if (this.stream != null && this.type == 0) {
                ProcessExec.this.outputHandler.processOutputData(this.stream);
            } else if (this.stream != null && this.type == 1) {
                ProcessExec.this.outputHandler.processErrorData(this.stream);
            }
        }
    }
}

