/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.CalloutHolder;
import isus.CommandLineInterface;
import isus.DownloadManager;
import isus.IDownloadEvents;
import isus.IMessage;
import isus.IMessage5;
import isus.IMessageProperties;
import isus.IPrivMessage;
import isus.IUpdateEvents;
import isus.LOG;
import isus.ProcessExec;
import isus.ProcessExecException;
import isus.ProxyInfo;
import isus.Strings;
import isus.UpdateServiceException;
import isus.XMLGetMessages;
import isus.net.AgentURLStreamHandlerFactory;
import isus.rpc.RPCAuthenticate;
import isus.rpc.RPCGetAuthenticationParameters;
import isus.rpc.RPCReport;
import isus.shared.ConfigurationManager;
import isus.shared.CrypterHelper;
import isus.shared.Tracer;
import isus.shared.UpdateServiceProperties;
import isus.shared.Util;
import isus.shared.WindowsHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Message
implements IMessage,
IMessage5,
IPrivMessage,
IMessageProperties,
IDownloadEvents {
    private String m_filter = null;
    private String m_basedir = "";
    private boolean m_bExecute = false;
    private String m_local = new String("");
    private UpdateServiceProperties m_prop = null;
    private String m_callout = "";
    private String m_calloutURL = "";
    private String m_currentinstance = "";
    private int m_rate = 0;
    private int m_size = 0;
    private Map m_header_map;
    private Object m_contenthandler = null;
    private Constructor constructor = null;
    private Class contentClass;
    private boolean m_bIsReadyToPresent = false;
    private boolean m_bFiredMessagePending = false;
    private int m_type = 0;
    private String m_DownloadURL = "";
    private String m_Description;
    private String m_Title = "";
    private String m_Name = "";
    private String m_Category = "";
    private String m_CommandLine = "";
    private double m_DownloadSize = 0.0;
    private String m_id = "";
    private String m_productCode = "";
    private String m_versionid = "";
    private int m_mediaType = 8;
    private String m_DisplayVersion = "";
    private String m_DetailsURL = "";
    private String m_Details = "";
    private String m_TargetDir = "";
    private boolean m_Basketable = false;
    private int m_BasketPriority = 0;
    private String m_LocalFileName = "";
    private String m_ProductName = "";
    private String m_SecurityType = "";
    private String m_SecuritySignature = "";
    private String m_StartDate = "";
    private String m_ExpireDate = "";
    private String m_ReleaseName = "";
    private String m_AuthenticateURL = "";
    private int m_UIType = 0;
    private String m_Version = "";
    private int m_AuthID = 0;
    private String m_sdurl = "";
    private int m_DownloadType = 0;
    private String m_AuthenticateMessage = "";
    private String m_AuthFailMsg = "";
    private String m_ProductDisplayName = "";
    private List _listeners = new ArrayList();
    private DownloadManager m_dm = null;
    static /* synthetic */ Class class$isus$CalloutHolder;

    public Message(UpdateServiceProperties updateServiceProperties) {
        this.m_prop = updateServiceProperties;
    }

    public void Report(String string) {
        String string2 = "verb=";
        String string3 = string;
        string2 = string2 + string3;
        string2 = string2 + "&";
        String string4 = "triplets";
        string2 = string2 + string4;
        string2 = string2 + "=";
        string2 = string2 + this.getMsgID();
        string2 = string2 + ",";
        string2 = string2 + this.getProductCode();
        string2 = string2 + ",";
        string2 = string2 + this.getVersionid();
        RPCReport rPCReport = new RPCReport(this.m_prop, string2);
        try {
            rPCReport.Run(false);
        }
        catch (UpdateServiceException updateServiceException) {
            this.logException(updateServiceException);
        }
        catch (IOException iOException) {
            this.logException(iOException);
        }
    }

    public void CreateLogEntry(String string, long l, String string2, boolean bl) {
        String string3;
        String string4 = this.getMsgID() + "," + this.getProductCode() + "," + this.getVersionid();
        if (bl) {
            if (this.m_size == 0) {
                string3 = "0/0";
            } else {
                int n = this.m_rate / this.m_size;
                string3 = Integer.toString(this.m_size) + "/" + Integer.toString(n);
            }
        } else {
            string3 = "";
        }
        RPCReport rPCReport = new RPCReport(this.m_prop, string4, string, l, string3, string2);
        try {
            rPCReport.Run(false);
        }
        catch (UpdateServiceException updateServiceException) {
            this.logException(updateServiceException);
        }
        catch (IOException iOException) {
            this.logException(iOException);
        }
    }

    public String getDownloadURL() {
        return this.m_DownloadURL;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public void setTitle(String string) {
        this.m_Title = string;
    }

    public void setDownloadURL(String string) {
        this.m_DownloadURL = string;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getDescription() {
        try {
            this.Report("MSGDISPLAYED");
        }
        catch (Exception exception) {
            Tracer.trace(this, "There was a problem trying to report msgread on getDetailsURL()");
            Tracer.traceException(exception);
        }
        return this.getDescriptionInternal();
    }

    public String getDescriptionInternal() {
        return this.m_Description;
    }

    private String createLocalFileName() {
        String string = System.getProperty("java.io.tmpdir");
        String string2 = this.m_productCode + "_" + this.m_id;
        File file = new File(string, string2);
        File file2 = null;
        if (file.exists() || file.mkdir()) {
            String string3;
            URL uRL = null;
            try {
                uRL = new URL(this.m_DownloadURL);
            }
            catch (MalformedURLException malformedURLException) {
                Tracer.traceException(malformedURLException);
            }
            if (uRL != null) {
                // empty if block
            }
            if ((string3 = uRL.getFile()).indexOf("/") > -1) {
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
            }
            file2 = new File(file, string3);
        }
        if (file2 != null) {
            return file2.toString();
        }
        return "";
    }

    protected boolean DownloadBeforePresent() {
        String string = this.createLocalFileName();
        if (string.length() > 0) {
            this.Download(string, true);
            return true;
        }
        Tracer.trace(this, "DownloadBeforePresent FAILURE: m_DownloadURL");
        return false;
    }

    protected boolean IsReadyToPresent() {
        String string;
        this.m_LocalFileName = string = this.createLocalFileName();
        DownloadManager downloadManager = new DownloadManager();
        this.m_bIsReadyToPresent = downloadManager.IsReadyToPresent(this.m_DownloadURL, string);
        return this.m_bIsReadyToPresent;
    }

    public boolean DownloadAndInstall(final boolean bl) {
        if (this.m_DownloadType == 1 && this.IsReadyToPresent()) {
            this.Install();
        } else {
            this.m_bExecute = true;
            Runnable runnable = new Runnable(){

                public void run() {
                    String string = Message.this.createLocalFileName();
                    File file = null;
                    if (string.length() > 0) {
                        file = new File(string);
                    } else {
                        try {
                            file = Message.this.m_DownloadURL.endsWith(".exe") ? File.createTempFile("tmp", ".exe") : (Message.this.m_DownloadURL.endsWith(".jar") ? File.createTempFile("tmp", ".jar") : (Message.this.m_DownloadURL.endsWith(".msi") ? File.createTempFile("tmp", ".msi") : (Message.this.m_DownloadURL.endsWith(".msp") ? File.createTempFile("tmp", ".msp") : (Message.this.m_DownloadURL.endsWith(".rpm") ? File.createTempFile("tmp", ".rpm") : (Message.this.m_DownloadURL.endsWith(".tar") ? File.createTempFile("tmp", ".tar") : (Message.this.m_DownloadURL.endsWith(".tgz") ? File.createTempFile("tmp", ".tgz") : File.createTempFile("tmp", ".tmp")))))));
                        }
                        catch (IOException iOException) {
                            Message.this.logException(iOException);
                        }
                    }
                    String string2 = file.getAbsolutePath();
                    if (Message.this.m_DownloadURL.length() == 0 && Message.this.getMediaType() == 9) {
                        string2 = "";
                    }
                    Message.this.DownloadImpl(string2, bl);
                }
            };
            new Thread(runnable).start();
        }
        return true;
    }

    public boolean Download(final String string, final boolean bl) {
        this.m_bExecute = false;
        Runnable runnable = new Runnable(){

            public void run() {
                Message.this.DownloadImpl(string, bl);
            }
        };
        new Thread(runnable).start();
        return true;
    }

    public boolean DownloadImpl(String string, boolean bl) {
        this.Report("MSGREAD");
        this.m_local = string;
        if ((this.getType() & 2) != 0) {
            Tracer.trace(this, "Download FAILURE: trying to download a message");
            return false;
        }
        if (this.getMediaType() == 10) {
            try {
                this.contentClass = Class.forName("com.installshield.USFileSync.USFileSync");
                try {
                    this.m_dm = null;
                    this.constructor = this.contentClass.getConstructor(new Class[0]);
                    this.m_contenthandler = this.constructor.newInstance(new Object[0]);
                    Method method = this.contentClass.getMethod("addDownloadListener", IDownloadEvents.class);
                    method.invoke(this.m_contenthandler, this);
                    Method method2 = this.contentClass.getMethod("Download", IMessageProperties.class, Integer.TYPE, Boolean.TYPE);
                    Object[] objectArray = new Object[]{this, new Integer(1033), new Boolean(bl)};
                    method2.invoke(this.m_contenthandler, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Tracer.traceException(illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    Tracer.traceException(instantiationException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Tracer.traceException(noSuchMethodException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Tracer.traceException(invocationTargetException);
                }
            }
            catch (Exception exception) {
                Tracer.traceException(exception);
                return false;
            }
            return true;
        }
        if (this.getMediaType() == 9 && this.getDownloadURL().length() == 0) {
            this.m_bExecute = true;
            this.OnDownloadComplete();
            return false;
        }
        this.m_contenthandler = null;
        this.m_dm = new DownloadManager();
        ProxyInfo proxyInfo = new ProxyInfo(this.m_prop);
        this.m_dm.setProxy(proxyInfo);
        try {
            this._fireMessagePending();
            this.m_bFiredMessagePending = true;
            if (this.m_header_map != null) {
                this.m_dm.setHeaders(this.m_header_map);
            }
            this.m_dm.addDownloadListener(this);
            this.m_dm.Download(this.getTitle(), this.getDownloadURL(), string, bl);
        }
        catch (IOException iOException) {
            this.logException(iOException);
        }
        return false;
    }

    public String getCategory() {
        return this.m_Category;
    }

    public void setCategory(String string) {
        this.m_Category = string;
    }

    public void setDownloadSize(int n) {
        this.m_DownloadSize = new Integer(n).doubleValue();
    }

    public int getDownloadSize() {
        return new Double(this.m_DownloadSize).intValue();
    }

    public double getDownloadSizeEx() {
        return this.m_DownloadSize;
    }

    public void setDownloadSize(double d) {
        this.m_DownloadSize = d;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    public String getProductDisplayName() {
        return this.m_ProductDisplayName;
    }

    public void setProductDisplayName(String string) {
        this.m_ProductDisplayName = string;
    }

    public String getAuthenticateMessage() {
        return this.m_AuthenticateMessage;
    }

    public void setAuthenticateMessage(String string) {
        this.m_AuthenticateMessage = string;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public int getType() {
        return this.m_type;
    }

    public void addUpdateListener(IUpdateEvents iUpdateEvents) {
        this._listeners.add(iUpdateEvents);
    }

    public void removeUpdateListener(IUpdateEvents iUpdateEvents) {
        this._listeners.remove(iUpdateEvents);
    }

    private synchronized boolean _fireDownloadBegin() {
        boolean bl = true;
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext() && bl) {
            bl = ((IDownloadEvents)iterator.next()).OnDownloadBegin();
        }
        return bl;
    }

    private synchronized boolean _fireDownloadComplete() {
        boolean bl = true;
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext() && bl) {
            bl = ((IDownloadEvents)iterator.next()).OnDownloadComplete();
        }
        return bl;
    }

    private synchronized boolean _fireDownloadProgress(int n, int n2, int n3) {
        boolean bl = true;
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext() && bl) {
            bl = ((IDownloadEvents)iterator.next()).OnDownloadProgress(n, n2, n3);
        }
        return bl;
    }

    private synchronized boolean _fireDownloadError(String string) {
        boolean bl = true;
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext() && bl) {
            bl = ((IDownloadEvents)iterator.next()).OnDownloadError(string);
        }
        return bl;
    }

    private synchronized void _fireInstallStart() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((IUpdateEvents)iterator.next()).OnInstallStart();
        }
    }

    private synchronized void _fireInstallEnd(int n) {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((IUpdateEvents)iterator.next()).OnInstallEnd(n);
        }
    }

    private synchronized void _fireMessagePending() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            Object e;
            Class clazz = class$isus$CalloutHolder == null ? Message.class$("isus.CalloutHolder") : class$isus$CalloutHolder;
            if (!clazz.isInstance(e = iterator.next())) continue;
            ((CalloutHolder)e).OnMessagePending();
        }
    }

    public boolean OnDownloadBegin() {
        this.CreateLogEntry("DOWNLOADSTART", 0L, Strings.getString("Report.DownloadStart.Desc"), true);
        if (!this._fireDownloadBegin()) {
            this.CancelDownload();
        }
        return true;
    }

    public boolean OnDownloadProgress(int n, int n2, int n3) {
        this.m_rate = n3;
        this.m_size = n2;
        if (!this._fireDownloadProgress(n, n2, n3)) {
            this.CancelDownload();
        }
        return true;
    }

    public boolean OnDownloadComplete() {
        CrypterHelper crypterHelper;
        File file = new File(this.m_local);
        if (this.m_SecurityType.equalsIgnoreCase("signed")) {
            crypterHelper = new CrypterHelper();
            if (!crypterHelper.VerifySignature2(this.m_local, this.m_SecuritySignature)) {
                this.Report("SIGNATURECHECKFALURE");
                file.delete();
                this._fireDownloadError(Strings.getUIString("IDS_SECURITY_ERROR_SIGNATURE"));
                if (this.m_dm != null) {
                    this.m_dm.setDownloadFailedMessage(Strings.getUIString("IDS_SECURITY_ERROR_SIGNATURE"));
                }
                return false;
            }
        } else if (this.m_SecurityType.equals("sha1") && !(crypterHelper = new CrypterHelper()).verifySHAHash(this.m_local, this.m_SecuritySignature)) {
            this.Report("SIGNATURECHECKFAILURE");
            file.delete();
            this._fireDownloadError(Strings.getUIString("IDS_SECURITY_ERROR_SIGNATURE"));
            if (this.m_dm != null) {
                this.m_dm.setDownloadFailedMessage(Strings.getUIString("IDS_SECURITY_ERROR_SIGNATURE"));
            }
            return false;
        }
        this.CreateLogEntry("DOWNLOADSUCCESS", 0L, Strings.getString("Report.DownloadSuccess.Desc"), true);
        if (this._fireDownloadComplete() && this.m_mediaType != 10 && this.m_bExecute) {
            file.deleteOnExit();
            if (this.getMediaType() == 10) {
                this._fireInstallStart();
                this._fireInstallEnd(0);
                return true;
            }
            this._fireInstallStart();
            try {
                if (this.m_CommandLine == null) {
                    this.m_CommandLine = "";
                }
                this.m_CommandLine = Util.replaceAll(this.m_CommandLine, "$(INSTANCE)", this.getInstance());
                this.launchInstaller(this.m_local, this.m_CommandLine);
            }
            catch (UpdateServiceException updateServiceException) {
                LOG.dumpStack(updateServiceException);
            }
            this._fireInstallEnd(0);
        }
        return true;
    }

    public boolean OnDownloadError(String string) {
        int n = -1;
        if (string.equalsIgnoreCase("Download Cancelled")) {
            n = 13002;
        }
        this.CreateLogEntry("DOWNLOADFAILURE", n, string, false);
        this._fireDownloadError(string);
        return true;
    }

    public void CancelDownload() {
        if (this.m_dm != null) {
            this.m_dm.CancelDownload();
        } else if (this.m_contenthandler != null) {
            try {
                Method method = this.contentClass.getMethod("Cancel", null);
                try {
                    method.invoke(this.m_contenthandler, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Tracer.traceException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Tracer.traceException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Tracer.traceException(invocationTargetException);
                }
            }
            catch (SecurityException securityException) {
                Tracer.traceException(securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Tracer.traceException(noSuchMethodException);
            }
        }
    }

    public void pauseDownload() {
        if (this.m_dm != null) {
            try {
                this.m_dm.pause();
            }
            catch (IOException iOException) {
                Tracer.traceException(iOException);
            }
        } else if (this.m_contenthandler != null) {
            try {
                Method method = this.contentClass.getMethod("pause", null);
                try {
                    method.invoke(this.m_contenthandler, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Tracer.traceException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Tracer.traceException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Tracer.traceException(invocationTargetException);
                }
            }
            catch (SecurityException securityException) {
                Tracer.traceException(securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Tracer.traceException(noSuchMethodException);
            }
        }
    }

    public String getCommandLine() {
        return this.m_CommandLine;
    }

    public void setCommandLine(String string) {
        this.m_CommandLine = string;
    }

    public void Install() {
        String string;
        if (this.m_DownloadType == 1) {
            this.m_local = this.createLocalFileName();
            this.CleanDTPFiles();
        }
        if (!this.m_bFiredMessagePending) {
            this._fireMessagePending();
        }
        if (this.m_mediaType == 10) {
            this._fireInstallStart();
            this._fireInstallEnd(0);
            return;
        }
        if (this.m_local.length() == 0 && (string = this.getDownloadURL()).startsWith("file://")) {
            this.m_local = string.substring(7);
            this.m_local.replace('/', '\\');
        }
        if (this.m_local.length() != 0) {
            this._fireInstallStart();
            try {
                this.launchInstaller(this.m_local, this.m_CommandLine);
            }
            catch (UpdateServiceException updateServiceException) {
                LOG.dumpStack(updateServiceException);
            }
            this._fireInstallEnd(0);
        }
    }

    public void SetProxy(String string, int n) {
    }

    public void setProductBaseDir(String string) {
        this.m_basedir = string;
    }

    public String getProductBaseDir() {
        if (this.m_basedir == null) {
            this.m_basedir = new String(".");
        }
        return this.m_basedir;
    }

    public UpdateServiceProperties getUpdateServiceProperties() {
        return this.m_prop;
    }

    public String getMsgID() {
        return this.m_id;
    }

    public String getProductCode() {
        return this.m_productCode;
    }

    public String getVersionid() {
        return this.m_versionid;
    }

    public void setMsgID(String string) {
        this.m_id = string;
    }

    public void setProductCode(String string) {
        this.m_productCode = string;
    }

    public void setVersionid(String string) {
        this.m_versionid = string;
    }

    public String getFilterKey() {
        return this.m_filter;
    }

    public void setFilterKey(String string) {
        this.m_filter = string;
    }

    public int getMediaType() {
        return this.m_mediaType;
    }

    public void setMediaType(int n) {
        this.m_mediaType = n;
    }

    public void setStartDate(String string) {
        this.m_StartDate = string;
    }

    public String getStartDate() {
        return this.m_StartDate;
    }

    public void setExpireDate(String string) {
        this.m_ExpireDate = string;
    }

    public String getExpireDate() {
        return this.m_ExpireDate;
    }

    private void launchInstaller(String string, String string2) throws UpdateServiceException {
        Tracer.trace(this, "launchInstaller(" + string + ", " + string2 + ") called.");
        if (this.getMediaType() != 6) {
            String string3 = System.getProperty("os.name").toLowerCase();
            if (!string3.startsWith("window")) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Tracer.trace(this, "launchInstaller: calling chmod");
                    runtime.exec("/bin/chmod 777 " + string);
                }
                catch (IOException iOException) {
                    Tracer.traceException(iOException);
                }
            }
            long l = 0L;
            try {
                ProcessExec processExec = null;
                this.CreateLogEntry("INSTALLSTART", 0L, Strings.getString("Report.InstallStart.Desc"), false);
                if (string2.indexOf("$DOWNLOADFILE") >= 0) {
                    if (string.indexOf(32) > 0) {
                        string = "\"" + string + "\"";
                    }
                    String string4 = Util.replaceAll(string2, "$DOWNLOADFILE", string);
                    try {
                        Tracer.trace(this, "launchInstaller: " + string4);
                        Process process = Runtime.getRuntime().exec(string4);
                        process.waitFor();
                    }
                    catch (IOException iOException) {
                        throw new UpdateServiceException(iOException.getMessage());
                    }
                    catch (InterruptedException interruptedException) {
                        throw new UpdateServiceException(interruptedException.getMessage());
                    }
                } else if (string.endsWith(".jar")) {
                    String string5 = this.getJavaCmd();
                    if (string5 != null) {
                        String string6 = string5 + " -jar " + string + " " + string2;
                        Tracer.trace(this, "launchInstaller: " + string6);
                        Process process = Runtime.getRuntime().exec(string6);
                        process.waitFor();
                    }
                } else if (string.endsWith(".msi") && string3.startsWith("window")) {
                    Tracer.trace(this, "launchInstaller: MSIEXEC.EXE /i" + string + " " + string2);
                    String string7 = "/i ";
                    string7 = string7 + string;
                    string7 = string7 + " ";
                    string7 = string7 + string2;
                    WindowsHelper windowsHelper = new WindowsHelper();
                    l = windowsHelper.shellExecute("MSIEXEC.EXE", string7);
                } else if (string.endsWith(".msp") && string3.startsWith("window")) {
                    Tracer.trace(this, "launchInstaller: MSIEXEC.EXE /p" + string + " " + string2);
                    String string8 = "/p ";
                    string8 = string8 + string;
                    string8 = string8 + " ";
                    string8 = string8 + string2;
                    WindowsHelper windowsHelper = new WindowsHelper();
                    l = windowsHelper.shellExecute("MSIEXEC.EXE", string8);
                } else if (string.endsWith(".rpm")) {
                    Tracer.trace(this, "launchInstaller: rpm -i" + string + " " + string2);
                    processExec = new ProcessExec("rpm", new String[]{"-i", string, string2});
                    processExec.executeProcess();
                } else {
                    Tracer.trace(this, "launchInstaller: " + string + " " + string2);
                    if (string3.startsWith("window")) {
                        WindowsHelper windowsHelper = new WindowsHelper();
                        l = windowsHelper.shellExecute(string, string2);
                    } else {
                        processExec = new ProcessExec(string, new String[]{string2});
                        processExec.executeProcess();
                    }
                }
                if (processExec != null) {
                    l = processExec.getExitCode();
                }
                Tracer.trace(this, "launchInstaller: INSTALLCOMPLETE");
                this.CreateLogEntry("INSTALLCOMPLETE", l, Strings.getString("Report.InstallComplete.Desc"), false);
            }
            catch (ProcessExecException processExecException) {
                throw new UpdateServiceException(processExecException.getMessage());
            }
            catch (IOException iOException) {
                throw new UpdateServiceException(iOException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                throw new UpdateServiceException(interruptedException.getMessage());
            }
        }
        if (this.m_prop != null && this.m_prop.getProperty(ConfigurationManager.LAUNCHER).length() > 0) {
            Tracer.trace(this, "launchInstaller: Going through ConfigurationManager.LAUNCHER");
            Tracer.trace(this, "launchInstaller: ConfigurationManager.LAUNCHER=" + this.m_prop.getProperty(ConfigurationManager.LAUNCHER));
            CommandLineInterface commandLineInterface = new CommandLineInterface(this.m_prop.getProperty(ConfigurationManager.LAUNCHER), string, string2);
            int n = commandLineInterface.runCommand();
        } else {
            String string9 = this.getJavaCmd();
            if (string9 != null) {
                String string10 = string9 + " -jar " + string + " " + string2;
                try {
                    Tracer.trace(this, "launchInstaller: " + string10);
                    Process process = Runtime.getRuntime().exec(string10);
                    process.waitFor();
                }
                catch (IOException iOException) {
                    throw new UpdateServiceException(iOException.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    throw new UpdateServiceException(interruptedException.getMessage());
                }
            }
        }
    }

    public void setCalloutURL(String string) {
        this.m_calloutURL = string;
    }

    public String getCalloutURL() {
        return this.m_calloutURL;
    }

    public void setCallout(String string) {
        this.m_callout = string;
    }

    public String getCallout() {
        return this.m_callout;
    }

    public void initCallout() {
        CalloutHolder calloutHolder;
        if (this.m_callout.length() > 0 && (calloutHolder = new CalloutHolder()).loadCalloutClass(this.m_callout)) {
            this.addUpdateListener(calloutHolder);
            calloutHolder.setMessage(this);
        }
    }

    public void setDisplayVersion(String string) {
        this.m_DisplayVersion = string;
    }

    public String getDisplayVersion() {
        return this.m_DisplayVersion;
    }

    public void setDetailsURL(String string) {
        this.m_DetailsURL = string;
    }

    public String getDetailsURL() {
        try {
            this.Report("MSGREAD");
        }
        catch (Exception exception) {
            Tracer.trace(this, "There was a problem trying to report msgread on getDetailsURL()");
            Tracer.traceException(exception);
        }
        return this.getDetailsURLInternal();
    }

    public String getDetailsURLInternal() {
        return this.m_DetailsURL;
    }

    public void setDetails(String string) {
        this.m_Details = string;
    }

    public String getDetails() {
        return this.m_Details;
    }

    public void setTargetDir(String string) {
        this.m_TargetDir = string;
    }

    public String getTargetDir() {
        return this.m_TargetDir;
    }

    public void setBasketable(boolean bl) {
        this.m_Basketable = bl;
    }

    public boolean getBasketable() {
        return this.m_Basketable;
    }

    public void setBasketPriority(int n) {
        this.m_BasketPriority = n;
    }

    public int getBasketPriority() {
        return this.m_BasketPriority;
    }

    public void setLocalFileName(String string) {
        this.m_LocalFileName = string;
    }

    public String getLocalFileName() {
        return this.m_LocalFileName;
    }

    public void setProductName(String string) {
        this.m_ProductName = string;
    }

    public String getProductName() {
        return this.m_ProductName;
    }

    public String getSecurityType() {
        return this.m_SecurityType;
    }

    public void setSecurityType(String string) {
        this.m_SecurityType = string;
    }

    public String getSecuritySignature() {
        return this.m_SecuritySignature;
    }

    public void setSecuritySignature(String string) {
        this.m_SecuritySignature = string;
    }

    private String DownloadToTemp(String string) {
        try {
            File file = null;
            file = string.endsWith(".class") ? File.createTempFile("tmp", ".class") : (string.endsWith(".jar") ? File.createTempFile("tmp", ".jar") : File.createTempFile("tmp", ".tmp"));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            URL uRL = null;
            URLConnection uRLConnection = null;
            uRL = new URL(null, string, new AgentURLStreamHandlerFactory().createURLStreamHandler(string));
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "ISUA 12.00MP Downloader");
            if (uRLConnection == null) {
                return "";
            }
            ProxyInfo proxyInfo = new ProxyInfo(this.m_prop);
            proxyInfo.InitProxy(uRLConnection);
            uRLConnection.setDefaultUseCaches(false);
            DataInputStream dataInputStream = null;
            DataOutputStream dataOutputStream = null;
            dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            dataOutputStream = new DataOutputStream(fileOutputStream);
            byte[] byArray = new byte[10250];
            int n = 10240;
            int n2 = 0;
            while ((n2 = dataInputStream.read(byArray, 0, n)) != -1) {
                dataOutputStream.write(byArray, 0, n2);
            }
            dataInputStream.close();
            dataOutputStream.close();
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            this.logException(iOException);
            return "";
        }
    }

    private void logException(Exception exception) {
    }

    private String getJavaCmd() {
        String string;
        String string2 = System.getProperty("java.home");
        String string3 = System.getProperty("file.separator");
        String string4 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), string4);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.indexOf(32) > 0) {
                stringBuffer.append("\"" + string + "\"" + string4);
                continue;
            }
            stringBuffer.append(string + string4);
        }
        string = string2 + string3 + "bin" + string3 + "java";
        if (string.indexOf(" ") > 0) {
            string = "\"" + string + "\"";
        }
        String string5 = string;
        return string5;
    }

    public void setInstance(String string) {
        this.m_currentinstance = string;
    }

    public String getInstance() {
        return this.m_currentinstance;
    }

    public void setHeaders(Map map) {
        if (map == null) {
            System.out.println("m is NULL " + map.toString());
        }
        this.m_header_map = map;
    }

    public String getLocalSyncDir() {
        return this.getSDURL();
    }

    public void setLocalSyncDir(String string) {
        this.setSDURL(string);
    }

    public void setReleaseName(String string) {
        this.m_ReleaseName = string;
    }

    public String getReleaseName() {
        return this.m_ReleaseName;
    }

    public String[][] GetAuthenticationParameters() {
        RPCGetAuthenticationParameters rPCGetAuthenticationParameters = new RPCGetAuthenticationParameters(this.m_prop, this);
        try {
            rPCGetAuthenticationParameters.Run(true);
        }
        catch (UpdateServiceException updateServiceException) {
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
        }
        String string = rPCGetAuthenticationParameters.GetResult();
        XMLGetMessages xMLGetMessages = new XMLGetMessages(string);
        int n = (int)xMLGetMessages.getCount();
        String[][] stringArray = new String[n][3];
        for (int i = 0; i < n; ++i) {
            stringArray[i][0] = xMLGetMessages.GetAttributeValue(i, "FieldName");
            stringArray[i][1] = xMLGetMessages.GetAttributeValue(i, "DisplayName");
            stringArray[i][2] = xMLGetMessages.GetAttributeValue(i, "FieldType");
            if (stringArray[i][2].equals("1")) {
                stringArray[i][2] = "text";
                continue;
            }
            if (!stringArray[i][2].equals("2")) continue;
            stringArray[i][2] = "password";
        }
        this.m_AuthenticateURL = xMLGetMessages.GetAttributeValue(0, "AuthURL");
        return stringArray;
    }

    public long Authenticate(String[][] stringArray, StringBuffer stringBuffer) {
        RPCAuthenticate rPCAuthenticate = new RPCAuthenticate(this.m_prop, stringArray, this.m_AuthenticateURL);
        long l = 0L;
        try {
            rPCAuthenticate.Run(false);
            String string = rPCAuthenticate.GetResult().trim();
            if (string.equalsIgnoreCase("OK")) {
                l = 1L;
            }
            stringBuffer.append(string);
        }
        catch (UpdateServiceException updateServiceException) {
            Tracer.traceException(updateServiceException);
            l = -1L;
        }
        return l;
    }

    public void AddToExceptionList(boolean bl) {
        String string = "ExceptionMsg." + this.m_id;
        if (bl) {
            string = "ExceptionMsg." + this.m_id;
            this.m_prop.setProperty(string, "TRUE");
        } else {
            this.m_prop.removeProperty(string);
        }
    }

    public boolean IsException() {
        boolean bl = false;
        String string = "ExceptionMsg." + this.m_id;
        String string2 = this.m_prop.getProperty(string);
        if (string2 != null && string2.equalsIgnoreCase("TRUE")) {
            bl = true;
        }
        return bl;
    }

    private void CleanDTPFiles() {
        File file = new File(this.createLocalFileName());
        if (file.exists()) {
            String string = file.getParent();
            if (string != null) {
                File file2 = new File(string);
                file2.deleteOnExit();
            }
            file.deleteOnExit();
        }
    }

    public int getUIType() {
        return this.m_UIType;
    }

    public void setUIType(int n) {
        this.m_UIType = n;
    }

    public String getVersion() {
        return this.m_Version;
    }

    public void setVersion(String string) {
        this.m_Version = string;
    }

    public int getAuthID() {
        return this.m_AuthID;
    }

    public void setAuthID(String string) {
        Integer n = new Integer(string);
        this.m_AuthID = n;
    }

    public void setAuthID(int n) {
        this.m_AuthID = n;
    }

    public String getSDURL() {
        return this.m_sdurl;
    }

    public void setSDURL(String string) {
        this.m_sdurl = string;
    }

    public int getDownloadType() {
        return this.m_DownloadType;
    }

    public void setDownloadType(int n) {
        this.m_DownloadType = n;
    }

    public void setAuthenticationFailedMessage(String string) {
        this.m_AuthFailMsg = string;
    }

    public String getAuthenticationFailedMessage() {
        return this.m_AuthFailMsg;
    }

    public int FileSynchronization(String string, boolean bl) {
        this.Report("MSGREAD");
        if (this.getMediaType() == 10) {
            try {
                this.contentClass = Class.forName("com.installshield.USFileSync.USFileSync");
                try {
                    this.m_dm = null;
                    this.constructor = this.contentClass.getConstructor(new Class[0]);
                    this.m_contenthandler = this.constructor.newInstance(new Object[0]);
                    Method method = this.contentClass.getMethod("addDownloadListener", IDownloadEvents.class);
                    method.invoke(this.m_contenthandler, this);
                    Method method2 = this.contentClass.getMethod("DownloadEx", IMessageProperties.class, String.class, Integer.TYPE, Boolean.TYPE);
                    Object[] objectArray = new Object[]{this, new String(string), new Integer(1033), new Boolean(bl)};
                    method2.invoke(this.m_contenthandler, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Tracer.traceException(illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    Tracer.traceException(instantiationException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Tracer.traceException(noSuchMethodException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Tracer.traceException(invocationTargetException);
                }
            }
            catch (Exception exception) {
                Tracer.traceException(exception);
                return 0;
            }
        }
        return 1;
    }
}

