/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.OSUtils;
import isus.UpdateServiceException;
import java.io.File;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class JVMUtils {
    private static final boolean isDos = OSUtils.isFamily("dos");
    private static final boolean isNetware = OSUtils.isName("netware");
    private static final boolean isAix = OSUtils.isName("aix");
    private static final String javaHome = System.getProperty("java.home");
    private static String javaVersion;
    private static int javaVersionNumber;
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static boolean isJavaVersion(String string) {
        return javaVersion == string;
    }

    public static String getJreExecutable(String string) throws UpdateServiceException {
        if (isNetware) {
            return string;
        }
        File file = null;
        if (isAix) {
            file = JVMUtils.findInDir(javaHome + "/sh", string);
        }
        if (file == null) {
            file = JVMUtils.findInDir(javaHome + "/bin", string);
        }
        if (file != null) {
            return file.getAbsolutePath();
        }
        return JVMUtils.addExtension(string);
    }

    public static String getJdkExecutable(String string) throws UpdateServiceException {
        if (isNetware) {
            return string;
        }
        File file = null;
        if (isAix) {
            file = JVMUtils.findInDir(javaHome + "/../sh", string);
        }
        if (file == null) {
            file = JVMUtils.findInDir(javaHome + "/../bin", string);
        }
        if (file != null) {
            return file.getAbsolutePath();
        }
        return JVMUtils.getJreExecutable(string);
    }

    private static String addExtension(String string) {
        return string + (isDos ? ".exe" : "");
    }

    private static File findInDir(String string, String string2) throws UpdateServiceException {
        File file = JVMUtils.normalize(string);
        File file2 = null;
        if (file.exists() && !(file2 = new File(file, JVMUtils.addExtension(string2))).exists()) {
            file2 = null;
        }
        return file2;
    }

    public static File normalize(String string) throws UpdateServiceException {
        int n;
        CharSequence charSequence;
        Object object;
        Object object2;
        String string2 = string;
        string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int n2 = string.indexOf(":");
        if (!isNetware) {
            if (!(string.startsWith(File.separator) || string.length() >= 2 && Character.isLetter(string.charAt(0)) && n2 == 1)) {
                String string3 = string + " is not an absolute path";
                throw new UpdateServiceException(string3);
            }
        } else if (!string.startsWith(File.separator) && n2 == -1) {
            String string4 = string + " is not an absolute path";
            throw new UpdateServiceException(string4);
        }
        boolean bl = false;
        String string5 = null;
        if (!isNetware && string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' || isNetware && n2 > -1) {
            bl = true;
            object2 = string.replace('/', '\\').toCharArray();
            object = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                ((StringBuffer)object).append(Character.toUpperCase((char)object2[i]));
            }
            ((StringBuffer)object).append(':');
            if (n2 + 1 < string.length()) {
                ((StringBuffer)object).append(File.separatorChar);
            }
            string5 = ((StringBuffer)object).toString();
            charSequence = new StringBuffer();
            for (n = n2 + 1; n < ((Object)object2).length; ++n) {
                if (object2[n] == 92 && (object2[n] != 92 || object2[n - 1] == 92)) continue;
                ((StringBuffer)charSequence).append((char)object2[n]);
            }
            string = ((StringBuffer)charSequence).toString().replace('\\', File.separatorChar);
        } else if (string.length() == 1) {
            string5 = File.separator;
            string = "";
        } else if (string.charAt(1) == File.separatorChar) {
            string5 = File.separator + File.separator;
            string = string.substring(2);
        } else {
            string5 = File.separator;
            string = string.substring(1);
        }
        object2 = new Stack();
        ((Stack)object2).push(string5);
        object = new StringTokenizer(string, File.separator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            charSequence = ((StringTokenizer)object).nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (((Vector)object2).size() < 2) {
                    throw new UpdateServiceException("Cannot resolve path " + string2);
                }
                ((Stack)object2).pop();
                continue;
            }
            ((Stack)object2).push(charSequence);
        }
        charSequence = new StringBuffer();
        for (n = 0; n < ((Vector)object2).size(); ++n) {
            if (n > 1) {
                ((StringBuffer)charSequence).append(File.separatorChar);
            }
            ((StringBuffer)charSequence).append(((Vector)object2).elementAt(n));
        }
        string = ((StringBuffer)charSequence).toString();
        if (bl) {
            string = string.replace('/', '\\');
        }
        return new File(string);
    }

    static {
        try {
            javaVersion = JAVA_1_0;
            javaVersionNumber = 10;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            ++javaVersionNumber;
            Class.forName("java.lang.ThreadLocal");
            javaVersion = JAVA_1_2;
            ++javaVersionNumber;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
            ++javaVersionNumber;
            Class.forName("java.lang.CharSequence");
            javaVersion = JAVA_1_4;
            ++javaVersionNumber;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

