/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.NameValuePair;
import java.io.IOException;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class HeaderElement
extends NameValuePair {
    private static final BitSet SEPARATORS;
    private static final BitSet TOKEN_CHAR;
    private static final BitSet UNSAFE_CHAR;
    private NameValuePair[] parameters = null;

    public HeaderElement() {
        this(null, null, null);
    }

    public HeaderElement(String string, String string2) {
        this(string, string2, null);
    }

    public HeaderElement(String string, String string2, NameValuePair[] nameValuePairArray) {
        super(string, string2);
        this.setParameters(nameValuePairArray);
    }

    public NameValuePair[] getParameters() {
        return this.parameters;
    }

    protected void setParameters(NameValuePair[] nameValuePairArray) {
        this.parameters = nameValuePairArray;
    }

    public static final HeaderElement[] parse(String string) throws IOException {
        Object object;
        if (string == null) {
            return null;
        }
        Vector<HeaderElement> vector = new Vector<HeaderElement>();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        while (stringTokenizer.countTokens() > 0) {
            object = stringTokenizer.nextToken();
            try {
                while (HeaderElement.hasOddNumberOfQuotationMarks((String)object)) {
                    object = (String)object + "," + stringTokenizer.nextToken();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("Bad header format: wrong number of quotation marks");
            }
            try {
                if (stringTokenizer.hasMoreTokens() && (((String)object).endsWith("Mon") || ((String)object).endsWith("Tue") || ((String)object).endsWith("Wed") || ((String)object).endsWith("Thu") || ((String)object).endsWith("Fri") || ((String)object).endsWith("Sat") || ((String)object).endsWith("Sun") || ((String)object).endsWith("Monday") || ((String)object).endsWith("Tuesday") || ((String)object).endsWith("Wednesday") || ((String)object).endsWith("Thursday") || ((String)object).endsWith("Friday") || ((String)object).endsWith("Saturday") || ((String)object).endsWith("Sunday"))) {
                    object = (String)object + "," + stringTokenizer.nextToken();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("Bad header format: parsing with wrong header elements");
            }
            String string2 = ((String)object).trim();
            if (!string2.endsWith(";")) {
                string2 = string2 + ";";
            }
            char[] cArray = string2.toCharArray();
            boolean bl = false;
            int n = 0;
            HeaderElement headerElement = new HeaderElement();
            Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == ';' && !bl) {
                    NameValuePair nameValuePair = HeaderElement.parsePair(cArray, n, i);
                    if (nameValuePair == null) {
                        throw new IOException("Bad header format: empty name/value pair in" + (String)object);
                    }
                    if (n == 0) {
                        headerElement.setName(nameValuePair.getName());
                        headerElement.setValue(nameValuePair.getValue());
                    } else {
                        vector2.addElement(nameValuePair);
                    }
                    n = i + 1;
                    continue;
                }
                if (cArray[i] != '\"' || bl && i > 0 && cArray[i - 1] == '\\') continue;
                bl = !bl;
            }
            if (vector2.size() > 0) {
                Object[] objectArray = new NameValuePair[vector2.size()];
                vector2.copyInto(objectArray);
                headerElement.setParameters((NameValuePair[])objectArray);
                vector2.removeAllElements();
            }
            vector.addElement(headerElement);
        }
        object = new HeaderElement[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private static final boolean hasOddNumberOfQuotationMarks(String string) {
        boolean bl = false;
        int n = -1;
        while ((n = string.indexOf(34, n + 1)) != -1) {
            bl = !bl;
        }
        return bl;
    }

    private static final NameValuePair parsePair(char[] cArray, int n, int n2) {
        NameValuePair nameValuePair = null;
        String string = new String(cArray, n, n2 - n).trim();
        String string2 = null;
        int n3 = string.indexOf("=");
        if (n3 >= 0) {
            if (n3 + 1 < string.length() && (string2 = string.substring(n3 + 1).trim()).startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            string = string.substring(0, n3).trim();
        }
        nameValuePair = new NameValuePair(string, string2);
        return nameValuePair;
    }

    public NameValuePair getParameterByName(String string) {
        if (string == null) {
            throw new NullPointerException("Name is null");
        }
        NameValuePair nameValuePair = null;
        NameValuePair[] nameValuePairArray = this.getParameters();
        if (nameValuePairArray != null) {
            for (int i = 0; i < nameValuePairArray.length; ++i) {
                NameValuePair nameValuePair2 = nameValuePairArray[i];
                if (!nameValuePair2.getName().equalsIgnoreCase(string)) continue;
                nameValuePair = nameValuePair2;
                break;
            }
        }
        return nameValuePair;
    }

    static {
        int n;
        SEPARATORS = new BitSet(128);
        TOKEN_CHAR = new BitSet(128);
        UNSAFE_CHAR = new BitSet(128);
        SEPARATORS.set(40);
        SEPARATORS.set(41);
        SEPARATORS.set(60);
        SEPARATORS.set(62);
        SEPARATORS.set(64);
        SEPARATORS.set(44);
        SEPARATORS.set(59);
        SEPARATORS.set(58);
        SEPARATORS.set(92);
        SEPARATORS.set(34);
        SEPARATORS.set(47);
        SEPARATORS.set(91);
        SEPARATORS.set(93);
        SEPARATORS.set(63);
        SEPARATORS.set(61);
        SEPARATORS.set(123);
        SEPARATORS.set(125);
        SEPARATORS.set(32);
        SEPARATORS.set(9);
        for (n = 32; n < 127; ++n) {
            TOKEN_CHAR.set(n);
        }
        TOKEN_CHAR.xor(SEPARATORS);
        for (n = 0; n < 32; ++n) {
            UNSAFE_CHAR.set(n);
        }
        UNSAFE_CHAR.set(32);
        UNSAFE_CHAR.set(60);
        UNSAFE_CHAR.set(62);
        UNSAFE_CHAR.set(34);
        UNSAFE_CHAR.set(123);
        UNSAFE_CHAR.set(125);
        UNSAFE_CHAR.set(124);
        UNSAFE_CHAR.set(92);
        UNSAFE_CHAR.set(94);
        UNSAFE_CHAR.set(126);
        UNSAFE_CHAR.set(91);
        UNSAFE_CHAR.set(93);
        UNSAFE_CHAR.set(96);
        UNSAFE_CHAR.set(127);
    }
}

