/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.ICancel;
import isus.IDownloadEvents;
import isus.IDownloadManager;
import isus.ProxyInfo;
import isus.Strings;
import isus.net.AgentURLStreamHandlerFactory;
import isus.shared.Tracer;
import isus.shared.Util;
import isus.util.Progress;
import isus.util.ResumeDownloadDialog;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DownloadManager
implements IDownloadManager,
ICancel {
    private Progress m_progress = null;
    private boolean silent = true;
    private boolean m_throttling = false;
    private Map m_headers_map = null;
    private ProxyInfo m_proxy = null;
    private static final int MAX_DOWNLOAD_SIZE = 40960;
    private static final int START_DOWNLOAD_SIZE = 4096;
    private static final int MIN_DOWNLOAD_SIZE = 512;
    private static final int THROTTLE_UP_PCT = 20;
    private static final int THROTTLE_UP_DELAY = 3;
    private boolean paused = false;
    private String name;
    private String remoteURL;
    private String localFile;
    private List _listeners = new ArrayList();
    private boolean m_bCancel = false;

    public void setProxy(ProxyInfo proxyInfo) {
        this.m_proxy = proxyInfo;
    }

    public void setHeaders(Map map) {
        this.m_headers_map = map;
    }

    public boolean IsReadyToPresent(String string, String string2) {
        File file = new File(string2);
        long l = 0L;
        Tracer.trace(this, "IsReadyToPresent(" + string + ", " + string2 + ") called");
        try {
            URL uRL = null;
            URLConnection uRLConnection = null;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isSpaceChar(c)) {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append("%20");
            }
            uRL = new URL(stringBuffer.toString());
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "ISUA 12.00MP Download Manager");
            if (this.m_proxy != null) {
                this.m_proxy.InitProxy(uRLConnection);
            }
            this.setHeaders(this.m_headers_map, uRLConnection);
            uRLConnection.setDefaultUseCaches(false);
            DataInputStream dataInputStream = null;
            Object var10_12 = null;
            dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            l = uRLConnection.getLastModified();
            boolean bl = false;
            boolean bl2 = false;
            if (file.exists() && uRLConnection.getLastModified() == file.lastModified() && (long)uRLConnection.getContentLength() == file.length()) {
                return true;
            }
        }
        catch (Exception exception) {
            Tracer.traceException(exception);
        }
        return false;
    }

    public void Download(String string, String string2, String string3, boolean bl) throws IOException {
        this.silent = bl;
        this.m_throttling = bl;
        this.name = string;
        this.remoteURL = string2;
        this.localFile = string3;
        this.download();
    }

    /*
     * WARNING - void declaration
     */
    public void download() throws IOException {
        File file = new File(this.localFile);
        long l = 0L;
        if (this.silent) {
            Tracer.trace(this, "Download(" + this.name + ", " + this.remoteURL + ", " + this.localFile + ", true) called");
        } else {
            Tracer.trace(this, "Download(" + this.name + ", " + this.remoteURL + ", " + this.localFile + ", false) called");
        }
        FilterInputStream filterInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            File file2;
            void var9_16;
            Object object;
            int n;
            void var9_11;
            if (this.m_progress == null && !this.silent) {
                this.m_progress = new Progress(this.name, this.name, this);
            }
            this.m_bCancel = false;
            URL uRL = null;
            URLConnection uRLConnection = null;
            StringBuffer stringBuffer = new StringBuffer();
            boolean n2 = false;
            while (var9_11 < this.remoteURL.length()) {
                n = this.remoteURL.charAt((int)var9_11);
                if (!Character.isSpaceChar((char)n)) {
                    stringBuffer.append((char)n);
                } else {
                    stringBuffer.append("%20");
                }
                ++var9_11;
            }
            uRL = new URL(null, stringBuffer.toString(), new AgentURLStreamHandlerFactory().createURLStreamHandler(stringBuffer.toString()));
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "ISUA 12.00MP Download Manager");
            this.setHeaders(this.m_headers_map, uRLConnection);
            if (uRLConnection == null) {
                this._fireDownloadError("File Not Found " + this.remoteURL);
                if (!this.silent) {
                    this.m_progress.setFinish("File Not Found - " + this.remoteURL);
                }
                return;
            }
            if (this.m_proxy != null) {
                this.m_proxy.InitProxy(uRLConnection);
            }
            uRLConnection.setDefaultUseCaches(false);
            filterInputStream = new DataInputStream(uRLConnection.getInputStream());
            l = uRLConnection.getLastModified();
            boolean bl = false;
            n = 0;
            if (file.exists() && uRLConnection.getLastModified() == file.lastModified()) {
                if (!this.silent && !this.paused) {
                    boolean bl2 = true;
                    try {
                        object = Util.getGlobalProperty("ResumePartialDownloadPrompt");
                        if (object != null) {
                            object = ((String)object).trim();
                            boolean bl3 = ((String)object).equalsIgnoreCase("YES");
                            bl2 = false;
                        }
                    }
                    catch (Exception exception) {
                        Tracer.traceException(exception);
                        bl2 = false;
                    }
                    if (bl2) {
                        boolean bl4;
                        object = new ResumeDownloadDialog();
                        ((ResumeDownloadDialog)object).setVisible(true);
                        if (((ResumeDownloadDialog)object).result == 3) {
                            this.Cancel();
                            if (this.m_progress != null) {
                                this.m_progress.actionPerformed(null);
                            }
                            return;
                        }
                        boolean bl5 = bl4 = ((ResumeDownloadDialog)object).result == 1;
                        if (((ResumeDownloadDialog)object).hideCheck.isSelected()) {
                            String string = bl4 ? "YES" : "NO";
                            try {
                                Util.setGlobalProperty("ResumePartialDownloadPrompt", string);
                            }
                            catch (Exception exception) {
                                Tracer.traceException(exception);
                            }
                        }
                    }
                } else {
                    boolean bl6 = true;
                    this.paused = false;
                }
            }
            if (var9_16 != false) {
                n = (int)file.length();
            }
            if (!(file2 = new File(file.getParent())).exists()) {
                file2.mkdirs();
            }
            object = new FileOutputStream(file.toString(), (boolean)var9_16);
            filterOutputStream = new DataOutputStream((OutputStream)object);
            int n3 = 10240;
            if (this.m_throttling) {
                n3 = 4096;
            }
            byte[] byArray = new byte[40970];
            int n4 = uRLConnection.getContentLength();
            if (n4 == n) {
                filterInputStream.close();
                filterOutputStream.close();
                if (!this.silent) {
                    this.m_progress.setTitle(Strings.getUIString("IDS_FINISHED_SINGLEFILE_TITLE"));
                    this.m_progress.StepIt(100);
                }
                if (!this.m_bCancel) {
                    this._fireDownloadComplete();
                }
                Tracer.trace(this, "Download Complete");
                return;
            }
            if (var9_16 != false) {
                filterInputStream.close();
                uRLConnection = null;
                uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("User-Agent", "ISUA 12.00MP Download Manager");
                this.setHeaders(this.m_headers_map, uRLConnection);
                Integer n5 = new Integer(n);
                uRLConnection.setRequestProperty("Range", "bytes=" + n5.toString() + "-");
                uRLConnection.setDefaultUseCaches(false);
                filterInputStream = new DataInputStream(uRLConnection.getInputStream());
            }
            this._fireDownloadBegin();
            int n6 = 0;
            int n7 = -1;
            int n8 = 0;
            int n9 = 0;
            long l2 = 0L;
            boolean bl7 = true;
            long l3 = System.currentTimeMillis() / 1000L;
            long l4 = System.currentTimeMillis();
            while ((n6 = ((DataInputStream)filterInputStream).read(byArray, 0, n3)) != 0) {
                long l5 = System.currentTimeMillis();
                long l6 = l5 / 1000L;
                if (n6 == -1) break;
                ((DataOutputStream)filterOutputStream).write(byArray, 0, n6);
                l2 += (long)n6;
                int n10 = (int)((double)(n += n6) * 100.0 / (double)n4);
                long l7 = 0L;
                long l8 = 0L;
                if (l6 - l3 > 0L) {
                    l7 = (long)((double)l2 / ((double)l6 - (double)l3));
                }
                this._fireDownloadProgress(n10, n4, (int)l7);
                l8 = l7 != 0L ? (long)(((double)n4 - (double)n) / (double)l7) : -1L;
                if (!this.silent) {
                    this.m_progress.StepIt(n, n4, l7, l8);
                }
                if (this.m_bCancel || this.paused) {
                    filterOutputStream.close();
                    if (!this.m_bCancel) break;
                    this._fireDownloadError("Download Cancelled");
                    Tracer.trace(this, "Download cancelled");
                    break;
                }
                if (!this.m_throttling) continue;
                long l9 = l5 - l4;
                if (l9 > 0L) {
                    if (bl7) {
                        if (l9 < 1000L) {
                            n3 = (int)((float)n3 * (1000.0f / (float)l9));
                        }
                    } else if (l9 < 1000L && n3 < 40960) {
                        if (n8 > 3) {
                            n3 = (int)((float)n3 * (1000.0f / (float)l9));
                            n8 = 0;
                        } else {
                            n9 = (int)((float)n3 * (1000.0f / (float)l9)) - n3;
                            n3 += 20 * n9 / 100;
                            ++n8;
                        }
                    } else if (l9 > 1100L) {
                        n8 = 0;
                        n3 = (int)((float)n3 * (1000.0f / (float)l9));
                    }
                    bl7 = false;
                }
                if (n3 > 40960) {
                    n3 = 40960;
                } else if (n3 < 512) {
                    n3 = 512;
                }
                l4 = System.currentTimeMillis();
            }
            if (!this.silent && !this.paused) {
                this.m_progress.setTitle(Strings.getUIString("IDS_FINISHED_SINGLEFILE_TITLE"));
            }
            if (!this.m_bCancel && !this.paused) {
                filterOutputStream.close();
                filterInputStream.close();
                this._fireDownloadComplete();
            }
            Tracer.trace(this, "Download Complete");
        }
        catch (IOException iOException) {
            Tracer.traceException(iOException);
            if (!this.silent) {
                String string = Strings.getUIString("IDS_WININET_ERROR_TEXT");
                string = Util.replaceAll(string, "%s", iOException.getMessage());
                string = Util.replaceAll(string, "%i", "");
                this.m_progress.setFinish(string);
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            this._fireDownloadError("Download Error - " + iOException.getMessage());
        }
        if (this.m_bCancel || this.paused) {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        if (file.exists()) {
            file.setLastModified(l);
        }
    }

    private void setHeaders(Map map, URLConnection uRLConnection) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            uRLConnection.setRequestProperty(string, string2);
        }
    }

    private void _fireDownloadError() {
    }

    public void addDownloadListener(IDownloadEvents iDownloadEvents) {
        this._listeners.add(iDownloadEvents);
    }

    public void removeDownloadListener(IDownloadEvents iDownloadEvents) {
        this._listeners.remove(iDownloadEvents);
    }

    private synchronized boolean _fireDownloadBegin() {
        boolean bl = true;
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext() && bl) {
            bl = ((IDownloadEvents)iterator.next()).OnDownloadBegin();
        }
        return bl;
    }

    private synchronized boolean _fireDownloadComplete() {
        boolean bl = true;
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext() && bl) {
            bl = ((IDownloadEvents)iterator.next()).OnDownloadComplete();
        }
        return bl;
    }

    private synchronized boolean _fireDownloadProgress(int n, int n2, int n3) {
        boolean bl = true;
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext() && bl) {
            bl = ((IDownloadEvents)iterator.next()).OnDownloadProgress(n, n2, n3);
        }
        return bl;
    }

    private synchronized boolean _fireDownloadError(String string) {
        boolean bl = true;
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext() && bl) {
            bl = ((IDownloadEvents)iterator.next()).OnDownloadError(string);
        }
        return bl;
    }

    public void CancelDownload() {
        this.m_bCancel = true;
    }

    public void Cancel() {
        this.m_bCancel = true;
    }

    public void pause() throws IOException {
        if (!this.paused) {
            this.paused = true;
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        DownloadManager.this.download();
                    }
                    catch (IOException iOException) {
                        Tracer.traceException(iOException);
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    public void setDownloadFailedMessage(String string) {
        if (this.m_progress != null) {
            this.m_progress.setFinish(string);
        }
    }
}

