/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.LOG;
import isus.ProcessExec;
import isus.ProcessExecException;
import isus.UpdateServiceException;
import isus.shared.Tracer;
import java.io.File;
import java.util.Vector;

public class CommandLineInterface {
    private String launcher;
    private String updateJar;
    private boolean logging = false;
    private boolean vlog = false;
    private String arguments;

    public static void main(String[] stringArray) {
        try {
            CommandLineInterface commandLineInterface = new CommandLineInterface("C:\\july2003\\02\\_isus\\isus.exe", "C:\\july2003\\02\\_isus\\icebrowserlitebean.jar", "");
            commandLineInterface.setLauncherLogging(true);
            commandLineInterface.runCommand();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CommandLineInterface(String string, String string2, String string3) {
        this.launcher = new File(string).getAbsolutePath();
        LOG.log("launcher path=" + this.launcher);
        this.updateJar = string2;
        this.arguments = string3;
    }

    public void setLauncherLogging(boolean bl) {
        this.logging = bl;
    }

    public void setVerboseLogging(boolean bl) {
        this.vlog = false;
    }

    int runCommand() throws UpdateServiceException {
        try {
            LOG.log("launcher = " + new File(this.launcher).getAbsolutePath());
            LOG.log("updatejar = " + new File(this.updateJar).getAbsolutePath());
            if (!new File(this.launcher).exists() || !new File(this.updateJar).exists()) {
                throw new UpdateServiceException("Either launcher or patch JAR archive does not exist. Update can not run");
            }
            Vector<String> vector = new Vector<String>();
            vector.addElement("-is:javahome");
            vector.addElement(System.getProperty("java.home"));
            vector.addElement("-cp:p");
            vector.addElement(new File(this.updateJar).getAbsolutePath());
            if (this.logging) {
                vector.addElement("-is:log");
                vector.addElement(new File(new File(this.launcher).getParent(), "isus" + Long.toString(System.currentTimeMillis()) + ".log").getAbsolutePath());
            }
            if (this.arguments.length() != 0) {
                vector.addElement(this.arguments);
            }
            int n = vector.size();
            Object[] objectArray = new String[n];
            vector.copyInto(objectArray);
            Tracer.trace(this, "runCommand launcher: " + this.launcher);
            for (int i = 0; i < objectArray.length; ++i) {
                Tracer.trace(this, "runCommand argument: " + (String)objectArray[i]);
            }
            ProcessExec processExec = new ProcessExec(this.launcher, (String[])objectArray);
            processExec.executeProcess();
            return processExec.getExitCode();
        }
        catch (ProcessExecException processExecException) {
            LOG.dumpStack(processExecException);
            throw new UpdateServiceException(processExecException.getMessage());
        }
    }
}

