/*
 * Decompiled with CFR 0.152.
 */
package isus;

import isus.ICalloutEvents;
import isus.IMessageProperties;
import isus.IUpdateEvents;
import isus.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class CalloutHolder
implements IUpdateEvents {
    private ICalloutEvents m_listener;
    private IMessageProperties m_msg;

    public boolean loadCalloutClass(String string) {
        String string2 = this.getClassName(string);
        RuleClassLoader ruleClassLoader = new RuleClassLoader();
        try {
            Class clazz = ruleClassLoader.loadClass(new File(string), string2);
            if (clazz != null) {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                this.m_listener = (ICalloutEvents)constructor.newInstance(new Object[0]);
                if (this.m_listener != null) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            this.logException(exception);
            return false;
        }
        return false;
    }

    public void setMessage(Message message) {
        this.m_msg = message;
    }

    public boolean OnInstallStart() {
        this.m_listener.OnInstallStart(this.m_msg);
        return false;
    }

    public boolean OnInstallEnd(int n) {
        this.m_listener.OnInstallEnd(this.m_msg, n);
        return false;
    }

    public boolean OnDownloadBegin() {
        this.m_listener.OnDownloadBegin(this.m_msg);
        return true;
    }

    public boolean OnDownloadComplete() {
        this.m_listener.OnDownloadComplete(this.m_msg);
        return true;
    }

    public boolean OnDownloadProgress(int n, int n2, int n3) {
        return true;
    }

    public boolean OnDownloadError(String string) {
        return true;
    }

    public boolean OnMessagePending() {
        this.m_listener.OnMessagePending(this.m_msg);
        return true;
    }

    private String getClassName(String string) {
        File file = new File(string);
        String string2 = null;
        try {
            JarFile jarFile = new JarFile(file);
            String string3 = "META-INF/Callouts.properties";
            ZipEntry zipEntry = jarFile.getEntry(string3);
            if (zipEntry != null) {
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                Properties properties = new Properties();
                properties.load(inputStream);
                string2 = properties.getProperty("implementor");
            } else {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry2 = enumeration.nextElement();
                    String string4 = zipEntry2.getName();
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return string2;
    }

    private void logException(Exception exception) {
    }

    private class RuleClassLoader
    extends ClassLoader {
        private File m_fJarFile;

        private RuleClassLoader() {
        }

        private byte[] getBytes(String string) throws IOException {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            long l = file.length();
            byte[] byArray = new byte[(int)l];
            int n = fileInputStream.read(byArray);
            if ((long)n != l) {
                throw new IOException("Can't read");
            }
            fileInputStream.close();
            return byArray;
        }

        public Class loadClass(File file, String string) throws ClassNotFoundException {
            try {
                Class<?> clazz;
                if (file.toString().endsWith(".jar")) {
                    this.m_fJarFile = file;
                    clazz = this.findClass(string);
                } else {
                    byte[] byArray = this.getBytes(file.getAbsolutePath());
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                }
                this.resolveClass(clazz);
                return clazz;
            }
            catch (IOException iOException) {
                CalloutHolder.this.logException(iOException);
                return null;
            }
        }

        public Class findClass(String string) throws ClassNotFoundException {
            Object object;
            if (this.m_fJarFile != null && this.m_fJarFile.isFile()) {
                Object object2;
                boolean bl = false;
                byte[] byArray = null;
                try {
                    object = new JarFile(this.m_fJarFile);
                    object2 = string.replace('.', '/') + ".class";
                    Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
                    while (enumeration.hasMoreElements()) {
                        int n;
                        ZipEntry zipEntry = enumeration.nextElement();
                        if (!((String)object2).equals(zipEntry.getName())) continue;
                        InputStream inputStream = ((JarFile)object).getInputStream(zipEntry);
                        int n2 = (int)zipEntry.getSize();
                        byArray = new byte[n2];
                        for (int i = 0; i < n2; i += n) {
                            n = inputStream.read(byArray, i, n2 - i);
                        }
                        bl = true;
                        break;
                    }
                }
                catch (IOException iOException) {
                    CalloutHolder.this.logException(iOException);
                    bl = false;
                }
                if (bl) {
                    object2 = this.defineClass(string, byArray, 0, byArray.length);
                    return object2;
                }
            }
            object = new ClassNotFoundException();
            throw object;
        }
    }
}

