/*
 * Decompiled with CFR 0.152.
 */
package isus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class AnalyzeVPD {
    private static final String FIELD_DELIMITER = "|";
    private static PrintWriter writer;
    private String major = "";
    private String minor = "";
    private String udpate = "";
    private String maintenance = "";
    private String productInstallDir = "";
    private String VPDUID = "f1256507fb8fe476e88992c0893ffdee";

    public AnalyzeVPD() {
        this.read("c:\\windows\\vpd.temp");
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getUpdate() {
        return this.udpate;
    }

    public String getMaintenance() {
        return this.maintenance;
    }

    public String getProductInstallDir() {
        return this.productInstallDir;
    }

    private void read(String string) {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        Object var4_4 = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            int n = 0;
            while (string2 != null) {
                char c;
                if (string2.trim().length() > 0 && (c = string2.charAt(0)) != '#' && c != '!') {
                    ++n;
                    if (this.findProductInVPD(string2)) break;
                }
                string2 = bufferedReader.readLine();
            }
            System.out.println(n + " software object processed.");
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("vpd file missing");
        }
        catch (IOException iOException) {
            System.err.println("error closing reader stream");
        }
    }

    public static void main(String[] stringArray) {
        AnalyzeVPD analyzeVPD = new AnalyzeVPD();
        System.out.println("major=" + analyzeVPD.getMajor());
        System.out.println("minor=" + analyzeVPD.getMinor());
        System.out.println("update=" + analyzeVPD.getUpdate());
        System.out.println("maintenance=" + analyzeVPD.getMaintenance());
        System.out.println("productInstallDir=" + analyzeVPD.getProductInstallDir());
    }

    private boolean findProductInVPD(String string) {
        int n = string.indexOf(61);
        if (this.loadSoftwareObjectKey(string.substring(0, n))) {
            this.getSoftwareObjectLocation(string.substring(n + 1));
            return true;
        }
        return false;
    }

    private void getSoftwareObjectLocation(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_DELIMITER, false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name = " + this.getFieldValue(stringTokenizer));
        stringBuffer.append("DisplayName =" + this.getFieldValue(stringTokenizer));
        stringBuffer.append("Description = " + this.getFieldValue(stringTokenizer));
        stringBuffer.append("Vendor =" + this.getFieldValue(stringTokenizer));
        stringBuffer.append("VendorWebsite = " + this.getFieldValue(stringTokenizer));
        stringBuffer.append("ProductNumber = " + this.getFieldValue(stringTokenizer));
        this.productInstallDir = this.getFieldValue(stringTokenizer);
        stringBuffer.append("InstallLocation = " + this.productInstallDir);
    }

    private boolean loadSoftwareObjectKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_DELIMITER, false);
        StringBuffer stringBuffer = new StringBuffer();
        return this.loadSoftwareObject(stringTokenizer, stringBuffer);
    }

    private boolean loadSoftwareObject(StringTokenizer stringTokenizer, StringBuffer stringBuffer) {
        String string = this.getFieldValue(stringTokenizer);
        if (string.equals(this.VPDUID)) {
            stringBuffer.append("uid=" + string);
            this.loadSoftwareVersion(stringTokenizer, stringBuffer);
            return true;
        }
        return false;
    }

    private void loadSoftwareVersion(StringTokenizer stringTokenizer, StringBuffer stringBuffer) {
        this.major = this.getFieldValue(stringTokenizer);
        stringBuffer.append("major=" + this.major);
        this.minor = this.getFieldValue(stringTokenizer);
        stringBuffer.append("minor=" + this.minor);
        this.udpate = this.getFieldValue(stringTokenizer);
        stringBuffer.append("update=" + this.udpate);
        this.maintenance = this.getFieldValue(stringTokenizer);
        stringBuffer.append("maintenance=" + this.maintenance);
    }

    private String getFieldValue(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        if (string.trim().length() == 0) {
            string = "";
        }
        return string;
    }
}

