/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.USFileSync;

import com.installshield.USFileSync.HttpFile;
import com.installshield.USFileSync.IContentHandler;
import com.installshield.USFileSync.PartialInputStream;
import com.installshield.USFileSync.USZipEntry;
import isus.Agent;
import isus.ICancel;
import isus.IDownloadEvents;
import isus.IMessageProperties;
import isus.IUpdateEvents;
import isus.Message;
import isus.Strings;
import isus.shared.Tracer;
import isus.util.Progress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class USFileSync
implements IContentHandler,
ICancel {
    USZipEntry[] entries;
    String baseUrl;
    int MaxFileOffset;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private static final long LOCSIG = 67324752L;
    private static final long CENSIG = 33639248L;
    private static final int BUFSIZE = 10240;
    private EventHandler evtHandler = new EventHandler();
    private String m_productname = "InstallShield Professional";
    private String m_subject = "Object Gallery";
    private Progress m_progress = null;
    private boolean m_bCancel = false;
    private boolean paused = false;
    private String pausedURL;
    private String pausedLocaldir;
    private boolean pausedSilent;

    public void FileSyncEx(final String url, final String localdir, final boolean silent, final String szTemp) {
        Runnable fsync = new Runnable(){

            public void run() {
                USFileSync.this.FileSyncImpl(url, localdir, silent, szTemp);
            }
        };
        new Thread(fsync).start();
    }

    public void FileSync(final String url, final String localdir, final boolean silent) {
        Runnable fsync = new Runnable(){

            public void run() {
                USFileSync.this.FileSyncImpl(url, localdir, silent, null);
            }
        };
        new Thread(fsync).start();
    }

    public void FileSyncImpl(String url, String localdir, boolean silent, String szTempLoc) {
        try {
            this.pausedURL = url;
            this.pausedLocaldir = localdir;
            this.pausedSilent = silent;
            this.m_bCancel = false;
            String szTemp = null;
            if (szTempLoc != null && szTempLoc.length() > 0) {
                szTemp = szTempLoc;
            }
            if (this.m_progress == null && !silent) {
                this.m_progress = new Progress(this.m_subject, this.m_productname, this);
                this.m_progress.HideXfrRate();
            }
            this.evtHandler._fireDownloadBegin();
            if (!this.Load(url)) {
                if (this.m_bCancel) {
                    this.evtHandler._fireDownloadComplete();
                    return;
                }
                if (!silent) {
                    this.m_progress.setFinish("File Not Found - " + url);
                }
            }
            double percent = 0.0;
            double incr = 100.0;
            double uTotalSoFar = 0.0;
            double uTotalToDo = 0.0;
            if (this.getSize() > 0) {
                incr = 100.0 / (double)this.getSize();
            }
            for (int i = 0; i < this.getSize(); ++i) {
                USZipEntry z = this.getEntry(i);
                if (!z.isDirectory()) {
                    String dstFname;
                    String fname = localdir;
                    String string = dstFname = szTemp == null ? localdir : szTemp;
                    if (!(fname.endsWith(File.separator) || z.getName().startsWith(File.separator) || z.getName().startsWith("/"))) {
                        fname = fname + File.separator;
                    }
                    if (!(dstFname.endsWith(File.separator) || z.getName().startsWith(File.separator) || z.getName().startsWith("/"))) {
                        dstFname = dstFname + File.separator;
                    }
                    fname = fname + z.getName();
                    dstFname = dstFname + z.getName();
                    fname = fname.replace('/', File.separatorChar);
                    dstFname = dstFname.replace('/', File.separatorChar);
                    File tmpz = new File(fname);
                    File tmpx = new File(dstFname);
                    boolean bDownload = true;
                    if (USFileSync.getCRC(fname) == z.getCrc()) {
                        bDownload = false;
                    }
                    if (bDownload) {
                        File tmp1;
                        if (szTemp == null) {
                            if (tmpz.getParentFile() != null) {
                                tmp1 = new File(tmpz.getParentFile().getAbsolutePath());
                                tmp1.mkdirs();
                            }
                        } else if (tmpx.getParentFile() != null) {
                            tmp1 = new File(tmpx.getParentFile().getAbsolutePath());
                            tmp1.mkdirs();
                        }
                        Tracer.trace(this, "Now downloading " + tmpz.getAbsolutePath());
                        if (!silent) {
                            this.m_progress.SetProgressMessage(z.getName());
                        }
                        this.evtHandler._fireDownloadProgress((int)percent, 0, 0);
                        InputStream in = this.GetInputStream(z);
                        File tmp = new File(szTemp == null ? fname : dstFname);
                        FileOutputStream fo = new FileOutputStream(tmp);
                        DataOutputStream out = new DataOutputStream(fo);
                        uTotalToDo = z.getSize();
                        uTotalSoFar = 0.0;
                        int bytestoread = (int)(uTotalToDo - uTotalSoFar > 10240.0 ? 10240.0 : uTotalToDo - uTotalSoFar);
                        int bytesread = 0;
                        byte[] bucket = new byte[10241];
                        while ((bytesread = in.read(bucket, 0, bytestoread)) > 0) {
                            out.write(bucket, 0, bytesread);
                            bytestoread = (int)(uTotalToDo - uTotalSoFar > 10240.0 ? 10240.0 : uTotalToDo - (uTotalSoFar += (double)bytesread));
                            percent = incr * (double)i + incr * uTotalSoFar / uTotalToDo;
                            this.evtHandler._fireDownloadProgress((int)percent, 0, 0);
                            if (this.m_bCancel || this.paused) break;
                            if (!silent) {
                                this.m_progress.StepIt((int)percent);
                            }
                            if (!(uTotalSoFar >= uTotalToDo)) continue;
                        }
                        out.close();
                        in.close();
                    } else {
                        Tracer.trace(this, "Skipping " + tmpz.getAbsolutePath());
                        this.evtHandler._fireDownloadProgress((int)(percent += incr), 0, 0);
                        if (this.m_bCancel || this.paused) break;
                        if (!silent) {
                            this.m_progress.StepIt((int)percent);
                        }
                    }
                    if (!this.m_bCancel && !this.paused) continue;
                    break;
                }
                this.evtHandler._fireDownloadProgress((int)(percent += incr), 0, 0);
                if (!this.m_bCancel && !this.paused) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String sErr = Strings.getUIString("IDS_E_HTTP");
            sErr = this.replaceString(sErr, "%d", e.toString());
            if (!this.m_bCancel && !silent) {
                this.m_progress.setFinish(sErr);
            }
            this.evtHandler._fireDownloadError(sErr);
            Tracer.trace(this, sErr);
            return;
        }
        if (!this.m_bCancel && !this.paused) {
            this.evtHandler._fireDownloadComplete();
        } else if (this.m_bCancel) {
            this.evtHandler._fireDownloadError(Strings.getUIString("IDS_E_USER_CANCEL"));
        }
        if (!this.m_bCancel && !this.paused) {
            if (!silent) {
                this.m_progress.setFinish("");
                this.m_progress.setTitle(Strings.getUIString("IDS_FINISHED_SINGLEFILE_TITLE"));
            }
        } else if (this.m_bCancel && !silent) {
            this.m_progress.setFinish(Strings.getUIString("IDS_E_USER_CANCEL"));
        }
        Tracer.trace(this, Strings.getUIString("IDS_FINISHED_SINGLEFILE_TITLE"));
    }

    public boolean IsFileSyncRequired(String url, String localdir) {
        try {
            int posEnd;
            int posStart;
            String rghtpart;
            String leftpart;
            if (localdir.indexOf("<TARGETDIR>") >= 0) {
                Agent a = new Agent();
                String resolved = a.getDatabaseDir();
                if (resolved != null) {
                    int posStart2 = localdir.indexOf("<TARGETDIR>");
                    int posEnd2 = posStart2 + 11;
                    leftpart = localdir.substring(0, posStart2);
                    rghtpart = localdir.substring(posEnd2);
                    localdir = leftpart + resolved + rghtpart;
                }
            } else if (localdir.indexOf("<") >= 0 && localdir.indexOf(">") > 0 && (posStart = localdir.indexOf(60)) < (posEnd = localdir.indexOf(62))) {
                String macro = localdir.substring(posStart + 1, posEnd);
                String resolved = System.getProperty(macro);
                if (resolved != null) {
                    leftpart = localdir.substring(0, posStart);
                    rghtpart = localdir.substring(posEnd + 1);
                    localdir = leftpart + resolved + rghtpart;
                } else {
                    resolved = System.getenv(macro);
                    if (resolved != null) {
                        leftpart = localdir.substring(0, posStart);
                        rghtpart = localdir.substring(posEnd + 1);
                        localdir = leftpart + resolved + rghtpart;
                    }
                }
            }
            if (!this.Load(url)) {
                return true;
            }
            for (int i = 0; i < this.getSize(); ++i) {
                USZipEntry z = this.getEntry(i);
                if (z.isDirectory()) continue;
                String fname = localdir;
                if (!(fname.endsWith(File.separator) || z.getName().startsWith(File.separator) || z.getName().startsWith("/"))) {
                    fname = fname + File.separator;
                }
                fname = fname + z.getName();
                if (USFileSync.getCRC(fname = fname.replace('/', File.separatorChar)) == z.getCrc()) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public void addDownloadListener(IDownloadEvents e) {
        this.evtHandler.addDownloadListener(e);
    }

    public void removeDownloadListener(IDownloadEvents e) {
        this.evtHandler.removeDownloadListener(e);
    }

    public static void main(String[] args) {
        USFileSync r = new USFileSync();
        String str = "http://sunny/eclipse-SDK-3.1-win32.zip";
        if (args.length == 1) {
            str = args[0];
        }
        if (r.IsFileSyncRequired(str, "c:\\temp\\")) {
            System.out.println("File Sync is required.");
            r.FileSync(str, "c:\\temp\\", false);
        } else {
            System.out.println("File Sync is NOT required.");
        }
    }

    private static long getCRC(String name) throws IOException {
        File tmp = new File(name);
        if (tmp.isFile()) {
            FileInputStream fo;
            CRC32 crc = new CRC32();
            crc.reset();
            try {
                fo = new FileInputStream(tmp);
            }
            catch (FileNotFoundException e) {
                return 0L;
            }
            DataInputStream in = new DataInputStream(fo);
            int bytestoread = 40960;
            int bytesread = 0;
            byte[] bucket = new byte[40961];
            while ((bytesread = in.read(bucket, 0, bytestoread)) > 0) {
                crc.update(bucket, 0, bytesread);
            }
            in.close();
            return crc.getValue();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Load(String url) throws IOException {
        int CentralOffset = 0;
        int CentralSize = 0;
        int TotalEntries = 0;
        CentralDir c = new CentralDir();
        if (!this.FindCentralDirectory(url, c)) {
            return false;
        }
        CentralOffset = c.getCentralOffset();
        CentralSize = c.getCentralSize();
        TotalEntries = c.getTotalEntries();
        this.MaxFileOffset = CentralOffset;
        this.baseUrl = url;
        this.entries = new USZipEntry[TotalEntries];
        HttpFile req = new HttpFile(url);
        req.AddRange(CentralOffset, CentralOffset + CentralSize);
        PartialInputStream res = req.GetInputStream();
        try {
            for (int i = 0; i < TotalEntries; ++i) {
                if (this.m_bCancel) {
                    ((InputStream)res).close();
                    boolean bl = false;
                    return bl;
                }
                if ((long)this.ReadLeInt(res) != 33639248L) {
                    throw new ZipException("Wrong Central Directory signature");
                }
                this.ReadLeInt(res);
                this.ReadLeShort(res);
                int method = this.ReadLeShort(res);
                int dostime = this.ReadLeInt(res);
                int crc = this.ReadLeInt(res);
                int csize = this.ReadLeInt(res);
                int size = this.ReadLeInt(res);
                int nameLen = this.ReadLeShort(res);
                int extraLen = this.ReadLeShort(res);
                int commentLen = this.ReadLeShort(res);
                this.ReadLeInt(res);
                this.ReadLeInt(res);
                int offset = this.ReadLeInt(res);
                byte[] buffer = new byte[nameLen > commentLen ? nameLen : commentLen];
                USFileSync.ReadAll(buffer, 0, nameLen, res);
                String name = new String(buffer);
                USZipEntry entry = new USZipEntry(name);
                entry.setMethod(method);
                entry.setCrc((long)crc & 0xFFFFFFFFL);
                entry.setSize((long)size & 0xFFFFFFFFL);
                entry.setCompressedSize((long)csize & 0xFFFFFFFFL);
                entry.setTime(dostime);
                if (extraLen > 0) {
                    byte[] extra = new byte[extraLen];
                    USFileSync.ReadAll(extra, 0, extraLen, res);
                    entry.setExtra(extra);
                }
                if (commentLen > 0) {
                    USFileSync.ReadAll(buffer, 0, commentLen, res);
                    entry.setComment(new String(buffer));
                }
                entry.setIndex(i);
                entry.setOffset(offset);
                this.entries[i] = entry;
            }
        }
        finally {
            ((InputStream)res).close();
        }
        return true;
    }

    synchronized void SkipLocalHeader(InputStream baseStream, ZipEntry entry) throws IOException {
        if ((long)this.ReadLeInt(baseStream) != 67324752L) {
            throw new ZipException("Wrong Local header signature");
        }
        USFileSync.Skip(baseStream, 22);
        int namelen = this.ReadLeShort(baseStream);
        int extralen = this.ReadLeShort(baseStream);
        USFileSync.Skip(baseStream, namelen + extralen);
    }

    public boolean FindCentralDirectory(String url, CentralDir c) throws IOException {
        block7: {
            int pos;
            byte[] bb;
            int currentLength = 256;
            c.setTotalEntries(0);
            c.setCentralSize(0);
            c.setCentralOffset(-1);
            while (true) {
                HttpFile req = new HttpFile(url);
                req.AddRange(-(currentLength + 22));
                PartialInputStream res = req.GetInputStream();
                if (this.m_bCancel) {
                    return false;
                }
                bb = new byte[req.getContentLength()];
                int endSize = USFileSync.ReadAll(bb, 0, req.getContentLength(), res);
                res.close();
                pos = endSize - 22;
                while (pos >= 0) {
                    if (bb[pos] == 80) {
                        if (bb[pos + 1] == 75 && bb[pos + 2] == 5 && bb[pos + 3] == 6) break;
                        pos -= 4;
                        continue;
                    }
                    --pos;
                }
                if (pos >= 0) break;
                if (currentLength != 65536) {
                    if (currentLength == 1024) {
                        currentLength = 65536;
                        continue;
                    }
                    if (currentLength == 256) {
                        currentLength = 1024;
                        continue;
                    }
                }
                break block7;
                break;
            }
            c.setCentralSize(USFileSync.MakeInt(bb, pos + 12));
            c.setCentralOffset(USFileSync.MakeInt(bb, pos + 16));
            c.setTotalEntries(USFileSync.MakeShort(bb, pos + 10));
            return true;
        }
        return false;
    }

    public InputStream GetInputStream(USZipEntry entry) throws IOException {
        if (entry.getSize() == 0L) {
            return null;
        }
        if (this.entries == null) {
            throw new ZipException("ZipFile has closed");
        }
        int index = entry.getIndex();
        if (index < 0 || index >= this.entries.length || this.entries[index].getName() != entry.getName()) {
            throw new IndexOutOfBoundsException();
        }
        HttpFile req = new HttpFile(this.baseUrl);
        int limit = (int)((long)entry.getOffset() + entry.getCompressedSize() + 16L + 131072L);
        if (limit >= this.MaxFileOffset) {
            limit = this.MaxFileOffset - 1;
        }
        req.AddRange(entry.getOffset(), limit);
        PartialInputStream baseStream = req.GetInputStream();
        this.SkipLocalHeader(baseStream, this.entries[index]);
        int method = this.entries[index].getMethod();
        PartialInputStream istr = new PartialInputStream(baseStream, this.entries[index].getCompressedSize());
        switch (method) {
            case 0: {
                return istr;
            }
            case 8: {
                return new InflaterInputStream(istr, new Inflater(true));
            }
        }
        throw new ZipException("Unknown compression method " + method);
    }

    int ReadLeShort(InputStream s) throws IOException {
        return s.read() | s.read() << 8;
    }

    int ReadLeInt(InputStream s) throws IOException {
        return this.ReadLeShort(s) | this.ReadLeShort(s) << 16;
    }

    static void Skip(InputStream s, int n) throws IOException {
        s.skip(n);
    }

    static int ReadAll(byte[] bb, int p, int sst, InputStream s) throws IOException {
        int ss = 0;
        while (ss < sst) {
            int r = s.read(bb, p, sst - ss);
            if (r <= 0) {
                return ss;
            }
            ss += r;
            p += r;
        }
        return ss;
    }

    public static int MakeInt(byte[] bb, int pos) {
        return bb[pos + 0] & 0xFF | (bb[pos + 1] & 0xFF) << 8 | (bb[pos + 2] & 0xFF) << 16 | (bb[pos + 3] & 0xFF) << 24;
    }

    public static int MakeShort(byte[] bb, int pos) {
        return bb[pos + 0] & 0xFF | (bb[pos + 1] & 0xFF) << 8;
    }

    public int getSize() {
        return this.entries == null ? 0 : this.entries.length;
    }

    public USZipEntry getEntry(int index) {
        return this.entries[index];
    }

    public void CloseEntry() {
    }

    public int read() throws IOException {
        System.out.println("This should not be called");
        return 0;
    }

    public long GetHandlerAttributes() {
        return 7L;
    }

    public boolean DownloadEx(IMessageProperties pMessage, String szTempLoc, int langid, boolean bSilent) {
        return this.DownloadImpl(pMessage, langid, bSilent, szTempLoc);
    }

    public boolean Download(IMessageProperties pMessage, int langid, boolean bSilent) {
        return this.DownloadImpl(pMessage, langid, bSilent, "");
    }

    public boolean DownloadImpl(IMessageProperties pMessage, int langid, boolean bSilent, String szTempLoc) {
        int posEnd;
        int posStart;
        String localdir = pMessage.getLocalSyncDir();
        if (localdir == null) {
            localdir = ".";
        }
        this.m_subject = pMessage.getTitle();
        if (this.m_subject == null) {
            this.m_subject = "File Synchronization";
        }
        this.m_productname = pMessage.getProductName();
        Message m = (Message)pMessage;
        if (localdir.indexOf("<TARGETDIR>") >= 0) {
            Agent a = new Agent();
            String resolved = a.getDatabaseDir();
            if (resolved != null) {
                int posStart2 = localdir.indexOf("<TARGETDIR>");
                int posEnd2 = posStart2 + 11;
                String leftpart = localdir.substring(0, posStart2);
                String rghtpart = localdir.substring(posEnd2);
                localdir = leftpart + resolved + rghtpart;
            }
        } else if (localdir.indexOf("<") >= 0 && localdir.indexOf(">") > 0 && (posStart = localdir.indexOf(60)) < (posEnd = localdir.indexOf(62))) {
            String macro = localdir.substring(posStart + 1, posEnd);
            String resolved = System.getProperty(macro);
            if (resolved != null) {
                String leftpart = localdir.substring(0, posStart);
                String rghtpart = localdir.substring(posEnd + 1);
                localdir = leftpart + resolved + rghtpart;
            } else {
                resolved = System.getenv(macro);
                if (resolved != null) {
                    String leftpart = localdir.substring(0, posStart);
                    String rghtpart = localdir.substring(posEnd + 1);
                    localdir = leftpart + resolved + rghtpart;
                }
            }
        }
        this.FileSyncEx(pMessage.getDownloadURL(), localdir, bSilent, szTempLoc);
        return true;
    }

    public boolean Execute(IMessageProperties pMessage, int langid, boolean bSilent) {
        this.evtHandler._fireInstallStart();
        this.evtHandler._fireInstallEnd(0);
        return true;
    }

    public synchronized void Cancel() {
        this.m_bCancel = true;
    }

    public synchronized void pause() {
        if (!this.paused) {
            this.paused = true;
        } else {
            this.paused = false;
            this.FileSync(this.pausedURL, this.pausedLocaldir, this.pausedSilent);
        }
    }

    private String replaceString(String src, String substr, String substitute) {
        int posStart = src.indexOf(substr);
        int posEnd = posStart + substr.length();
        String leftpart = src.substring(0, posStart);
        String rghtpart = src.substring(posEnd);
        return leftpart + substitute + rghtpart;
    }

    class EventHandler {
        private List _listeners = new ArrayList();

        public void addDownloadListener(IDownloadEvents e) {
            this._listeners.add(e);
        }

        public void removeDownloadListener(IDownloadEvents e) {
            this._listeners.remove(e);
        }

        private synchronized boolean _fireDownloadBegin() {
            boolean bContinue = true;
            Iterator listeners = this._listeners.iterator();
            while (listeners.hasNext() && bContinue) {
                bContinue = ((IDownloadEvents)listeners.next()).OnDownloadBegin();
            }
            return bContinue;
        }

        private synchronized boolean _fireDownloadComplete() {
            boolean bContinue = true;
            Iterator listeners = this._listeners.iterator();
            while (listeners.hasNext() && bContinue) {
                bContinue = ((IDownloadEvents)listeners.next()).OnDownloadComplete();
            }
            return bContinue;
        }

        private synchronized boolean _fireDownloadProgress(int p, int ts, int tr) {
            boolean bContinue = true;
            Iterator listeners = this._listeners.iterator();
            while (listeners.hasNext() && bContinue) {
                bContinue = ((IDownloadEvents)listeners.next()).OnDownloadProgress(p, ts, tr);
            }
            return bContinue;
        }

        private synchronized boolean _fireDownloadError(String s) {
            boolean bContinue = true;
            Iterator listeners = this._listeners.iterator();
            while (listeners.hasNext() && bContinue) {
                bContinue = ((IDownloadEvents)listeners.next()).OnDownloadError(s);
            }
            return bContinue;
        }

        private synchronized void _fireInstallStart() {
            Iterator listeners = this._listeners.iterator();
            while (listeners.hasNext()) {
                ((IUpdateEvents)listeners.next()).OnInstallStart();
            }
        }

        private synchronized void _fireInstallEnd(int rc) {
            Iterator listeners = this._listeners.iterator();
            while (listeners.hasNext()) {
                ((IUpdateEvents)listeners.next()).OnInstallEnd(rc);
            }
        }
    }

    class CentralDir {
        private int CentralOffset;
        private int CentralSize;
        private int TotalEntries;

        CentralDir() {
        }

        public void setCentralOffset(int centralOffset) {
            this.CentralOffset = centralOffset;
        }

        public int getCentralOffset() {
            return this.CentralOffset;
        }

        public void setCentralSize(int centralSize) {
            this.CentralSize = centralSize;
        }

        public int getCentralSize() {
            return this.CentralSize;
        }

        public void setTotalEntries(int totalEntries) {
            this.TotalEntries = totalEntries;
        }

        public int getTotalEntries() {
            return this.TotalEntries;
        }
    }
}

