/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.USFileSync;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PartialInputStream
extends DataInputStream {
    InputStream baseStream;
    long filepos;
    long end;

    public PartialInputStream(InputStream baseStream, long len) {
        super(baseStream);
        this.baseStream = baseStream;
        this.filepos = 0L;
        this.end = len;
    }

    public synchronized int ReadByte() throws IOException {
        if (this.filepos == this.end) {
            return -1;
        }
        ++this.filepos;
        return this.baseStream.read();
    }

    public synchronized int Read(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.end - this.filepos && (len = (int)(this.end - this.filepos)) == 0) {
            return 0;
        }
        int count = this.baseStream.read(b, off, len);
        if (count > 0) {
            this.filepos += (long)len;
        }
        return count;
    }

    public long SkipBytes(long amount) throws IOException {
        if (amount < 0L) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (amount > this.end - this.filepos) {
            amount = this.end - this.filepos;
        }
        this.filepos += amount;
        int i = 0;
        while ((long)i < amount) {
            this.baseStream.read();
            ++i;
        }
        return amount;
    }

    public void Close() throws IOException {
        this.baseStream.close();
    }
}

