/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.USFileSync;

import com.installshield.USFileSync.PartialInputStream;
import isus.net.AgentURLStreamHandlerFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class HttpFile {
    private PartialInputStream m_in = null;
    private URLConnection m_yc = null;
    private int m_length = -1;
    private URL m_yahoo = null;
    private String m_url = null;

    public HttpFile(String url) throws IOException {
        this.m_url = url;
    }

    public static int getContentsLength(String url) throws IOException {
        URL yahoo = new URL(url);
        URLConnection yc = yahoo.openConnection();
        yc.setRequestProperty("User-Agent", "ISUA 12.00MP Download Manager");
        yc.setDefaultUseCaches(true);
        return yc.getContentLength();
    }

    private void CreateConnection() throws IOException {
        this.m_yahoo = new URL(null, this.m_url, new AgentURLStreamHandlerFactory().createURLStreamHandler(this.m_url));
        this.m_yc = this.m_yahoo.openConnection();
        this.m_yc.setRequestProperty("User-Agent", "ISUA 12.00MP Download Manager");
        this.m_yc.setDefaultUseCaches(false);
        this.m_in = null;
    }

    private boolean isConnected() {
        return this.m_yc != null;
    }

    private void ensureOpen() throws IOException {
        if (!this.isConnected()) {
            this.CreateConnection();
        }
    }

    public int getContentLength() throws IOException {
        this.ensureOpen();
        if (this.m_in == null) {
            return this.m_length;
        }
        this.m_length = this.m_yc.getContentLength();
        return this.m_length;
    }

    public PartialInputStream GetInputStream() throws IOException {
        DataInputStream i = new DataInputStream(this.m_yc.getInputStream());
        this.m_in = new PartialInputStream(i, this.m_yc.getContentLength());
        return this.m_in;
    }

    public void AddRange(int i) throws IOException {
        this.ensureOpen();
        if (i >= 0) {
            this.m_yc.setRequestProperty("Range", "bytes=" + new Integer(i).toString() + "-");
        } else {
            this.m_yc.setRequestProperty("Range", "bytes=" + new Integer(HttpFile.getContentsLength(this.m_url) + i).toString() + "-");
        }
    }

    public void AddRange(int centralOffset, int i) throws IOException {
        this.ensureOpen();
        this.m_yc.setRequestProperty("Range", "bytes=" + new Integer(centralOffset).toString() + "-" + new Integer(i).toString());
    }
}

