/*
 * Decompiled with CFR 0.152.
 */
package com.intel.remmon;

import com.intel.remmon.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class LegalDialog
extends JDialog {
    public static final int STATUS_ALLOWED = 100;
    public static final int STATUS_NOT_ALLOWED = 200;
    public static final int STATUS_UNKNOWN = 2;
    private int rCode;
    private boolean shouldExit;
    private boolean isAllowed;
    private ButtonGroup buttonGroup1;
    private JPanel jButtonsPanel;
    private JButton jCancelButton;
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JRadioButton jNoRadioButton;
    private JButton jOkButton;
    private JPanel jQuestionPanel;
    private JScrollPane jScrollPane1;
    private JPanel jTitlePanel;
    private JRadioButton jYesRadioButton;

    public LegalDialog(Frame parent, boolean modal, boolean shouldExit) {
        super(parent, modal);
        this.initComponents();
        if (this.isInitialStatusCollect()) {
            this.isAllowed = true;
            this.jYesRadioButton.setSelected(true);
        } else {
            this.isAllowed = false;
            this.jNoRadioButton.setSelected(true);
        }
        this.shouldExit = shouldExit;
        this.rCode = this.isAllowed ? 100 : 200;
        Font font = UIManager.getFont("Label.font");
        String cssFont = "body { font-family:" + font.getFamily() + "; font-size: " + font.getSize() + "pt;}";
        ((HTMLDocument)this.jEditorPane1.getDocument()).getStyleSheet().addRule(cssFont);
        this.setIconImage(new ImageIcon(LegalDialog.class.getResource("/com/intel/remmon/app_icon_32x32.png")).getImage());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTitlePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.jQuestionPanel = new JPanel();
        this.jYesRadioButton = new JRadioButton();
        this.jNoRadioButton = new JRadioButton();
        this.jButtonsPanel = new JPanel();
        this.jOkButton = new JButton();
        this.jCancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Intel\u00ae Software Improvement Program");
        this.setMinimumSize(new Dimension(400, 200));
        this.setName("legalDialog");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTitlePanel.setBackground(Color.white);
        this.jTitlePanel.setLayout(new BorderLayout());
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("<html><b>Help improve your experience with Intel&reg; software</b></html>");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jTitlePanel.add((Component)this.jLabel1, "North");
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jEditorPane1.setBorder(null);
        this.jEditorPane1.setContentType("text/html");
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setText("<html>\nParticipate in the design of future Intel software. Click 'Yes' to give us permission to learn about how  you use your Intel software and we will do the rest.<br>\n<ul>\n<li>No personally identifiable information is collected<br>\n<li>There are no additional follow-up emails by opting in<br>\n<li>You can stop participating at any time<br><br>\n<a href=\"http://software.intel.com/en-us/articles/software-improvement-program\">Learn more</a> about the Intel&reg; Software Improvement Program\n</ul>\n<b>With your permission, Intel may automatically receive anonymous information about how you use your current and future Intel&reg; Software Development Products.</b>\n</html>\n");
        this.jEditorPane1.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                LegalDialog.this.jEditorPane1HyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.jTitlePanel.add((Component)this.jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        this.getContentPane().add((Component)this.jTitlePanel, gridBagConstraints);
        this.jQuestionPanel.setBackground(Color.white);
        this.jQuestionPanel.setLayout(new BoxLayout(this.jQuestionPanel, 3));
        this.jYesRadioButton.setBackground(Color.white);
        this.buttonGroup1.add(this.jYesRadioButton);
        this.jYesRadioButton.setFont(new Font("Dialog", 0, 12));
        this.jYesRadioButton.setText("<html>Yes, I am willing to participate and improve Intel software. (Recommended)</html>");
        this.jYesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegalDialog.this.jYesRadioButtonActionPerformed(evt);
            }
        });
        this.jQuestionPanel.add(this.jYesRadioButton);
        this.jNoRadioButton.setBackground(Color.white);
        this.buttonGroup1.add(this.jNoRadioButton);
        this.jNoRadioButton.setFont(new Font("Dialog", 0, 12));
        this.jNoRadioButton.setSelected(true);
        this.jNoRadioButton.setText("<html>No, I don't want to participate in the Intel&reg; Software Improvement Program at this time.</html>");
        this.jNoRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegalDialog.this.jNoRadioButtonActionPerformed(evt);
            }
        });
        this.jQuestionPanel.add(this.jNoRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jQuestionPanel, gridBagConstraints);
        this.jButtonsPanel.setBackground(Color.white);
        this.jButtonsPanel.setLayout(new FlowLayout(2));
        this.jOkButton.setText("OK");
        this.jOkButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                LegalDialog.this.jOkButtonMouseReleased(evt);
            }
        });
        this.jButtonsPanel.add(this.jOkButton);
        this.jCancelButton.setText("Cancel");
        this.jCancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                LegalDialog.this.jCancelButtonMouseReleased(evt);
            }
        });
        this.jButtonsPanel.add(this.jCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jButtonsPanel, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 566) / 2, (screenSize.height - 308) / 2, 566, 308);
    }

    private boolean isInitialStatusCollect() {
        String remotemon = "";
        String path_to_jar = new File(LegalDialog.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
        try {
            path_to_jar = new File(URLDecoder.decode(LegalDialog.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")).getParent();
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (Tools.isMac()) {
            remotemon = path_to_jar + "/universal_mac10/intelremotemon";
        } else {
            switch (Tools.getArch()) {
                case IA32: {
                    remotemon = path_to_jar + "/ia32/intelremotemon";
                    break;
                }
                case INTEL64: {
                    remotemon = path_to_jar + "/intel64/intelremotemon";
                }
            }
        }
        int exitCode = 1;
        if (!remotemon.isEmpty()) {
            try {
                String[] cmd = new String[]{remotemon, "-g"};
                Process proc = Runtime.getRuntime().exec(cmd);
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                }
                try {
                    exitCode = proc.waitFor();
                }
                catch (InterruptedException ex) {}
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return exitCode == 0;
    }

    private int getExitCode() {
        if (this.isAllowed) {
            return 100;
        }
        return 200;
    }

    public int getStatus() {
        return this.rCode;
    }

    private void jCancelButtonMouseReleased(MouseEvent evt) {
        this.rCode = 2;
        if (this.shouldExit) {
            System.exit(this.rCode);
        } else {
            this.dispose();
        }
    }

    private void jOkButtonMouseReleased(MouseEvent evt) {
        this.rCode = this.getExitCode();
        if (this.shouldExit) {
            System.exit(this.rCode);
        } else {
            this.dispose();
        }
    }

    private void jYesRadioButtonActionPerformed(ActionEvent evt) {
        this.isAllowed = true;
    }

    private void jNoRadioButtonActionPerformed(ActionEvent evt) {
        this.isAllowed = false;
    }

    private void jEditorPane1HyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(evt.getURL().toURI());
                }
                catch (Exception ex) {}
            } else {
                try {
                    Runtime.getRuntime().exec("firefox " + evt.getURL().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LegalDialog dialog = new LegalDialog((Frame)new JFrame(), true, true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(2);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

