/*
 * Decompiled with CFR 0.152.
 */
package com.intel.regtool;

import com.intel.ism.gui.Common;
import isus.ProfileMgr;
import isus.USAgent;
import isus.shared.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class Main {
    private static final String profileGroup = "Public";
    private static final String undefinedProperty = "NONE";
    private static final String infoDelimiter = "\\;";
    private static final String valueDelimiter = "\\=";
    private static final String profileItemSN = "SN";
    private static final USAgent agt = new USAgent();
    private static String ismDBFile = "/tmp/intel.ism.db";
    private static String databaseDir = "";
    private static String productGuid = "NONE";
    private static boolean unregMode = false;

    private static void parseCmdLine(String[] args) {
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).equals("-isroot")) {
                if (i < args.length) {
                    if (args[i++].equals("yes")) {
                        databaseDir = "/opt/intel/ism/db";
                        continue;
                    }
                    databaseDir = System.getProperty("user.home") + "/intel/ism/db";
                    continue;
                }
                System.err.println("regtool(): -isroot parameter requires value: yes or no ");
                continue;
            }
            if (arg.equals("-db")) {
                if (i < args.length) {
                    ismDBFile = args[i++];
                    continue;
                }
                System.err.println("regtool(): -db requires a filename, trying to use a default one (" + ismDBFile + ")");
                continue;
            }
            if (arg.equals("-unreg")) {
                unregMode = true;
                continue;
            }
            if (!arg.equals("-guid")) continue;
            if (i < args.length) {
                productGuid = args[i++];
                continue;
            }
            System.err.println("regtool(): -guid option requires a value");
        }
    }

    public static void main(String[] args) {
        System.out.print("regtool(): command line: ");
        for (String arg : args) {
            System.out.print(arg + " ");
        }
        System.out.println();
        Main.parseCmdLine(args);
        if (databaseDir.isEmpty()) {
            databaseDir = System.getProperty("user.name").equals("root") ? "/opt/intel/ism/db" : System.getProperty("user.home") + "/intel/ism/db";
        }
        if (unregMode) {
            int exitCode = 0;
            if (!productGuid.equals(undefinedProperty)) {
                agt.setProductBaseDir(databaseDir);
                try {
                    for (String guid : productGuid.split(",")) {
                        System.out.println("regtool(): unregistering " + guid + " from " + databaseDir);
                        agt.unRegister(guid, "Default");
                    }
                }
                catch (Exception ex) {
                    exitCode = 1;
                    System.err.println("regtool(): exception during unregistration: " + ex.toString());
                }
            } else {
                System.err.println("regtool(): -unregister option requires -guid option");
                exitCode = 2;
            }
            System.exit(exitCode);
        }
        Main.setDataBaseDir();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(ismDBFile)));
            while (in.ready()) {
                String info_str = in.readLine();
                if (info_str.isEmpty()) continue;
                String[] info = info_str.split(infoDelimiter);
                HashMap<String, String> attrs = new HashMap<String, String>();
                for (int i = 0; i < info.length; ++i) {
                    String assignment_str = info[i];
                    String[] assignment = assignment_str.split(valueDelimiter, 2);
                    if (assignment.length < 2) {
                        attrs.put(assignment[0], "");
                        continue;
                    }
                    attrs.put(assignment[0], assignment[1]);
                }
                Main.addAttrsInfoToDataBase(attrs);
            }
        }
        catch (IOException ioe) {
            System.err.println("regtool(): " + ioe.toString());
            System.exit(1);
        }
    }

    private static void setProfileMgrAttr(ProfileMgr prf, String guid, String attr, String value) {
        if (value == null) {
            prf.setValue(guid, profileGroup, attr, undefinedProperty);
        } else {
            prf.setValue(guid, profileGroup, attr, value);
        }
    }

    private static String getSerialNumberOfInstalledProduct(String guid) {
        System.out.println("regtool(): ... looking for already installed product with such GUID");
        String sn = "";
        File dir = new File(agt.getDatabaseDir());
        if (dir.exists()) {
            String[] products;
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            };
            for (String product : products = dir.list(filter)) {
                String prodDB = product.split(".properties")[0];
                if (!prodDB.equals(Util.convert2UID(guid))) continue;
                System.out.println("regtool(): found product!");
                sn = agt.getValue(prodDB, profileItemSN).trim();
                if (!sn.isEmpty()) {
                    System.out.println("regtool(): SN of installed product = " + sn);
                    continue;
                }
                System.out.println("regtool(): installed product doesn't have a SN record");
            }
        }
        System.out.println("regtool(): ... search completed");
        return sn;
    }

    private static void addAttrsInfoToDataBase(HashMap attrs) {
        Process proc;
        String guid = (String)attrs.get("GUID");
        if (guid == null || guid.equals("")) {
            System.out.println("regtool(): Please input product GUID");
            return;
        }
        String version = (String)attrs.get("VERSION");
        if (version == null || version.equals("")) {
            System.out.println("regtool(): Please input product version");
            return;
        }
        String url = (String)attrs.get("URL");
        if (url == null || url.equals("")) {
            System.out.println("regtool(): Please input FNC server URL");
            return;
        }
        String sn = (String)attrs.get(profileItemSN);
        if (sn == null || sn.equals("") || sn.equals(undefinedProperty)) {
            System.out.println("regtool(): SN record of installing product is empty");
            sn = Main.getSerialNumberOfInstalledProduct(guid);
            if (!sn.isEmpty()) {
                agt.setValue(guid, profileItemSN, sn);
            } else {
                agt.setValue(guid, profileItemSN, undefinedProperty);
            }
        } else {
            agt.setValue(guid, profileItemSN, sn);
        }
        agt.setValue(guid, "OSName", System.getProperty("os.name"));
        agt.setValue(guid, "OSVersion", System.getProperty("os.version"));
        agt.setValue(guid, "Arch", System.getProperty("os.arch"));
        String[] cmd_get_cpu_info = new String[]{"/bin/bash", "-c", Common.isMac() ? "echo $(/usr/sbin/sysctl -n machdep.cpu.brand_string) Family:$(/usr/sbin/sysctl -n machdep.cpu.family) Model:$(/usr/sbin/sysctl -n machdep.cpu.model)" : "echo $(cat /proc/cpuinfo | grep 'model name' | tail -1 | cut -d':' -f2) Family:$(cat /proc/cpuinfo | grep family | tail -1 | cut -d':' -f2) Model:$(cat /proc/cpuinfo | grep '^model[[:space:]]*:' | tail -1 | cut -d':' -f2)"};
        String proc_info_str = "";
        try {
            proc = Runtime.getRuntime().exec(cmd_get_cpu_info);
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            StringBuilder strbuf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strbuf.append(line).append(" ");
            }
            proc_info_str = strbuf.toString().trim();
        }
        catch (Throwable t) {
            System.out.println("regtool(): cannot obtain CPU info");
        }
        if (proc_info_str.isEmpty()) {
            proc_info_str = "Unknown";
        }
        String[] cmd_get_mac_addr = new String[]{"/bin/bash", "-c", Common.isMac() ? "/sbin/ifconfig | grep ether | head -1 | sed 's/^.*ether[[:space:]]*\\(.*\\)/\\1/g' | cut -d':' -f5-6" : "/sbin/ifconfig | grep HWaddr | head -1 | sed 's/^.*HWaddr[[:space:]]*\\(.*\\)/\\1/g' | cut -d':' -f5-6"};
        String mac_addr = "";
        try {
            proc = Runtime.getRuntime().exec(cmd_get_mac_addr);
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            StringBuilder strbuf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strbuf.append(line).append(" ");
            }
            mac_addr = strbuf.toString().trim();
        }
        catch (Throwable t) {
            System.out.println("regtool(): cannot obtain MAC address");
        }
        if (mac_addr.isEmpty()) {
            mac_addr = "Unknown";
        }
        agt.setValue(guid, "CPU", proc_info_str);
        agt.setValue(guid, "MACLast4", mac_addr);
        agt.setValue(guid, "Locale", System.getProperty("user.language"));
        agt.setValue(guid, "RecordDemographics", "false");
        agt.register(guid, version, "1033", url, "Default");
        agt.setNotificationServerURL(guid, url);
        ProfileMgr prf = new ProfileMgr();
        prf.addGroup(guid, profileGroup);
        Main.setProfileMgrAttr(prf, guid, "Version", (String)attrs.get("VERSION"));
        Main.setProfileMgrAttr(prf, guid, "ProductName", (String)attrs.get("ProductName"));
        Main.setProfileMgrAttr(prf, guid, "MediaID", (String)attrs.get("MediaID"));
        Main.setProfileMgrAttr(prf, guid, "UpdateID", (String)attrs.get("UpdateID"));
        String productID = (String)attrs.get("ProductID");
        productID = productID == null || productID.equals("") ? "Intel(R) Software Product" : (String)attrs.get("ProductID");
        Main.setProfileMgrAttr(prf, guid, "ProductID", productID);
        String fulfillmentID = (String)attrs.get("FulfillmentID");
        fulfillmentID = fulfillmentID == null || fulfillmentID.equals("") ? undefinedProperty : (String)attrs.get("FulfillmentID");
        Main.setProfileMgrAttr(prf, guid, "FulfillmentID", fulfillmentID);
        if (!Common.isMac()) {
            try {
                String pfFile = Util.getHome() + System.getProperty("file.separator") + Util.convert2UID(guid) + ".pf";
                String pFile = Util.getHome() + System.getProperty("file.separator") + Util.convert2UID(guid) + ".properties";
                Runtime.getRuntime().exec("/bin/chmod 644 " + pfFile);
                Runtime.getRuntime().exec("/bin/chmod 644 " + pFile);
            }
            catch (Exception ex) {
                System.out.println("regtool(): exception " + ex.getMessage());
            }
        }
    }

    private static void setDataBaseDir() {
        if (!new File(databaseDir).exists() && !new File(databaseDir).mkdirs()) {
            System.err.println("regtool(): ERROR: Cannot create dir " + databaseDir);
            System.exit(1);
        }
        agt.setProductBaseDir(databaseDir);
    }
}

