/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.osxgui;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.intel.ism.core.Resources;
import com.intel.ism.core.SumLogger;
import com.intel.ism.gui.AboutDialog;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.TabPanel;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OSXGui
implements AboutHandler,
QuitHandler,
PreferencesHandler {
    public void registerHandlers() {
        Application.getApplication().setAboutHandler((AboutHandler)this);
        Application.getApplication().setQuitHandler((QuitHandler)this);
        Application.getApplication().setPreferencesHandler((PreferencesHandler)this);
    }

    public void handleAbout(AppEvent.AboutEvent e) {
        int y;
        int x;
        Gui.getInstance().setVisible(true);
        AboutDialog dialog = AboutDialog.getInstance();
        if (Gui.getInstance().isVisible()) {
            Point p = Gui.getInstance().getLocationOnScreen();
            x = p.x + Gui.getInstance().getWidth() / 2 - dialog.getWidth() / 2;
            y = p.y + Gui.getInstance().getHeight() / 2 - dialog.getHeight() / 2;
        } else {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            x = d.width / 2 - dialog.getWidth() / 2;
            y = d.height / 2 - dialog.getHeight() / 2;
        }
        dialog.setLocation(x, y);
        dialog.setVisible(false);
        dialog.setVisible(true);
    }

    public void handlePreferences(AppEvent.PreferencesEvent event) {
        Gui.getInstance().setVisible(true);
        TabPanel.getInstance().setSelectedIndex(5);
        if (AboutDialog.getInstance().isVisible()) {
            AboutDialog.refresh();
        }
        if (ApplicationManager.getInstance().isCheckForUpdatesRunning()) {
            Gui.getInstance().showFindingUpdatesPanel((JPanel)TabPanel.getInstance().getSelectedComponent());
        }
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent event, QuitResponse response) {
        if (!ApplicationManager.getInstance().getIsSomethingIsInstalling()) {
            ApplicationManager.getInstance().exitAction(0);
        } else {
            SumLogger.logger.log(Level.INFO, "trayAction(): trying to exit during active installation ... skipping exit");
            String msg = String.format(Resources.getInstance().getBundle().getString("install_progress_exit_during_install_warning"), ApplicationManager.getInstance().getInstallingUpdateTitle());
            JFrame frame = new JFrame();
            frame.setIconImage(SumImages.imgAppIcon32x32.getImage());
            JOptionPane.showMessageDialog(frame, msg, Resources.getInstance().getProductName(), 2);
        }
    }
}

