/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui.treetable;

import com.intel.ism.gui.treetable.TreeTableInterface;
import java.lang.reflect.Method;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DynamicTreeTable
implements TreeTableInterface {
    private Object root;
    private EventListenerList listenerList = new EventListenerList();
    private String[] colNames;
    private String[] getterNames;
    private String[] setterNames;
    private Class[] classesTypes;

    public DynamicTreeTable(TreeNode root, String[] colNames, String[] getterNames, String[] setterNames, Class[] classesTypes) {
        this.root = root;
        this.colNames = colNames;
        this.getterNames = getterNames;
        this.setterNames = setterNames;
        this.classesTypes = classesTypes;
    }

    @Override
    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    @Override
    public Object getChild(Object node, int i) {
        return ((TreeNode)node).getChildAt(i);
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public String getColumnName(int column) {
        if (this.classesTypes == null || column < 0 || column >= this.classesTypes.length) {
            return null;
        }
        return this.colNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        if (this.classesTypes == null || column < 0 || column >= this.classesTypes.length) {
            return null;
        }
        return this.classesTypes[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        try {
            Method method = node.getClass().getMethod(this.getterNames[column], new Class[0]);
            if (method != null) {
                return method.invoke(node, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.setterNames != null && this.setterNames[column] != null;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
    }

    @Override
    public int getIndexOfTreeColumn() {
        for (int idx = 0; idx < this.classesTypes.length; ++idx) {
            if (this.classesTypes[idx] != TreeTableInterface.class) continue;
            return idx;
        }
        return -1;
    }
}

