/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui.treetable;

import com.intel.ism.core.Resources;
import com.intel.ism.core.data.LicenseMessage;
import com.intel.ism.core.data.Update;
import com.intel.ism.core.objects.LicenseMessageData;
import com.intel.ism.core.objects.LicenseMessages;
import com.intel.ism.core.objects.MarketingMessageData;
import com.intel.ism.core.objects.MarketingMessages;
import com.intel.ism.core.objects.UpdatesAndDownloads;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.controllers.FontManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataTree {
    private Group root;

    public DataTree(Class ctype) {
        block8: {
            block9: {
                block7: {
                    this.root = new Group("root");
                    if (ctype != Update.class) break block7;
                    List<Update> list = new UpdatesAndDownloads().getUpdatesAndDownloadsList();
                    for (Update u : list) {
                        Group g_item = this.getGroupByName(u.getPackageName());
                        if (g_item == null) {
                            g_item = new Group(u.getPackageName());
                            this.root.add(g_item);
                        }
                        ItemUpdate u_item = new ItemUpdate(u);
                        if (u.getUpdateType().equals((Object)Update.EUpdateType.BUNDLE)) {
                            g_item.insert(u_item, 0);
                            continue;
                        }
                        g_item.add(u_item);
                    }
                    break block8;
                }
                if (ctype != LicenseMessageData.class) break block9;
                List<LicenseMessageData> list = new LicenseMessages().getMessagesList();
                for (LicenseMessageData lmd : list) {
                    Group g_item = this.getGroupByName(lmd.getPackageName());
                    if (g_item == null) {
                        g_item = new Group(lmd.getPackageName());
                        this.root.add(g_item);
                    }
                    ItemLicense l_item = new ItemLicense(lmd);
                    g_item.add(l_item);
                }
                break block8;
            }
            if (ctype != MarketingMessageData.class) break block8;
            List<MarketingMessageData> list = new MarketingMessages().getMarketingMessagesList();
            for (MarketingMessageData mmd : list) {
                Group g_item = this.getGroupByName(mmd.getPackageName());
                if (g_item == null) {
                    g_item = new Group(mmd.getPackageName());
                    this.root.add(g_item);
                }
                ItemNews n_item = new ItemNews(mmd);
                g_item.add(n_item);
            }
        }
    }

    public Group getRoot() {
        return this.root;
    }

    private Group getGroupByName(String name) {
        int c_count = this.root.getChildCount();
        for (int i = 0; i < c_count; ++i) {
            Group g = (Group)this.root.getChildAt(i);
            if (!g.getName().equals(name)) continue;
            return g;
        }
        return null;
    }

    public TreePath getTreePathForUpdateByGuid(String guid) {
        Enumeration<TreeNode> t_enum = this.root.depthFirstEnumeration();
        while (t_enum.hasMoreElements()) {
            Update update;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)t_enum.nextElement();
            if (!(node instanceof ItemUpdate) || !(update = ((ItemUpdate)node).getUpdate()).getProductGuid().equals(guid)) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    public List<Update> getListOfUpdates() {
        Enumeration<TreeNode> t_enum = this.root.depthFirstEnumeration();
        ArrayList<Update> list = new ArrayList<Update>();
        while (t_enum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)t_enum.nextElement();
            if (!(node instanceof ItemUpdate)) continue;
            list.add(((ItemUpdate)node).getUpdate());
        }
        return list;
    }

    public int getLeafCount() {
        if (!this.root.isLeaf()) {
            return this.root.getLeafCount();
        }
        return 0;
    }

    public class ItemNews
    extends DefaultMutableTreeNode {
        MarketingMessageData mmd;
        private JLabel jlbTitle;
        private JLabel jlbDate;

        public ItemNews(final MarketingMessageData mm) {
            this.mmd = mm;
            this.jlbTitle = new JLabel(mm.getTitle()){

                @Override
                public Font getFont() {
                    return mm.getIsRead() ? FontManager.getPlainFont() : FontManager.getBoldFont();
                }
            };
            ImageIcon icon = this.mmd.getIsRead() ? SumImages.imgStatusMsgRead : SumImages.imgStatusMsgUnread;
            this.jlbTitle.setIcon(icon);
            this.jlbDate = new JLabel(mm.getPublishedDate()){

                @Override
                public Font getFont() {
                    return mm.getIsRead() ? FontManager.getPlainFont() : FontManager.getBoldFont();
                }
            };
        }

        public JLabel getJlbTitle() {
            return this.jlbTitle;
        }

        public void setJlbTitle(JLabel jlbTitle) {
            this.jlbTitle = jlbTitle;
        }

        public JLabel getJlbDate() {
            return this.jlbDate;
        }

        public void setJlbDate(JLabel jlbDate) {
            this.jlbDate = jlbDate;
        }

        public MarketingMessageData getMarketingMessageData() {
            return this.mmd;
        }

        @Override
        public String toString() {
            return this.mmd.getTitle();
        }
    }

    public class ItemLicense
    extends DefaultMutableTreeNode {
        LicenseMessageData lmd;
        private JLabel jlbTitle;
        private JLabel jlbStatus;
        private JLabel jlbAction;
        private JLabel jlbActivation;

        public ItemLicense(final LicenseMessageData lm) {
            this.lmd = lm;
            this.jlbTitle = new JLabel(lm.getTitle()){

                @Override
                public Color getForeground() {
                    if (lm.getMessageType() == LicenseMessage.EMessageType.Unknown) {
                        return Color.GRAY;
                    }
                    return Color.BLACK;
                }

                @Override
                public Font getFont() {
                    switch (lm.getMessageStatus()) {
                        case Expired: 
                        case ExpiredMoreThanAYearAgo: 
                        case Warning: {
                            return FontManager.getBoldFont();
                        }
                    }
                    return FontManager.getPlainFont();
                }
            };
            this.jlbTitle.setIcon(SumImages.imgStatusLicense);
            if (!lm.getMessageStatus().equals((Object)LicenseMessage.EMessageStatus.OK) && !lm.getMessageStatus().equals((Object)LicenseMessage.EMessageStatus.Unknown)) {
                if (lm.getMessageType().equals((Object)LicenseMessage.EMessageType.Evaluation)) {
                    this.jlbAction = new JLabel(Resources.getInstance().getBundle().getString("link_buy"));
                } else {
                    switch (lm.getMessageStatus()) {
                        case ExpiredMoreThanAYearAgo: {
                            this.jlbAction = new JLabel(Resources.getInstance().getBundle().getString("link_buy"));
                            break;
                        }
                        case Expired: {
                            this.jlbAction = new JLabel(Resources.getInstance().getBundle().getString("link_renew"));
                            break;
                        }
                        case Warning: {
                            this.jlbAction = new JLabel(Resources.getInstance().getBundle().getString("link_extend"));
                            break;
                        }
                        default: {
                            this.jlbAction = new JLabel(Resources.getInstance().getBundle().getString("link_renew"));
                            break;
                        }
                    }
                }
            } else {
                this.jlbAction = new JLabel();
            }
            this.jlbAction.setFont(FontManager.getUnderlinedFont());
            this.jlbAction.setForeground(Color.BLUE);
            this.jlbActivation = new JLabel(Resources.getInstance().getBundle().getString("link_activate"));
            this.jlbActivation.setFont(FontManager.getUnderlinedFont());
            this.jlbActivation.setForeground(Color.BLUE);
            this.jlbStatus = new JLabel(lm.getEndDate()){

                @Override
                public Color getForeground() {
                    if (lm.getMessageType() == LicenseMessage.EMessageType.Unknown) {
                        return Color.GRAY;
                    }
                    switch (lm.getMessageStatus()) {
                        case ExpiredMoreThanAYearAgo: {
                            return Color.RED.darker().darker();
                        }
                        case Expired: {
                            return Color.RED.darker();
                        }
                        case Warning: {
                            return Color.ORANGE;
                        }
                        case OK: {
                            return Color.GREEN.darker();
                        }
                    }
                    return Color.BLACK;
                }

                @Override
                public Font getFont() {
                    switch (lm.getMessageStatus()) {
                        case Expired: 
                        case ExpiredMoreThanAYearAgo: 
                        case Warning: {
                            return FontManager.getBoldFont();
                        }
                    }
                    return FontManager.getPlainFont();
                }
            };
        }

        public JLabel getJlbTitle() {
            return this.jlbTitle;
        }

        public void setJlbTitle(JLabel jlbTitle) {
            this.jlbTitle = jlbTitle;
        }

        public JLabel getJlbStatus() {
            return this.jlbStatus;
        }

        public void setJlbStatus(JLabel jlbStatus) {
            this.jlbStatus = jlbStatus;
        }

        public JLabel getJlbAction() {
            return this.jlbAction;
        }

        public void setJlbAction(JLabel jlbAction) {
            this.jlbAction = jlbAction;
        }

        public JLabel getJlbActivation() {
            return this.jlbActivation;
        }

        public void setJlbActivation(JLabel jlbActivation) {
            this.jlbActivation = jlbActivation;
        }

        public LicenseMessageData getLicenseMessageData() {
            return this.lmd;
        }

        @Override
        public String toString() {
            return this.lmd.getTitle();
        }
    }

    public class ItemUpdate
    extends DefaultMutableTreeNode {
        private Update update;
        private JPanel jpnlButtons;
        private JLabel jlbUpdateName;
        private JLabel jlbPublishedDate;
        private JLabel jlbDownloadSize;
        private JLabel jlbDownloadStatus;
        private JProgressBar jprbrProgress;
        private JLabel jlbDownloadSpeed;
        private JButton btnPause;
        private JButton btnStartResume;
        private JButton btnCancel;
        private JButton btnInstall;
        private JButton btnInfo;

        public ItemUpdate(final Update update) {
            this.update = update;
            String uTitle = update.getUpdateType().equals((Object)Update.EUpdateType.PART_OF_BUNDLE) ? "    " + update.getTitle() : update.getTitle();
            this.jlbUpdateName = new JLabel(uTitle){

                @Override
                public Color getForeground() {
                    if (!update.getIsAllowToDownload()) {
                        return Color.GRAY;
                    }
                    return Color.BLACK;
                }
            };
            this.jlbPublishedDate = new JLabel(update.getPublishedDateStr()){

                @Override
                public Color getForeground() {
                    if (!update.getIsAllowToDownload()) {
                        return Color.GRAY;
                    }
                    return Color.BLACK;
                }
            };
            this.jlbDownloadSize = new JLabel(update.getDownloadSizeStr()){

                @Override
                public Color getForeground() {
                    if (!update.getIsAllowToDownload()) {
                        return Color.GRAY;
                    }
                    return Color.BLACK;
                }
            };
            this.jlbDownloadStatus = new JLabel(){

                @Override
                public String getText() {
                    if (!update.getIsAllowToDownload()) {
                        return Resources.getInstance().getBundle().getString("status_unavailable");
                    }
                    return update.getUpdateDownloadStatusString();
                }

                @Override
                public Color getForeground() {
                    if (!update.getIsAllowToDownload()) {
                        return Color.GRAY;
                    }
                    return Color.BLACK;
                }
            };
            this.jlbDownloadSpeed = new JLabel();
            this.jprbrProgress = new JProgressBar(0, 100);
            this.jprbrProgress.getAccessibleContext().setAccessibleName("progressBar" + update.getId());
            this.jprbrProgress.setIndeterminate(update.getDownloadProgress() < 0);
            this.jprbrProgress.setValue(update.getDownloadProgress());
            this.jpnlButtons = new JPanel(new FlowLayout(0, 1, 1));
            this.btnPause = new JButton(SumImages.imgPauseButton);
            this.btnStartResume = new JButton(SumImages.imgResumeButton);
            this.btnCancel = new JButton(SumImages.imgCancelButton);
            this.btnInstall = new JButton(SumImages.imgInstallButton);
            this.btnInfo = new JButton(SumImages.imgInfoButton);
            this.btnStartResume.getAccessibleContext().setAccessibleName("btnStartResume" + update.getId());
            this.btnPause.getAccessibleContext().setAccessibleName("btnPause" + update.getId());
            this.btnCancel.getAccessibleContext().setAccessibleName("btnCancel" + update.getId());
            this.btnInfo.getAccessibleContext().setAccessibleName("btnInfo" + update.getId());
            this.btnInstall.getAccessibleContext().setAccessibleName("btnInstall" + update.getId());
            this.btnStartResume.setToolTipText(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_start"));
            this.btnPause.setToolTipText(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_pause"));
            this.btnCancel.setToolTipText(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_stop"));
            this.btnInfo.setToolTipText(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_info"));
            this.btnInstall.setToolTipText(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_install"));
            this.btnPause.setPreferredSize(new Dimension(SumImages.imgPauseButton.getIconWidth(), SumImages.imgPauseButton.getIconHeight()));
            this.btnStartResume.setPreferredSize(new Dimension(SumImages.imgResumeButton.getIconWidth(), SumImages.imgResumeButton.getIconHeight()));
            this.btnCancel.setPreferredSize(new Dimension(SumImages.imgCancelButton.getIconWidth(), SumImages.imgCancelButton.getIconHeight()));
            this.btnInstall.setPreferredSize(new Dimension(SumImages.imgInstallButton.getIconWidth(), SumImages.imgInstallButton.getIconHeight()));
            this.btnInfo.setPreferredSize(new Dimension(SumImages.imgInfoButton.getIconWidth(), SumImages.imgInfoButton.getIconHeight()));
        }

        public void setBtnPanel(JPanel panel) {
            this.jpnlButtons = panel;
        }

        public JPanel getBtnPanel() {
            return this.jpnlButtons;
        }

        public void setJlbUpdateName(JLabel name) {
            this.jlbUpdateName = name;
        }

        public JLabel getJlbUpdateName() {
            return this.jlbUpdateName;
        }

        public void setJlbPublishedDate(JLabel date) {
            this.jlbPublishedDate = date;
        }

        public JLabel getJlbPublishedDate() {
            return this.jlbPublishedDate;
        }

        public void setJlbDownloadSize(JLabel size) {
            this.jlbDownloadSize = size;
        }

        public JLabel getJlbDownloadSize() {
            return this.jlbDownloadSize;
        }

        public void setJlbDownloadStatus(JLabel status) {
            this.jlbDownloadStatus = status;
        }

        public void setDownloadStatusText(String status) {
            this.jlbDownloadStatus.setText(status);
        }

        public JLabel getJlbDownloadStatus() {
            return this.jlbDownloadStatus;
        }

        public void setProgressBar(JProgressBar progress) {
            this.jprbrProgress = progress;
        }

        public JProgressBar getProgressBar() {
            if (this.update.getIsAllowToDownload()) {
                return this.jprbrProgress;
            }
            return null;
        }

        public void setJlbDownloadSpeed(JLabel speed) {
            this.jlbDownloadSpeed = speed;
        }

        public void setDownloadSpeedText(String speed) {
            this.jlbDownloadSpeed.setText(speed);
        }

        public JLabel getJlbDownloadSpeed() {
            return this.jlbDownloadSpeed;
        }

        public JButton getBtnStartResume() {
            return this.btnStartResume;
        }

        public JButton getBtnCancel() {
            return this.btnCancel;
        }

        public JButton getBtnPause() {
            return this.btnPause;
        }

        public JButton getBtnInstall() {
            return this.btnInstall;
        }

        public JButton getBtnInfo() {
            return this.btnInfo;
        }

        public Update getUpdate() {
            return this.update;
        }

        @Override
        public String toString() {
            return this.update.getTitle();
        }
    }

    public class Group
    extends DefaultMutableTreeNode {
        private String name;
        private JLabel jlbTitle;

        public Group(String name) {
            this.name = name;
            this.jlbTitle = new JLabel(name){

                @Override
                public Color getForeground() {
                    return new Color(45, 75, 190);
                }

                @Override
                public Font getFont() {
                    return FontManager.getPlainFont();
                }
            };
            this.jlbTitle.setToolTipText(name);
        }

        public void setJlbTitle(JLabel jlbTitle) {
            this.jlbTitle = jlbTitle;
        }

        public JLabel getJlbTitle() {
            return this.jlbTitle;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

