/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui.controllers;

import com.intel.ism.core.CommandLineParser;
import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.Tools;
import com.intel.ism.core.UsageStatisticsManager;
import com.intel.ism.core.data.DataManager;
import com.intel.ism.core.data.ErrorNum;
import com.intel.ism.core.data.LocalStoreDataManager;
import com.intel.ism.core.objects.UpdatesAndDownloads;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.PanelBottom;
import com.intel.ism.gui.RemoteInterface;
import com.intel.ism.gui.SumTrayIcon;
import com.intel.ism.gui.controllers.SumController;
import com.intel.ism.gui.controllers.TrayNotificationManager;
import java.awt.GraphicsEnvironment;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

public class ApplicationManager {
    private final String appVersion;
    private final String jarName = new File(System.getProperty("java.class.path")).getName().toLowerCase();
    private String pathToJar = new File(ApplicationManager.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
    private SwingWorker workerCheckForUpdates;
    private TrayNotificationManager trayManager;
    private Registry registry;
    private volatile boolean allTabsRefreshed;
    private volatile boolean smthIsInstalling;
    private volatile String installingUpdateTitle;
    private FileChannel fchn;
    private FileLock flck;
    private File lockFile;
    private String lockFileFullPath;
    private boolean firstInstance;

    private ApplicationManager() {
        this.appVersion = "1.0";
        try {
            this.pathToJar = new File(URLDecoder.decode(ApplicationManager.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")).getParent();
        }
        catch (UnsupportedEncodingException e) {
            SumLogger.logger.log(Level.WARNING, "ApplicationManager: UTF-8 is unknown encoding");
        }
        this.workerCheckForUpdates = null;
        this.trayManager = new TrayNotificationManager();
        this.registry = null;
        this.allTabsRefreshed = false;
        this.smthIsInstalling = false;
        this.firstInstance = true;
        this.lockFileFullPath = Settings.defaultSettings.getPrivateInstallDir() + "/intel.ism.lock";
        this.installingUpdateTitle = "";
    }

    public String getAppVersion() {
        try {
            String versionFile = this.pathToJar + System.getProperty("file.separator") + "support.txt";
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(versionFile)));
            while (in.ready()) {
                String[] info;
                String info_str = in.readLine();
                if (info_str.isEmpty() || !(info = info_str.split("="))[0].equals("VERSION")) continue;
                return info[1];
            }
        }
        catch (IOException ioe) {
            SumLogger.logger.log(Level.WARNING, "getAppVersion(): {0}", ioe.toString());
        }
        return this.appVersion;
    }

    public static ApplicationManager getInstance() {
        return InstanceHolder.instance;
    }

    public void setWorker(SwingWorker worker) {
        this.workerCheckForUpdates = worker;
    }

    public void setAllTabsRefreshed(boolean allTabsRefreshed) {
        this.allTabsRefreshed = allTabsRefreshed;
    }

    public void setIsSomethingIsInstalling(boolean smthIsInstalling) {
        this.setIsSomethingIsInstalling(smthIsInstalling, "");
    }

    public void setIsSomethingIsInstalling(boolean smthIsInstalling, String title) {
        this.smthIsInstalling = smthIsInstalling;
        this.installingUpdateTitle = title;
    }

    public SwingWorker getWorker() {
        return this.workerCheckForUpdates;
    }

    public TrayNotificationManager getTrayNotificationManager() {
        return this.trayManager;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getPathToJar() {
        return this.pathToJar;
    }

    public boolean getAllTabsRefreshed() {
        return this.allTabsRefreshed;
    }

    public String getLockFileFullPath() {
        return this.lockFileFullPath;
    }

    public boolean getIsSomethingIsInstalling() {
        return this.smthIsInstalling;
    }

    public String getInstallingUpdateTitle() {
        return this.installingUpdateTitle;
    }

    public void checkPrerequisites() {
        String msg;
        if (Common.isLinux() || Common.isMac() && !System.getProperty("java.vendor").toLowerCase().matches(".*apple.*")) {
            msg = "";
            msg = Common.isLinux() ? Resources.getInstance().getBundle().getString("common_error_openjdk_detected") + System.getProperty("line.separator") + Resources.getInstance().getBundle().getString("common_error_incorrect_jre_cont") : String.format(Resources.getInstance().getBundle().getString("common_error_incorrect_jre"), "vendor " + System.getProperty("java.vendor")) + System.getProperty("line.separator") + Resources.getInstance().getBundle().getString("common_error_incorrect_jre_cont");
            System.err.println(msg);
            SumLogger.logger.warning(msg);
        }
        try {
            if (Integer.parseInt(System.getProperty("java.version").split("\\.")[1]) < 6) {
                msg = String.format(Resources.getInstance().getBundle().getString("common_error_incorrect_jre"), "version " + System.getProperty("java.version")) + System.getProperty("line.separator") + Resources.getInstance().getBundle().getString("common_error_incorrect_jre_cont");
                System.err.println(msg);
                SumLogger.logger.severe(msg);
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Exception in checking JRE version: " + e + System.getProperty("line.separator") + "StackTrace:" + System.getProperty("line.separator") + Arrays.toString(e.getStackTrace()));
            System.exit(1);
        }
        if (!Common.isLinux() && !Common.isMac()) {
            msg = Resources.getInstance().getBundle().getString("common_error_unsupported_os");
            System.err.println(msg);
            JOptionPane.showMessageDialog(null, msg, Resources.getInstance().getBundle().getString("common_error_error"), 0);
            System.exit(1);
        }
        if (GraphicsEnvironment.isHeadless()) {
            msg = Resources.getInstance().getBundle().getString("common_error_x11_not_found");
            System.err.println(msg);
            SumLogger.logger.severe(msg);
            System.exit(1);
        }
    }

    private boolean isOpenJDK() {
        SumLogger.logger.info("isOpenJDK(): checking if current JRE is OpenJDK");
        String[] cmd_get_java_version = new String[]{"/bin/bash", "-c", "echo $(java -version 2>&1) | tr [:upper:] [:lower:] | grep -e 'open[ ]*jdk'"};
        String output_str = "";
        try {
            Process proc = Runtime.getRuntime().exec(cmd_get_java_version);
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            StringBuilder strbuf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strbuf.append(line).append(" ");
            }
            output_str = strbuf.toString().trim();
            SumLogger.logger.log(Level.INFO, "isOpenJDK(): output str = {0}", output_str);
            int exitVal = proc.waitFor();
            if (exitVal == 0) {
                return true;
            }
        }
        catch (Throwable t) {
            System.out.println("isOpenJDK(): error while detection... assuming it's not OpenJDK");
        }
        return false;
    }

    private boolean initRemoteServer() {
        try {
            SumLogger.logger.log(Level.INFO, "initRemoteServer() - initializing server accepting remote calls...");
            SumLogger.logger.log(Level.INFO, "initRemoteServer() - ... initializing server stub");
            RemoteInterface stub = (RemoteInterface)UnicastRemoteObject.exportObject((Remote)Gui.getInstance(), 0);
            int remotePort = Settings.defaultSettings.getRemotePort();
            SumLogger.logger.log(Level.INFO, "initRemoteServer() - ... trying to get reference to registry on port {0}");
            this.registry = LocateRegistry.getRegistry(remotePort);
            try {
                SumLogger.logger.log(Level.INFO, "initRemoteServer() - ... trying to run a rmiregistry");
                this.registry = LocateRegistry.createRegistry(remotePort);
            }
            catch (RemoteException ex) {
                SumLogger.logger.log(Level.INFO, "initRemoteServer() - cannot run a rmiregistry - it's already bounded to the port {0}", remotePort);
            }
            String objLabel = "sumremote_" + System.getProperty("user.name");
            try {
                SumLogger.logger.log(Level.INFO, "initRemoteServer() - ... binding stub to registry");
                this.registry.rebind(objLabel, stub);
                SumLogger.logger.log(Level.INFO, "initRemoteServer() - server is initialized");
            }
            catch (AccessException ex) {
                SumLogger.logger.log(Level.INFO, "initRemoteServer() - AccessException: cannot rebind the object (string label = {0}) in the registry: {1}", new Object[]{objLabel, ex.getMessage()});
                return false;
            }
        }
        catch (RemoteException ex) {
            SumLogger.logger.log(Level.INFO, "initRemoteServer() - RemoteException: {0}", ex.getMessage());
        }
        return true;
    }

    public void setLockFile() {
        try {
            File ismHomeDir = new File(Settings.defaultSettings.getPrivateInstallDir());
            if (!ismHomeDir.exists() && !ismHomeDir.mkdirs()) {
                SumLogger.logger.log(Level.WARNING, "setLockFile(): cannot create {0} directory for lock file!", ismHomeDir.getPath());
                String msg = String.format(Resources.getInstance().getBundle().getString("common_error_cannot_create_intel_dir"), ismHomeDir.getPath());
                System.err.println(msg);
                SumLogger.logger.severe(msg);
                JOptionPane.showMessageDialog(null, msg, Resources.getInstance().getProductName(), 0);
                ApplicationManager.getInstance().exitAction(1);
            }
            this.lockFile = new File(this.lockFileFullPath);
            this.fchn = new RandomAccessFile(this.lockFile, "rw").getChannel();
            try {
                SumLogger.logger.warning("setLockFile: trying to obtain lock file");
                this.flck = this.fchn.tryLock();
            }
            catch (OverlappingFileLockException e) {
                SumLogger.logger.warning("setLockFile: this JVM or another thread already blocked the lock");
                this.firstInstance = false;
            }
            if (this.flck == null) {
                SumLogger.logger.warning("setLockFile: another instance already blocked the lock");
                this.firstInstance = false;
            } else {
                SumLogger.logger.warning("setLockFile: lock has been obtained");
            }
        }
        catch (Exception e) {
            SumLogger.logger.warning("setLockFile: exception when obtaining lock file ");
            this.firstInstance = true;
        }
    }

    public boolean isApplicationRunning() {
        return !this.firstInstance;
    }

    public void closeLock() {
        try {
            this.flck.release();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.fchn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteLockFile() {
        try {
            this.lockFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void runClient(CommandLineParser clp, boolean shouldRunCheckForUpdates, boolean needExit) {
        new SumController(clp.getGuid(), clp.getAction(), clp.getResponseFile()).runClient(shouldRunCheckForUpdates, needExit);
    }

    public void runApplication(boolean shouldBeVisible) {
        this.runApplication(shouldBeVisible, "EMPTY");
    }

    public void runApplication(boolean shouldBeVisible, String guid) {
        SwingWorker w = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                return ApplicationManager.this.initRemoteServer();
            }
        };
        w.execute();
        Gui.getInstance().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Gui.getInstance().getTopPanel().resized(e);
                Gui.getInstance().resized(e);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        Gui.getInstance().setVisible(shouldBeVisible);
        PanelBottom.getInstance().btnCheckForUpdatesClick(guid, false);
        if (shouldBeVisible && !Common.isMac()) {
            SumTrayIcon.getInstance().createTrayIcon();
        }
    }

    public ErrorNum.EGetDataErrors runGetAllData(boolean skipCFU) {
        new UpdatesAndDownloads().pauseAllDownloadsByApp();
        DataManager tmpDm = new DataManager();
        if (tmpDm.getAllData(skipCFU)) {
            DataManager.defaultDataManager.clearData();
            DataManager.defaultDataManager = tmpDm;
            LocalStoreDataManager.defaultLocalStoreDataManager.loadMessages();
            LocalStoreDataManager.defaultLocalStoreDataManager.loadHistory();
            LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
            LocalStoreDataManager.defaultLocalStoreDataManager.saveHistory();
        }
        return tmpDm.getStatusofGetAllData();
    }

    public void interruptCheckForUpdates() {
        if (this.workerCheckForUpdates != null) {
            SumLogger.logger.info("interruptCheckForUpdates(): check for updates is being cancelled...");
            this.workerCheckForUpdates.cancel(true);
        }
    }

    public boolean isCheckForUpdatesRunning() {
        if (this.workerCheckForUpdates != null) {
            return !this.workerCheckForUpdates.isDone();
        }
        return false;
    }

    public boolean checkActionFrequency(String lastActionDateStr) {
        int freqAction = 1;
        SumLogger.logger.log(Level.INFO, "checkLaunchFrequency(): checking if we should run action (freqCFU = {0})", freqAction);
        if (!lastActionDateStr.equals(Resources.getInstance().getBundle().getString("panel_bottom_last_update_date_never"))) {
            try {
                Calendar lastActionDate = Calendar.getInstance();
                lastActionDate.setTime(Common.getDateTimeFormat().parse(lastActionDateStr));
                Calendar curDate = Calendar.getInstance();
                int daysFromLastAction = Tools.dateDiff(lastActionDate, curDate);
                SumLogger.logger.log(Level.INFO, "checkLaunchFrequency(): days from last action = {0}", daysFromLastAction);
                if (daysFromLastAction < freqAction && !DataManager.defaultDataManager.getProductList().isEmpty()) {
                    SumLogger.logger.log(Level.INFO, "checkLaunchFrequency(): action is going to be cancelled...");
                    return false;
                }
                SumLogger.logger.log(Level.INFO, "checkLaunchFrequency(): action is allowed");
            }
            catch (ParseException ex) {
                SumLogger.logger.log(Level.SEVERE, "Exception in set label: {0}{1}StackTrace:{2}{3}", new Object[]{ex, System.getProperty("line.separator"), System.getProperty("line.separator"), Arrays.toString(ex.getStackTrace())});
            }
        } else {
            SumLogger.logger.log(Level.INFO, "checkLaunchFrequency(): action was never run before, runAction = true");
        }
        return true;
    }

    public void exitAction(int rc) {
        SumLogger.logger.info("exitAction(): exiting action start...");
        new UpdatesAndDownloads().pauseAllDownloadsByApp();
        Registry reg = ApplicationManager.getInstance().getRegistry();
        if (reg != null) {
            try {
                reg.unbind("sumremote_" + System.getProperty("user.name"));
                UnicastRemoteObject.unexportObject(Gui.getInstance(), true);
            }
            catch (RemoteException ex) {
                SumLogger.logger.log(Level.INFO, "exitAction(): exception when trying unbind stub from registry: {0}", ex.getMessage());
            }
            catch (NotBoundException ex) {
                SumLogger.logger.log(Level.INFO, "exitAction(): exception when trying unbind stub from registry: {0}", ex.getMessage());
            }
        }
        UsageStatisticsManager.getInstance().dumpCollectedStatistics();
        LocalStoreDataManager.defaultLocalStoreDataManager.saveHistory();
        LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
        ApplicationManager.getInstance().closeLock();
        ApplicationManager.getInstance().deleteLockFile();
        SumLogger.logger.info("exitAction(): exiting action end...");
        System.exit(rc);
    }

    private static class InstanceHolder {
        public static final ApplicationManager instance = new ApplicationManager();

        private InstanceHolder() {
        }
    }
}

