/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.data.LocalHistoryData;
import com.intel.ism.core.data.LocalHistoryItem;
import javax.swing.table.AbstractTableModel;

public final class TableModelHistory
extends AbstractTableModel {
    private final String[] columnNames = Resources.getInstance().getBundle().getString("tab_history_column_names").split(";");
    private Object[][] data;

    public TableModelHistory(LocalHistoryData listData) {
        this.data = new Object[listData.getHistoryDataCount()][this.columnNames.length];
        int i = 0;
        for (LocalHistoryItem historyData : listData.getHistoryData()) {
            this.data[i][0] = historyData.getTitle();
            this.data[i][1] = historyData.getStatus();
            this.data[i][2] = historyData.getDate();
            this.data[i][3] = historyData.getType();
            ++i;
        }
    }

    @Override
    public String getColumnName(int c) {
        return this.columnNames[c];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.data[rowIndex][columnIndex];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

