/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.Tools;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.SumTimer;
import com.intel.ism.gui.TabUpdatesAndDownloads;
import com.intel.ism.gui.controllers.ApplicationManager;
import com.intel.ism.gui.controllers.FontManager;
import com.intel.remmon.LegalDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class TabSettings
extends JPanel {
    private static TabSettings tabSettings;
    private JLabel jlbSettings = new JLabel(Resources.getInstance().getLabelTabSettings(), SumImages.imgInfo, 2);
    private JButton btnCancel = new JButton(Resources.getInstance().getBtnCancel());
    private JButton btnSave = new JButton(Resources.getInstance().getBundle().getString("tab_settings_btn_save_changes"));
    private JButton btnBrowse = new JButton(Resources.getInstance().getBundle().getString("tab_settings_btn_change"));
    private JRadioButton jrbManually = new JRadioButton(Resources.getInstance().getBundle().getString("tab_settings_rb_item_manually"));
    private JRadioButton jrbContext = new JRadioButton(Resources.getInstance().getBundle().getString("tab_settings_rb_item_context"));
    private JRadioButton jrbAuto = new JRadioButton(Resources.getInstance().getBundle().getString("tab_settings_rb_item_auto"));
    private JComboBox combo = new JComboBox();
    private JTextField jtfDownloadLocation = new JTextField(Settings.defaultSettings.getDefaultDownloadLocation());
    private JLabel jlbCheck = new JLabel(Resources.getInstance().getBundle().getString("tab_settings_lbl_check"));
    private JLabel jlbFolder = new JLabel(Resources.getInstance().getBundle().getString("tab_settings_lbl_folder"));
    private JLabel jlbDownload = new JLabel(Resources.getInstance().getBundle().getString("tab_settings_lbl_download"));
    private JLabel jlbYouCan = new JLabel(Resources.getInstance().getBundle().getString("tab_settings_lbl_preferences"), 2);
    private JLabel jlbYouCanFind = new JLabel(Resources.getInstance().getBundle().getString("tab_settings_lbl_youcanfind"));
    private String strNextCFU = Resources.getInstance().getBundle().getString("tab_settings_lbl_next_cfu");
    private String strNextCFUDateUnknown = Resources.getInstance().getBundle().getString("tab_settings_lbl_next_cfu_date_unknown");
    private JLabel jlbNextCFU = new JLabel(this.strNextCFU);
    private JLabel jlbNotifications = new JLabel(Resources.getInstance().getBundle().getString("tab_settings_lbl_notifications"));
    private JLabel jlbPrivacy = new JLabel(Resources.getInstance().getBundle().getString("tab_settings_lbl_privacy"));
    private JButton btnCustomerFeedbackOptions = new JButton(Resources.getInstance().getBundle().getString("tab_settings_btn_customer_feedback_options"));
    private JCheckBox chbxDisableUpdatePopupNotifications = new JCheckBox(Resources.getInstance().getBundle().getString("tab_settings_chbx_disable_update_popup_notifications"));
    private JCheckBox chbxDisableLicensePopupNotifications = new JCheckBox(Resources.getInstance().getBundle().getString("tab_settings_chbx_disable_license_popup_notifications"));
    private JLabel jlbSendSystemInfoURL;
    Map<Integer, Settings.ECFUAutoMode> map_comboIndex;

    public static synchronized TabSettings getInstance() {
        if (tabSettings == null) {
            tabSettings = new TabSettings();
        }
        return tabSettings;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private TabSettings() {
        this.jlbCheck.setFont(FontManager.getBoldFont());
        this.jlbDownload.setFont(FontManager.getBoldFont());
        this.jlbNotifications.setFont(FontManager.getBoldFont());
        this.jlbPrivacy.setFont(FontManager.getBoldFont());
        this.btnCancel.setFocusPainted(false);
        this.btnBrowse.setFocusPainted(false);
        this.btnSave.setFocusPainted(false);
        this.btnCustomerFeedbackOptions.setFocusPainted(false);
        this.jlbSendSystemInfoURL = new JLabel(Resources.getInstance().getBundle().getString("tab_settings_lbl_send_system_info")){

            @Override
            public Font getFont() {
                return FontManager.getUnderlinedFont();
            }

            @Override
            public Color getForeground() {
                return Color.BLUE;
            }
        };
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jrbAuto);
        bg.add(this.jrbContext);
        bg.add(this.jrbManually);
        this.combo.getAccessibleContext().setAccessibleName("freqCombo");
        this.combo.addItem(Resources.getInstance().getBundle().getString("tab_settings_list_item_every_day"));
        this.combo.addItem(Resources.getInstance().getBundle().getString("tab_settings_list_item_every_week"));
        this.combo.addItem(Resources.getInstance().getBundle().getString("tab_settings_list_item_every_month"));
        this.map_comboIndex = new HashMap<Integer, Settings.ECFUAutoMode>();
        this.map_comboIndex.put(0, Settings.ECFUAutoMode.EVERYDAY);
        this.map_comboIndex.put(1, Settings.ECFUAutoMode.EVERYWEEK);
        this.map_comboIndex.put(2, Settings.ECFUAutoMode.EVERYMONTH);
        this.jlbFolder.setPreferredSize(new Dimension(this.jlbFolder.getPreferredSize().width, this.btnBrowse.getPreferredSize().height));
        this.jtfDownloadLocation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String fieldText = TabSettings.this.jtfDownloadLocation.getText();
                        FontMetrics fm = TabSettings.this.jtfDownloadLocation.getFontMetrics(TabSettings.this.jtfDownloadLocation.getFont());
                        int fieldTextWidth = fm.stringWidth(fieldText);
                        if (fieldTextWidth >= TabSettings.this.jtfDownloadLocation.getWidth()) {
                            TabSettings.this.jtfDownloadLocation.setToolTipText(fieldText);
                        } else {
                            TabSettings.this.jtfDownloadLocation.setToolTipText(null);
                        }
                    }
                });
            }
        });
        this.jtfDownloadLocation.setCaretPosition(0);
        this.jtfDownloadLocation.getAccessibleContext().setAccessibleName("textBoxPathToFolder");
        this.jtfDownloadLocation.setPreferredSize(new Dimension(300, this.btnBrowse.getPreferredSize().height));
        this.jtfDownloadLocation.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                TabSettings.this.btnCancel.setEnabled(true);
                TabSettings.this.btnSave.setEnabled(true);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.jrbAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabSettings.this.combo.setEnabled(true);
                TabSettings.this.updateJlbNextCFU(TabSettings.this.map_comboIndex.get(TabSettings.this.combo.getSelectedIndex()));
                TabSettings.this.btnCancel.setEnabled(true);
                TabSettings.this.btnSave.setEnabled(true);
            }
        });
        this.jrbContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabSettings.this.combo.setEnabled(false);
                TabSettings.this.updateJlbNextCFU();
                TabSettings.this.btnCancel.setEnabled(true);
                TabSettings.this.btnSave.setEnabled(true);
            }
        });
        this.jrbManually.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabSettings.this.combo.setEnabled(false);
                TabSettings.this.updateJlbNextCFU();
                TabSettings.this.btnCancel.setEnabled(true);
                TabSettings.this.btnSave.setEnabled(true);
            }
        });
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TabSettings.this.map_comboIndex.get(TabSettings.this.combo.getSelectedIndex()) != Settings.defaultSettings.getCheckingForUpdateAutoMode()) {
                    TabSettings.this.btnCancel.setEnabled(true);
                    TabSettings.this.btnSave.setEnabled(true);
                }
                TabSettings.this.updateJlbNextCFU(TabSettings.this.map_comboIndex.get(TabSettings.this.combo.getSelectedIndex()));
            }
        });
        this.chbxDisableUpdatePopupNotifications.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabSettings.this.btnCancel.setEnabled(true);
                TabSettings.this.btnSave.setEnabled(true);
            }
        });
        this.chbxDisableLicensePopupNotifications.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabSettings.this.btnCancel.setEnabled(true);
                TabSettings.this.btnSave.setEnabled(true);
            }
        });
        this.btnCustomerFeedbackOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegalDialog ld = new LegalDialog((Frame)Gui.getInstance(), true, false);
                ld.setVisible(true);
                int dialogStatus = ld.getStatus();
                if (dialogStatus != 2) {
                    String collectStatus = dialogStatus == 200 ? "0" : "1";
                    String remotemon = "";
                    String path_to_jar = ApplicationManager.getInstance().getPathToJar();
                    if (Common.isMac()) {
                        remotemon = path_to_jar + "/bin/universal_mac10/intelremotemon";
                    } else {
                        switch (Tools.getArch()) {
                            case IA32: {
                                remotemon = path_to_jar + "/bin/ia32/intelremotemon";
                                break;
                            }
                            case INTEL64: {
                                remotemon = path_to_jar + "/bin/intel64/intelremotemon";
                            }
                        }
                    }
                    if (!remotemon.isEmpty()) {
                        try {
                            String[] cmd = new String[]{remotemon, "-sc", collectStatus};
                            Runtime.getRuntime().exec(cmd);
                        }
                        catch (IOException ex) {
                            SumLogger.logger.log(Level.WARNING, "TabSettings(): exception when launching the opt-in dialog {0}", ex.toString());
                        }
                    }
                }
            }
        });
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(1);
                JFrame frame = new JFrame();
                int res = fileChooser.showOpenDialog(frame);
                File f = fileChooser.getSelectedFile();
                if (res == 0) {
                    TabSettings.this.jtfDownloadLocation.setText(f.getAbsolutePath());
                    TabSettings.this.btnCancel.setEnabled(true);
                    TabSettings.this.btnSave.setEnabled(true);
                }
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File downloadDir = new File(TabSettings.this.jtfDownloadLocation.getText());
                try {
                    String directory = downloadDir.getCanonicalPath();
                    if (!downloadDir.exists()) {
                        if (!downloadDir.mkdirs()) {
                            String msg = String.format(Resources.getInstance().getBundle().getString("message_cannot_create_dir"), directory);
                            JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
                            TabSettings.this.jtfDownloadLocation.setText(Settings.defaultSettings.getDefaultDownloadLocation());
                            return;
                        }
                        try {
                            downloadDir.delete();
                        }
                        catch (Exception ex) {
                            SumLogger.logger.log(Level.WARNING, "TabSettings(): exception when deleting download dir {0}", ex.toString());
                        }
                    } else if (!downloadDir.canWrite()) {
                        String msg = String.format(Resources.getInstance().getBundle().getString("message_directory_is_not_writable"), directory);
                        JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
                        TabSettings.this.jtfDownloadLocation.setText(Settings.defaultSettings.getDefaultDownloadLocation());
                        return;
                    }
                    Settings.defaultSettings.setDefaultDownloadLocation(directory);
                    TabSettings.this.jtfDownloadLocation.setText(directory);
                    TabSettings.this.jtfDownloadLocation.setCaretPosition(0);
                    TabUpdatesAndDownloads.getInstance().updateDownloadToLabel();
                    if (TabSettings.this.jrbManually.isSelected()) {
                        Settings.defaultSettings.setCheckingForUpdateMode(Settings.ECFUMode.MANUAL);
                    } else if (TabSettings.this.jrbAuto.isSelected()) {
                        Settings.defaultSettings.setCheckingForUpdateMode(Settings.ECFUMode.AUTO);
                        Settings.defaultSettings.setCheckingForUpdateAutoMode(TabSettings.this.map_comboIndex.get(TabSettings.this.combo.getSelectedIndex()));
                    } else {
                        Settings.defaultSettings.setCheckingForUpdateMode(Settings.ECFUMode.CONTEXT);
                    }
                    if (TabSettings.this.chbxDisableUpdatePopupNotifications.isSelected()) {
                        Settings.defaultSettings.setDisableUpdatePopupNotifications(1);
                    } else {
                        Settings.defaultSettings.setDisableUpdatePopupNotifications(0);
                    }
                    if (TabSettings.this.chbxDisableLicensePopupNotifications.isSelected()) {
                        Settings.defaultSettings.setDisableLicensePopupNotifications(1);
                    } else {
                        Settings.defaultSettings.setDisableLicensePopupNotifications(0);
                    }
                    TabSettings.this.btnCancel.setEnabled(false);
                    TabSettings.this.btnSave.setEnabled(false);
                    SumTimer.getInstance().updateTimer();
                }
                catch (IOException ex) {
                    TabSettings.this.jtfDownloadLocation.setText(Settings.defaultSettings.getDefaultDownloadLocation());
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabSettings.this.combo.setSelectedIndex(Settings.defaultSettings.getCheckingForUpdateAutoModeInt());
                TabSettings.this.jtfDownloadLocation.setText(Settings.defaultSettings.getDefaultDownloadLocation());
                switch (Settings.defaultSettings.getCheckingForUpdateMode()) {
                    case MANUAL: {
                        TabSettings.this.jrbManually.setSelected(true);
                        TabSettings.this.combo.setEnabled(false);
                        TabSettings.this.updateJlbNextCFU();
                        break;
                    }
                    case AUTO: {
                        TabSettings.this.jrbAuto.setSelected(true);
                        TabSettings.this.combo.setEnabled(true);
                        break;
                    }
                    default: {
                        TabSettings.this.jrbContext.setSelected(true);
                        TabSettings.this.combo.setEnabled(false);
                        TabSettings.this.updateJlbNextCFU();
                    }
                }
                if (Settings.defaultSettings.getDisableUpdatePopupNotifications() == 0) {
                    TabSettings.this.chbxDisableUpdatePopupNotifications.setSelected(false);
                } else {
                    TabSettings.this.chbxDisableUpdatePopupNotifications.setSelected(true);
                }
                if (Settings.defaultSettings.getDisableLicensePopupNotifications() == 0) {
                    TabSettings.this.chbxDisableLicensePopupNotifications.setSelected(false);
                } else {
                    TabSettings.this.chbxDisableLicensePopupNotifications.setSelected(true);
                }
                TabSettings.this.btnCancel.setEnabled(false);
                TabSettings.this.btnSave.setEnabled(false);
            }
        });
        this.jlbSendSystemInfoURL.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Common.openBrowser(Resources.getInstance().getBundle().getString("tab_settings_send_system_info_url_dest"));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TabSettings.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TabSettings.this.setCursor(new Cursor(0));
            }
        });
        this.combo.setSelectedIndex(Settings.defaultSettings.getCheckingForUpdateAutoModeInt());
        switch (Settings.defaultSettings.getCheckingForUpdateMode()) {
            case MANUAL: {
                this.jrbManually.setSelected(true);
                this.combo.setEnabled(false);
                this.updateJlbNextCFU();
                break;
            }
            case AUTO: {
                this.jrbAuto.setSelected(true);
                this.combo.setEnabled(true);
                this.updateJlbNextCFU(this.map_comboIndex.get(this.combo.getSelectedIndex()));
                break;
            }
            default: {
                this.jrbContext.setSelected(true);
                this.combo.setEnabled(false);
                this.updateJlbNextCFU();
            }
        }
        if (Settings.defaultSettings.getDisableUpdatePopupNotifications() == 0) {
            this.chbxDisableUpdatePopupNotifications.setSelected(false);
        } else {
            this.chbxDisableUpdatePopupNotifications.setSelected(true);
        }
        if (Settings.defaultSettings.getDisableLicensePopupNotifications() == 0) {
            this.chbxDisableLicensePopupNotifications.setSelected(false);
        } else {
            this.chbxDisableLicensePopupNotifications.setSelected(true);
        }
        this.btnCancel.setEnabled(false);
        this.btnSave.setEnabled(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.refresh();
    }

    public final void refresh() {
        this.removeAll();
        this.jlbSettings.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        GridBagLayout gbagSettings = new GridBagLayout();
        GridBagConstraints gbcSettings = new GridBagConstraints();
        gbcSettings.weightx = 1.0;
        gbcSettings.weighty = 0.0;
        gbcSettings.insets = new Insets(5, 10, 0, 0);
        gbcSettings.anchor = 18;
        gbcSettings.gridx = 0;
        gbcSettings.gridy = 0;
        gbcSettings.gridwidth = 3;
        gbagSettings.setConstraints(this.jlbCheck, gbcSettings);
        ++gbcSettings.gridy;
        gbcSettings.fill = 2;
        gbagSettings.setConstraints(this.jlbYouCan, gbcSettings);
        gbcSettings.fill = 0;
        ++gbcSettings.gridy;
        gbcSettings.insets = new Insets(5, 30, 0, 0);
        gbagSettings.setConstraints(this.jrbManually, gbcSettings);
        ++gbcSettings.gridy;
        gbagSettings.setConstraints(this.jrbContext, gbcSettings);
        ++gbcSettings.gridy;
        JPanel jpnAutoCheckPanel = new JPanel(new BorderLayout(5, 0));
        jpnAutoCheckPanel.add((Component)this.jrbAuto, "West");
        jpnAutoCheckPanel.add((Component)this.combo, "Center");
        gbagSettings.setConstraints(jpnAutoCheckPanel, gbcSettings);
        ++gbcSettings.gridy;
        gbcSettings.insets = new Insets(5, 50, 0, 0);
        gbagSettings.setConstraints(this.jlbNextCFU, gbcSettings);
        gbcSettings.gridx = 0;
        ++gbcSettings.gridy;
        gbcSettings.insets = new Insets(10, 10, 0, 0);
        gbagSettings.setConstraints(this.jlbDownload, gbcSettings);
        ++gbcSettings.gridy;
        gbcSettings.insets = new Insets(5, 10, 0, 0);
        gbagSettings.setConstraints(this.jlbYouCanFind, gbcSettings);
        ++gbcSettings.gridy;
        gbcSettings.gridwidth = 1;
        gbcSettings.weightx = 0.0;
        gbcSettings.fill = 1;
        gbcSettings.insets = new Insets(5, 30, 0, 0);
        gbagSettings.setConstraints(this.jlbFolder, gbcSettings);
        gbcSettings.gridx = 1;
        gbcSettings.weightx = 0.6;
        gbcSettings.insets = new Insets(5, 5, 0, 0);
        gbagSettings.setConstraints(this.jtfDownloadLocation, gbcSettings);
        gbcSettings.fill = 0;
        gbcSettings.gridx = 2;
        gbcSettings.weightx = 0.4;
        gbagSettings.setConstraints(this.btnBrowse, gbcSettings);
        gbcSettings.gridx = 0;
        gbcSettings.gridwidth = 3;
        ++gbcSettings.gridy;
        gbcSettings.insets = new Insets(10, 10, 0, 0);
        gbagSettings.setConstraints(this.jlbNotifications, gbcSettings);
        ++gbcSettings.gridy;
        gbcSettings.insets = new Insets(5, 30, 0, 0);
        gbagSettings.setConstraints(this.chbxDisableUpdatePopupNotifications, gbcSettings);
        ++gbcSettings.gridy;
        gbagSettings.setConstraints(this.chbxDisableLicensePopupNotifications, gbcSettings);
        ++gbcSettings.gridy;
        gbcSettings.insets = new Insets(10, 10, 0, 0);
        gbagSettings.setConstraints(this.jlbPrivacy, gbcSettings);
        ++gbcSettings.gridy;
        gbcSettings.gridwidth = 3;
        gbcSettings.weightx = 1.0;
        gbcSettings.weighty = 1.0;
        gbcSettings.insets = new Insets(5, 30, 0, 0);
        gbagSettings.setConstraints(this.btnCustomerFeedbackOptions, gbcSettings);
        JPanel jpnSettings = new JPanel(gbagSettings);
        jpnSettings.add(this.jlbCheck);
        jpnSettings.add(this.jlbYouCan);
        jpnSettings.add(this.jrbManually);
        jpnSettings.add(this.jrbContext);
        jpnSettings.add(jpnAutoCheckPanel);
        jpnSettings.add(this.jlbNextCFU);
        jpnSettings.add(this.jlbDownload);
        jpnSettings.add(this.jlbYouCanFind);
        jpnSettings.add(this.jlbFolder);
        jpnSettings.add(this.jtfDownloadLocation);
        jpnSettings.add(this.btnBrowse);
        jpnSettings.add(this.jlbNotifications);
        jpnSettings.add(this.chbxDisableUpdatePopupNotifications);
        jpnSettings.add(this.chbxDisableLicensePopupNotifications);
        jpnSettings.add(this.jlbPrivacy);
        jpnSettings.add(this.btnCustomerFeedbackOptions);
        jpnSettings.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JPanel jpnBtnSaveCancel = new JPanel();
        jpnBtnSaveCancel.add(this.btnSave);
        jpnBtnSaveCancel.add(this.btnCancel);
        JPanel jpnBottom = new JPanel(new BorderLayout());
        jpnBottom.add((Component)jpnBtnSaveCancel, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.jlbSettings, "North");
        this.add((Component)jpnSettings, "Center");
        this.add((Component)jpnBottom, "South");
    }

    private void updateJlbNextCFU() {
        this.jlbNextCFU.setEnabled(false);
        this.jlbNextCFU.setText(this.strNextCFU + " " + this.strNextCFUDateUnknown);
    }

    private void updateJlbNextCFU(Settings.ECFUAutoMode mode) {
        this.jlbNextCFU.setEnabled(true);
        this.jlbNextCFU.setText(this.strNextCFU + " " + Common.getDateTimeFormat().format(SumTimer.getInstance().getNextPlanningCFUDate(mode).getTime()));
    }
}

