/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.UsageStatisticsManager;
import com.intel.ism.gui.AlignedTabbedPaneUI;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.TabHistory;
import com.intel.ism.gui.TabLicenses;
import com.intel.ism.gui.TabMessages;
import com.intel.ism.gui.TabSettings;
import com.intel.ism.gui.TabUpdatesAndDownloads;
import java.awt.ComponentOrientation;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;

public final class TabPanel
extends JTabbedPane {
    private static TabPanel tabPanel;
    private int lastActiveTabIdx;

    public static synchronized TabPanel getInstance() {
        if (tabPanel == null) {
            tabPanel = new TabPanel();
        }
        return tabPanel;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private TabPanel() {
        super(2);
        this.setUI(new AlignedTabbedPaneUI());
        this.setTabPlacement(2);
        this.setFocusable(false);
        this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.lastActiveTabIdx = 0;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx = TabPanel.this.indexAtLocation(e.getX(), e.getY());
                if (idx != TabPanel.this.lastActiveTabIdx) {
                    switch (idx) {
                        case 0: {
                            UsageStatisticsManager.getInstance().increaseTabUpdates();
                            break;
                        }
                        case 1: {
                            UsageStatisticsManager.getInstance().increaseTabLicenses();
                            break;
                        }
                        case 2: {
                            UsageStatisticsManager.getInstance().increaseTabNews();
                            break;
                        }
                        case 4: {
                            UsageStatisticsManager.getInstance().increaseTabHistory();
                            break;
                        }
                        case 5: {
                            UsageStatisticsManager.getInstance().increaseTabSettings();
                        }
                    }
                }
                TabPanel.this.lastActiveTabIdx = idx;
            }
        });
        this.addTab(Resources.getInstance().getTabNameDownloads() + " (0)", SumImages.imgDownloadTab, TabUpdatesAndDownloads.getInstance());
        this.addTab(Resources.getInstance().getTabNameActivations() + " (0)", SumImages.imgActivationTab, TabLicenses.getInstance());
        this.addTab(Resources.getInstance().getTabNameMessages() + " (0)", SumImages.imgMessagesTab, TabMessages.getInstance());
        this.addTab("", null);
        this.setEnabledAt(3, false);
        this.addTab(Resources.getInstance().getTabNameHistory(), SumImages.imgHistoryTab, TabHistory.getInstance());
        this.addTab(Resources.getInstance().getTabNameSettings(), SumImages.imgSettingsTab, TabSettings.getInstance());
    }

    public void setUpdatesAndDownloadsTabTitle(String str) {
        this.setTitleAt(0, Resources.getInstance().getTabNameDownloads() + " (" + str + ")");
    }

    public void setActivationsTabTitle(String str) {
        this.setTitleAt(1, Resources.getInstance().getTabNameActivations() + " (" + str + ")");
    }

    public void setMessagesTabTitle(String str) {
        this.setTitleAt(2, Resources.getInstance().getTabNameMessages() + " (" + str + ")");
    }
}

