/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.objects.MarketingMessageData;
import com.intel.ism.core.objects.MarketingMessages;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.OutputPane;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.TabHistory;
import com.intel.ism.gui.TabPanel;
import com.intel.ism.gui.controllers.FontManager;
import com.intel.ism.gui.treetable.DataTree;
import com.intel.ism.gui.treetable.TreeTable;
import com.intel.ism.gui.treetable.TreeTableNews;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class TabMessages
extends JPanel {
    private static TabMessages tabMessages;
    private TreeTable treeTable;
    private DataTree dataModel;
    private final JLabel jlbMessages = new JLabel(Resources.getInstance().getLabelTabMessages(), SumImages.imgInfo, 2);
    private final OutputPane pane = new OutputPane();
    private final JLabel jlbProductName = new JLabel();
    private JPopupMenu popupMenu;
    private JMenuItem itemMarkAsRead;
    private JMenuItem itemMarkAsUnread;
    private JMenuItem itemMoveToHistory;
    private String statusCFU = Resources.getInstance().getBundle().getString("label_tab_no_messages");
    private static final int TABLE_MESSAGE_NAME_COLUMN_INDEX = 0;
    private static final int TABLE_POSTED_DATE_COLUMN_INDEX = 1;

    public static synchronized TabMessages getInstance() {
        if (tabMessages == null) {
            tabMessages = new TabMessages();
        }
        return tabMessages;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private TabMessages() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabNoMessages();
    }

    public void refresh() {
        this.dataModel = new DataTree(MarketingMessageData.class);
        int msgCount = this.dataModel.getLeafCount();
        TabPanel.getInstance().setMessagesTabTitle(String.valueOf(msgCount));
        if (msgCount > 0) {
            this.tabFoundMessages();
        } else {
            this.tabNoMessages();
        }
        this.updateUI();
    }

    private void tabNoMessages() {
        this.removeAll();
        JLabel jlbImg = new JLabel(SumImages.imgInfo, 2);
        JEditorPane jepNoUpdates = new JEditorPane("text/html", this.statusCFU);
        jepNoUpdates.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jepNoUpdates.setEditable(false);
        jepNoUpdates.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (Desktop.isDesktopSupported()) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(he.getEventType())) {
                        try {
                            Desktop.getDesktop().browse(he.getURL().toURI());
                        }
                        catch (Exception ex) {
                            SumLogger.logger.log(Level.WARNING, "tabNoMessages(): exception during open default browser {0}", ex.getMessage());
                        }
                    }
                } else if (HyperlinkEvent.EventType.ACTIVATED.equals(he.getEventType())) {
                    Common.openBrowser(he.getURL().toString());
                }
            }
        });
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbag.setConstraints(jlbImg, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbag.setConstraints(jepNoUpdates, gbc);
        this.setLayout(gbag);
        this.add(jlbImg);
        this.add(jepNoUpdates);
    }

    private void tabFoundMessages() {
        TreeTableNews treeTableNewsData = new TreeTableNews(this.dataModel.getRoot());
        this.treeTable = new TreeTable(treeTableNewsData, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TabMessages.this.selectionHandler();
                return null;
            }
        });
        this.treeTable.setRowHeight(SumImages.imgStatusMsgRead.getIconHeight() + 4);
        this.setTreeTableMouseListeners();
        this.popupMenu = new JPopupMenu();
        this.setupPopupMenu(this.popupMenu);
        int[] columnsToFit = new int[]{0, 1};
        Common.fitColumnsWidth(this.treeTable, columnsToFit);
        this.treeTable.getColumnModel().getColumn(1).setResizable(false);
        this.removeAll();
        this.jlbMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JScrollPane scrollTable = new JScrollPane(this.treeTable, 20, 30);
        scrollTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        scrollTable.getViewport().setBackground(Color.WHITE);
        this.jlbProductName.setFont(FontManager.getBoldFont());
        JPanel jpnProductName = new JPanel(new BorderLayout());
        jpnProductName.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 0));
        jpnProductName.add((Component)this.jlbProductName, "West");
        JScrollPane scrollOutput = new JScrollPane(this.pane.getOutput()){

            @Override
            public Color getBackground() {
                return Color.WHITE;
            }
        };
        scrollOutput.setBorder(BorderFactory.createEmptyBorder(0, 12, 5, 5));
        JPanel jpnOutput = new JPanel(new BorderLayout());
        jpnOutput.add((Component)jpnProductName, "North");
        jpnOutput.add((Component)scrollOutput, "Center");
        jpnOutput.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JSplitPane splitPane = new JSplitPane(0, (Component)scrollTable, (Component)jpnOutput){

            @Override
            public double getResizeWeight() {
                return 0.3;
            }

            @Override
            public Border getBorder() {
                return BorderFactory.createEmptyBorder();
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.jlbMessages, "North");
        this.add((Component)splitPane, "Center");
    }

    private void setupPopupMenu(JPopupMenu popupMenu) {
        this.itemMarkAsRead = new JMenuItem(Resources.getInstance().getBundle().getString("tab_messages_popup_menu_item_mark_as_read"), SumImages.imgMarkAsRead);
        this.itemMarkAsUnread = new JMenuItem(Resources.getInstance().getBundle().getString("tab_messages_popup_menu_item_mark_as_unread"), SumImages.imgMarkAsUnread);
        this.itemMoveToHistory = new JMenuItem(Resources.getInstance().getBundle().getString("tab_messages_popup_menu_item_move_to_history"), SumImages.imgMoveToHistory);
        this.removePopupMenuItemListeners(this.itemMarkAsRead);
        this.removePopupMenuItemListeners(this.itemMarkAsUnread);
        this.removePopupMenuItemListeners(this.itemMoveToHistory);
        this.itemMarkAsRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabMessages.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemNews) {
                    MarketingMessageData mm = ((DataTree.ItemNews)tn).getMarketingMessageData();
                    MarketingMessages m = new MarketingMessages();
                    m.setRead(mm.getGuid(), mm.getId(), true);
                    TabMessages.this.refresh();
                }
            }
        });
        this.itemMarkAsUnread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabMessages.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemNews) {
                    MarketingMessageData mm = ((DataTree.ItemNews)tn).getMarketingMessageData();
                    MarketingMessages m = new MarketingMessages();
                    m.setRead(mm.getGuid(), mm.getId(), false);
                    TabMessages.this.refresh();
                }
            }
        });
        this.itemMoveToHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabMessages.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemNews) {
                    MarketingMessageData mm = ((DataTree.ItemNews)tn).getMarketingMessageData();
                    new MarketingMessages().setRemove(mm.getGuid(), mm.getId());
                    TabMessages.this.pane.clean();
                    TabMessages.this.refresh();
                    TabHistory.getInstance().refresh();
                }
            }
        });
        popupMenu.add(this.itemMarkAsRead);
        popupMenu.add(this.itemMarkAsUnread);
        popupMenu.addSeparator();
        popupMenu.add(this.itemMoveToHistory);
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Object tn = TabMessages.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemNews) {
                    MarketingMessageData mm = ((DataTree.ItemNews)tn).getMarketingMessageData();
                    boolean isRead = mm.getIsRead();
                    if (isRead) {
                        TabMessages.this.itemMarkAsRead.setEnabled(false);
                        TabMessages.this.itemMarkAsUnread.setEnabled(true);
                    } else {
                        TabMessages.this.itemMarkAsRead.setEnabled(true);
                        TabMessages.this.itemMarkAsUnread.setEnabled(false);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void removePopupMenuItemListeners(JMenuItem item) {
        for (ActionListener i : item.getActionListeners()) {
            item.removeActionListener(i);
        }
    }

    private void setTreeTableMouseListeners() {
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = TabMessages.this.treeTable.rowAtPoint(e.getPoint());
                if (row < TabMessages.this.treeTable.getTree().getRowCount() && row != -1) {
                    TabMessages.this.treeTable.changeSelection(row, 0, false, false);
                    Object tn = TabMessages.this.treeTable.getTree().getLastSelectedPathComponent();
                    if (tn instanceof DataTree.ItemNews) {
                        this.showPopup(e);
                    }
                } else {
                    TabMessages.this.treeTable.getSelectionModel().clearSelection();
                    TabMessages.this.pane.clean();
                    TabMessages.this.jlbProductName.setText("");
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Object tn;
                int row = TabMessages.this.treeTable.rowAtPoint(e.getPoint());
                if (row < TabMessages.this.treeTable.getTree().getRowCount() && row != -1 && (tn = TabMessages.this.treeTable.getTree().getLastSelectedPathComponent()) instanceof DataTree.ItemNews) {
                    this.showPopup(e);
                }
            }

            public void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TabMessages.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void setCFUStatusStr(String status) {
        this.statusCFU = status;
    }

    private void selectionHandler() {
        Object tn = this.treeTable.getTree().getLastSelectedPathComponent();
        if (tn instanceof DataTree.ItemNews) {
            this.pane.getOutput().setText(((DataTree.ItemNews)tn).getMarketingMessageData().getDescription());
            this.pane.getOutput().setCaretPosition(0);
            this.jlbProductName.setText(((DataTree.ItemNews)tn).getMarketingMessageData().getTitle());
        } else {
            this.treeTable.getSelectionModel().clearSelection();
            this.pane.getOutput().setDocument(this.pane.getOutput().getEditorKit().createDefaultDocument());
            this.pane.clean();
            this.jlbProductName.setText("");
        }
    }
}

